saveTracks:
	bsr	.dosOpen
	tst.l	d0
.crash:	beq.s	.crash

	IFNE	SAVE_TRACKS
	lea	.file_table,a4
	

.loop:		move.l	(a4)+,d1			; File name
		bmi	.exit				; Done.
	
		bsr	.openNewFile
		tst.l	d0
		beq.s	.crash
		
		move.l  .filehd,d1          ;file handle in D1
		move.l	(a4)+,d2		; Start of buffer to write
		move.l	(a4)+,d3		; Amount to write
		bsr	.writeFile
		tst.l	d0
		beq	.crash
		
		move.l  .filehd,d1        ;file handle in D1
		bsr	.closeFile
		tst.l	d0
		beq	.crash
		bra	.loop
		
	ENDC

.openNewFile:                	;*open file,mode in D0
				;pointer to filename
	move.l  #MODE_NEWFILE,d2
	move.l  .dosbase,a6       ;DOS base address in A6
	jsr     _LVOOpen(a6)         ;open file
	move.l  d0,.filehd        ;save handle
	bra	.exit

; In D1   the file handle that you got back from the OPEN function.
; In D2   a pointer to the data that should be written.
; In D3   the number of bytes to be written.
.writeFile:               ;*write data in the file

	move.l  .dosbase,a6         ;DOS base address
	jsr     _LVOWrite(a6)          ;write data
	bra	.exit
	
.closeFile                     ;*close file
	move.l  .dosbase,a6       ;DOS base address in A6
	jsr     _LVOClose(a6)        ;close file
	bra	.exit
	
.dosOpen:
	move.l  ExecBase,a6				
	lea     .dosname,a1
	moveq   #0,d0
	jsr     _LVOOpenLibrary(a6)			; LibBase = OpenLibrary=(version[d0],libname[a1])
	move.l	d0,.dosbase
	bra	.exit
	
	nop
	
.exit:	rts

.filehd:	dc.l	0
.dosname:	dc.b	"dos.library",0
		even
.dosbase:	dc.l	0

.file_table:	
		IFEQ	BUILD_TRACKS
		dc.l	.file_lower_terrain,S1,(E1-S1)
		dc.l	.file_upper_terrain,S2,(E2-S2)
		dc.l	.file_lower_guides,S3,(E3-S3)
		dc.l	.file_upper_guides,S4,(E4-S4)
		dc.l	.file_lower_commands,S5,(E5-S5)
		dc.l	.file_upper_commands,S6,(E6-S6)
		
		ELSE
		
		IFNE	BUILD_TRACK1
		dc.l	.file_track_box,BOX_TRACK1,(BOX_TRACK1E-BOX_TRACK1)
		ENDC
		IFNE	BUILD_TRACK2
		dc.l	.file_track_box,BOX_TRACK2,(BOX_TRACK2E-BOX_TRACK2)
		ENDC
		IFNE	BUILD_TRACK3
		dc.l	.file_track_box,BOX_TRACK3,(BOX_TRACK3E-BOX_TRACK3)
		ENDC
		IFNE	BUILD_TRACK4
		dc.l	.file_track_box,BOX_TRACK4,(BOX_TRACK4E-BOX_TRACK4)
		ENDC
		IFNE	BUILD_TRACK5
		dc.l	.file_track_box,BOX_TRACK5,(BOX_TRACK5E-BOX_TRACK5)
		ENDC
		IFNE	BUILD_TRACK6
		dc.l	.file_track_box,BOX_TRACK6,(BOX_TRACK6E-BOX_TRACK6)
		ENDC
		IFNE	BUILD_TRACK7
		dc.l	.file_track_box,BOX_TRACK7,(BOX_TRACK7E-BOX_TRACK7)
		ENDC
		IFNE	BUILD_TRACK8
		dc.l	.file_track_box,BOX_TRACK8,(BOX_TRACK8E-BOX_TRACK8)
		ENDC
		
		ENDC
		
		dc.l	-1
		
		IFNE	SAVE_TRACK1
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track1_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track1_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track1_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track1_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track1_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track1_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track1.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK2
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track2_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track2_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track2_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track2_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track2_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track2_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track2.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK3
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track3_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track3_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track3_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track3_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track3_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track3_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track3.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK4
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track4_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track4_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track4_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track4_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track4_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track4_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track4.box",0
			even			
		ENDC
		
		
		IFNE	SAVE_TRACK5
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track5_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track5_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track5_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track5_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track5_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track5_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track5.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK6
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track6_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track6_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track6_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track6_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track6_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track6_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track6.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK7
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track7_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track7_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track7_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track7_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track7_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track7_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track7.box",0
			even			
		ENDC
		
		IFNE	SAVE_TRACK8
.file_lower_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track8_lower_terrain.dat",0
			even
.file_upper_terrain:	dc.b	"dh1:TurboSprint/SavedTracks/track8_upper_terrain.dat",0
			even		
.file_lower_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track8_lower_guides.dat",0
			even
.file_upper_guides:	dc.b	"dh1:TurboSprint/SavedTracks/track8_upper_guides.dat",0		
			even
.file_lower_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track8_lower_commands.dat",0
			even
.file_upper_commands:	dc.b	"dh1:TurboSprint/SavedTracks/track8_upper_commands.dat",0
			even
.file_track_box:	dc.b	"dh1:TurboSprint/SavedTracks/track8.box",0
			even			
		ENDC