ssHiscoreDelayTime:	equ	60*8

; Nonvolatile offsets
_LVOGetCopyNV		= -30
_LVOFreeNVData		= -36
_LVOStoreNV		= -42
_LVODeleteNV		= -48
_LVOGetNVInfo		= -54
_LVOGetNVList		= -60
_LVOSetNVProtection	= -76
;_LVOIoErr		= -132

CD32SaveUnits:		equ	29


; Need a wrapper to shut down the system

	
ssHiscoreCheckSaveNeeded:
	move.l	d0,-(a7)
	tst.w	HISCORE_SAVE_REQUIRED(a6)
	beq	.exit
	clr.w	HISCORE_SAVE_REQUIRED(a6)
	
	bsr	ssLoadSaveSetSaveText

;--------
	IFEQ	ENABLE_DEBUG
	;bsr	agdRemoveAudioPlayer
	bsr	RemoveScreenInterrupt
	bsr	RemoveKeyboardInterrupt		
	RESTORE_SYSTEM_STATE
	;RESTORE_COPPER			; Disable this to stop showing WB screen (must replace though).
	INIT_PERMIT_OS
	OS_WAITBLIT
	DISOWN_BLITTER
	
	lea	CHIPBASE,a5	
	move.w	#0,BEAMCON0(a5)
	move.w #$8000,VPOSW(a5)			; Set LOF Auto Toggle
	ENDC
	
	bsr	agdShowAvilableChipMemory
	bsr	ssSaveHiscoreTable
	
; wait for motor to stop for 5 seconds

	move.l	#60*5,d5
.wait:	bsr	WaitVbl
	dbf	d5,.wait
	
	IFEQ	ENABLE_DEBUG
	OS_WAITBLIT
	OWN_BLITTER			; Take Blitter
	INIT_FORBID_OS			; Forbid()
	WAIT_FOR_BLITTER
	SAVE_SYSTEM_STATE
	INIT_DMA_INT
	
	move.w	#$0200,BPLCON0(a5)
	move.l	RAWPTR_BLANK_BITPLANES(a6),a0
	move.l	(a0),a0
	move.l	a0,BPL0PTH(a5)
	move.l	a0,BPL1PTH(a5)
	move.l	a0,BPL2PTH(a5)
	move.l	a0,BPL3PTH(a5)
	move.l	a0,BPL4PTH(a5)
	move.l	a0,BPL5PTH(a5)
	move.l	a0,BPL6PTH(a5)
	move.l	a0,BPL7PTH(a5)
	bsr	InstallScreenInterrupt
	bsr	InstallKeyboardInterrupt
	ENDC
	
.exit:	move.l	(a7)+,d0
	rts
	

ssHiscoreInitialise:
	lea	RNC_HISCORES_SCREEN,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_HISCORE_SCREEN(a6)
.exit:	rts

ssHiscoreSetInitials:
	moveq	#CAR_1,d1
	GET_CAR_CONTEXT
	move.l	#$412020ff,carHiscoreInitials(a4)
	clr.b	carHiScoreAlphaPos(a4)
	
	moveq	#CAR_2,d1
	GET_CAR_CONTEXT
	move.l	#$412020ff,carHiscoreInitials(a4)
	clr.b	carHiScoreAlphaPos(a4)
	
	moveq	#CAR_3,d1
	GET_CAR_CONTEXT
	move.l	#$412020ff,carHiscoreInitials(a4)
	clr.b	carHiScoreAlphaPos(a4)
	
	moveq	#CAR_4,d1
	GET_CAR_CONTEXT
	move.l	#$412020ff,carHiscoreInitials(a4)
	clr.b	carHiScoreAlphaPos(a4)
	rts
	
ssHiscoreInitHandles:
; Destroy all Vram chunks
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	move.l	UNPPTR_HISCORE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_HISCORE_SCREEN(a6)
	move.l	BMPPTR_HISCORE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_HISCORE_SCREEN(a6)
	move.l	PALPTR_HISCORE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_HISCORE_SCREEN(a6)
	move.l	BMPPTR_HISCORE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_HISCORE_SCREEN(a6)
	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_HISCORE_SCREEN(a6)
	rts

ssHiscoreCreateHandles	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_HISCORE_SCREEN(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_HISCORE_SCREEN(a6)

	move.l	UNPPTR_HISCORE_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_HISCORE_SCREEN(a6)	
	
	move.l	UNPPTR_HISCORE_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_HISCORE_SCREEN(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_HISCORE_SCREEN(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_HISCORE_SCREEN(a6)
	move.l	d0,a0
	move.l	PALPTR_HISCORE_SCREEN(a6),hScreenPalette(a0)	; Assign palette to screen
.exit:	rts
	
ssHiscoreCrash:	bra.s	ssHiscoreCrash

ssHiscore:
	move.w	#sceneHiscore,CURRENT_SCENE(a6)
	move.w	#ssHiscoreDelayTime,SCENE_DELAY_TIME(a6)
	clr.l	FRAME_COUNT(a6)
	
	moveq	#CAR_1,d0
	move.l	d0,HI_SCORES_NUMBER(a6)
	
	bsr	ssHiscoreInitHandles
	bsr	ssHiscoreCreateHandles
	tst.l	d0
	bmi.s	ssHiscoreCrash
	
	;bsr	ssHiscoreConvertToText
	;bsr	ssHiscoreSort
	
	bsr	ssHiscoreCopy

	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	lea	$dff000,a5	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC

	move.l	BMPPTR_HISCORE_SCREEN(a6),d0
	move.l	SCRPTR_HISCORE_SCREEN(a6),d1
	bsr	agdTransitionBitmapToScreen
	
; Display Score Panel
	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	moveq	#%00011,d2
	bsr	ssDisplayScorePanel

; Display Upgrade Car Large Text
	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	move.l	HI_SCORES_NUMBER(a6),d0			; "BLUE CAR"
	moveq	#%0011,d2				; 
	bsr	ssHiScoresText				; 

	bsr	ssDisplayHiScores
	
	bsr	ssHiscoreBuildRecordTable
	
	move.l	#60*6,LEVEL_DELAY
	clr.l	LEVEL_TICK
	
.frame:	
	bsr	WaitVbl
	
	IFNE	NO_INPUT_INTERUPTS
	bsr	agdReadInputs
	ENDC
	
	bsr	ssDisplayLevels
	
	;subq.w	#1,SCENE_DELAY_TIME(a6)
	
	tst.w	SCENE_DELAY_TIME(a6)
	bmi.s	.timeout

	bsr	ssGetFirstPlayerCar
	tst.w	d0
	bmi.s	.frame
	
	move.w	#-1,START_GAME(a6)
	
	;and.l	#$ffff,d0
	;move.l	d0,GAME_FIRST_PLAYER(a6)

.timeout:
	move.l	SCRPTR_HISCORE_SCREEN(a6),d0
	bsr	agdTransitionBitmapFromScreen
	move.w	#sceneLoad,CURRENT_SCENE(a6)
	
; Kill VBL
	IFEQ	ENABLE_DEBUG
		END_SCENE
	ENDC
	;bsr	ssHiscoreInitHandles
.error:	rts

; a0=Screen Pointer
; d2=Bits to set ..... must be two bits set. (i.e. d2=%00011 for first two bitplanes).
ssHiScoresText:
	moveq	#0,d3
	move.l	SPRPTR_LARGE_FONT(a6),a1
	
	lea	.line1(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr	.display
	bra	.exit
	
.display:
	move.b	(a2)+,d0
	move.b	(a2)+,d1
	add.w	d1,d1
.loop:	move.b	(a2)+,d3			
	beq	.exit
	bsr	agdLargeFont
	add.w	#16,d0
	bra.s	.loop
.exit:	rts

.line1:	dc.b	64,66>>1,"TURBO SPRINT RACING TEAM",0
	even


ssDisplayHiScores:
	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	lea	HI_SCORES_TABLE(a6),a1
	moveq	#15,d3					; Colour 7 is White.	
.loop:	cmp.l	#-1,(a1)
	beq	.exit

	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	move.l	a1,-(a7)
	bsr	agdSmallFont
	move.l	(a7)+,a1
	add.l	#16,a1
	bra	.loop
.exit:	rts



VVV
ssHiscoreCopy:
	lea	HI_SCORES_TABLE(a6),a1
	lea	HISCORE_RAW(a6),a0
	moveq	#30-1,d7
.copy:	move.b	4(a0),14(a1)			; Initials
	move.b	5(a0),15(a1)
	move.b	6(a0),16(a1)
	
; Now translate scores
	move.l	(a0),d0
	bsr	.conv
	
	add.l	#20,a1
	addq.l	#8,a0
	dbf	d7,.copy
	bra.s	.exit

.conv:	movem.l	a0-a1,-(a7)
	add.l	#7,a1
	move.l	#"    ",hiscore_temp(a6)
	move.w	#"  ",hiscore_temp+4(a6)
	bsr	Binary2Decimal

	add.l	#6,a1
	add.l	d0,a0
	subq.l	#1,d0
.strcopy:
	move.b	-(a0),-(a1)
	dbf	d0,.strcopy
	movem.l	(a7)+,a0-a1
	bra	.exit
	nop
.exit:	rts
	
	
ssHiscoreConvertToText:
	move.l	#"    ",hiscore_temp(a6)
	move.w	#"  ",hiscore_temp+4(a6)
	move.l	HISCORE_NEW(a6),d0
	bsr	Binary2Decimal
	lea	hiscore_temp(a6),a1
	add.l	#6,a1
	add.l	d0,a0
	subq.l	#1,d0
.strcopy:
	move.b	-(a0),-(a1)
	dbf	d0,.strcopy	
.exit:	rts
	
	
	
ssHiscoreSort:	
	moveq	#30,d2
	lea	HISCORE_RAW(a6),a0
	move.l	a0,a1
.sort:	move.l	a1,a0
	move.l	d2,d0
	subq.w	#1,d0
	moveq	#0,d1
	
.loop:	move.l	8(a0),d3		; Get next value?
	cmp.l	(a0),d3			; Compare with this value.
	beq.s	.noswap
	bcs.s	.noswap
	
.doswap:			
	move.l	(a0),d1
	move.l	8(a0),(a0)
	move.l	d1,8(a0)
	
	move.l	4(a0),d1
	move.l	12(a0),4(a0)
	move.l	d1,12(a0)
		
	moveq	#1,d1
	
.noswap:
	addq.l	#8,a0
	dbf	d0,.loop
	tst.w	d1
	bne.s	.sort
	rts	


; Load the HiScores
ssLoadHiscoreTable:
; CD32 code here....
; Do a check here to see if we are a CD32
; a1 will need to point at the HISCORE table data
; d0 will also need the length (80 bytes)
	bsr	CD32Detect
	tst.l	d0
	beq	.no_cd32
.is_cd32:
	bsr	CD32OpenNVRAMLib		; Open NVRam Lib
	move.w	#$ff0,d2
	tst.l	d0
	beq	ssIoError

; d0.l: length
; a0.l: file name
; a1.l: destination
	move.l	#CD32SaveUnits*10,d0			;80 bytes to copy
	lea	HISCORE_CD32_START,a1
	bsr	CD32LoadHighscores
	tst.l	d0
	beq	ssIoError

	bsr	CD32CloseNVRAMLib
	bra.s	.dos_close
	

.no_cd32:
	bsr	ssOpenExistingFile
	move.w	#$f0f,d2
	tst.l	d0
	beq	ssIoError
	move.l	#HISCORE_IO_START,d2
	move.l	#HISCORE_IO_END-HISCORE_IO_START,d3
	
	bsr	ssReadFile
	move.w	#$7af,d2
	tst.l	d0
	beq	ssIoError

	bsr	ssCloseFile
.dos_close:
	moveq	#0,d0
.exit:	rts


TTT
ssSaveHiscoreTable:
; Do a check here to see if we are a CD32
	bsr	CD32Detect
	tst.l	d0
	beq	.no_cd32
	bsr	CD32OpenNVRAMLib		; Open NVRam Lib
	move.w	#$0f0,d2
	tst.l	d0
	beq.s	ssIoError

; d0.l: length
; a0.l: file name
; a1.l: data

	bsr	CD32SaveHighscores
	move.w	#$f0f,d2
	tst.l	d0
	beq.s	.close_nv
	
	move.l	a0,-(a7)
	lea	txtSaveHiScoreFail,a0
	bsr	agdPrintLine
	move.l	(a7)+,a0
	bra	ssIoError
.close_nv:
	bsr	CD32CloseNVRAMLib
	bra.s	.dos_close

.no_cd32:
	bsr	ssOpenNewFile
	move.w	#$00f,d2
	tst.l	d0
	beq.s	ssIoError

	move.l	#HISCORE_IO_START,d2
	move.l	#HISCORE_IO_END-HISCORE_IO_START,d3
	
	bsr	ssWriteFile
	tst.l	d0
	beq	ssIoError

	bsr	ssCloseFile
.dos_close:
	moveq	#0,d0
.exit:	rts



;d2=colour
ssIoError: 
	move.l	a6,-(a7)
	move.l  DOSBASE,a6       ;address of library name
        jsr     _LVOIoErr(a6)        ;call IoErr for error info
	move.l	(a7)+,a6
        move.l  d0,d5            
	move.l	#120,d7
.loop:	nop
	bsr	raceWaitVbl
	move.w	d2,$dff180
	dbf	d7,.loop
	move.w	#$000,$dff180
	moveq	#-1,d0			; failed to open.
	rts

; d1 = file handle
; d2 = buff pointer
; d3 = read amount
ssReadFile:
	move.l	a6,-(a7)
	move.l  FILEHD(a6),d1      ;file handle in D1
	;move.l  #$ffffff,d3    ;read an arbitrary number of bytes
	move.l  DOSBASE,a6     ;DOS base address in A6
	jsr     _LVORead(a6)       ;read data
	move.l	(a7)+,a6
	rts

; In D1   the file handle that you got back from the OPEN function.
; In D2   a pointer to the data that should be written.
; In D3   the number of bytes to be written.
ssWriteFile:               ;*write data in the file
	move.l	a6,-(a7)
	move.l  FILEHD(a6),d1          ;file handle in D1
	move.l  DOSBASE,a6         ;DOS base address
	jsr     _LVOWrite(a6)          ;write data
	move.l	(a7)+,a6
	rts


ssOpenNewFile:                	;*open file,mode in D0
	move.l	a6,-(a7)
	move.l  #HISCORE_FILENAME,d1     ;pointer to filename
	move.l  #MODE_NEWFILE,d2
	move.l  DOSBASE,a6       ;DOS base address in A6
	jsr     _LVOOpen(a6)         ;open file
	move.l  d0,FILEHD        ;save handle
	move.l	(a7)+,a6
        rts

ssOpenExistingFile:           	;*open file,mode in D0
	move.l	a6,-(a7)
	move.l  #HISCORE_FILENAME,d1     ;pointer to filename
	move.l  #MODE_OLDFILE,d2
	move.l  DOSBASE,a6       ;DOS base address in A6
	jsr     _LVOOpen(a6)         ;open file
	move.l  d0,FILEHD        ;save handle
	move.l	(a7)+,a6
        rts


ssCloseFile                     ;*close file
	move.l	a6,-(a7)
	move.l  FILEHD(a6),d1        ;file handle in D1
	move.l  DOSBASE,a6       ;DOS base address in A6
	jsr     _LVOClose(a6)        ;close file
	move.l	(a7)+,a6
	rts
	
	
; d0: 0=a 1=b
EER
ssDisplayLevels:
	tst.l	LEVEL_DELAY
	beq.s	.ok
	subq.l	#1,LEVEL_DELAY
	bra	.exit

.ok:	moveq	#15,d3					; Colour 7 is White.	


	move.l	#$20,d1
	
	tst.w	LEVEL_TICK+2				; is level tick 0?
	beq	.clear
		
	move.l	LEVEL_TICK,d0
	add.l	d1,LEVEL_TICK
	add.b	d1,d0
	bcs	.plot_line
	
	bra	.exit
	
.plot_line:
	lea	LEVELS_TEXT(pc),a2
	moveq	#0,d0
	move.w	LEVEL_TICK,d0	

	move.l	(a2,d0*4),a2
	cmp.l	#-1,a2
	bne.s	.2
	
	move.w	#-1,SCENE_DELAY_TIME(a6)
	bra	.exit
	
.2:	moveq	#0,d0
	move.w	LEVEL_TICK+2,d0
	lsr.l	#8,d0
	tst.w	d0
	beq.s	.1
	
	subq.w	#1,d0
	cmp.w	#9,d0
	blt.s	.1
	
	move.w	#$10000-$100,LEVEL_TICK+2
	move.l	#60*3,LEVEL_DELAY
	bra	.exit
.1:	move.l	(a2,d0*4),a1

	move.l	SCRPTR_HISCORE_SCREEN(a6),a0
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	addq.w	#8,d1
	move.l	a2,-(a7)
	bsr	agdSmallFont
	move.l	(a7)+,a2	
	bra	.exit
	
.clear:	
	add.l	d1,LEVEL_TICK
	
; Re-Transition Bitmap
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	BMPPTR_HISCORE_SCREEN(a6),d0	
	move.l	SCRPTR_HISCORE_SCREEN(a6),d1
	move.l	#212,d2
	bsr	agdCopyBitmapToScreenFromLine
	movem.l	(a7)+,d0-d7/a0-a6
	bra	.exit
	
.exit:	rts


DDD
ssHiscoreBuildRecordTable:
	lea	RECORD_TABLE,a0
	moveq	#3,d6

	lea	LEVELS_TEXT,a1
	
.loop2:	move.l	(a1)+,a2
	addq.w	#4,a2
	moveq	#7,d7
	
.loop:
	move.l	(a2)+,a3
	
; Put name in
	move.l	(a0)+,d0
	lsr.l	#8,d0
	move.b	d0,14(a3)
	lsr.l	#8,d0
	move.b	d0,13(a3)
	lsr.l	#8,d0
	move.b	d0,12(a3)
	
; do lap time seconds
	moveq	#0,d0
	move.w	(a0)+,d0
	bsr	ssWinningCarsGetLapTime
	
	move.b	d0,22(a3)
	lsr.l	#8,d0
	move.b	d0,21(a3)
	lsr.l	#8,d0
	move.b	d0,20(a3)
	lsr.l	#8,d0
	move.b	d0,19(a3)

; do level time seconds
	
	moveq	#0,d0
	move.w	(a0)+,d0
	bsr	ssWinningCarsGetLapTime
	
	move.b	d0,40(a3)
	lsr.l	#8,d0
	move.b	d0,39(a3)
	lsr.l	#8,d0
	move.b	d0,38(a3)
	lsr.l	#8,d0
	move.b	d0,37(a3)	

	add.l	#56,a3

	dbf	d7,.loop
	
	dbf	d6,.loop2
	rts


;move.b	carHiscoreInitials(a4),HISCORE_NEW+4
;move.b	carHiscoreInitials+1(a4),HISCORE_NEW+5
;move.b	carHiscoreInitials+2(a4),HISCORE_NEW+6
		
ssHiscoreSetWorldRecordInitials:
	movem.l	d0-d7/a0-a6,-(a7)
	lea	RECORD_TABLE,a0
	moveq	#MAX_LEVELS-1,d7
	move.l	carNumber(a4),d1		; This car
.loop:	
	cmp.b	3(a0),d1			; World Record for this car?
	bne.s	.next
	
	move.b	carHiscoreInitials(a4),(a0)
	move.b	carHiscoreInitials+1(a4),1(a0)
	move.b	carHiscoreInitials+2(a4),2(a0)
	move.b 	#-1,3(a0)
	
.next:	addq.l	#8,a0
	dbf	d7,.loop

	movem.l	(a7)+,d0-d7/a0-a6
	rts
	
txtSaveHiScoreFail:	dc.b	13,10,"Failed to save hiscore",0
			even

txtSaveOpenNVRAMFail:	dc.b	13,10,"Failed to open NVRAM",0
			even

txtLoadHiscoresGetCopyNVFail:	dc.b	13,10,"Failed to get NVRAM",0	
				even

HISCORE_FILENAME:	
	dc.b  "TurboSprint.hiscore",0  ;file to be opened
	even

	CNOP	0,4
	
LEVEL_TICK	dc.l	0
LEVEL_DELAY:	dc.l	0

LEVELS_TEXT:
			dc.l	LEVELS_A_TEXT
			dc.l	LEVELS_B_TEXT
			dc.l	LEVELS_C_TEXT
			dc.l	LEVELS_D_TEXT
			dc.l	-1
			
			
LEVELS_A_TEXT:	
			dc.l	LEVELS_A_HEADING
			dc.l	LEVELS_A1
			dc.l	LEVELS_A2
			dc.l	LEVELS_A3
			dc.l	LEVELS_A4
			dc.l	LEVELS_A5
			dc.l	LEVELS_A6
			dc.l	LEVELS_A7
			dc.l	LEVELS_A8
			dc.l	-1
	
LEVELS_B_TEXT:	
			dc.l	LEVELS_B_HEADING
			dc.l	LEVELS_B1
			dc.l	LEVELS_B2
			dc.l	LEVELS_B3
			dc.l	LEVELS_B4
			dc.l	LEVELS_B5
			dc.l	LEVELS_B6
			dc.l	LEVELS_B7
			dc.l	LEVELS_B8
			dc.l	-1
			
LEVELS_C_TEXT:	
			dc.l	LEVELS_C_HEADING
			dc.l	LEVELS_C1
			dc.l	LEVELS_C2
			dc.l	LEVELS_C3
			dc.l	LEVELS_C4
			dc.l	LEVELS_C5
			dc.l	LEVELS_C6
			dc.l	LEVELS_C7
			dc.l	LEVELS_C8
			dc.l	-1
			
LEVELS_D_TEXT:	
			dc.l	LEVELS_D_HEADING
			dc.l	LEVELS_D1
			dc.l	LEVELS_D2
			dc.l	LEVELS_D3
			dc.l	LEVELS_D4
			dc.l	LEVELS_D5
			dc.l	LEVELS_D6
			dc.l	LEVELS_D7
			dc.l	LEVELS_D8
			dc.l	-1
		
LEVELS_A_HEADING:
		dc.w	7*8,27*8
		dc.b	"LEVEL   NAME   BEST LAP TIME     AVERAGE LAP TIME ",0
		even
	
LEVELS_A1:	dc.w	7*8,29*8
		dc.b	"  1     LEO    00.0 SECONDS      00.0 SECONDS     ",0
		even
	
LEVELS_A2:	dc.w	7*8,31*8
		dc.b	"  2     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_A3:	dc.w	7*8,33*8
		dc.b	"  3     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_A4:	dc.w	7*8,35*8
		dc.b	"  4     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_A5:	dc.w	7*8,37*8
		dc.b	"  5     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_A6:	dc.w	7*8,39*8
		dc.b	"  6     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_A7:	dc.w	7*8,41*8
		dc.b	"  7     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_A8:	dc.w	7*8,43*8
		dc.b	"  8     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
	
	
LEVELS_B_HEADING:
		dc.w	7*8,27*8
		dc.b	"LEVEL   NAME   RECORD LAP TIME   RECORD TRACK TIME",0
		even
	
LEVELS_B1:	dc.w	7*8,29*8
		dc.b	"  9     LEO    00.0 SECONDS      00.0 SECONDS     ",0
		even
	
LEVELS_B2:	dc.w	7*8,31*8
		dc.b	" 10     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_B3:	dc.w	7*8,33*8
		dc.b	" 11     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_B4:	dc.w	7*8,35*8
		dc.b	" 12     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_B5:	dc.w	7*8,37*8
		dc.b	" 13     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_B6:	dc.w	7*8,39*8
		dc.b	" 14     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_B7:	dc.w	7*8,41*8
		dc.b	" 15     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_B8:	dc.w	7*8,43*8
		dc.b	" 16     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
		
LEVELS_C_HEADING:
		dc.w	7*8,27*8
		dc.b	"LEVEL   NAME   RECORD LAP TIME   RECORD TRACK TIME",0
		even
	
LEVELS_C1:	dc.w	7*8,29*8
		dc.b	" 17     LEO    00.0 SECONDS      00.0 SECONDS     ",0
		even
	
LEVELS_C2:	dc.w	7*8,31*8
		dc.b	" 18     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_C3:	dc.w	7*8,33*8
		dc.b	" 19     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_C4:	dc.w	7*8,35*8
		dc.b	" 20     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_C5:	dc.w	7*8,37*8
		dc.b	" 21     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_C6:	dc.w	7*8,39*8
		dc.b	" 22     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_C7:	dc.w	7*8,41*8
		dc.b	" 23     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_C8:	dc.w	7*8,43*8
		dc.b	" 24     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_D_HEADING:
		dc.w	7*8,27*8
		dc.b	"LEVEL   NAME   RECORD LAP TIME   RECORD TRACK TIME",0
		even
	
LEVELS_D1:	dc.w	7*8,29*8
		dc.b	" 25     LEO    00.0 SECONDS      00.0 SECONDS     ",0
		even
	
LEVELS_D2:	dc.w	7*8,31*8
		dc.b	" 26     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_D3:	dc.w	7*8,33*8
		dc.b	" 27     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_D4:	dc.w	7*8,35*8
		dc.b	" 28     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_D5:	dc.w	7*8,37*8
		dc.b	" 29     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
		
LEVELS_D6:	dc.w	7*8,39*8
		dc.b	" 30     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_D7:	dc.w	7*8,41*8
		dc.b	" 31     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even

LEVELS_D8:	dc.w	7*8,43*8
		dc.b	" 32     LEO    00.0 SECONDS      00.0 SECONDS     ",0	
		even
	
		data

FILEHD:		dc.l   0            ;storage for file handle	
		
HI_SCORES_TABLE:
	dc.w	200,104
	dc.b	" 1"," ","      "," ","   ",0,0,0

	dc.w	200,120
	dc.b	" 2"," ","      "," ","   ",0,0,0

	dc.w	200,136
	dc.b	" 3"," ","      "," ","   ",0,0,0	
	
	dc.w	48,224
	dc.b	" 4"," ","      "," ","   ",0,0,0
	
	dc.w	48,240
	dc.b	" 5"," ","      "," ","   ",0,0,0
	
	dc.w	48,256
	dc.b	" 6"," ","      "," ","   ",0,0,0
	
	dc.w	48,272
	dc.b	" 7"," ","      "," ","   ",0,0,0
	
	dc.w	48,288
	dc.b	" 8"," ","      "," ","   ",0,0,0
	
	dc.w	48,304
	dc.b	" 9"," ","      "," ","   ",0,0,0
	
	dc.w	48,320
	dc.b	"10"," ","      "," ","   ",0,0,0
	
	dc.w	48,336
	dc.b	"11"," ","      "," ","   ",0,0,0
	
	dc.w	48,352
	dc.b	"12"," ","      "," ","   ",0,0,0
	
	dc.w	192,224
	dc.b	"13"," ","      "," ","   ",0,0,0
	
	dc.w	192,240
	dc.b	"14"," ","      "," ","   ",0,0,0
	
	dc.w	192,256
	dc.b	"15"," ","      "," ","   ",0,0,0
	
	dc.w	192,272
	dc.b	"16"," ","      "," ","   ",0,0,0
	
	dc.w	192,288
	dc.b	"17"," ","      "," ","   ",0,0,0
	
	dc.w	192,304
	dc.b	"18"," ","      "," ","   ",0,0,0
	
	dc.w	192,320
	dc.b	"19"," ","      "," ","   ",0,0,0
	
	dc.w	192,336
	dc.b	"20"," ","      "," ","   ",0,0,0
	
	dc.w	192,352
	dc.b	"21"," ","      "," ","   ",0,0,0
	
	dc.w	352,224
	dc.b	"22"," ","      "," ","   ",0,0,0
	
	dc.w	352,240
	dc.b	"23"," ","      "," ","   ",0,0,0
	
	dc.w	352,256
	dc.b	"24"," ","      "," ","   ",0,0,0
	
	dc.w	352,272
	dc.b	"25"," ","      "," ","   ",0,0,0
	
	dc.w	352,288
	dc.b	"26"," ","      "," ","   ",0,0,0
	
	dc.w	352,304
	dc.b	"27"," ","      "," ","   ",0,0,0
	
	dc.w	352,320
	dc.b	"28"," ","      "," ","   ",0,0,0
	
	dc.w	352,336
	dc.b	"29"," ","      "," ","   ",0,0,0
	
	dc.w	352,352
	dc.b	"30"," ","      "," ","   ",0,0,0	
	
	dc.w	-1,-1

; This is a table of current 
HISCORE_CD32_START:
HISCORE_IO_START:
RECORD_TABLE:	rept	MAX_LEVELS		
		dc.b	"LEO",$ff		; 0 = level number, only anything >0 is saved = 0 is default in game.
		dc.w	0
		dc.w	0
		endr
		
HISCORE_RAW:
	dc.l	100000		;1
	dc.b	"LEO",1
	dc.l	70000		;2
	dc.b	"LEO",1
	dc.l	40000		;3
	dc.b	"LEO",1
	dc.l	35000		;4
	dc.b	"LEO",1
HISCORE_CD32_END:
	dc.l	34000		;5
	dc.b	"LEO",1
	dc.l	33000		;6
	dc.b	"LEO",1
	dc.l	32000		;7
	dc.b	"LEO",1
	dc.l	31000		;8
	dc.b	"LEO",1
	dc.l	30000		;9
	dc.b	"LEO",1
	dc.l	29000		;10
	dc.b	"LEO",1
	dc.l	28000		;11
	dc.b	"LEO",1
	dc.l	27000		;12
	dc.b	"LEO",1
	dc.l	26000		;13
	dc.b	"LEO",1
	dc.l	25000		;14
	dc.b	"LEO",1
	dc.l	24000		;15
	dc.b	"LEO",1
	dc.l	23000		;16
	dc.b	"LEO",1
	dc.l	20000		;17
	dc.b	"LEO",1
	dc.l	15000		;18
	dc.b	"LEO",1
	dc.l	10000		;19
	dc.b	"LEO",1
	dc.l	9000		;20
	dc.b	"LEO",1	
	dc.l	8000		;21
	dc.b	"LEO",1
	dc.l	7500		;22
	dc.b	"LEO",1
	dc.l	7000		;23
	dc.b	"LEO",1
	dc.l	6500		;24
	dc.b	"LEO",1
	dc.l	6000		;25
	dc.b	"LEO",1
	dc.l	5000		;26
	dc.b	"LEO",1
	dc.l	4000		;27
	dc.b	"LEO",1
	dc.l	3000		;28
	dc.b	"LEO",1
	dc.l	2000		;29
	dc.b	"LEO",1
	dc.l	1000		;30
	dc.b	"LEO",1	
HISCORE_IO_END:
HISCORE_NEW:	dc.l	2234		; Must be at end of the table
		dc.b	"MCG",0		; dummy 	
hiscore_temp:	dc.b 	"      ",0,0
		even
		

							
	code

