ssPrepareRaceInitilise:
	lea	RNC_PREPARE_RACE_SCENE,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_PREPARE_RACE(a6)
	
	lea	RNC_PREPARE_RACE_DRIVERS,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_PREPARE_RACE_DRIVERS(a6)
	
	lea	RNC_PREPARE_RACE_ENGINE,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_PREPARE_RACE_ENGINE(a6)
	rts

ssPrepareRaceInitHandles
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	
	move.l	UNPPTR_PREPARE_RACE(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_PREPARE_RACE(a6)
	
	move.l	BMPPTR_PREPARE_RACE(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_PREPARE_RACE(a6)
	
	move.l	PALPTR_PREPARE_RACE(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_PREPARE_RACE(a6)
	
	move.l	SCRPTR_PREPARE_RACE(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_PREPARE_RACE(a6)
	
	move.l	UNPPTR_PREPARE_RACE_DRIVERS(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	MSKPTR_PREPARE_RACE_DRIVERS(a6),a0
	bsr	agdDestroyHandle
	clr.l	MSKPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	BMPPTR_PREPARE_RACE_DRIVERS(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	SPSPTR_PREPARE_RACE_DRIVERS(a6),a0
	bsr	agdDestroyHandle
	clr.l	SPSPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	UNPPTR_PREPARE_RACE_ENGINE(a6),a0 
	bsr	agdDestroyHandle
	clr.l	UNPPTR_PREPARE_RACE_ENGINE(a6)
	
	move.l	BMPPTR_PREPARE_RACE_ENGINE(a6),a0	; MOVEA.L (PC,$0824) == $000861e8 [0007c8ca],A0
	bsr	agdDestroyHandle		; BSR.L #$ffff5e74 == $0007b83c
	clr.l	BMPPTR_PREPARE_RACE_ENGINE(a6)
	
	move.l	MSKPTR_PREPARE_RACE_ENGINE(a6),a0
	bsr	agdDestroyHandle
	clr.l	MSKPTR_PREPARE_RACE_ENGINE(a6)
	
	move.l	SPSPTR_PREPARE_RACE_ENGINE(a6),a0
	bsr	agdDestroyHandle
	clr.l	SPSPTR_PREPARE_RACE_ENGINE(a6)
	rts

ssPrepareRaceCreateHandles:
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_PREPARE_RACE(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_PREPARE_RACE(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_PREPARE_RACE_DRIVERS(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_PREPARE_RACE_DRIVERS(a6)
	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_PREPARE_RACE(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_PREPARE_RACE(a6)

	move.l	UNPPTR_PREPARE_RACE_DRIVERS(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	VRMPTR_SCREENS,a0
	move.l	BMPPTR_PREPARE_RACE_DRIVERS(a6),d0
	bsr	agdCreateBitmapMask
	move.l	d0,MSKPTR_PREPARE_RACE_DRIVERS(a6)
	
	move.l	VRMPTR_SCREENS,a0
	move.l	BMPPTR_PREPARE_RACE_DRIVERS(a6),d0
	move.l	MSKPTR_PREPARE_RACE_DRIVERS(a6),d1
	move.l	#$3014,d2					; 48x20 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPSPTR_PREPARE_RACE_DRIVERS(a6)

	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_PREPARE_RACE_ENGINE(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_PREPARE_RACE_ENGINE(a6)
	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_PREPARE_RACE_ENGINE(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			
	move.l	d0,BMPPTR_PREPARE_RACE_ENGINE(a6)
	
; Create a mask of the bitmap
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_PREPARE_RACE_ENGINE(a6),d0
	bsr	agdCreateBitmapMask
	tst.l	d0
	bmi	mainAllocRamFail
	move.l	d0,MSKPTR_PREPARE_RACE_ENGINE(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_PREPARE_RACE_ENGINE(a6),d0
	move.l	MSKPTR_PREPARE_RACE_ENGINE(a6),d1
	move.l	#$6028,d2					; 48x20 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPSPTR_PREPARE_RACE_ENGINE(a6)	
	
; Get the palette of the Bitmap
	move.l	UNPPTR_PREPARE_RACE(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_PREPARE_RACE(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_PREPARE_RACE(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_PREPARE_RACE(a6)
	move.l	d0,a0
	move.l	PALPTR_PREPARE_RACE(a6),hScreenPalette(a0)
.exit:	rts

ssPrepareRaceCrash:	bra	ssPrepareRaceCrash

ssPrepareRace:
	move.w	#scenePrepareRace,CURRENT_SCENE(a6)
	bsr	ssPrepareRaceInitHandles
	bsr	ssPrepareRaceCreateHandles
	
	bsr	ssHiscoreSetInitials
	
	clr.l	FRAME_COUNT(a6)
	
	clr.w	HISCORE_SAVE_REQUIRED(a6)
	
	move.l	SCRPTR_PREPARE_RACE(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER|DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC
	
	IFEQ	ENABLE_DEBUG
	moveq	#0,d0
	bsr	_mt_musicmask
	
	moveq	#SONG_PREPARE_TO_RACE,d0
	move.l	UNPPTR_MODS2(a6),a0
	bsr	agdPlayModule
	
	moveq	#0,d0
	bsr	agdSetVolume
	
	move.b	#-1,mt_Enable
	ENDC
	
; Copy a bitmap to a screen
	move.l	BMPPTR_PREPARE_RACE(a6),d0
	move.l	SCRPTR_PREPARE_RACE(a6),d1
	bsr	agdTransitionBitmapToScreen

	;move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_BLITTER),DMACON(a5)
	
	bsr	ssPrepareRaceCustomCars		; Display text of cars.
	
	clr.l	OSD_SCREEN_UPDATE(a6)
	move.l	#-1,OSD_SCREEN_UPDATE(a6)	
	move.l	SCRPTR_PREPARE_RACE(a6),a0
	moveq	#%00110,d2			; Bitplane 2 and 3 = colours 2 and 
	bsr	ssDisplayScorePanel
	
	moveq	#-1,d7
	bsr	ssPrepareRaceBlits	

	clr.l	FRAME_COUNT(a6)
	clr.l	COUNTDOWN(a6)
	clr.b	COUNTDOWN_CHAR(a6)
	
	clr.l	AUDIO_FADE(a6)
	
	
.fade_audio:	
.frame:
	bsr	WaitVbl
	
	cmp.b	#$20,COUNTDOWN_CHAR(a6)
	beq.s	.f1
	cmp.b	#$34,COUNTDOWN_CHAR(a6)
	ble.s	.fadein
.f1:	moveq	#0,d0
	move.w	AUDIO_FADE(a6),d0
	cmp.w	#$40,d0
	bge.s	.fadein
	add.l	#$10000,AUDIO_FADE(a6)
	bsr	agdSetVolume

.fadein:
	move.l	#-1,OSD_SCREEN_UPDATE(a6)
	
	IFNE	ENABLE_DEBUG
	bsr	agdReadInputs
	ENDC
	
	bsr	ssSetDroneToPlayerInput
	
	moveq	#0,d7
	bsr	ssPrepareRaceBlits
	
	move.l	SCRPTR_PREPARE_RACE(a6),a0
	moveq	#-1,d2
	move.w	#%00110,d2
	bsr	ssDisplayScorePanel
	
; Debugging stuff here.
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC
	
	
.no_update:

	addq.l	#1,FRAME_COUNT(a6)
	bsr	ssPrepareRaceCarsOutOfRace
	tst.l	d0			; Check if any cars still are
	beq	.frame			; out of race.
	addq.l	#1,COUNTDOWN(a6)
	
	cmp.b	#$34,COUNTDOWN_CHAR(a6)
	bge.s	.fadeout

	moveq	#0,d0
	move.w	AUDIO_FADE(a6),d0
	beq.s	.fadeout
	sub.l	#$4000,AUDIO_FADE(a6)
	bsr	agdSetVolume

.fadeout:
	
	cmp.b	#"$",COUNTDOWN_CHAR(a6)
	bne	.frame
	
.done:	
	move.b	#" ",COUNTDOWN_CHAR(a6)
	bsr	ssPrepareRaceSetDrones		; set any out of race cars as drones
	move.w	#sceneLoad,CURRENT_SCENE(a6)
	
	bsr	agdStopModule
	;clr.b	_mt_Enable
	moveq	#0,d0
	bsr	agdSetVolume
	
	move.l	SCRPTR_PREPARE_RACE(a6),d0
	bsr	agdTransitionBitmapFromScreen

	IFEQ	ENABLE_DEBUG

	END_SCENE
	ENDC
	
	
	bsr	ssPrepareRaceCarsInRace

	bsr	ssPrepareRaceInitHandles
	
; d0=0 some cars remaining  d1=-1 no cars
.error:	rts

ssPrepareRaceCarsInRace:
	moveq	#-1,d0
	moveq	#maxCars-1,d1
.loop:	GET_CAR_CONTEXT
	tst.w	carIsDrone(a4)
	bmi.s	.next
	moveq	#0,d0
.next:	dbf	d1,.loop
	rts
	
ssPrepareRaceCarsOutOfRace:
	movem.l	d1/a4,-(a7)
	moveq	#-1,d0
	moveq	#maxCars-1,d1
.loop:	GET_CAR_CONTEXT
	tst.b	carOutOfRace(a4)
	beq.s	.next
	moveq	#0,d0
.next:	dbf	d1,.loop
	movem.l	(a7)+,d1/a4
	rts
	
	
ssPrepareRaceSetDrones:
	moveq	#maxCars-1,d1
.loop:	GET_CAR_CONTEXT
	tst.b	carOutOfRace(a4)
	beq.s	.next
	move.w	#-1,carIsDrone(a4)
	clr.b	carOutOfRace(a4)
.next:	dbf	d1,.loop
	rts
		
	
	near	a6
	
ssPrepareRaceCustomCars:
	moveq	#maxCars-1,d7
	
.loop:	move.l	d7,d1
	GET_CAR_CONTEXT
	
	clr.l	carTimer(a4)
	
	lea	.text_labels(pc),a3
	tst.b	carOutOfRace(a4)			; If the car has just been taken out of the race then show it
	bmi.s	.outofrace
	tst.w	carIsDrone(a4)				; If the car is a drone then skip it
	beq.s	.player
	bra	.next					; If the car is a drone then skip
	
.player:
.outofrace:
	tst.b	carAttrTraction(a4)
	bne.s	.show
	tst.b	carAttrTurbo(a4)
	bne.s	.show
	tst.b	carAttrSpeed(a4)
	bne.s	.show	
	bra	.next
.show:
	moveq	#0,d0
	move.b	carAttrTraction(a4),d0
	add.b	#$30,d0
	move.b	d0,.text_num_traction(a6)
	
	moveq	#0,d0
	move.b	carAttrTurbo(a4),d0
	add.b	#$30,d0
	move.b	d0,.text_num_turbo(a6)
	
	moveq	#0,d0
	move.b	carAttrSpeed(a4),d0
	add.b	#$30,d0
	move.b	d0,.text_num_speed(a6)
	
	move.l	(a3)+,a2			; Get label
	cmp.l	#-1,a2				; Last one?
	beq.s	.next
	move.l	(a2)+,a1			; Get text string
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d3
	move.w	2(a2,d7*8),d0			; get xpos
	move.w	4(a2,d7*8),d1			; get ypos
	move.w	(a2,d7*8),d3			; get colour
	lsl.w	#3,d0
	lsl.w	#3,d1
	subq.w	#2,d1

	move.l	SCRPTR_PREPARE_RACE(a6),a0		
	bsr	agdSmallFont
	bra.s	.show
	
.next:	dbf	d7,.loop
	
.exit:	rts
	
.text_labels:		dc.l	.text_custom1_pos,.text_custom2_pos,.text_traction,.text_turbo,.text_speed
			dc.l	-1

; Long word pointer to text, word=Colour Register (0-31), word=Xpos, word=Ypos, word=0
.text_custom1_pos:	dc.l	.text_custom1
			dc.w	11,3,28,0			; Blue Car "CUSTOMISATION"
			dc.w	09,3,42,0
			dc.w	19,34,28,0			
			dc.w	16,34,42,0			
			
.text_custom2_pos:	dc.l	.text_custom2
			dc.w	13,3,30,0
			dc.w	11,3,44,0
			dc.w	21,34,30,0
			dc.w	18,34,44,0

.text_traction:		dc.l	.text_num_traction
			dc.w	31,12,30,0
			dc.w	31,12,44,0
			dc.w	31,43,30,0
			dc.w	31,43,44,0
	
.text_turbo:		dc.l	.text_num_turbo
			dc.w	31,21,30,0
			dc.w	31,21,44,0
			dc.w	31,52,30,0
			dc.w	31,52,44,0

.text_speed:		dc.l	.text_num_speed
			dc.w	31,30,30,0
			dc.w	31,30,44,0
			dc.w	31,61,30,0
			dc.w	31,61,44,0				
			

.text_custom1:	dc.b	"CUSTOMIZED CAR INCLUDES",0
		even
.text_custom2:	dc.b	"TRACTION    TURBO    SPEED  ",0
		even
		
		data
		
.text_num_traction:	dc.b	"0",0
			even

.text_num_turbo:	dc.b	"0",0
			even

.text_num_speed:	dc.b	"0",0
			even


		code


;a0=Sprite sheet
;a1=Screen
;d0=Car to display [0-2]
;a0=Sprite sheet
;a1=Screen
;a2=Source screen [post]
;d0=Car to display [0-2] 
ssPrepareRaceDriverSprite:
		move.l	a2,d3
		lea	.table(pc),a2
		move.l	(a2,d0*4),a2		; frames pointer
		moveq	#0,d0
		moveq	#0,d1
		move.w	(a2)+,d0		; xpos
		move.w	(a2)+,d1		; ypos
		;mulu.w	hScreenScanline(a1),d1
		lsl.l	#6,d1			; Multiply by $140 (5 bitplanes)
		move.l	d1,d2
		lsl.l	#2,d1
		add.l	d2,d1
		
		lsr.w	#3,d0
		move.l	hScreenPointers(a1),a1
		moveq	#0,d2
		add.l	d1,d2
		add.l	d0,d2
		add.l	d2,a1			; d2=Screen offset
						; a1=Screen Address
.reset:		moveq	#0,d0
		move.w	(a2),d0			;Get frame number

.change:	move.b	4(a2,d0),d0		;Get anim frame
		bpl.s	.plus
		clr.l	(a2)
		bra.s	.reset
		
.plus:		and.l	#$ff,d0
		add.l	#$3000,(a2)+		; Animation speed
		move.l	hAddress(a0),a0		; Address of Sprite Sheet
		move.l	4(a0,d0*8),a2		; a2=Source Mask BLTAPTH
		move.l	(a0,d0*8),a0		; a0=Bitmap Address BLTBPTH
						; a1=Screen Address BLTDPTH

		move.l	d3,a3
		move.l	hBitmapBody(a3),a3	
		addq.w	#8,a3			; a3=Source screen BLTCPTH
		add.l	d2,a3			; add offset
				
		WAIT_FOR_BLITTER
		move.w	#$0fca,BLTCON0(a5)
		move.w	#0,BLTCON1(a5)
		move.l	a2,BLTAPTH(a5)
		move.l	a0,BLTBPTH(a5)
		move.l	a3,BLTCPTH(a5)
		move.l	a1,BLTDPTH(a5)
		
		move.l	#$-1,BLTAFWM(a5)
		move.w	#(288/8)-6,BLTAMOD(a5)
		move.w	#(288/8)-6,BLTBMOD(a5)
		move.w	#(SCREEN_SIZE_X/8)-6,BLTCMOD(a5)
		move.w	#(SCREEN_SIZE_X/8)-6,BLTDMOD(a5)
		move.w	#(20*5<<6)+3,BLTSIZE(a5)		96x40
.exit:		rts
	
.table:		dc.l	.blue_xypos
		dc.l	.red_xypos
		dc.l	.yellow_xypos
		dc.l	.green_xypos
		even

.blue_xypos:	dc.w	128,149
.blue_pointer:	dc.l	0
.blue_frames:	
		rept	2
		dc.b	0
		endr
		dc.b	1,2,3,4,5,6,7,8,9,10,11
		rept	20*2
		dc.b	0
		endr
		dc.b	$ff
			
.yellow_xypos:	dc.w	368,149
.yellow_pointer	dc.l	0
.yellow_frames:	
		rept	2
		dc.b	12
		endr
		dc.b	12,13,14,15,16,17,18,19,20,21,22,23
		rept	20*2
		dc.b	12
		endr
		dc.b	$ff
		even

.red_xypos:	dc.w	128,261
.red_pointer:	dc.l	0
.red_frames:	
		rept	4
		dc.b	0
		endr
		dc.b	1,2,3,4,5,6,7,8,9,10,11
		rept	20*2
		dc.b	0
		endr
		dc.b	$ff
		even

.green_xypos:	dc.w	368,261
.green_pointer	dc.l	0
.green_frames:	
		rept	4
		dc.b	12
		endr
		dc.b	12,13,14,15,16,17,18,19,20,21,22,23
		rept	20*2
		dc.b	12
		endr
		dc.b	$ff
		even
		




;a0=Sprite sheet
;a1=Screen
;a2=Source screen [post]
;d0=Car to display [0-2] 
ssPrepareRaceEngineSprite:
		move.l	a2,d3
		lea	.table(pc),a2
		move.l	(a2,d0*4),a2		; frames pointer
		moveq	#0,d0
		moveq	#0,d1
		move.w	(a2)+,d0		; xpos
		move.w	(a2)+,d1		; ypos
		;mulu.w	hScreenScanline(a1),d1
		lsl.l	#6,d1			; Multiply by $140 (5 bitplanes)
		move.l	d1,d2
		lsl.l	#2,d1
		add.l	d2,d1
		
		lsr.w	#3,d0
		move.l	hScreenPointers(a1),a1
		moveq	#0,d2
		add.l	d1,d2
		add.l	d0,d2
		add.l	d2,a1			; d2=Screen offset
						; a1=Screen Address
.reset:		moveq	#0,d0
		move.w	(a2),d0			;Get frame number

.change:	move.b	4(a2,d0),d0		;Get anim frame
		bpl.s	.plus
		clr.l	(a2)
		bra.s	.reset
		
.plus:		tst.w	d5
		beq	.exit

		and.l	#$ff,d0
		add.l	#$3000,(a2)+		; Animation speed
		move.l	hAddress(a0),a0		; Address of Sprite Sheet
		move.l	4(a0,d0*8),a2		; a2=Source Mask BLTAPTH
		move.l	(a0,d0*8),a0		; a0=Bitmap Address BLTBPTH
						; a1=Screen Address BLTDPTH
		move.l	d3,a3
		move.l	hBitmapBody(a3),a3	
		addq.w	#8,a3			; a3=Source screen BLTCPTH
		add.l	d2,a3			; add offset
				
		WAIT_FOR_BLITTER
		move.w	#$0fca,BLTCON0(a5)
		move.w	#0,BLTCON1(a5)
		move.l	a2,BLTAPTH(a5)
		move.l	a0,BLTBPTH(a5)
		move.l	a3,BLTCPTH(a5)
		move.l	a1,BLTDPTH(a5)
		
		move.l	#-1,BLTAFWM(a5)
		move.w	#(288/8)-12,BLTAMOD(a5)
		move.w	#(288/8)-12,BLTBMOD(a5)
		move.w	#(SCREEN_SIZE_X/8)-12,BLTCMOD(a5)
		move.w	#(SCREEN_SIZE_X/8)-12,BLTDMOD(a5)
		move.w	#(39*5<<6)+6,BLTSIZE(a5)		96x40
.exit:		rts
	
.table:		
		dc.l	.blue_xypos		;0
		dc.l	.red_xypos		;1
		dc.l	.yellow_xypos		;0
		dc.l	.green_xypos		;1
		even

.blue_xypos:	dc.w	48,138
.blue_pointer:	dc.l	0
.blue_frames:	
		rept	1
		dc.b	0,1,0,1,2,1
		endr
		dc.b	2,3,4,5,6,7,8,9,10,11,$ff
		even
				
.yellow_xypos:	dc.w	288,138
.yellow_pointer	dc.l	0
.yellow_frames:	
		rept	1
		dc.b	0,1,2,1
		endr
		dc.b	2,3,4,5,6,7,8,9,10,11,$ff
		even

.red_xypos:	dc.w	48,250
.red_pointer:	dc.l	0
.red_frames:	
		rept	1
		dc.b	2,1
		endr
		dc.b	2,3,4,5,6,7,8,9,10,11,$ff
		even

.green_xypos:	dc.w	288,250
.green_pointer:	dc.l	0
.green_frames:	
		rept	1
		dc.b	0,1,2,3,2,1
		endr
		dc.b	2,3,4,5,6,7,8,9,10,11,$ff
		even



ssPrepareRaceBlits:
	bsr	ssPrepareRaceEngineSprites
	bsr	ssPrepareRaceDriverSprites
	rts
	
	near	a6
	
ssPrepareRaceEngineSprites:
	cmp.w	#4,.frame(a6)
	bne.s	.go
	clr.w	.frame(a6)
.go:	moveq	#0,d7
	move.w	.frame(a6),d7

	moveq	#maxCars-1,d6
	moveq	#CAR_1,d1	
.loop:	move.l	d1,-(a7)

	moveq	#0,d5
	and.w	#1,d7
	beq	.blit
	moveq	#-1,d5
.blit:
	
	GET_CAR_CONTEXT
	tst.w	carIsDrone(a4)
	bmi.s	.next
	tst.b	carOutOfRace(a4)			
	bmi.s	.next
	move.l	SPSPTR_PREPARE_RACE_ENGINE(a6),a0	
	move.l	SCRPTR_PREPARE_RACE(a6),a1
	move.l	BMPPTR_PREPARE_RACE(a6),a2
	move.l	d1,d0
	bsr	ssPrepareRaceEngineSprite
	
.next:	move.l	(a7)+,d1
	addq.w	#1,d1
	dbf	d6,.loop
.exit:	addq.w	#1,.frame(a6)
	rts

	data
	
.frame:	dc.w	0

	code

ssPrepareRaceDriverSprites:
	moveq	#maxCars-1,d6
	moveq	#CAR_1,d1	
.loop:	move.l	d1,-(a7)
.1a:	tst.l	d7				;
	bmi.s	.1b

	GET_CAR_CONTEXT
	tst.w	carIsDrone(a4)
	bmi.s	.next
	tst.b	carOutOfRace(a4)			
	bmi.s	.next
	
.1b:	move.l	SPSPTR_PREPARE_RACE_DRIVERS(a6),a0	
	move.l	SCRPTR_PREPARE_RACE(a6),a1
	move.l	BMPPTR_PREPARE_RACE(a6),a2
	move.l	d1,d0
	bsr	ssPrepareRaceDriverSprite
	
.next:	move.l	(a7)+,d1
	addq.w	#1,d1
	dbf	d6,.loop
.exit:	rts

	data

	CNOP	0,4
	
COUNTDOWN:	dc.l	0
COUNTDOWN_CHAR:	dc.b	0
		even

VBL_BUSY:	dc.w	-1
HISCORE_SAVE_REQUIRED:	dc.w	0

SCRPTR_PREPARE_RACE:	dc.l	0		
UNPPTR_PREPARE_RACE:	dc.l	0
BMPPTR_PREPARE_RACE:	dc.l	0
PALPTR_PREPARE_RACE:	dc.l	0		
RNCPTR_PREPARE_RACE:	dc.l	0
				
UNPPTR_PREPARE_RACE_DRIVERS:	dc.l	0
BMPPTR_PREPARE_RACE_DRIVERS:	dc.l	0
SPSPTR_PREPARE_RACE_DRIVERS:	dc.l	0
RNCPTR_PREPARE_RACE_DRIVERS:	dc.l	0
MSKPTR_PREPARE_RACE_DRIVERS:	dc.l	0

UNPPTR_PREPARE_RACE_ENGINE:	dc.l	0
RNCPTR_PREPARE_RACE_ENGINE:	dc.l	0
BMPPTR_PREPARE_RACE_ENGINE:	dc.l	0
MSKPTR_PREPARE_RACE_ENGINE:	dc.l	0
SPSPTR_PREPARE_RACE_ENGINE:	dc.l	0

COPPTR_PREPRACE_PAL:	dc.l	0

	code
