// snake game by rob for 4kgba
// www.goldroad.co.uk

#include <gba.h>
#include <sprite.h>
#include "stdio.h"
#include "worm.h"

/* external functions (in internal work ram) */
extern void move_worm(worm_t *w) IN_IWRAM;
extern bool wormHitEdge(worm_t *w) IN_IWRAM;
extern bool wormHitItself(worm_t *w) IN_IWRAM;
extern void getWormInput(worm_t *worm) IN_IWRAM;
extern bool checkMapAndGrow(worm_t *worm) IN_IWRAM;
extern void draw_the_block() IN_IWRAM;
extern void remove_the_block() IN_IWRAM;

/* globals */
u32 blockx,blocky;


/* random number generator */

u32 rndseed = 124;
u32 shift	= 4;

u32 random()
{
	asm volatile("

		tst		%3,%3,lsr #1
		movs	r2,%2,rrx
		adc		%3,%3,%3
        eor		r2,r2,r2,lsl #12
		eor		%2,r2,r2,lsr #20
		mov		%0,%2
		mov     %1,%3
		"	
		 : "=r"(rndseed),"=r"(shift)
		 : "r"(rndseed),"r"(shift) 
		 : "r2");

	return rndseed;
}

/* generates new random coordinates for the block */

void make_new_block()
{
	blockx = random()%232;
	blocky = random()%152;
}

/* copies worm parts into sprites */

void draw_worm(worm_t *w)
{
	u32 i;

	for (i=0;i<w->numParts;i++)
	{
		sprites[w->firstSpriteNo + i].attribute0 = COLOR_256 | (w->y[i]);
		sprites[w->firstSpriteNo + i].attribute1 = SIZE_8 | (w->x[i]);
		sprites[w->firstSpriteNo + i].attribute2 = 448<<1;
	}

}



/* waits for vertical sync then copies our oam buffer
   to the gba's oam */

void copyOamWaitVSync()
{
	u32 i;
	u16* spt		= (u16*)sprites;
    u16* oam		= (u16*)0x07000000;
	volatile u16* regdstat	= (volatile u16*)0x04000004;

	while (! (   *regdstat & 1   ) );

	for (i=0;i<128*4;i++)
	{
		oam[i] = spt[i];
	}	
}

/* puts all sprites off screen */

void clearOam()
{
	u32 i;
	for (i=0;i<128;i++)
	{
		sprites[i].attribute0 = 160;
		sprites[i].attribute1 = 240;
	}
}

/* create the graphics (using that term loosly ;)) */

void build_tiles()
{
	u32 i;
	u16 *stile_ram = (u16*)0x06010000+(28672>>1);
	
	/* make the tiles */
	for (i=0;i<32;i++)	*(stile_ram++) = 0x0101;		

	/* make colours */
	*((u16*)0x05000202) = RGB(0,31,0);
}

/* return the worm to its initial status */

void reset(worm_t *worm)
{
	worm->numParts=1;
	worm->firstSpriteNo=0;
	worm->dx[0]=1;
	worm->dy[0]=0;
	worm->x[0] = 64;
	worm->y[0] = 64;
	worm->score = 0;
	clearOam();
	PrintDec(worm->score,4,0,NULL);
}

/* clear the screen (only used when you die) */

void cls()
{
	u32 a;
	u32 *vram = (u32*)0x06000000;
	for (a=0;a<(240*160)>>1;a++)
	{
		vram[a] = 0;
	}
}

/* game entry point */

void AgbMain(void)
{
	u32 i,oo;
	SetMode(MODE_3 |  BG2_ENABLE | OBJ_ENABLE);
	*((u16*)0x04000008) = BGCOLOR_256 | CHARMAP8; 

	build_tiles();
	worm_t worm;
	reset(&worm);
	make_new_block();
	draw_the_block();

	for (;;)
	{
		getWormInput(&worm);

		if (checkMapAndGrow(&worm))
		{
			remove_the_block();
			make_new_block();
			draw_the_block();
			worm.score+=10;
			PrintDec(worm.score,4,0,NULL);
		}

		if (KEY_START_PRESSED)
		{
			while (KEY_START_PRESSED);
			while (!(KEY_START_PRESSED));
			for (i=0;i<100000;i++) oo++;
		}

		move_worm(&worm);
		draw_worm(&worm);

		if (wormHitItself(&worm) || wormHitEdge(&worm))
		{
			for (i=0;i<500000;i++) oo++;
			cls();				reset(&worm);
			make_new_block();	draw_the_block();
		}
		
		copyOamWaitVSync();

	}
}



