#include "rotris.h"

.GLOBAL genSample

@ r0 -> outbuf, r1 -> SampleInfo
genSample:
	stmfd sp!,{r1-r12,lr}

	mov r11,r0
	mov r10,r1

	ldrh r4,[r10,#SI_RELEASE]
	ldrh r5,[r10,#SI_SUSTAIN]
	add r5,r4,r5  @ r5 = len

	mov r0,#0xFFFFFF
	add r1,r4,#1
	swi SWI_NO_DIV<<16
	mov r7,#0xFFFFFF
	mov r12,r0

	ldrh r3,[r10,#SI_FREQ] @ ufadd=r3<<4
	ldrsb r8,[r10,#SI_PITCH]
	mov r9,#2608 @#163	
	mul r9,r8,r9  @ pitchadd=r9>>10
	mov r8,#0     @ pitchvaradd=r8>>10
	mov r2,#0     @ underf=0
	mov r6,r5     @ pos (samples left)

	@ r10->SampleInfo, r11->buf
	@ r2=underf, r3=ufadd, r8=pitchvaradd, r9=pitchadd
	@ r4=release, r5=len, r6=pos
	@ r7=release multiplier, r12=relmulsub

_genloop:
	add r8,r8,r9,asl #1
	add r2,r2,r3,asl #4
	add r2,r2,r8,asr #18

	@ calc r2 mod 1600
_checkrange:
	subs r2,r2,#1600<<8
	bge _checkrange
_rangeok:
	add r2,r2,#1600<<8

	stmfd sp!,{r2-r3,r8-r9}

	mov r9,r2,lsr #8
	ldrb r8,[r10,#SI_FLAG]
	ands r8,r8,#3

	add pc,pc,r8,lsl #4

_samplerate:
	.word 25728
_sawwave:
	mov r3,#80
	mul r3,r9,r3
	sub r3,r3,#64000
	b _ampit

_squarewave:
	mov r3,#58880
	cmp r9,#800
	rsbge r3,r3,#0
	b _ampit

_noisewave:
	mov r0,#32768
	bl random
	sub r3,r0,#16384

_ampit:
	ldrb r9,[r10,#SI_AMP]
	mul r9,r3,r9

	cmp r6,r4  @ release part of sample?
	smullle r9,r1,r7,r9
	suble r7,r7,r12
	movgt r1,r9,asr #8

	sub r8,r5,r6
	add r9,r5,r8,lsl #1
	strh r1,[r11,r9]
	mov r1,r1,asr #8
	strb r1,[r11,r8]

	ldmfd sp!,{r2-r3,r8-r9}

	subs r6,r6,#1
	bne _genloop

	ldrb r8,[r10,#SI_FLAG]
	tst r8,#4
	beq _gendone

	@ r11->buf, r10->sample info, r5=len, r0+r5->workbuf
	ldrh r3,[r10,#SI_CUT_ENV]
	ldrb r4,[r10,#SI_RES_ENV]
	ldrb r8,[r10,#SI_CUT]
	ldrb r9,[r10,#SI_RES]
	mov r8,r8,lsl #24 @ r8 = CR_param_cutoff
	mov r9,r9,lsl #16 @ r9 = CR_resonance_cutoff
	
	mov r0,r3,lsl #16	
	ldr r1,_samplerate
	swi SWI_NO_DIV<<16
	mov r10,r0  @ r10 = cutoff_add
	mov r0,r4,lsl #16
	ldr r1,_samplerate
	swi SWI_NO_DIV<<16
	mov r6,r0  @ r6 = res_add

	mov r3,#0

	@ r3=pos, r5=len, r11->buf, r7=sample rate
	@ r8=CR_param_cutoff, r9=CR_resonance_cutoff, r10=cutoff_add, r6=res_add

_filterloop:
	add r8,r8,r10
	add r9,r9,r6
	tst r3,#7
	bleq CR_SetParams
	add r0,r5,r3,lsl #1
	ldrsh r0,[r11,r0]
	bl CR_Work
	strb r0,[r11,r3]
	add r3,r3,#1
	cmp r3,r5
	blt _filterloop

_gendone:
	mov r0,r5
	ldmfd sp!,{r1-r12,lr}
	bx lr

	.LTORG
	.END
