#include "rotris.h"

.GLOBAL AgbMain
.GLOBAL rotparam
.GLOBAL randSeed
.GLOBAL random
.GLOBAL lines

AgbMain:
	bl init

#ifndef SMALL
	ldr r0,=songTitle
	bl songStart
#endif	

GameLoop:
	bl wellReset
	bl wellShow
	bl showStat

	bl spinIn

_waitKeyLoop:
	swi SWI_NO_VBLANK_INTR_WAIT<<16
#ifndef SMALL	
	bl songUpdate
	bl wavRefresh
#endif
	ldr r0,keyTrg
	tst r0,#A_BUTTON|B_BUTTON|START_BUTTON
	beq _waitKeyLoop

	ldr r0,=songTetris
	bl songStart

	mov r0,#DEF_FALLSPEED
	str r0,fallspeed

MainLoop:
	swi SWI_NO_VBLANK_INTR_WAIT<<16

	bl showStat
	bl rotateSet
	bl songUpdate
	bl wavRefresh

	adr r0,curp
	ldmia r0,{r1-r9}
	cmp r1,#0
	bge _pieceexist
	mov r0,#7
	bl random
	mov r1,r0,lsl #2
	mov r2,#3
	mov r3,#1
	mov r5,r4
	mov r6,#1
	mov r8,#0
	mov r7,#0
	bl checkValid
	bne GameOver
_pieceexist:
	ldr r10,keyCur
	tst r10,#D_KEY   @ keyCur & D_KEY
	moveq r6,#0      @ reset downflag if DOWN not pressed
	beq _nodownpress
	cmp r6,#0
	bne _nodownpress
	cmp r5,#DOWNFALL
	ble _nodownpress
	mov r5,#DOWNFALL
	add r7,r7,#1
_nodownpress:
	tst r10,#L_KEY|R_KEY
	moveq r9,#0
	moveq r8,#0
	beq _noleftrightpress
	cmp r8,#0       @ if (dircnt)
	subne r8,r8,#1  @   dircnt--;
	bne _noleftrightpress
	mov r0,r2
	tst r10,#L_KEY
	subne r2,r2,#1
	tst r10,#R_KEY
	addne r2,r2,#1
	bl checkValid
	movne r2,r0     @ invalid left/right move
	bne _noleftrightpress
	cmp r9,#0
	moveq r8,#LRFIRST
	movne r8,#LRNEXT
	add r9,r9,#1
	mov r0,#FX_move
	bl playFX
_noleftrightpress:
	ldr r10,keyTrg
	tst r10,#START_BUTTON
	bne GameOver
	tst r10,#A_BUTTON|B_BUTTON|U_KEY
	beq _norotate
	and r12,r1,#3
	add r12,r12,#1
	tst r10,#A_BUTTON|U_KEY
	addeq r12,r12,#2
	add r12,r12,#2
	and r12,r12,#3
	mov r0,r1
	and r1,r1,#0xFC
	orr r1,r1,r12
	bl checkValid
	movne r1,r0
	mov r0,#FX_rotate
	bleq playFX
_norotate:
	subs r5,r5,#1
	bne _nofall
	add r3,r3,#1
	bl checkValid
	moveq r5,r4     @ piece can fall, reset fallcnt
	beq _nofall     @ and continue
	sub r3,r3,#1
	bl putPiece

	@ check if lines cleared

	stmfd sp!,{r1-r9}

	ldr r0,=well
	ldr r1,=welltmp
	dmacopy 18*16
	bl wellReset

	ldr r12,=spiralSpeed
	ldmia r12,{r8-r10}
	add r10,r10,r7  @ score+=downcnt

	mov r7,#0

	ldr r0,=welltmp+17*16
	ldr r1,=well+17*16

	mov r4,#18
_rowloop:
	mov r2,#0
	mov r3,#9
_colloop:
	ldrb r5,[r0,r3]
	cmp r5,#1
	addne r2,r2,#1
	subs r3,r3,#1
	bcs _colloop
	cmp r2,#10
	beq _clear
	dmacopy 16
	b _nextline
_clear:
	add r8,r8,#256 @ spiralSpeed+=256
	add r7,r7,#1
	add r1,r1,#16
_nextline:
	sub r0,r0,#16
	sub r1,r1,#16
	subs r4,r4,#1
	bne _rowloop

	mov r0,#FX_drop
	cmp r7,#0
	movne r0,#FX_clear
	cmp r7,#4
	moveq r0,#FX_tetris
	bl playFX

	add r9,r9,r7  @ update lines
	adr r6,scoreTable
	add r6,r6,r7,lsl #1
	ldrh r6,[r6]
	add r10,r10,r6
	ldr r6,rotspeed0
	add r6,r6,r7
	str r6,rotspeed0

	stmia r12,{r8-r10}
	ldmfd sp!,{r1-r9}

	mov r1,#-1
_nofall:
	adr r0,curp
	stmia r0,{r1-r9}
	bl wellShow

	b MainLoop

GameOver:
	bl putPiece
	bl wellShow

	mov r0,#-1
	bl wavStop

	mov r0,#FX_gameover
	bl playFX

	mov r0,#0
	str r0,score
	str r0,lines
	str r0,rotspeed0
	str r0,rotcurspeed

	mov r5,#60
_delay:
	swi SWI_NO_VBLANK_INTR_WAIT<<16
	bl wavRefresh
	subs r5,r5,#1
	bne _delay

#ifndef SMALL
	ldr r0,=songTitle
	bl songStart
#endif	

	bl spinOut
	b GameLoop

curp:         .word 0 @ r1
curx:         .word 0 @ r2
cury:         .word 0 @ r3
fallspeed:    .word 0 @ r4
fallcnt:      .word 0 @ r5
downflag:     .word 0 @ r6
downcnt:      .word 0 @ r7
dircnt:       .word 0 @ r8
dirflag:      .word 0 @ r9

scoreTable:   .hword 0,400,1000,3000,12000,0

wellReset:
	ldr r0,=well
	ldr r1,=0x01010101
	add r2,r1,#0x01000000
	add r3,r1,#0x00010000
	mov r4,#18
_wellResetLoop:
	str r1,[r0],#4
	str r1,[r0],#4
	str r3,[r0],#4
	str r2,[r0],#4
	subs r4,r4,#1
	bne _wellResetLoop
	add r1,r1,r1
	.REPT 4
	str r1,[r0],#4
	.ENDR
	mov r0,#-1
	str r0,curp
	bx lr

wellShow:
	stmfd sp!,{r0-r12,lr}
	adr r0,curp
	ldmia r0,{r1-r3}
	bl checkValid
	ldr r0,=welltmp+32
	ldr r1,=VRAM+(WELL_SB<<11)
	mov r4,#16
	mov r5,#16
_wellLoop:
	dmacopy 10
	add r0,r0,r4
	add r1,r1,r4,lsl #1
	subs r5,r5,#1
	bne _wellLoop
	ldmfd sp!,{r0-r12,lr}
	bx lr

@ r1=piece, r2=x, r3=y
putPiece:
	stmfd sp!,{r0-r12,lr}
	ldr r5,=well
	b check
checkValid:
	stmfd sp!,{r0-r12,lr}
	ldr r4,=well
	ldr r5,=welltmp
	dmacopy4 19*16
check:
	mov r0,#1
	mov r9,r1,asr #2
	adds r9,r9,#2
	bcs _noPiece
	ldr r8,=piecedata
	add r1,r8,r1,lsl #3
	mov r7,#4
	@ r2=x, r3=y, r1=piecedata[piece], r5=welltmp, r9=byte to plot, r0=empty mask, r7=bytes left
_putPieceLoop:
	ldrb r6,[r1],#1 @ y ofs
	add r6,r6,r3
	add r8,r5,r6,lsl #4 @ r8=&welltmp[y]
	ldrb r6,[r1],#1 @ x ofs
	add r6,r6,r2
	add r8,r8,r6
	ldrb r10,[r8]
	orr r0,r0,r10
	strb r9,[r8]
	subs r7,r7,#1
	bne _putPieceLoop
_noPiece:
	cmp r0,#1
	ldmfd sp!,{r0-r12,lr}
	bx lr

showStat:
	stmfd sp!,{lr}
	ldr r0,score
	ldr r4,=VRAM+(TEXT_SB<<11)+(17<<6)+16
	bl showNumber
	ldr r0,lines
	add r4,r4,#64
	bl showNumber
	ldmfd sp!,{pc}

showNumber:
	stmfd sp!,{r4,lr}
	mov r5,#19
	strh r5,[r4],#-2
_showLoop:
	mov r1,#10
	swi SWI_NO_DIV<<16
	add r1,r1,#9
	strh r1,[r4],#-2
	cmp r0,#0
	bne _showLoop
_showFillLoop:
	strh r5,[r4],#-2
	tst r4,#15
	bne _showFillLoop
	ldmfd sp!,{r4,lr}
	bx lr

intr_main:
	ldr r3,=REG_IE
	mov r0, #V_BLANK_INTR_FLAG
	strh r0, [r3,#2]

	stmfd sp!,{r0-r12,lr}
	
	bl wavUpdate

	@ Update rand seed
	ldr r0,randSeed
	add r0,r0,#1
	str r0,randSeed

	@ Update keypresses
	ldr r0,=REG_KEYINPUT
	ldr r0,[r0]
	eor r0,r0,#0xFF @ r0=cur
	ldr r1,keyCur
	str r0,keyCur
	eor r1,r0,r1
	and r1,r0,r1
	str r1,keyTrg

	@ Update spiral

	adr r6,spiralRed
	ldmia r6,{r0-r3} @ r0=spiralRed, r1=spiralPos, r2=spiralSpeed, r3=lines
	add r1,r1,r2     @ spiralPos+=spiralSpeed;
	mov r5,r3,lsl #2
	add r5,r5,#256
	cmp r2,r5        @ if (spiralSpeed>256+lines*4)
	subgt r2,r2,#2   @   spiralSpeed-=2;
	cmp r0,r3,lsl #7 @ if (spiralRed>lines*128)
	subgt r0,r0,#64  @   spiralRed-=64;
	addlt r0,r0,#64  @ if (spiralRed<lines*128) spiralRed+=64;
	mov r5,#7680
	cmp r0,r5        @ if (spiralRed>7680)
	movgt r0,r5      @   spiralRed=7680;
	stmia r6,{r0-r3}
	
@ r0=red, r1=pos
	mov r0,r0,lsr #8  @r0=red>>8
	mov r2,#31  @ r2=i
	mov r7,#PLTT
	add r7,r7,#256   @ r7=&PLTT[128]
_spiralPalLoop:
	
	rsb r3,r0,#32
	mul r3,r2,r3 @ r3 = i*(32-red)
	add r6,r0,r3,lsr #5  @ r6 = red
	rsb r4,r2,#31 @ r4 = blue
	add r5,r6,r2,lsl #5
	add r5,r5,r4,lsl #10  @ color code
	
	mov r3,r3,lsr #5
	rsb r3,r3,#31    @ r3 = red, r4 = green
	add r3,r3,r4,lsl #5
	add r3,r3,r2,lsl #10 @ color code
	
	sub r4,r2,r1,lsr #8
	and r4,r4,#63
	add r4,r4,r4
	strh r5,[r7,r4]
	eor r4,r4,#64
	strh r3,[r7,r4]

	subs r2,r2,#1
	bcs _spiralPalLoop

	@ Update well

	ldr r0,lines
	cmp r0,#0
	beq _nolines

	adr r8,rotparam
	ldrsh r0,[r8,#16] @ Theta

	mov r3,r0        @ v
	ldr r1,rotcurspeed
	ldr r6,rotspeed0
	add r2,r3,#512
	sub r1,r1,r2,asr #10 @ rotcurspeed-=(v+512)>>10

	adds r4,r3,r1     @ v+rotcurspeed
	bgt _checkvless
	cmp r3,#0
	blt _checkvless

	mov r1,r6,lsl #4
	rsb r1,r1,#0
	mov r0,#0
	b _noadd

_checkvless:
	cmp r4,#0
	blt _noadd
	cmp r3,#0
	bgt _noadd

	mov r1,r6,lsl #4
	mov r0,#0

_noadd:
	add r4,r3,r1
	cmp r4,#-0x8000
	blt _wrap
	cmp r4,#0x8000
	blt _nowrap
_wrap:
	ldr r4,fallspeed
	cmp r4,#DOWNFALL
	subgt r4,r4,#1
	str r4,fallspeed
	sub r6,r6,#1
_nowrap:

	str r6,rotspeed0
	str r1,rotcurspeed
	add r0,r0,r1
	strh r0,[r8,#16]

_nolines:

	mov r0,#V_BLANK_INTR_FLAG
	ldr r1,=INTR_CHECK_BUF
	strh r0,[r1]

	ldmfd sp!,{r0-r12,lr}

	bx lr

randSeed:     .word 0
spiralRed:    .word 0
spiralPos:    .word 0
spiralSpeed:  .word 256
lines:        .word 0
score:        .word 0
keyTrg:       .word 0
keyCur:       .word 0

random:
	stmfd sp!,{r1-r3}
	mov r1,#0x7A00
	add r1,r1,#0xBD
	ldrh r3,randSeed
	mul r1,r3,r1
	add r1,r1,#0x1B00
	add r1,r1,#0x0F	
	mov r1,r1,lsl #16
	mov r1,r1,lsr #16
	strh r1,randSeed
	mul r0,r1,r0
	mov r0,r0,lsr #16
	ldmfd sp!,{r1-r3}
	bx lr

init:
	stmfd sp!,{lr}
	
	mov r11,#REG_BASE
	adr r0,pltt
	mov r1,#PLTT
	dmacopy 54

	@ Create tiles

	add r5,pc,#0x4000
	mov r0,#22
_createTileLoop:
	mov r1,#0
	mov r2,#63
_createTileLoopI:
	add r4,r0,#1
	tst r2,#7
	@addeq r4,r0,#2
	tstne r2,#56
	addeq r4,r0,#2
	tst r1,#7
	@moveq r4,r0
	tstne r1,#56
	moveq r4,r0
	strb r4,[r5],#1
	add r1,r1,#1
	subs r2,r2,#1
	bcs _createTileLoopI
	subs r0,r0,#3
	bcs _createTileLoop

	@ Create digits

	mov r0,#0
	adr r1,digits
_extractDigits:
	ldr r6,[r1],#4
	mov r4,#31
_extLoop:
	movs r6,r6,lsr #1
	mov r3,#25
	movcs r3,#26
	strb r3,[r5],#1
	subs r4,r4,#1
	bcs _extLoop
	add r0,r0,#1
	cmp r0,#22	
	blt _extractDigits

	@ Copy to VRAM

	sub r0,r5,#576+64*11
	mov r1,#VRAM
	dmacopy 576+64*11

	@ Extract piece data
	adr r1,pieces
	ldr r0,=piecedata
	mov r2,#28*8
_extPieceLoop:
	tst r2,#15
	ldreq r3,[r1],#4
	and r4,r3,#3
	strb r4,[r0],#1
	mov r3,r3,lsr #2
	subs r2,r2,#1
	bne _extPieceLoop

	@ Generate sin/cos table

	mov r0,#0
	mov r1,#65536
	mov r2,#1024
	ldr r4,=cosTable
	mov r6,#6400
	add r6,r6,#34
	mov r8,#1
_cosloop:
	rsb r3,r0,#0
	str r0,[r4,r2,lsl #2] @ cosTable[i]=s;
	rsb r7,r2,#4096
	str r0,[r4,r7,lsl #2] @ cosTable[4096-i]=s;
	add r7,r2,#2048
	str r3,[r4,r7,lsl #2] @ cosTable[2048+i]=-s;
	rsb r7,r2,#2048
	str r3,[r4,r7,lsl #2] @ cosTable[2048-i]=-s;
	mul r7,r6,r1
	add r7,r8,r7,asr #21
	add r0,r0,r7,asr #1
	mul r7,r6,r0
	add r7,r8,r7,asr #21
	sub r1,r1,r7,asr #1
	subs r2,r2,#1
	bcs _cosloop

	bl drawSpiral

	ldr r1,=INTR_VECTOR_BUF
	adr r0,intr_main
	str r0,[r1]

	mov r0,#1	
	ldr r10,=REG_IE

	strh r0,[r10,#REG_IME-REG_IE] @ *(vu16*)REG_IME   = 1;
	strh r0,[r10]                 @ *(vu16*)REG_IE    = V_BLANK_INTR_FLAG;
	mov r0,#STAT_V_BLANK_IF_ENABLE
	strh r0,[r11,#OFFSET_REG_STAT]  @ *(vu16*)REG_STAT  = STAT_V_BLANK_IF_ENABLE;

	ldr r0,=BG_COLOR_256|BG_SCREEN_SIZE_0 | BG_PRIORITY_3 | (SPIRAL_SB<<BG_SCREEN_BASE_SHIFT)
	strh r0,[r11,#OFFSET_REG_BG0CNT]
	ldr r0,=BG_COLOR_256|BG_SCREEN_SIZE_0 | BG_PRIORITY_2 | (TEXT_SB<<BG_SCREEN_BASE_SHIFT)
	strh r0,[r11,#OFFSET_REG_BG1CNT]
	@mov r0,#4
	@strh r0,[r11,#OFFSET_REG_BG1HOFS]

	ldr r0,=BG_COLOR_256 | BG_SCREEN_SIZE_1 | BG_PRIORITY_1 | (WELL_SB<<BG_SCREEN_BASE_SHIFT);
	strh r0,[r11,#OFFSET_REG_BG2CNT]

	bl rotateSet

	ldr r0,=DISP_MODE_1|DISP_BG0_ON|DISP_BG2_ON
	strh r0,[r11,#OFFSET_REG_DISPCNT]

	bl initSamples

	@ Alpha Blend
	ldr r0,=BLD_BG2_1ST | BLD_BG1_1ST | BLD_BG0_2ND| BLD_A_BLEND_MODE
	strh r0,[r11,#OFFSET_REG_BLDCNT]
	mov r0,#((16<<BLD_1ST_PIXEL_SHIFT) | (4<<BLD_2ND_PIXEL_SHIFT))
	strh r0,[r11,#OFFSET_REG_BLDALPHA]

	ldmfd sp!,{pc}

pltt:
	.hword 0x7FFF
	.hword 0x739C,0x6739,0x5294
	.hword 0x03FF,0x039C,0x0249
	.hword 0x7C1F,0x701C,0x5014
	.hword 0x7FE0,0x7380,0x5280
	.hword 0x03E0,0x0380,0x0280
	.hword 0x7C00,0x7000,0x5000
	.hword 0x001F,0x001C,0x0014
	.hword 0x5294,0x0000,0x294A
	.hword 0x4210,0x7FFF

.align

pieces:
	.word 0x89AB159D,0x89AB159D
	.word 0x56AB5926,0x56AB5926
	.word 0x96A759AE,0x96A759AE
	.word 0x596A596A,0x596A596A
	.word 0x8C9A59DE,0x896A459D
	.word 0x456A1592,0x04568159
	.word 0x45961596,0x41564159

digits:
	.word 0x6363321C,0x001C2663 // 0
	.word 0x181E1C18,0x00181818 // 1
	.word 0x3863633E,0x007F030E // 2
	.word 0x3C18307E,0x003E6360 // 3
	.word 0x363C3830,0x00307F33 // 4
	.word 0x3F03033F,0x003E6360 // 5
	.word 0x3F03063C,0x003E6363 // 6
	.word 0x1C38707F,0x000C0C0C // 7
	.word 0x3E63633E,0x003E6363 // 8
	.word 0x7E63633E,0x001E3060 // 9
	.word 0x00000000,0x00000000

	.LTORG

rotcurspeed:
	.word 0
rotspeed0:
	.word 0
rotparam:
	.word 40<<8,64<<8
	.hword 120,80,16384,16384,0

.align

.BSS

well:
	.space 19*16
welltmp:
	.space 19*16
rotdest:
	.space 16
piecedata:
	.space 28*8
tiles:
