cube <- function(x=c(-1,1),y=c(-1,1),z=c(-1,1)) t(expand.grid(x=x,y=y,z=z))
colors <- NULL
triangleIndices <- NULL
vertices <- NULL
displaylistId <- NULL
cubeIndices <- function()
{
	as.integer(c(
		1, 3, 4, 1, 4, 2,
		2, 4, 8, 2, 8, 6,
		6, 8, 7, 6, 7, 5,
		5, 7, 3, 5, 3, 1,
		3, 7, 8, 3, 8, 4,
		5, 1, 2, 5, 2, 6
	)-1)
}

cubeColor <- function()
{
	as.raw(rep(c(0x80, 0x80, 0x80),8))
}


initCube <- function()
{
	vertices <<- cube()
	triangleIndices <<- cubeIndices()
	colors <<- cubeColor()
    displaylistId <<- loadDisplaylist()
}

loadDisplaylist <- function()
{
	glEnableClientState(GL_VERTEX_ARRAY)
	glVertexPointer(3, GL_DOUBLE, 0, vertices )

	glEnableClientState(GL_COLOR_ARRAY)  
	glColorPointer(3, GL_UNSIGNED_BYTE, 0, cubeColor() )

	glEnableClientState(GL_NORMAL_ARRAY)
	glNormalPointer(GL_DOUBLE, 0, vertices)
	
	displaylistId <- glGenLists(1)
	glNewList( displaylistId, GL_COMPILE )    	
	glPushAttrib(GL_ENABLE_BIT)
		
		glEnable(GL_CULL_FACE)
		glEnable(GL_NORMALIZE)
		glEnable(GL_LIGHTING)
		glEnable(GL_LIGHT0)
		glShadeModel(GL_SMOOTH)
		
		glDisable(GL_BLEND)
		glDisable(GL_TEXTURE_2D)
		
		glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE)
		glEnable(GL_COLOR_MATERIAL)
	
		glEnable(GL_DEPTH_TEST)
		glDrawElements(GL_TRIANGLES, length(triangleIndices), GL_UNSIGNED_INT, triangleIndices)
		
		glDisable(GL_DEPTH_TEST)
		glDisable(GL_COLOR_MATERIAL)
		
		glEnable(GL_TEXTURE_2D)
		glEnable(GL_BLEND)
		
		glDisable(GL_LIGHT0)
		glDisable(GL_LIGHTING)
		glDisable(GL_NORMALIZE)
		glDisable(GL_CULL_FACE)
		
	glPopAttrib()
	glEndList()

	glDisableClientState(GL_VERTEX_ARRAY)
	glDisableClientState(GL_COLOR_ARRAY)
	glDisableClientState(GL_NORMAL_ARRAY)

	return(displaylistId)
}

drawCube <- function(time,start,stop) {
  
  if(time > start && time < stop) {
    tdemo <- time - start 

    glPushAttrib(GL_ENABLE_BIT)

		glMatrixMode(GL_PROJECTION)
		
			glLoadIdentity()
			aspect <- 512/512
			gluPerspective(60, aspect, 3, 1000)

			glMatrixMode(GL_MODELVIEW)
			glLoadIdentity()

			specularLight <- as.floatraw(c(1.0, 1.0, 1.0, 1.0))
			glTranslatef(0, 0, -2)
			glPushMatrix()

			gluLookAt(0,0,5,0,0,0,0,1,0)
			glRotated(sin(tdemo)*60.0, 0, 1, 0)
			glRotated(cos(tdemo)*90.0, 1, 0, 0)
			glTranslatef(0, sin(tdemo), 0)

			glCallList(displaylistId)       

		glPopMatrix()

	glPopAttrib()
  }
}	
