starWhiteId <- NULL
starGreyId <- NULL
starDarkId <- NULL

stars1list_x <- NULL
stars1list_y <- NULL

stars2list_x <- NULL
stars2list_y <- NULL

stars3list_x <- NULL
stars3list_y <- NULL

starfield_drop_time <- 30

initStars <- function(num1=40, num2=30, num3=15) {
	starWhiteId <<- loadTexture("star_white.png")
	starGreyId <<- loadTexture("star_grey.png")
	starDarkId <<- loadTexture("star_dark.png")

	stars1list_x <<- runif(num1, -1, 1)
	stars1list_y <<- runif(num1, -1, 1)

	stars2list_x <<- runif(num2, -1, 1)
	stars2list_y <<- runif(num2, -1, 1)

	stars3list_x <<- runif(num3, -1, 1)
	stars3list_y <<- runif(num3, -1, 1)
} 

drawStar <- function(time, x, y, z) 
{

	w <- 0.1
	h <- 0.1

      glTexCoord2f(0,0) ; 
      glVertex3f(x  ,y  ,0)

      glTexCoord2f(1,0) ; 
      glVertex3f(x+w,y  ,0)

      glTexCoord2f(1,1) ; 
      glVertex3f(x+w,y+h,0)

      glTexCoord2f(0,1) ; 
      glVertex3f(x  ,y+h,0)
	
}


drawStarField <- function(time) {
	glPushAttrib(GL_ENABLE_BIT)
	glEnable(GL_TEXTURE_2D)
	glEnable(GL_BLEND)
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

	glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()  
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
		
        glColor3f(0.3,0.3,0.3)

	glBindTexture(GL_TEXTURE_2D, starDarkId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars3list_x)) {
		drawStar(time, stars3list_x[[i]], stars3list_y[[i]])
		stars3list_x[[i]] <<- stars3list_x[[i]] - 0.005
		if(		stars3list_x[[i]] < -1.5 ) {	
					stars3list_x[[i]] <<- stars3list_x[[i]] + 2.6
		
		}

	}
	glEnd()
	glBindTexture(GL_TEXTURE_2D, starGreyId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars2list_x)) {
		drawStar(time, stars2list_x[[i]], stars2list_y[[i]])
		stars2list_x[[i]] <<- stars2list_x[[i]] - 0.01
		if(		stars2list_x[[i]] < -1.5 ) {	
					stars2list_x[[i]] <<- stars2list_x[[i]] + 2.6
		
		}

	}
	glEnd()
	glBindTexture(GL_TEXTURE_2D, starWhiteId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars1list_x)) {
		drawStar(time, stars1list_x[[i]], stars1list_y[[i]])
		stars1list_x[[i]] <<- stars1list_x[[i]] - 0.015
		if(		stars1list_x[[i]] < -1.5 ) {	
					stars1list_x[[i]] <<- stars1list_x[[i]] + 2.6
		
		}

	}
	glEnd()
	glPopAttrib()
}

dropStarField <- function(time) {
	glPushAttrib(GL_ENABLE_BIT)
	glEnable(GL_TEXTURE_2D)
	glEnable(GL_BLEND)
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

	glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()  
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()

	glBindTexture(GL_TEXTURE_2D, starDarkId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars3list_x)) {
		drawStar(time, stars3list_x[[i]], stars3list_y[[i]])
		stars3list_y[[i]] <<- stars3list_y[[i]] - 0.01*time
		if(		stars3list_x[[i]] < -1.5 ) {	
					stars3list_x[[i]] <<- stars3list_x[[i]] + 2.6
		}

	}
	glEnd()
	glBindTexture(GL_TEXTURE_2D, starGreyId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars2list_x)) {
		drawStar(time, stars2list_x[[i]], stars2list_y[[i]])
		stars2list_y[[i]] <<- stars2list_y[[i]] - 0.01*time
		if(		stars2list_x[[i]] < -1.5 ) {	
					stars2list_x[[i]] <<- stars2list_x[[i]] + 2.6
		
		}

	}
	glEnd()
	glBindTexture(GL_TEXTURE_2D, starWhiteId)
	glBegin(GL_QUADS)
	for(i in 1:length(stars1list_x)) {
		drawStar(time, stars1list_x[[i]], stars1list_y[[i]])
		stars1list_y[[i]] <<- stars1list_y[[i]] - 0.01*time
		if(		stars1list_x[[i]] < -1.5 ) {	
					stars1list_x[[i]] <<- stars1list_x[[i]] + 2.6
		
		}

	}
	glEnd()
	glPopAttrib()
}

updateStarsCheapo <- function(tdemo, start_time, stop_time)
{
	if(tdemo > start_time && tdemo < stop_time) {
		drawStarField(tdemo)
	}	
}

updateStars <- function(tdemo, start_time, stop_time, dtime)
{	
      return()
	if(tdemo > start_time && tdemo < stop_time) {
		if(tdemo < dtime) {
			drawStarField(tdemo)
		} else {
			dropStarField((tdemo - start_time))
		}
	}
}
