drawFlash <- function(time, time_start, time_stop, direction) {
	if(time > time_start && time < time_stop) {
		reltime = time - time_start
		relstop = time_stop - time_start

		col = reltime/relstop
		
		if(direction == 0) {
			col = 1 - col
		}
		
		glPushAttrib(GL_ENABLE_BIT)
		
			glDisable(GL_BLEND)
			glDisable(GL_DEPTH_TEST)
			glDisable(GL_TEXTURE_2D)
			glMatrixMode(GL_MODELVIEW)
			glLoadIdentity()  
			glMatrixMode(GL_PROJECTION)
			glLoadIdentity()

			x <- -2
			y <- -2
			w <- 4
			h <- 4

			glBegin(GL_QUADS)
				glColor3f(col,col,col)
				glVertex3f(x ,y  , 0)
				glVertex3f(x+w ,y  ,0)
				glVertex3f(x+w,y+h,0)
				glVertex3f(x,y+h,0)
			glEnd()

		glPopAttrib()
	}
}

drawBox <- function(time, time_start, time_stop, texture_id) 
{
	if(time > time_start && time < time_stop) {
		
		glPushAttrib(GL_ENABLE_BIT)
		
			glEnable(GL_TEXTURE_2D)
			glBindTexture(GL_TEXTURE_2D, texture_id)

			glEnable(GL_BLEND)
			glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

			glMatrixMode(GL_MODELVIEW)
			glLoadIdentity()  
			glMatrixMode(GL_PROJECTION)
			glLoadIdentity()

			x <- -0.8
			y <- -0.8
			w <- 1.6
			h <- 1.6

			glBegin(GL_QUADS)
				glColor3f(1,0,1)
				glTexCoord2f(0,1) ; 
				glVertex3f(x ,y  , 0)

				glTexCoord2f(1,1) ; 
				glVertex3f(x+w ,y  ,0)

				glTexCoord2f(1,0) ; 
				glVertex3f(x+w,y+h,0)

				glTexCoord2f(0,0) ; 
				glVertex3f(x,y+h,0)
			glEnd()
		
		glPopAttrib()
	}
}

