# soulsalicious 
# happy birthday intro / a ph-neutral after-tro
# for souls -- 2011/05/30 @ b3rl1n

source("efx_starfield.R")
source("efx_scroller.R")
source("efx_text.R")
source("efx_cube.R")

startTime <- 0.0*1000

titleId <- NULL
t2Id <- NULL
logo <- NULL
title2Id <- NULL
endId <- NULL
realEndId <- NULL
moreId <- NULL
guaranaId <- NULL

flashWhiteLength <- 0.2
flashBlackLength <- 0.3

load <- function()
{
	initStars()
	initScroller()
	initCube()
	titleId <<- loadTexture("text.png")
	title2Id <<- loadTexture("text2.png")

	boxId <<- loadTexture("guarana.png")
	moreId <<- loadTexture("more.png")
	logoId <<- loadTexture("logo.png")

	endId <<- loadTexture("end.png")
	realEndId <<- loadTexture("3nd.png")
	guaranaId <<- loadTexture("guarana.png")
}

update <- function(tdemo)
{
	glClearColor(0,0,0,0)
	glClear(GL_COLOR_BUFFER_BIT+GL_DEPTH_BUFFER_BIT)
	lb <- 0

	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	drawBox(tdemo, lb, lb+3, titleId)
	lb <- lb + 3
	
	drawCube(tdemo, lb, lb+4)
	drawBox(tdemo, lb, lb+4, title2Id)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	drawBox(tdemo, lb, lb+4, logoId)
	drawFlash(tdemo, lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo, lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	updateStarsCheapo(tdemo,lb, lb + 30)
	drawCube(tdemo, lb, lb + 30)
	scroll_text1 <- utf8ToInt("HAPPY BIRTHDAY SOULS! GR33TINGS FROM TEH V01D KR3W!") - 32
	updateScroller(tdemo, lb+4, lb+30,scroll_text1)
	drawFlash(tdemo, lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo, lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 30
	
	drawBox(tdemo, lb, lb+4, endId)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	drawCube(tdemo, lb, lb+4)
	drawBox(tdemo, lb, lb+4, moreId)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	drawBox(tdemo, lb, lb+4, guaranaId)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	drawBox(tdemo, lb, lb+4, realEndId)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb + 4
	
	updateStarsCheapo(tdemo ,lb, lb+42)
	scroll_text2 <- utf8ToInt("C0D3: PL3X, SPEKUL, GH0ST - GFX: GH0ST, SPEKUL - CHIP: ESTRAYK - SM0KE: D1G - ATHM0: NANOC") - 32
	updateScroller(tdemo, lb, lb+42,scroll_text2)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb+42
	
	updateStarsCheapo(tdemo,lb, lb+11.6)
	drawCube(tdemo, lb, lb+11.6)
	scroll_text3 <- utf8ToInt("HACKER!! HACKER!!") - 32
    updateScroller(tdemo,lb, lb + 11.6, scroll_text3)
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb+11.6
	
	drawFlash(tdemo,lb, lb+flashWhiteLength, 1)
	drawFlash(tdemo,lb+flashWhiteLength, lb+flashWhiteLength+flashBlackLength, 0)
	lb <- lb+0.6

    if (tdemo > 112) doQuit <<- TRUE
	
	#112 intro seconds reached! :D
}


s     <- NULL
texId <- NULL
music <- NULL

checkGL <- function()
{
  glerror <- glGetError()
  if (glerror != 0)
  {
    cat("GL Error", glerror, "\n")
  }
  return(glerror == 0)
}
  
init <- function()
{
  require(rdyncall)
  dynport(SDL)
  SDL_Init(SDL_INIT_VIDEO+SDL_INIT_AUDIO)
  dynport(GL)
  dynport(GLU)
  dynport(SDL_image)

  SDL_GL_SetAttribute(SDL_GL_RED_SIZE,8)
  SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,8)
  SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,8)
  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1)
  s <<- SDL_SetVideoMode(0,0,32,SDL_HWSURFACE+SDL_OPENGL+SDL_DOUBLEBUF+SDL_FULLSCREEN)

  stopifnot( IMG_Init(IMG_INIT_PNG) == IMG_INIT_PNG )
  load()
  dynport(SDL_mixer)
  Mix_OpenAudio(MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 2, 4096)
  music <<- Mix_LoadMUS("birthday_intro_thm.mod")
  SDL_ShowCursor(SDL_DISABLE)
}
  
rsrc <- function(name) name # system.file(paste("demo-files",name,sep=.Platform$file.sep), package="rdyncall")

loadTexture <- function(name)
{
  checkGL()
  glEnable(GL_TEXTURE_2D)
  x <- rsrc(name)
  img <- IMG_Load(x)
  texid <- integer(1)
  glGenTextures(1, texid)
  glBindTexture(GL_TEXTURE_2D, texid)
  SDL_LockSurface(img)
  maxS <- integer(1)
  glGetIntegerv(GL_MAX_TEXTURE_SIZE, maxS)
  stopifnot( (img$w <= maxS) && (img$h <= maxS) )

  if (Sys.info()[["sysname"]] == "Darwin") {
    fmt <- GL_BGRA
  } else {
    fmt <- GL_RGBA
  }

  glTexImage2D(GL_TEXTURE_2D, 0, 4, img$w, img$h, 0, fmt, GL_UNSIGNED_BYTE, img$pixels)
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE)
  SDL_UnlockSurface(img)
  SDL_FreeSurface(img) 
  return(texid)
}
  
doQuit <<- FALSE
  
mainloop <- function()
{
  Mix_PlayMusic(music, 1)
  doQuit <<- FALSE
  tbase <- SDL_GetTicks() - startTime
  evt <- new.struct(SDL_Event)
  #tdemo <- 0
  #tstep <- (1000/60)/1000
  while(!doQuit)
  {
    tnow <- SDL_GetTicks()
    tdemo <- ( tnow - tbase ) / 1000
    update(tdemo)
    #tdemo <- tdemo + tstep
    glFinish()
    SDL_GL_SwapBuffers()
    # SDL_WM_SetCaption(paste("tdemo:", tdemo),NULL)
	
    while( SDL_PollEvent(evt) != 0 )
    {
      type <- evt$type
      if ( 
           type == SDL_QUIT 
      || ( type == SDL_KEYDOWN && evt$key$keysym$sym == SDLK_ESCAPE )
      ) {
        doQuit <<- TRUE
      }
    }
    SDL_Delay(1)
  }
}

cleanup <- function()
{
  SDL_SetVideoMode(640,480,32,SDL_OPENGL)
  Mix_CloseAudio()
#  Mix_Quit()
  IMG_Quit()
  SDL_Quit()
}

run <- function()
{
  init()
  mainloop()
  cleanup()
}

run()

