; Commodore C128 post-challenge entry for VCCC2024 by GeirS, 2025-05-24.
; Size: 37 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 11552 to start.

PrImm           = $fa17             ; Print inline null-terminated string
NewLine         = $a2ce             ; Print new line char
EorValues       = $88fd             ; Contains values 1 and 6
Pnt             = $e0               ; Pointer to current screen line
Every9thRow     = $84               ; Variable for determining every 9th row (1 at startup)
Every9thCol     = $7d               ; Variable for determining every 9th column (255 at startup)
BoxChars        = $16               ; Contains values 32 and 45 after SYS command

                * = $2d20           ; Load address

; Code and data (37 bytes)
Start           jsr PrImm           ; Print inline null-terminated string
                .byte 9,205,79,47,0 ; Tab, '\', 'O', '/', 0
RowLoop         txa
                lsr                 ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rol
                tax                 ; Index to 'BoxChars'
                jsr NewLine         ; Print new line char
                .byte $ac           ; Opcode for 'ldy $7d26' (will set y to 18)
ColLoop         rol Every9thCol     ; Skipped on first loop iteration due to 'ldy' above
                lda BoxChars,x      ; Get space or '-'
                bcs PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         sta (Pnt),y         ; Put char on screen
                dey
                bpl ColLoop         ; Loop for all columns
                asl $43,x           ; Contains word $1c00 at startup
                bpl RowLoop         ; Loop for all rows
                rts
