; MEGA65 post-challenge entry for VCCC2024 by GeirS, 2025-10-09.
; Size: 40 bytes excl. load address. Assemble using ACME.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 11552 to start.

                !cpu m65
                !to "present.prg",cbm

ROM_VERSION     = 920413            ; 920413 or 920417

!if ROM_VERSION = 920413 {
NewLine         = $e691             ; Print new line char
EorValues       = $ee20             ; Contains values 1 and 6
Every9thCol     = $e6               ; Variable for determining every 9th column (0 at startup)
} else if ROM_VERSION = 920417 {
NewLine         = $e7ba             ; Print new line char
EorValues       = $ef56             ; Contains values 1 and 6
Every9thCol     = $f6               ; Variable for determining every 9th column (0 at startup)
} else { !error "Unsupported MEGA65 ROM version" }

PrImm           = $ff7d             ; Print inline null-terminated string
Pnt             = $c4               ; Pointer to current line (might change in later ROM versions)
Every9thRow     = $97               ; Variable for determining every 9th row (1 at startup)
BoxChars        = $18               ; Contains values 32 and 45 after SYS command

                * = $2d20           ; Load address

; Code and data (40 bytes)
Start           jsr PrImm           ; Print inline null-terminated string
                !byte 9,205,79,47,0 ; Tab, '\', 'O', '/', 0
RowLoop         txa
                lsr                 ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rol
                pha                 ; Save value for use below
                jsr NewLine         ; Print new line
                plx                 ; Index to 'BoxChars'
                ldy #19             ; 19 columns per row
                !byte $cb           ; Opcode for 'asw abs' (will set carry flag)
ColLoop         ror Every9thCol     ; Skipped on first loop iteration due to 'asw' above
                lda BoxChars,x      ; Get space or '-'
                bcc PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         dey
                sta (Pnt),y         ; Put char on screen
                bne ColLoop         ; Loop for all columns
                asl $43,x           ; Contains word $2000 at startup
                bcc RowLoop         ; Loop for all rows
                rts
