﻿local M={}
local img1,img2
local iw,ih
local cachedTimePassed=0.0
local finished=false
function M.load()
img1=love.graphics.newImage("gurumeditation-01.png")
img2=love.graphics.newImage("gurumeditation-02.png")
img1:setFilter("nearest","nearest")
img2:setFilter("nearest","nearest")
iw,ih=img1:getWidth(),img1:getHeight()
cachedTimePassed=0.0
finished=false end
function M.update(dt,timePassed)
cachedTimePassed=timePassed
if finished then return end
local t0=3.76
local t=cachedTimePassed-t0
if t>=3.84 then
local tm=t-3.84
local shrinkDurSec=11.52
if tm>=shrinkDurSec then
finished=true end end end
function M.isFinished()
return finished end
local function flipImageAtTime(localT)
local cycle=math.floor(localT/0.96)
local useFirst=(cycle%2==0)
return useFirst and img1 or img2 end
local function asymmetricIntensePulse(t_since_motion_start)
local beatPos=(t_since_motion_start/0.48)%1.0
local Amax=0.08
local fin=0.20
if beatPos<fin then
local u=beatPos/fin
return 1.0+Amax*u
else
local u=(beatPos-fin)/(1.0-fin)
return 1.0+Amax*(1.0-u) end end
local function smoothstep01(x)
if x<=0 then return 0 end
if x>=1 then return 1 end
return x*x*(3-2*x) end
local function drawCentered(img,x,y,r,sx,sy)
love.graphics.setColor(1,1,1,1)
love.graphics.draw(img,x,y,r or 0,sx or 1,sy or sx or 1,iw/2,ih/2) end
function M.draw()
if finished then return end
local t0=3.76
local t=cachedTimePassed-t0
if t<0 then
return
end
local img=flipImageAtTime(t)
local W,H=love.graphics.getWidth(),love.graphics.getHeight()
local cx,cy=W*0.5,H*0.5
local rx=math.max(0,math.min(W*0.33,(W-iw)*0.45))
local ry=math.max(0,math.min(H*0.33,(H-ih)*0.45))
if t<3.84 then
drawCentered(img,cx,cy,0,1,1)
return
end
local tm=t-3.84
local x=cx+rx*math.cos(0.2045307717180855*tm)
local y=cy+ry*math.sin(0.2045307717180855*tm*1.07)
local rot=(0.5454153912482279*tm)%(2*math.pi)
local punchScale=asymmetricIntensePulse(tm)
local cycleT=tm/7.68
local cyclePhase=math.sin(2*math.pi*cycleT)
local cycleScale=1.0+0.04*cyclePhase
local shrinkDurSec=11.52
local shrinkAlpha=smoothstep01(math.min(1.0,math.max(0.0,tm/shrinkDurSec)))
local shrinkScale=1.00+(0.00-1.00)*shrinkAlpha
local finalScale=shrinkScale*cycleScale*punchScale
drawCentered(img,x,y,rot,finalScale,finalScale) end
return M
