#!/usr/bin/tcc -run -lgd

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "gdhelper.h"


int main( int argc, char *argv[] )
{
   gdImagePtr im;
   int x,y;
   FILE *f;

   im = gdLoadImg( "images/kickhand.gif" );
   if( !im )
   {
      fprintf( stderr, "image load failed\n");
      return 20;
   }

   f = fopen( "gfx/kickhand.bin", "wb" );
   if( !f )
   {
      fprintf( stderr, "bin file creation failed\n" );
      gdImageDestroy( im );
      return 21;
   }
   for( y = 0; y < im->sy/4; ++y )
   {
      for( x = 0; x < im->sx; ++x )
      {
         unsigned char c;
         c  = im->pixels[y+ 0][x] << 6;
         c |= im->pixels[y+ 8][x] << 4;
         c |= im->pixels[y+16][x] << 2;
         c |= im->pixels[y+24][x] << 0;
         fputc( c, f );
      }
   }
   fclose( f );

   gdImageDestroy( im );

   return 0;
}
