; 8bitworshop.com is the recommended IDE for this demo

	processor 6502
        include vcs.h
        include macro.h
        include xmacro.h
     
SHOW_FREE_CPU = 0

	MAC TIMER_WAIT_2
        
        IF SHOW_FREE_CPU
                LDA INTIM
                BPL .continueWait
                LDA #$64
                BNE .doneWait
        .continueWait        
                LDA #$04
                STA COLUBK
        ENDIF
.waitForImtim        
        LDA INTIM
        BNE .waitForImtim
        IF SHOW_FREE_CPU
                LDA #$00
        .doneWait        
                STA COLUBK
        ENDIF
        
        ENDM
; TV format switches
PAL             = 1
NTSC            = 0

        IF PAL
TIM_VBLANK      = 43
TIM_OVERSCAN    = 36
TIM_KERNEL      = 19
        ELSE
TIM_VBLANK      = 45
TIM_OVERSCAN    = 38
TIM_KERNEL      = 15
        ENDIF


AROUND_THE_WORLD equ 1
WHOLE_FONT equ 1
ANIMATE_TEXT_BANK1 equ 1


   MAC ALIGN_LINE_ROUTINE
.Bank   SET {1}
.Function   SET {2}
.FunctionName SET {3}

.X0Offset SET {2}X0 & $FFF
.X1Offset SET {2}X1 & $FFF
.X2Offset SET {2}X2 & $FFF
.X3Offset SET {2}X3 & $FFF
.X4Offset SET {2}X4 & $FFF
.X5Offset SET {2}X5 & $FFF

        ; echo {.FunctionName},"X0Offset is:" , .X0Offset
        ; echo {.FunctionName},"X1Offset is:" , .X1Offset
        ; echo {.FunctionName},"X2Offset is:" , .X2Offset

.BiggerX0X1Offset=[.X0Offset>.X1Offset?.X0Offset-.X1Offset]+.X1Offset
.BiggerX0X1X2Offset=[.BiggerX0X1Offset>.X2Offset?.BiggerX0X1Offset-.X2Offset]+.X2Offset
.BiggerX0X1X2X3Offset=[.BiggerX0X1X2Offset>.X3Offset?.BiggerX0X1X2Offset-.X3Offset]+.X3Offset
.BiggerX0X1X2X3X4Offset=[.BiggerX0X1X2X3Offset>.X4Offset?.BiggerX0X1X2X3Offset-.X4Offset]+.X4Offset
.BiggerOffset=[.BiggerX0X1X2X3X4Offset>.X5Offset?.BiggerX0X1X2X3X4Offset-.X5Offset]+.X5Offset

        ; echo "BiggerOffset is:" , .BiggerOffset
.orgAddress={1} * $1000 + .BiggerOffset
.rorgAddress={1} * $2000 + $1000 + .BiggerOffset

        ; echo "Add ", .BiggerOffset - .X0Offset, " bytes before ", {.FunctionName},"X0"
        ; echo "Add ", .BiggerOffset - .X1Offset, " bytes before ", {.FunctionName},"X1"
        ; echo "Add ", .BiggerOffset - .X2Offset, " bytes before ", {.FunctionName},"X2"
        ; echo "Add ", .BiggerOffset - .X3Offset, " bytes before ", {.FunctionName},"X3"
        ; echo "Add ", .BiggerOffset - .X4Offset, " bytes before ", {.FunctionName},"X4"
        ; echo "Add ", .BiggerOffset - .X5Offset, " bytes before ", {.FunctionName},"X5"

        ; RORG .rorgAddress

   ENDM

;    MAC ALIGN_LINE_ROUTINE2
; .Bank   SET {1}
; .Function   SET {2}

; .X0Offset SET {2}X0 & $FFF
; .X1Offset SET {2}X1 & $FFF
; .X2Offset SET {2}X2 & $FFF

; .BiggerX0X1Offset=[.X0Offset>.X1Offset?.X0Offset-.X1Offset]+.X1Offset
; .BiggerOffset=[.BiggerX0X1Offset>.X2Offset?.BiggerX0X1Offset-.X2Offset]+.X2Offset

;         ORG .Bank * $1000 + .BiggerOffset
;         RORG .Bank * $2000 + $1000 + .BiggerOffset

;    ENDM


        MAC BANK_SWITCH_TRAMPOLINE  
        pha             ; push hi byte
        tya             ; Y -> A
        pha             ; push lo byte
        ora $1FF4,x     ; do the bank switch ; 2 banks => FF8, 8 banks ==> FF4
        LDA #0
        rts             ; return to target
        ENDM

        MAC BANK_SWITCH_TRAMPOLINE_Y
        ora $1FF4,y     ; do the bank switch ; 2 banks => FF8, 8 banks ==> FF4
        rts             ; return to target
        ENDM

; Macro that performs bank switch
        MAC BANK_SWITCH
.Bank   SET {1}
.Addr   SET {2}
        lda #>(.Addr-1)
        ldy #<(.Addr-1)
        ldx #.Bank
        jmp BankSwitch
        ENDM

        MAC NOP3
        .BYTE $44,0
        ENDM

        MAC MAGI_CALL
.CurrentBank SET {1}
.Bank SET {2}
.Addr SET {3}
        lda #>(.RetAddr - 1)
        pha
        lda #<(.RetAddr - 1)
        pha
        lda #.CurrentBank
        pha
        ldx #.Bank
        lda #>(.Addr-1)
        ldy #<(.Addr-1)
        jmp BankSwitch
.RetAddr
        ENDM

        MAC RET_MAGI_CALL
        pla 
        tax
        jmp BankSwitch + 3
        ENDM


Y_DIVIDER equ 32

COLOR_VEST equ $D0
COLOR_BELT equ $28
COLOR_RED equ $62 ; besoin du bit 1 a 1 pour le missile 1
COLOR_WHITE equ $FE
COLOR_YELLOW equ $4A
COLOR_GREEN equ $5E
COLOR_BLUE equ $7E

COLOR_GREEN_0 equ $50
COLOR_GREEN_1 equ $52
COLOR_GREEN_2 equ $54
COLOR_GREEN_3 equ $56
COLOR_GREEN_4 equ $58
COLOR_GREEN_5 equ $5A
COLOR_GREEN_6 equ $5C

COLOR_BLUE_6 equ $7C
COLOR_BLUE_5 equ $7A
COLOR_BLUE_4 equ $78
COLOR_BLUE_3 equ $76
COLOR_BLUE_2 equ $74
COLOR_BLUE_1 equ $72
COLOR_BLUE_0 equ $70
COLOR_MARINE_0 equ $90
COLOR_MARINE_1 equ $92
COLOR_MARINE_2 equ $94
COLOR_MARINE_3 equ $96

; =====================================================================
; Variables
; =====================================================================

        SEG.U   variables
        ORG     $80


; 1: Global song speed, 0: Each pattern has individual speed
TT_GLOBAL_SPEED         = 1
; duration (number of TV frames) of a note
TT_SPEED                = 6
; duration of odd frames (needs TT_USE_FUNKTEMPO)
TT_ODD_SPEED            = 6

; 1: Overlay percussion, +40 bytes
TT_USE_OVERLAY          = 0
; 1: Melodic instrument slide, +9 bytes
TT_USE_SLIDE            = 0
; 1: Goto pattern, +8 bytes
TT_USE_GOTO             = 0
; 1: Odd/even rows have different SPEED values, +7 bytes
TT_USE_FUNKTEMPO        = 0
; If the very first notes played on each channel are not PAUSE, HOLD or
; SLIDE, i.e. if they start with an instrument or percussion, then set
; this flag to 0 to save 2 bytes.
; 0: +2 bytes
TT_STARTS_WITH_NOTES    = 1

; static (global) variables
TIATRACKER_ORG equ $80
; =====================================================================
; Permanent variables. These are states needed by the player.
; =====================================================================
tt_timer                equ TIATRACKER_ORG + 0 ;ds 1    ; current music timer value
tt_cur_pat_index_c0     equ TIATRACKER_ORG + 1 ; ds 1    ; current pattern index into tt_SequenceTable
tt_cur_pat_index_c1     equ TIATRACKER_ORG + 2 ; ds 1
tt_cur_note_index_c0    equ TIATRACKER_ORG + 3 ; ds 1    ; note index into current pattern
tt_cur_note_index_c1    equ TIATRACKER_ORG + 4 ; ds 1
tt_envelope_index_c0    equ TIATRACKER_ORG + 5 ; ds 1    ; index into ADSR envelope
tt_envelope_index_c1    equ TIATRACKER_ORG + 6 ; ds 1
tt_cur_ins_c0           equ TIATRACKER_ORG + 7 ; ds 1    ; current instrument
tt_cur_ins_c1           equ TIATRACKER_ORG + 8 ; ds 1

DEMO_PART equ $89 ; les 4 bits de poids fort pilotent le logo
; variables du scenario
SCENARIO_PTR equ $8A ; word
;SCENARIO_DONE equ $8C ; 1 bit : mettre ailleurs. dans les bits de poids fort de scenario ptr
COUNTER equ $8C ; pour emitFrames
ANIM_COUNTER equ $8D ; pour compter les frames d'animation

; =====================================================================
; Temporary variables. These will be overwritten during a call to the
; player routine, but can be used between calls for other things.
; =====================================================================
tt_ptr           equ $8E
COLOR_WHITE_BYTE equ $8E
COLOR_BLACK_BYTE equ $8F

; changing part of RAM

COLOR_VEST_BYTE equ $90
COLOR_RED_BYTE equ $91
COLOR_FF_BYTE equ $92

TEMP1 equ COLOR_WHITE_BYTE
TEMP2 equ COLOR_BLACK_BYTE
TEMP3 equ COLOR_VEST_BYTE
TEMP4 equ COLOR_RED_BYTE
TEMP5 equ COLOR_FF_BYTE

FRAME equ $93 ; one byte

BACKGROUND_COLOR_LINE_0  equ $94
BACKGROUND_COLOR_LINE_1  equ BACKGROUND_COLOR_LINE_0 + 1
BACKGROUND_COLOR_LINE_2  equ BACKGROUND_COLOR_LINE_0 + 2
BACKGROUND_COLOR_LINE_3  equ BACKGROUND_COLOR_LINE_0 + 3
BACKGROUND_COLOR_LINE_4  equ BACKGROUND_COLOR_LINE_0 + 4
BACKGROUND_COLOR_LINE_5  equ BACKGROUND_COLOR_LINE_0 + 5
BACKGROUND_COLOR_LINE_6  equ BACKGROUND_COLOR_LINE_0 + 6
BACKGROUND_COLOR_LINE_7  equ BACKGROUND_COLOR_LINE_0 + 7
BACKGROUND_COLOR_LINE_8  equ BACKGROUND_COLOR_LINE_0 + 8
BACKGROUND_COLOR_LINE_9  equ BACKGROUND_COLOR_LINE_0 + 9
BACKGROUND_COLOR_LINE_10 equ BACKGROUND_COLOR_LINE_0 + 10
BACKGROUND_COLOR_LINE_11 equ BACKGROUND_COLOR_LINE_0 + 11
BACKGROUND_COLOR_LINE_12 equ BACKGROUND_COLOR_LINE_0 + 12
BACKGROUND_COLOR_LINE_13 equ BACKGROUND_COLOR_LINE_0 + 13
BACKGROUND_COLOR_LINE_14 equ BACKGROUND_COLOR_LINE_0 + 14
BACKGROUND_COLOR_LINE_15 equ BACKGROUND_COLOR_LINE_0 + 15
BACKGROUND_COLOR_LINE_16 equ BACKGROUND_COLOR_LINE_0 + 16
BACKGROUND_COLOR_LINE_17 equ BACKGROUND_COLOR_LINE_0 + 17
BACKGROUND_COLOR_LINE_18 equ BACKGROUND_COLOR_LINE_0 + 18
BACKGROUND_COLOR_LINE_19 equ BACKGROUND_COLOR_LINE_0 + 19
BACKGROUND_COLOR_LINE_20 equ BACKGROUND_COLOR_LINE_0 + 20
BACKGROUND_COLOR_LINE_21 equ BACKGROUND_COLOR_LINE_0 + 21
BACKGROUND_COLOR_LINE_22 equ BACKGROUND_COLOR_LINE_0 + 22
BACKGROUND_COLOR_LINE_23 equ BACKGROUND_COLOR_LINE_0 + 23
BACKGROUND_COLOR_LINE_24 equ BACKGROUND_COLOR_LINE_0 + 24

; variables du split raster
PF_BANK_SWITCHER equ $AD ; word ;  4 bits libres, les adresses font 12 bits
COLOR_BANK_SWITCHER equ $AF ; word;  4 bits libres, les adresses font 12 bits
Y_DIVIDER_ZP equ $B1
WAIT_LINES equ $B2
; l'effet de decalage vertical entre le raster et le playfield sera gere par un byte en memoire
; controle par le scenario, qui sera ajoute au X_POS pour creer l'effet
X_POS equ $B3
SYNC_CYCLES equ $B4
OSCILLATION equ $B5


MODE equ $B6
TRUE_XPOS equ $B7
TRUE_YPOS equ $B8 ; point d'ancrage fixe par le haut du sprite
SCREEN_YPOS equ $B9
SPRITESTART_YPOS equ $BA ; = TRUE_YPOS + 1 quand le sprite fait 20 lignes de haut au lieu de 21
STEP_ANIM equ $BB ; 2 bits
STEP_COUNTER equ $BC ; pour la vitesse des pas, rarement plus de 2 ou 3 bit
; could also go to step anim
; TRUE_XPOS uses only 6 bits

; MODE bits
BIT_DIRECTION equ 1
; display face
BIT_FACE_ENABLE equ 2
; display playfield
BIT_PLAYFIELD_ENABLE equ 4
; utilise le missile 0 et la balle pour cacher les bords du split raster
BIT_HIDE_SIDES_ENABLE equ 8
; bidouille call stack qui repete des lignes
BIT_YSTRETCH_ENABLE equ 16 
; passe le visage en noir
BIT_DAFT_PUNK_ENABLE equ 32
; cache le sprite 0 et utilise le missile 0 pour colorer le playfield cache dans le noir
BIT_GHOST_ENABLE equ 64
; when OSCILLATION is != 0, allow the split raster to oscillate, not only face and missile
BIT_OSCILLATION_RASTER_ENABLE equ 128

; SCENARIO_PTR_HI bits
BIT_SCENARIO_DONE equ $80
BIT_YSTRETCH_FLY_ENABLE equ $40
BIT_DECOLLE_ENABLE equ $20

;RASTER SCENARIO_PTR_HI bits
BIT_USE_SPRITES equ $80
BIT_WOBBLING equ $40
BIT_SAX_BACKGROUND equ $20

; arguments pour loopPushLines. 1 byte a recuperer
CURRENT_FREE_COLOR equ $BD ; set by ClipSprite
SPRITE_YSTART equ $BF
SPRITE_YEND equ $C0
SPRITE_LINE equ $C1
HISPRITE_PTR equ $C2 ; 2 bytes
BACKGROUND_PTR equ $C4 ; 2 bytes

GLOBAL_TEMP equ $C6 ; for loops in scenarios for ex.

; variables text routines
txt_temp2 equ $8F ; 1 bytes , also TIA temp variable

TextPage equ $90 ; 2 bytes
textPtr equ $92 ; 2 bytes
maskPtr equ $94 ; 2 bytes
numLine equ $96 ; 1 byte
mask equ $97 ; 1 byte

temp equ $98 ; 2 bytes

tempStack equ $9A
ToDisplay equ $9B ; 1 byte
GlobalFrame equ $9C ; 2 bytes

Masks equ $9E ; 8 bytes
ColorsText equ $A6 ; 8 bytes

; Demo Part $BB
; TIA $C1-$C9

Char1   equ $AE ; 24 bytes


; variables split raster minimal
SPLIT_RASTER_VARIABLES equ $90

SplitMinimalFrameGoal equ SPLIT_RASTER_VARIABLES + 0
ColorFunctionPtr equ SPLIT_RASTER_VARIABLES + 12

Playfield0 equ SPLIT_RASTER_VARIABLES + 14 ; 2 bytes
Playfield1 equ SPLIT_RASTER_VARIABLES + 16 ; 2 bytes
;ColorFunctionPtr equ SPLIT_RASTER_VARIABLES + 37
;Playfield0 equ SPLIT_RASTER_VARIABLES + 39 ; 2 bytes
;Playfield1 equ SPLIT_RASTER_VARIABLES + 41 ; 2 bytes


; attention fin RAM at $C9 probablement
;FAST_STACK equ $C5

;CurrentPFDataStackPtr equ $E1 ; .byte 0

; =====================================================================
; Start of code
; =====================================================================

        SEG     Code
;        ORG     $1000
;        RORG     $F000
        ORG     $0000
        RORG     $1000

Bank0   SUBROUTINE
Start
;----The following code is the same on both banks----
; Ensure that bank 0 is selected
        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
BankSwitch
        BANK_SWITCH_TRAMPOLINE
BankSwitchY
	BANK_SWITCH_TRAMPOLINE_Y
;----End of bank-identical code----

Reset_0
        ; Clear zeropage        
        cld
        ldx #0
        txa
.clearLoop:
        dex
        txs
        pha
        bne .clearLoop

; fait un TIMER_SETUP pour permettre a l'init de la premiere partie de se synchroniser
; la demo execute PlayNextDemoPart au debut

        lda #TIM_VBLANK
        sta TIM64T
        
; Init TIA Tracker 
	IF AROUND_THE_WORLD = 1
        lda #33 ; 4 ; 2
        sta tt_cur_pat_index_c1
        ELSE
        lda #35
        sta tt_cur_pat_index_c1
	ENDIF        
        
        LDA #(((0 -1) & 15) | (0 * $10)) ;DEMO_PARTS_COUNT - 1
        STA DEMO_PART
	jmp PlayNextDemoPart

Lose103Cycles
	.byte $82
Lose102Cycles
	.byte $82
Lose101Cycles
	.byte $82
Lose100Cycles
	.byte $82
Lose99Cycles
	.byte $82
Lose98Cycles
	.byte $82
Lose97Cycles
	.byte $82
Lose96Cycles
	.byte $82
Lose95Cycles
	.byte $82
Lose94Cycles
	.byte $82
Lose93Cycles
	.byte $82
Lose92Cycles
	.byte $82
Lose91Cycles
	.byte $82
Lose90Cycles
	.byte $82
Lose89Cycles
	.byte $82
Lose88Cycles
	.byte $82
Lose87Cycles
	.byte $82
Lose86Cycles
	.byte $82
Lose85Cycles
	.byte $82
Lose84Cycles
	.byte $82
Lose83Cycles
	.byte $82
Lose82Cycles
	.byte $82
Lose81Cycles
	.byte $82
Lose80Cycles
	.byte $82
Lose79Cycles
	.byte $82
Lose78Cycles
	.byte $82
Lose77Cycles
	.byte $82
Lose76Cycles
	.byte $82
Lose75Cycles
	.byte $82
Lose74Cycles
	.byte $82
Lose73Cycles
	.byte $82
Lose72Cycles
	.byte $82
Lose71Cycles
	.byte $82
Lose70Cycles
	.byte $82
Lose69Cycles
	.byte $82
Lose68Cycles
	.byte $82
Lose67Cycles
	.byte $82
Lose66Cycles
	.byte $82
Lose65Cycles
	.byte $82
Lose64Cycles
	.byte $82
Lose63Cycles
	.byte $82
Lose62Cycles
	.byte $82
Lose61Cycles
	.byte $82
Lose60Cycles
	.byte $82
Lose59Cycles
	.byte $82
Lose58Cycles
	.byte $82
Lose57Cycles
	.byte $82
Lose56Cycles
	.byte $82
Lose55Cycles
	.byte $82
Lose54Cycles
	.byte $82
Lose53Cycles
	.byte $82
Lose52Cycles
	.byte $82
Lose51Cycles
	.byte $82
Lose50Cycles
	.byte $82
Lose49Cycles
	.byte $82
Lose48Cycles
	.byte $82
Lose47Cycles
	.byte $82
Lose46Cycles
	.byte $82
Lose45Cycles
	.byte $82
Lose44Cycles
	.byte $82
Lose43Cycles
	.byte $82
Lose42Cycles
	.byte $82
Lose41Cycles
	.byte $82
Lose40Cycles
	.byte $82
Lose39Cycles
	.byte $82
Lose38Cycles
	.byte $82
Lose37Cycles
	.byte $82
Lose36Cycles
	.byte $82
Lose35Cycles
	.byte $82
Lose34Cycles
	.byte $82
Lose33Cycles
	.byte $82
Lose32Cycles
	.byte $82
Lose31Cycles
	.byte $82
Lose30Cycles
	.byte $82
Lose29Cycles
	.byte $82
Lose28Cycles
	.byte $82
Lose27Cycles
	.byte $82
Lose26Cycles
	.byte $82
Lose25Cycles
	.byte $82
Lose24Cycles
	.byte $82
Lose23Cycles
	.byte $82
Lose22Cycles
	.byte $82
Lose21Cycles
	.byte $82
Lose20Cycles
	.byte $82
Lose19Cycles
	.byte $82
Lose18Cycles
	.byte $82
Lose17Cycles
	.byte $82
Lose16Cycles
        .byte $82 ; Nop imm 2
Lose15Cycles
        .byte $44 ; Nop zp 3
Lose14Cycles
        .byte $EA ; Nop
Lose12Cycles
	JMP BankSwitch + 3
        
; PlayNextDemoPart (en fonction du numero de partie)
; - initialise la partie a jouer (scenarioPtr pour le bomberman, textPage pour le texte,
;   variation pour le split raster minimal) -> ces variables peuvent partager la meme RAM
; - un BANK_SWITCH ou un jump vers l'init de la partie a jouer,
; l'init doit toujours considerer que tout est a initialiser (CLEAN_START) et aussi maintenir
DEMO_PARTS_COUNT equ 12 ;2 ;; 2;4 ;3 ; 13
BOOBS_PART equ 6

DemoPartLo 
	.byte <(Part01-1),<(Part02-1),<(Part03-1),<(Part04-1),<(Part05-1)
	.byte <(Part06-1),<(Part07-1),<(Part08-1),<(Part09-1),<(Part10-1)
	.byte <(Part11-1),<(Part12-1)
        
DemoPartHi 
	.byte >(Part01-1),>(Part02-1),>(Part03-1),>(Part04-1),>(Part05-1)
	.byte >(Part06-1),>(Part07-1),>(Part08-1),>(Part09-1),>(Part10-1)
	.byte >(Part11-1),>(Part12-1)


PlayNextDemoPart
        LDA DEMO_PART
        AND #$F0
        STA DEMO_PART + 1 ; temporarily save high nibble of DEMO_PART: logo height and sound control
        LDA DEMO_PART
        AND #$0F
	CLC
        ADC #1
        AND #$0F
	CMP #DEMO_PARTS_COUNT
        BNE .afterDemoLoop
        LDA #0 ;1 ; passe l'intro apres bouclage
.afterDemoLoop
	TAX
        ORA DEMO_PART + 1
	STA DEMO_PART
        LDA DemoPartHi,x
        PHA
        LDA DemoPartLo,x
        PHA
        RTS
        
;        CPX #0  	; TODO: faire une table de routines pour le branchement
;        BNE .notFirstPart

Part01
;TEST

;	LDA #>(PlayScenarioTest + 3)
;        STA SCENARIO_PTR + 1
;	LDA #<(PlayScenarioTest + 3)
;        STA SCENARIO_PTR
;	jmp InitBomberman ; bomberman 15.36 secondes, 768 frames


TEXT_DURATION equ 192
;	LDA #>(PlayScenario3 + 3)
;        STA SCENARIO_PTR + 1
;	LDA #<(PlayScenario3 + 3)
;        STA SCENARIO_PTR
;	jmp InitBomberman

;	LDA #3
;        LDX #127
;        JMP TextSequence

;	JSR PrepareBomb ; boobs
;	LDA #96 ; 7.68 secondes
;	JMP RasterMinimalSequence

;	JSR PrepareShuriken
;	LDA #96 ; 7.76 secondes
;	JMP RasterMinimalShurikenSequence

;	LDA #>(PlayScenario3 + 3)
;        STA SCENARIO_PTR + 1;
;	LDA #<(PlayScenario3 + 3)
;        STA SCENARIO_PTR
;	jmp InitBomberman ; bomberman 15.36 secondes, 768 frames

;	JSR PrepareBomb
;	LDA #96 ; 7.68 secondes
;	JMP RasterMinimalSequence

;	LDA #>(DemoStartScenario + 3)
;        STA SCENARIO_PTR + 1
;	LDA #<(DemoStartScenario + 3)
;        STA SCENARIO_PTR
;	jmp InitBomberman

;	JSR PrepareBomb
;	LDA #192 ; 3.84 secondes
;	JMP RasterMinimalDoubleSequence

;	LDA #>(PlayScenario4 + 3)
;        STA SCENARIO_PTR + 1
;	LDA #<(PlayScenario4 + 3)
;        STA SCENARIO_PTR
;	jmp InitBomberman

;	LDA #0
;        STA TextPage
;	BANK_SWITCH 7, InitTextPage

;	LDA #5
;        STA TextPage;;
;	BANK_SWITCH 7, InitTextPage

;	LDA #9
;	STA tt_cur_pat_index_c0
;	LDA #$37
;	STA tt_cur_pat_index_c1
;	LDA #>(PlayScenario + 3)
 ;       STA SCENARIO_PTR +1;;;
;	LDA #<(PlayScenario + 3)
;        STA SCENARIO_PTR;
;	jmp InitBomberman

;	LDA #$15
;	STA tt_cur_pat_index_c0
;	LDA #$43
;	STA tt_cur_pat_index_c1
;	LDA #>(PlayScenario2 + 3)
;        STA SCENARIO_PTR +1;;;
;	LDA #<(PlayScenario2 + 3)
;        STA SCENARIO_PTR;
;	jmp InitBomberman

;	LDA #$22
;	STA tt_cur_pat_index_c0
;	LDA #$50
;	STA tt_cur_pat_index_c1
;	LDA #>(PlayScenario3 + 3)
 ;       STA SCENARIO_PTR +1;;;
;	LDA #<(PlayScenario3 + 3)
;        STA SCENARIO_PTR;
;	jmp InitBomberman

;prod
	JSR PrepareBomberman
	LDA #144 + 13;+ 48 ; 11.52 secondes 1 tick = 4 frames (divise par 12.5)
	JMP RasterMinimalIntroSequence

Part02

	LDA #0
        LDX #96 - 16 - 1 ; en cas de bug de frame
        JMP TextSequence

Part03
	LDA #>(PlayScenario + 3)
        STA SCENARIO_PTR + 1
	LDA #<(PlayScenario + 3)
        STA SCENARIO_PTR
	jmp InitBomberman ; bomberman 15.36 secondes, 768 frames

Part04
	JSR PrepareShuriken
	LDA #96 ; 7.76 secondes
	JMP RasterMinimalShurikenSequence

Part05
        LDX #96
	LDA #1
        JMP TextSequence

Part06
	LDA #>(PlayScenario2 + 3)
        STA SCENARIO_PTR + 1;
	LDA #<(PlayScenario2 + 3)
        STA SCENARIO_PTR
	jmp InitBomberman ; 15 secondes


Part07
	JSR PrepareBomb ; boobs
	LDA #96 ; 7.68 secondes
	JMP RasterMinimalSequence

Part08
        LDX #96
	LDA #2
        JMP TextSequence

Part09
	LDA #>(PlayScenario3 + 3)
        STA SCENARIO_PTR + 1
	LDA #<(PlayScenario3 + 3)
        STA SCENARIO_PTR
	jmp InitBomberman

Part10
	LDA #>(PlayScenario4 + 3)
        STA SCENARIO_PTR + 1
	LDA #<(PlayScenario4 + 3)
        STA SCENARIO_PTR
	jmp InitBomberman

Part11        
        LDX #96
	LDA #3
        JMP TextSequence

Part12
	JSR PrepareBomberman
	LDA #200
        STA SplitMinimalFrameGoal
	LDA #>(DemoEndScenarioRaster + 3)
        STA SCENARIO_PTR + 1
	LDA #<(DemoEndScenarioRaster + 3)
        STA SCENARIO_PTR
        BANK_SWITCH 7, InitRasterMinimal

;	jmp InitBomberman



;;;;;;;

PrepareBomberman
        LDA #>ColorBomberman
        STA ColorFunctionPtr + 1
        LDA #<ColorBomberman
        STA ColorFunctionPtr

	LDA #>BombermanPF0 ;Hi
        STA Playfield0 + 1
        STA Playfield1 + 1
	LDA #<BombermanPF0 ;Hi
        STA Playfield0 + 0
        STA Playfield1 + 0
	RTS

PrepareBomb
        LDA #>ColorBomb
        STA ColorFunctionPtr + 1
        LDA #<ColorBomb
        STA ColorFunctionPtr

	LDA #>Bomb0PF0 ;Hi
        STA Playfield0 + 1
	LDA #>Bomb1PF0 ;Hi
        STA Playfield1 + 1
	LDA #<Bomb0PF0 ;Hi
        STA Playfield0 + 0
	LDA #<Bomb1PF0 ;Hi
        STA Playfield1 + 0
	RTS
        
PrepareShuriken        
        LDA #>ColorShuriken
        STA ColorFunctionPtr + 1
        LDA #<ColorShuriken
        STA ColorFunctionPtr
	LDA #>Shuriken0PF1 ;Hi
        STA Playfield0 + 1
	LDA #>Shuriken1PF1
        STA Playfield1 + 1
	LDA #<(Shuriken0PF1 - 25) ;Hi
        STA Playfield0 + 0
	LDA #<(Shuriken1PF1 - 25) ;Hi
        STA Playfield1 + 0
	RTS

; boobs
RasterMinimalSequence
        STA SplitMinimalFrameGoal
	LDA #(>(PlayScenarioRaster + 3)) & ~(BIT_SAX_BACKGROUND | BIT_WOBBLING)
        STA SCENARIO_PTR + 1
	LDA #<(PlayScenarioRaster + 3)
        STA SCENARIO_PTR
gotoRaster        
	BANK_SWITCH 7, InitRasterMinimal

RasterMinimalIntroSequence
        STA SplitMinimalFrameGoal
	LDA #<(PlayScenarioRasterIntro + 3)
        STA SCENARIO_PTR
	LDA #(>(PlayScenarioRasterIntro + 3)) & ~(BIT_WOBBLING  | BIT_SAX_BACKGROUND)
        STA SCENARIO_PTR + 1
        BNE gotoRaster

RasterMinimalShurikenSequence
        STA SplitMinimalFrameGoal
	LDA #<(PlayScenarioRasterShuriken + 3)
        STA SCENARIO_PTR
	LDA #(>(PlayScenarioRasterShuriken + 3)) & ~BIT_USE_SPRITES
        STA SCENARIO_PTR + 1
        BNE gotoRaster

TextSequence
	STX TextFrameGoal
	STA TextPage
	BANK_SWITCH 7, InitTextPage        


;;;;;;; Debut Bomberman

InitBomberman
	TIMER_WAIT_2

        sta HMCLR
        LDA #0
        STA WAIT_LINES;
        
;        LDA #0
;        STA SCENARIO_DONE




; =====================================================================
; MAIN LOOP
; =====================================================================

MainLoop:
; ---------------------------------------------------------------------
; Overscan
; ---------------------------------------------------------------------

Overscan        SUBROUTINE

        sta WSYNC
        LDA #37
        sta TIM64T

	IF SHOW_FREE_CPU = 0
        lda #2
        sta VBLANK
        LDA #0
        STA COLUBK
        ENDIF

        lda #$00
        sta COLUPF  ; fg color
        lda #$34
        sta CTRLPF  ; symetry and priorities
	lda #8
        sta REFP1  ; symetry of sprite

        lda #$37
        sta NUSIZ0
        lda #$37
        sta NUSIZ1
        
        IF SHOW_FREE_CPU
	LDA #0
        ELSE
	LDA #$FF
        ENDIF
        STA PF0
        STA PF1
        STA PF2
        


; controls only selection of the source bank for line pointers, change when dev 
; in progress in a bank and routines not aligned
BANK_SELECT equ 1

; commence a -18 et finit a 43, en colonne caractere a partir de la gauche de l'ecran
;TRUE_XPOS_MACRO equ 15; 
;	LDA #8
;        STA TRUE_XPOS
 

	JMP PlayScenario
returnPlayScenario

	LDA WAIT_LINES
        BNE .scaleTheRaster
        LDA #32
        STA Y_DIVIDER_ZP
        BNE .dividerZpReady
        
.scaleTheRaster        
; TOTAL_LINES = (220 - WAIT_LINES * 2) / 2
	LDA #192 
        LSR
        SEC
        SBC WAIT_LINES

; Y_DIVIDER_ZP = dividerTable(TOTAL_LINES - 14)
        TAY
        LDA totalHeight - 14,Y
        STA Y_DIVIDER_ZP
.dividerZpReady



; positionnement playfield et split raster
PF_COLUMN_START equ ((TRUE_XPOS + 20) % 20)
PF_COLUMN_START_BYTE equ TEMP1

	LDA TRUE_XPOS
        CLC
        ADC #20
.posXPos
	CMP #20
        BCC .setXposMod20_2
        SEC
        SBC #20
        BVC .posXPos
.setXposMod20_2        
	STA PF_COLUMN_START_BYTE

X_POS_SELECT equ (PF_COLUMN_START / 3)

	TAY
        LDA MODE
        AND #BIT_PLAYFIELD_ENABLE
        BNE .withPF
        LDA #7
        BNE .XPosReady
.withPF        
	LDA SCENARIO_PTR + 1
        AND #BIT_DECOLLE_ENABLE
        BEQ .normal

	LDA ANIM_COUNTER
        ASL
        ASL
        ASL
;        TAX
;        LDA Mul12,X
        CLC
        ADC Div3Table,Y
        BCC .XPosReady        
.normal
	LDA Div3Table,Y
.XPosReady        
        STA X_POS        


PF_BANK_SELECT equ (PF_COLUMN_START % 3)
PF_BANK_SELECT_BYTE equ TEMP1

	LDY PF_COLUMN_START_BYTE
        LDA Mod3Table,Y
        STA PF_BANK_SELECT_BYTE

COLOR_BANK_SELECT equ ((TRUE_XPOS + 18) % 3)
COLOR_BANK_SELECT_BYTE equ TEMP2
BANK_DIRECTION equ TEMP3

	LDA MODE
        AND #BIT_DIRECTION
        BEQ .selectBankDirection
        LDA #3
.selectBankDirection        
        STA BANK_DIRECTION
        
	LDA TRUE_XPOS
        CLC
        ADC #18
        TAY
        LDA Minus18Mod3Table,Y
        STA COLOR_BANK_SELECT_BYTE

; setter directement les switchers
        LDA #$1F
        STA PF_BANK_SWITCHER + 1
        STA COLOR_BANK_SWITCHER + 1
        LDA X_POS
        EOR #$FF
;        CLC
;	ADC #1 ; A = -XPOS
        CLC
        ADC #$F5 + 1 ;+ 3 ; sprite miroir
        CLC
        ADC BANK_DIRECTION
        CLC
        ADC PF_BANK_SELECT_BYTE
;        ADC #PF_BANK_SELECT
	STA PF_BANK_SWITCHER
        CLC
        ADC COLOR_BANK_SELECT_BYTE
        SEC
        SBC PF_BANK_SELECT_BYTE
;        ADC #(COLOR_BANK_SELECT - PF_BANK_SELECT)
        STA COLOR_BANK_SWITCHER


	IF TRUE_XPOS < 0
DECAL_CYCLES equ -(4 - COLOR_BANK_SELECT) % 4 ; 0, -3, -2
	ELSE
DECAL_CYCLES equ COLOR_BANK_SELECT
	ENDIF
X_POS_SELECT_CYCLES equ (TRUE_XPOS / 3)
; setter directement SYNC_CYCLES
DECAL_CYCLES_BYTE equ TEMP1

	LDA TRUE_XPOS
        BPL .posTruePos
        LDA COLOR_BANK_SELECT_BYTE
        EOR #3
        CLC
        ADC #1
        AND #3
        EOR #$FF
        CLC
        ADC #1
        BVC .decalCyclesReady
.posTruePos
        LDA COLOR_BANK_SELECT_BYTE
.decalCyclesReady
	CLC
        ADC #0
	STA DECAL_CYCLES_BYTE

	LDA TRUE_XPOS
        CLC
        ADC #18
        TAY
        LDA Minus18Div3Table,Y
        ASL
        ASL
        CLC
        ADC DECAL_CYCLES_BYTE
        CLC
        ADC #42

	TAX ; save A qui contient le bon SYNC_CYCLES
        ; calcul oscillation; todo: faire depuis le scenario
        LDA MODE
        AND #BIT_OSCILLATION_RASTER_ENABLE
        BEQ .setSyncCycles
        TXA
        CLC
        ADC OSCILLATION ; identM2(x) = 12 * power(sin, 3)

; clamp SYNC_CYCLES if doing BS
;	CMP #100
;        BCC .ok
;        LDA #100
;.ok
;	CMP #14
;        BCS .ok2
;        LDA #14
;.ok2
	TAX
;        LDA #26 + 16 + 4 * X_POS_SELECT_CYCLES + DECAL_CYCLES
.setSyncCycles        
   TXA ; restore A
   
        STA SYNC_CYCLES



; ajustement missile 1 pour bank 6 step anim 2 direction gauche 
; devrait utiliser le missile dans toutes les banks dans ce cas
; et bank 3 step anim 2 direction droite
        lda #$27
        sta NUSIZ1
MISSILE1_ADJUSTX equ TEMP2
	LDA #0
        STA MISSILE1_ADJUSTX
	; si direction = gauche et bank_select == 6
        LDA MODE
        AND #BIT_DIRECTION
        BEQ .noLargeMissile1
	LDA STEP_ANIM
        CMP #2
        BNE .noLargeMissile1
        
	LDA TRUE_XPOS
        CLC
        ADC #18
        TAY
        LDA Minus18Mod3Table,Y
        CMP #2
        BNE .noLargeMissile1
        lda #$37
        sta NUSIZ1
        DEC MISSILE1_ADJUSTX
        
.noLargeMissile1        
        LDA MODE
        AND #BIT_DIRECTION
        BNE .noLargeMissile2
	LDA STEP_ANIM
        CMP #2
        BNE .noLargeMissile2
        
        lda #$37
        sta NUSIZ1
        
.noLargeMissile2        


	MAGI_CALL 0,1,PositionBombermanSprites
        


        LDX STEP_ANIM
        BEQ .doStep0
        DEX
        BEQ .doStep1
        DEX
        BEQ .doStep2
        
.doStep3        
        LDA #>histep3lines
        STA HISPRITE_PTR + 1
        LDA #<histep3lines
        STA HISPRITE_PTR
        IF <histep3lines != 0
        BNE .donePreparingStep
        ELSE        
        BEQ .donePreparingStep
        ENDIF        
.doStep2
        LDA #>histep2lines
        STA HISPRITE_PTR + 1
        LDA #<histep2lines
        STA HISPRITE_PTR
        IF <histep2lines != 0
        BNE .donePreparingStep
        ELSE        
        BEQ .donePreparingStep
        ENDIF        
        
.doStep1      
        LDA #>histep1lines
        STA HISPRITE_PTR + 1
        LDA #<histep1lines
        STA HISPRITE_PTR
        IF <histep1lines != 0
        BNE .donePreparingStep
        ELSE        
        BEQ .donePreparingStep
        ENDIF        
                
.doStep0        
        LDA #>histep0lines
        STA HISPRITE_PTR + 1
        LDA #<histep0lines
        STA HISPRITE_PTR
        
.donePreparingStep

        LDA #>(finish_screen - 1)
        pha
        LDA #<(finish_screen - 1)
        pha

; init color variables, voir comment faire ca. pas envie d'un deuxieme pointeur

	INC FRAME

EndOverscan


; ---------------------------------------------------------------------
; Bientot VBlank (pendant loopPushLines)
; ---------------------------------------------------------------------

VBlankBomberman

        
VSYNC_DONE_TEMP equ TEMP1
CURRENT_FREE_COLOR_TEMP equ TEMP2
OUTPUT_COLOR_INDEX_TEMP equ TEMP3
SPRITE_LINE_TEMP equ TEMP4
CURRENT_COLOR equ TEMP5 ; temp

        
	LDA #0
        STA VSYNC_DONE_TEMP
	LDA SPRITE_LINE
        STA SPRITE_LINE_TEMP
        LDA CURRENT_FREE_COLOR
        STA CURRENT_FREE_COLOR_TEMP
;	LDX Y_END
	LDX #24 ;4
.loopPushLines:

	TXA
        CMP SPRITE_YSTART
        BCC .outputEmptyLine
        CMP SPRITE_YEND
        BCS .outputEmptyLine
        
        LDY SPRITE_LINE_TEMP
        DEY
        STY SPRITE_LINE_TEMP
        INY

        LDA (HISPRITE_PTR),Y ;histep1lines,X
        pha
        CLC
        TYA
        CLC
        ADC #(lostep1lines - histep1lines)
        TAY
        LDA (HISPRITE_PTR),Y ;lostep1lines,X
        pha

	TXA
        SEC
        SBC SPRITESTART_YPOS
        SEC
	SBC SCREEN_YPOS        
        SEC
        SBC #25
        STA OUTPUT_COLOR_INDEX_TEMP
                
        BNE .outputColor
        
.outputEmptyLine
	LDA #>EmptyLine0
        pha
        LDA CURRENT_FREE_COLOR_TEMP
        CLC
        ADC #25
        asl
        asl
        CLC
        ADC #<EmptyLine0 - 1
        pha

	LDY CURRENT_FREE_COLOR_TEMP
        STY OUTPUT_COLOR_INDEX_TEMP

	LDA CURRENT_FREE_COLOR_TEMP
        SEC
        SBC #1
        CMP #-25
        BCS .doneUpdatingFreeColor
        LDA #$FF
.doneUpdatingFreeColor        
        STA CURRENT_FREE_COLOR_TEMP

.outputColor
; update colors
        TXA
        SEC
        SBC SCREEN_YPOS
        BMI .colorBlackOut
	CMP #25
        BCS .colorBlackOut

	JMP (BACKGROUND_PTR)

.colorBlackOut
	LDA #0
;        JMP returnJmpBackgroundPtr

returnJmpBackgroundPtr
        LDY OUTPUT_COLOR_INDEX_TEMP        
	STA BACKGROUND_COLOR_LINE_24 + 1,Y

	LDA VSYNC_DONE_TEMP
        bne .afterVSyncCheck
        lda INTIM
        CMP #3
        BCS .afterVSyncCheck

        TIMER_WAIT_2
	lda #%1110
.vsyncLoop:
        sta WSYNC
        sta VSYNC
        lsr
        bne .vsyncLoop
        STA WSYNC
        lda #TIM_VBLANK + 7 ; pour le pire cas du stack abuse
        sta TIM64T
	IF SHOW_FREE_CPU = 0
        lda #2
        sta VBLANK
        ENDIF
        INC VSYNC_DONE_TEMP
.afterVSyncCheck

	DEX
        bmi .endLoopPushLines
        jmp .loopPushLines
.endLoopPushLines


; YStretch (call stack abuse)

        LDA MODE
        AND #BIT_YSTRETCH_ENABLE
        BEQ .afterAbuse

	TSX
        STX TEMP1

        LDA GLOBAL_TEMP
        AND #31
        ASL
        TAY
        CLC
        ADC ANIM_COUNTER
        ADC ANIM_COUNTER
        CLC
        
        ADC #$CC ; la call stack pourrait bouger
        TAX
        DEX
        TXS
        LDA $CC,Y
        EOR $CD,Y
        STA TEMP2
        LDA $CD,Y
        LDY ANIM_COUNTER
;        ADC #$CE ; la call stack pourrait bouger
;        TAX
;        DEX
;        TXS
;        LDA $CE,Y
;        EOR $CF,Y
;        STA TEMP2
;        LDA $CF,Y
;        LDY ANIM_COUNTER
.loopAbuse        
        PHA
        EOR TEMP2
        PHA
        EOR TEMP2
        DEY
        BPL .loopAbuse
        
	LDX TEMP1
        TXS
.afterAbuse

.waitForVBlankEnd:
	TIMER_WAIT_2
	; ligne 44 stable
        sta WSYNC


Kernel  SUBROUTINE
        LDA #0
        sta VBLANK
; ---------------------------------------------------------------------
; Kernel
; ---------------------------------------------------------------------

	LDA #$00
        STA COLUBK


        LDA #244 +1
        sta TIM64T


        LDA #COLOR_VEST
        STA COLOR_VEST_BYTE
        LDA #COLOR_RED
        STA COLOR_RED_BYTE
	LDX #COLOR_WHITE
        STX COLOR_WHITE_BYTE
        INX
        STX COLOR_FF_BYTE
        INX
        STX COLOR_BLACK_BYTE



DisplaySplitRaster
	LDA WAIT_LINES
        CMP #0
        BEQ DisplayTheSplitRaster
	TAX
waitLinesLoop:
	STA WSYNC
        DEX
        BNE waitLinesLoop

DisplayTheSplitRaster
	STA WSYNC ; on finit a cycle 2 apparemment

	JSR AltLose12Cycles
	JSR AltLose12Cycles
	JSR AltLose12Cycles
	JSR AltLose12Cycles


        LDA #>(Lose14Cycles - 1)
        PHA
        
        LDA SYNC_CYCLES ; nombre de cycles a decompter
        
        SEC
        SBC #9
        EOR #$FF
        CLC
        ADC #1
        CLC
        ADC #<(Lose14Cycles - 1)
        PHA
        LDX #BANK_SELECT
AltLose12Cycles        
	RTS ; Le RTS qui appelle le decalage du beam puis RTS a l'affichage de la premiere ligne de split rasters

    
;	LDX #30
;.wait1:
;	STA WSYNC
;        DEX
;        bne .wait1
        ; Do kernel stuff;
;	jmp KernelBomberman

;KernelBomberman

ReturnDisplaySplitRaster
	LDA #0 ; todo: put in finishscreens
        STA ENAM1

	TIMER_WAIT_2
        STA WSYNC
        JSR AltLose12Cycles
        NOP
        LDA #34
        STA TIM64T

	MAGI_CALL 0, 4, DrawLogo

	LDA SCENARIO_PTR + 1 
        AND #BIT_SCENARIO_DONE
        BEQ .playMusic
        
        JMP PlayNextDemoPart

.playMusic
;	LDA #$68
 ;       STA COLUBK
	MAGI_CALL 0, 7, tt_PlayerStart

	TIMER_WAIT_2
       
       	 jmp MainLoop

Mul12
	.byte 0,12,24,36,48,60,72,84,96,108,120,132,144

ClipTopMissilePatch
step0ClipTopPatches .byte 0,0,$FE,$FE
step1ClipTopPatches .byte 0,0,$FE,$FE
step2ClipTopPatches .byte 0,COLOR_RED,$FE,$FE
step3ClipTopPatches .byte COLOR_RED,COLOR_RED,$FE,$FE

EmitFrames
	JSR ClipSprite
	PLA
        CLC
        ADC #1
        STA SCENARIO_PTR + 0
        LDX SCENARIO_PTR + 1
        PLA
        ADC #0
        
        
        PHA           ; Save A
	TXA           ; Copy X to A
	AND #$E0      ; Isolate bits 7 and 6 and 5 of X
	STA TEMP1      ; Save them temporarily
	PLA           ; Restore A
	AND #$1F      ; Clear bits 7 and 6 and 5 in A
	ORA TEMP1      ; OR in bits 7 and 6 and 5 from X

;        CPX #$80
;        BCC .saveScenarioPtrHi
;        ORA #$80 ; persist SCENARIO_DONE flag
;.saveScenarioPtrHi        
        STA SCENARIO_PTR + 1
        
        
.loopEmitFrames
	LDX COUNTER
        DEX
        STX COUNTER
        JMP returnPlayScenario ;RTS ; JSR EmitFrame
afterEmitFrame
        LDA COUNTER
        BNE .loopEmitFrames
        JMP (SCENARIO_PTR)

;MoveRightWithWrap
;        LDA TRUE_XPOS
;        CLC
;        ADC #1
;        BMI .okMoveRight
;        CMP #42
;        BCC .okMoveRight
;        SEC
;        SBC #60
;.okMoveRight
;	STA TRUE_XPOS
;AltLose12Cycles
;        RTS

;MoveLeftWithWrap
;        LDA TRUE_XPOS
;        CLC
;        ADC #-1
;        BPL .okMoveLeft
;        CMP #256 - 18
;        BCS .okMoveLeft
;        CLC
;        ADC #60
;.okMoveLeft
;	STA TRUE_XPOS
;        RTS

;MoveDownWithWrap
;        LDA TRUE_YPOS
;        CLC
;        ADC #1
;        BMI .okMoveDown
;        CMP #26
;        BCC .okMoveDown
;        LDA #-21
;.okMoveDown
;	STA TRUE_YPOS
;        RTS

;MoveUpWithWrap
;        LDA TRUE_YPOS
;        CLC
;        ADC #-1
;        BPL .okMoveUp
;        CMP #256 - 22
;        BCS .okMoveUp
;        LDA #25
;.okMoveUp;
;	STA TRUE_XPOS
;        RTS

ClipSprite
        LDY STEP_ANIM

; SPRITESTART_YPOS = TRUE_YPOS + 21 - TailleSprite
	LDA TRUE_YPOS
        SEC
        SBC TailleSprite,Y
        CLC
        ADC #21
        STA SPRITESTART_YPOS

; IF SPRITESTART_YPOS + SCREEN_YPOS < 0 ClipNegativeYPos
        CLC 
        ADC SCREEN_YPOS
        BMI .clipNegativeYPos
; IF SPRITESTART_YPOS + SCREEN_YPOS >= 25 OutOfScreen
        CMP #25
        BCS .outOfScreen
; SPRITEEND_YPOS = SPRITESTART_YPOS + TailleSprite
; IF SPRITEEND_YPOS >= 25 ClipBottom
        CLC
        ADC TailleSprite,Y
        CMP #25
        BCS .clippedBottom

; ligne dans la stack des split rasters ou le sprite est insere
; SPRITE_YSTART = SPRITESTART_YPOS + SCREEN_YPOS        
        LDA SPRITESTART_YPOS
        CLC
        ADC SCREEN_YPOS
        STA SPRITE_YSTART
; SPRITE_YEND = SPRITE_YSTART + TailleSprite
	CLC
        ADC TailleSprite,Y
        STA SPRITE_YEND
; SPRITE_LINE = TailleSprite - 1        
        LDX TailleSprite,Y
        DEX
        STX SPRITE_LINE
        LDA #-1
        STA CURRENT_FREE_COLOR
        RTS

.outOfScreen
        LDA #0
        STA SPRITE_YSTART
        STA SPRITE_YEND
        STA SPRITE_LINE
        LDA #-1
        STA CURRENT_FREE_COLOR
	RTS

.clippedBottom        
        
; SPRITE_YSTART = SPRITESTART_YPOS + SCREEN_YPOS        
        LDA SPRITESTART_YPOS
        CLC 
        ADC SCREEN_YPOS
        STA SPRITE_YSTART
; SPRITE_YEND = 25        
        LDA #25
        STA SPRITE_YEND
; SPRITE_LINE =  SPRITESTART_YPOS + 25 - 1 - SCREEN_YPOS
        SEC
        SBC SPRITESTART_YPOS
        SEC 
        SBC SCREEN_YPOS
        SEC
        SBC #1
        STA SPRITE_LINE
        
        LDA #-1
        STA CURRENT_FREE_COLOR
        RTS

.clipNegativeYPos
; SPRITE_YEND = SPRITESTART_YPOS + SCREEN_YPOS + TailleSprite
; IF SPRITE_YEND <= 0 OutOfScreen
	CLC
        ADC TailleSprite,Y
        BMI .outOfScreen
        BEQ .outOfScreen
        
        STA SPRITE_YEND
; SPRITE_YSTART = 0
        LDA #0
        STA SPRITE_YSTART

; SPRITE_LINE = TailleSprite - 1
        LDX TailleSprite,Y
        DEX
        STX SPRITE_LINE     
        
; CURRENT_FREE_COLOR = SPRITE_LINE - SPRITE_YEND - 25
        TXA
        SEC
        SBC SPRITE_YEND
        SEC 
        SBC #25
        STA CURRENT_FREE_COLOR
        
        RTS



GoldColors
	.byte $00,$02,$04,$06,$08,$0A,$0C,$0E,$0E,$0C,$0A,$08,$06,$04,$02,$00
GetColorGold
;        TXA
;        SEC
;        SBC SCREEN_YPOS
;        BMI .colorBlackOut
;	CMP #25
;        BCS .colorBlackOut

        ASL
        SEC
        SBC FRAME
        LSR
        AND #15
        TAY
        LDA FRAME
        LSR
;        AND #15
        CLC
        ADC ident,Y
        AND #15
        TAY
        LDA GoldColors,Y
        ORA #$20
        JMP returnJmpBackgroundPtr


BWColors 
;	.byte $00,$02,$04,$06,$08,$0A,$0C,$0E,$0E,$0C,$0A,$08,$06,$04,$02,$00
	.byte $00,$01,$02,$03,$04,$05,$06,$07,$07,$06,$05,$04,$03,$02,$01,$00
;	.byte $00,$02,$04,$06,$08,$0A,$0C,$0E,$0E,$0C,$0A,$08,$06,$04,$02,$00
        

; Could return color to output for line no X
; Can use Y
GetColorBlues
;        TXA
;        SEC
;        SBC SCREEN_YPOS
;        BMI .colorBlackOut
;	CMP #25
;        BCS .colorBlackOut

        ASL
        SEC
        SBC FRAME
        LSR
        AND #15
        TAY
        LDA FRAME
        LSR
;        AND #15
        CLC
        ADC ident,Y
        AND #15
        TAY
        LDA BWColors,Y
        ORA #$B0
        JMP returnJmpBackgroundPtr

;GetColorStack
;	TAY
;        LDA $80,Y
;        AND #$07
;        ADC #$04
;        JMP returnJmpBackgroundPtr

RainbowColors 
	.byte $C0,$A0,$80,$60,$60,$40,$40,$20,$20,$30,$50,$70,$90,$B0,$D0,$C0
        
;	.byte $C0,$A0,$80,$60,$60,$40,$40,$20,$20,$30,$50,$70,$90,$B0,$D0,$C0
;	.byte $C0,$A0,$80,$60,$40,$20,$30,$50,$70,$90,$B0,$D0
;	.byte $C0,$A0,$80,$60,$60,$40,$40,$20,$20,$30,$50,$70,$90,$B0,$D0,$D0,$C0
        

; Could return color to output for line no X
; Can use Y
GetColorRainbow
	PHA
;        ASL
        SEC
        SBC FRAME
;        LSR
        LSR
        AND #15
        TAY

	PLA
        ADC FRAME
        AND #$F
        CMP #8
        BCC .readyLight
        EOR #$F
.readyLight
        ORA RainbowColors,Y
        JMP returnJmpBackgroundPtr

        

; Could return color to output for line no X
; Can use Y
; TODO: support SCREEN_YPOS
GetColorDesert
	CMP #20
        BCC .drawDesertSky

        CLC
	ASL
	ADC FRAME
        LSR
        AND #7
        ADC #6
        ORA #$40
        JMP returnJmpBackgroundPtr

.drawDesertSky

        CLC
	ASL
	ADC FRAME
	EOR #255
        EOR #7
        AND #7
        ADC #6
        ORA #$C0
        JMP returnJmpBackgroundPtr


GetColorDesert2
	CMP #20
        BCC .drawDesertSky2

        CLC
	ASL
	ADC FRAME
        LSR
        AND #7
        ADC #6
        ORA #$60
        JMP returnJmpBackgroundPtr

.drawDesertSky2

        CLC
	ASL
	ADC FRAME
;	EOR #248
;        EOR #7
        AND #7
        LSR
        ADC #2
        ORA #$A0
        JMP returnJmpBackgroundPtr


; Could return color to output for line no X
; Can use Y
; Could use Constants instead of RAM
; TODO: support SCREEN_YPOS
GetColorMeadow
	CMP #20
        BCC .drawMeadowSky
; meadow grass
	ASL
        ASL
        CLC
	ADC FRAME
	LSR        
        AND #7
        ADC #4
        ORA #$30
        JMP returnJmpBackgroundPtr

.drawMeadowSky
	ASL
	EOR #255
        CLC
	ADC FRAME
        LSR
        EOR #7
        AND #7
        ADC #4
        ORA #$B0
        JMP returnJmpBackgroundPtr

GetColorMeadow2
	CMP #20
        BCC .drawMeadowSky2
; meadow grass
	ASL
        ASL
        CLC
	ADC FRAME
	LSR        
        AND #7
        ADC #4
        ORA #$50
        JMP returnJmpBackgroundPtr

.drawMeadowSky2
	ASL
	EOR #255
        CLC
	ADC FRAME
        LSR
        EOR #7
        AND #7
        ADC #4
        ORA #$D0
        JMP returnJmpBackgroundPtr

STEP_COUNTER_VALUE equ 3

	MAC EMIT_FRAMES 
.Value   SET {1}
        lda #.Value
        STA COUNTER
        JSR EmitFrames
        ENDM

	MAC EMIT_FRAMES_A 
        STA COUNTER
        JSR EmitFrames
        ENDM

BombermanJump        
	LDA #33
        STA ANIM_COUNTER
.loopJump1
	LDY ANIM_COUNTER
        LDA Saute,Y
;        SEC 
;        SBC #1
        STA TRUE_YPOS
        EMIT_FRAMES 1
        DEC ANIM_COUNTER
        bne .loopJump1
	RTS
        
     
Saute
;	.byte 3,3,2,2,1,1,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2
	.byte 2,2,1,1,0,0,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3
        .byte -1,-1,-1,-1,0,0,0,1,1,2,2,3,3,3,3

ComputeOscillation
        LDA FRAME
        LSR
        AND #63
        TAY
        LDA sin3,Y ; identM2(x) = 12 * power(sin, 3)
        STA OSCILLATION
        RTS


TurnLeft
        LDA MODE
        ORA #BIT_DIRECTION
        STA MODE
	RTS

TurnRight
        LDA MODE
        AND #~BIT_DIRECTION
        STA MODE
	RTS

EnableGhost
        LDA MODE
        ORA #BIT_GHOST_ENABLE
        STA MODE
	RTS

DisableGhost
        LDA MODE
        AND #~BIT_GHOST_ENABLE
        STA MODE
	RTS

SetColorDesert
        LDA #>GetColorDesert
        STA BACKGROUND_PTR + 1
        LDA #<GetColorDesert
        STA BACKGROUND_PTR
	RTS

SetColorMeadow
        LDA #>GetColorMeadow
        STA BACKGROUND_PTR + 1
        LDA #<GetColorMeadow
        STA BACKGROUND_PTR
	RTS

SetColorRainbow
        LDA #>GetColorRainbow
        STA BACKGROUND_PTR + 1
        LDA #<GetColorRainbow
        STA BACKGROUND_PTR
        RTS

; possible que ca gere pas le clipping
;SetColorBW
;        LDA #>GetColorRainbow
;        STA BACKGROUND_PTR + 1
;        LDA #<GetColorRainbow
;        STA BACKGROUND_PTR
;        RTS

ExitRight
	LDA #41
        STA ANIM_COUNTER
WalkRightUntilAnimCounter
	JSR TurnRight
.loopWalkRight
	EMIT_FRAMES 4

;	JSR MoveRightWithWrap
	INC TRUE_XPOS
	JSR AnimateForward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopWalkRight
        RTS

ExitRightBackward
	LDA #41
        STA ANIM_COUNTER
WalkRightUntilAnimCounterBackward
	JSR TurnLeft
.loopWalkRightBackward
	EMIT_FRAMES 4

;	JSR MoveRightWithWrap
	INC TRUE_XPOS
	JSR AnimateBackward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopWalkRightBackward
        RTS

RunExitRight
	LDA #41
        STA ANIM_COUNTER
RunRightUntilAnimCounter
	JSR TurnRight
.loopRunRight
	EMIT_FRAMES 2

;	JSR MoveRightWithWrap
	INC TRUE_XPOS
	JSR AnimateForward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopRunRight
        RTS

ExitLeft
	LDA #-18
        STA ANIM_COUNTER
WalkLeftUntilAnimCounter
	JSR TurnLeft
.loopWalkLeft
	EMIT_FRAMES 4

	DEC TRUE_XPOS
;	JSR MoveLeftWithWrap        
	JSR AnimateForward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopWalkLeft
        RTS

ExitLeftBackward
	LDA #-18
        STA ANIM_COUNTER
WalkLeftUntilAnimCounterBackward
	JSR TurnRight
.loopWalkLeftBackward
	EMIT_FRAMES 4

	DEC TRUE_XPOS
;	JSR MoveLeftWithWrap        
	JSR AnimateBackward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopWalkLeftBackward
        RTS

RunExitLeft
	LDA #-18
        STA ANIM_COUNTER
RunLeftUntilAnimCounter
	JSR TurnLeft
.loopRunLeft
	EMIT_FRAMES 2

	DEC TRUE_XPOS
;	JSR MoveLeftWithWrap        
	JSR AnimateForward
        
        LDA TRUE_XPOS
        CMP ANIM_COUNTER
        BNE .loopRunLeft
        RTS

;RunExitLeftFly
;	JSR Align4Frames
;	LDA #-18
;        STA ANIM_COUNTER
;FlyLeftUntilAnimCounter
;	JSR TurnLeft
;.loopFlyLeft
;	EMIT_FRAMES 2

;;	JSR MoveLeftWithWrap        
;	DEC TRUE_XPOS
;	JSR AnimateForward
        
;        LDA FRAME
;        AND #4
;        BNE .noFly2
;        DEC TRUE_YPOS
;.noFly2        
;        LDA TRUE_XPOS
;        CMP ANIM_COUNTER
;        BNE .loopFlyLeft
;        RTS

Align4Frames
	LDA FRAME
        AND #3
        BNE .waitNextFrame
        RTS
.waitNextFrame        
        EMIT_FRAMES 1
        JMP Align4Frames
        
;Align8Frames SUBROUTINE
;	LDA FRAME
;        AND #7
;        BNE .waitNextFrame
;        RTS
;.waitNextFrame        
;        EMIT_FRAMES 1
;        JMP Align8Frames
        
;ExitDown
;	LDA #25
;        STA ANIM_COUNTER
;WalkDownUntilAnimCounter
;        JSR Align4Frames
;.loopWalkDown
;	EMIT_FRAMES 4
;
;	JSR AnimateForward
;        LDA FRAME
;        AND #7
;        BNE .okDown
;        INC TRUE_YPOS
;.okDown        
;        LDA TRUE_YPOS
;        CMP ANIM_COUNTER
;        BNE .loopWalkDown
;        RTS

;WalkUpUntilAnimCounter
;        JSR Align4Frames
;.loopWalkUp
;	EMIT_FRAMES 4

;	JSR AnimateForward
;        LDA FRAME
;        AND #3
;        BNE .okUp
;        DEC TRUE_YPOS
;.okUp        
;        LDA TRUE_YPOS
;        CMP ANIM_COUNTER
;        BNE .loopWalkUp
;        RTS


BombermanFall
        LDA #-25
	STA SCREEN_YPOS
	LDA #-56
        STA TRUE_YPOS
	LDA #35 + 25 + 35 + 2 + 1
        STA ANIM_COUNTER
; petite phase a 50Hz
.loopScreenFall1
	LDA ANIM_COUNTER
        CMP #38
        BCC .finiPremiereChute
        
	INC SCREEN_YPOS
        BCS .afterFallFaster
.finiPremiereChute
        INC TRUE_YPOS
        CMP #2
        BCC .afterFallFaster
	DEC SCREEN_YPOS
        LDA SCREEN_YPOS
        CMP #20
        BCS .afterFallFaster
        INC TRUE_YPOS         
.afterFallFaster
	EMIT_FRAMES 1
        DEC ANIM_COUNTER
        BNE .loopScreenFall1
        INC TRUE_YPOS
        RTS

SetScenarioDone
        LDA SCENARIO_PTR + 1
        ORA #BIT_SCENARIO_DONE
        STA SCENARIO_PTR + 1
        EMIT_FRAMES 1

BounceScreenYPosDeltas .byte 0,0,1,1,-1,-1,-1,-1,-1,-1,1,1,1,1
BounceTrueYPosDeltas .byte 1,1,0,0,-1,-1,0,0,0,0,0,0,0,0

BombermanBounce
        LDA #13
        STA ANIM_COUNTER
.loopBounce3
	LDY ANIM_COUNTER
        LDA BounceScreenYPosDeltas,Y
        CLC
        ADC SCREEN_YPOS
        STA SCREEN_YPOS
        LDA BounceTrueYPosDeltas,Y
        CLC
        ADC TRUE_YPOS
        STA TRUE_YPOS
        LDA #2
        CPY #4
        BNE .notPeakBounce
        LDA #5
.notPeakBounce
        EMIT_FRAMES_A
	DEC ANIM_COUNTER
        BPL .loopBounce3
	RTS

;BitYStretchEffect
;.effect1
;	LDA SCENARIO_PTR + 1
;        AND #BIT_YSTRETCH_FLY_ENABLE
;        EOR #BIT_YSTRETCH_FLY_ENABLE
;        asl
;        asl
;        LDA #1
;        ADC #0
;        EMIT_FRAMES_A
;;        LDA FRAME
;;        AND #1
;;        BEQ .noAnim1
;;        JSR AnimateForward
;.noAnim1        
;        INC ANIM_COUNTER
;        LDA ANIM_COUNTER
;        CMP #22
;        BNE .effect1
;
;.effect3;
;	LDA SCENARIO_PTR + 1
;        AND #BIT_YSTRETCH_FLY_ENABLE
;        EOR #BIT_YSTRETCH_FLY_ENABLE
;        asl
;        asl
;        LDA #1
;        ADC #0
;        EMIT_FRAMES_A
;;        LDA FRAME
;;        AND #1
;;        BEQ .noAnim2
;;        JSR AnimateForward
;;.noAnim2
        ;
;	LDA SCENARIO_PTR + 1
;        AND #BIT_YSTRETCH_FLY_ENABLE;
;	BEQ .noFlyToday        
;        DEC TRUE_YPOS        
;.noFlyToday        
;        DEC ANIM_COUNTER
;        BNE .effect3
;        RTS

StartBombermanScenario
	LDA #0
        STA OSCILLATION

	LDA #(BIT_PLAYFIELD_ENABLE | BIT_HIDE_SIDES_ENABLE | BIT_FACE_ENABLE) ; | BIT_GHOST_ENABLE)
        STA MODE
	
	LDA #0
	STA STEP_ANIM

        LDA #STEP_COUNTER_VALUE
        STA STEP_COUNTER

	LDA #3
        STA TRUE_XPOS
        LDA #-25
        STA SCREEN_YPOS
	RTS

;PlayScenarioTest
;	JMP afterEmitFrame ;(SCENARIO_PTR)

;	JSR StartBombermanScenario
;        JSR SetColorRainbow
        
;	LDA #14
;        STA TRUE_XPOS
;        LDA #2
;        STA TRUE_YPOS
;        LDA #0
;        STA SCREEN_YPOS;
;	LDA #;78
;        STA WAIT_LINES
;        LDA #3
;        STA STEP_ANIM
;.loopTest
;;	INC TRUE_XPOS
;        LDA TRUE_XPOS
;        CMP #43
;        BNE .noLoop
;        LDA #12
;        STA TRUE_XPOS
;.noLoop        
;	EMIT_FRAMES 10
;        JMP .loopTest

PlayScenario
	JMP afterEmitFrame ;(SCENARIO_PTR)

	JSR StartBombermanScenario
        
        JSR SetColorMeadow
	JSR BombermanFall
	JSR BombermanBounce


;.loopTest
;	JSR ExitRight
;        JSR ExitLeft
;        jmp .loopTest

;	JMP .finScenario
;        LDA SCENARIO_PTR + 1 ; Change YStretch effect to fly the bomberman
;        ORA #$40
;        STA SCENARIO_PTR + 1


;	LDA #50
;        STA GLOBAL_TEMP
;.loopTest        
;	JSR BitYStretchEffect
;        LDA #2
;        STA TRUE_YPOS
;        DEC GLOBAL_TEMP
;        bne .loopTest

	EMIT_FRAMES (10  + 24)
;        JSR TurnLeft
;        EMIT_FRAMES 50
;        JSR TurnRight
;        EMIT_FRAMES 50
	LDA #22
        STA ANIM_COUNTER
        JSR WalkRightUntilAnimCounter
	LDA #0
        STA STEP_ANIM
        EMIT_FRAMES 40 - 20
	JSR EnableGhost
        EMIT_FRAMES 40 + 20
        JSR TurnLeft
        EMIT_FRAMES 15
        JSR DisableGhost
        EMIT_FRAMES 25 - 10
        
        JSR TurnRight
        EMIT_FRAMES 16  ;+ 20
        JSR EnableGhost
        EMIT_FRAMES 70 - 40
        EMIT_FRAMES 10 + 10
        JSR TurnLeft
        EMIT_FRAMES 15
        JSR DisableGhost
        EMIT_FRAMES 5 + 20
        JSR EnableGhost        
	JSR BombermanJump
        JSR DisableGhost

;	EMIT_FRAMES 10
        
;        EMIT_FRAMES 10 - 40 - 20
	LDA #38
        STA ANIM_COUNTER
        JSR WalkRightUntilAnimCounter
	JSR SetColorDesert
        JSR TurnLeft
;        JSR BombermanJump
;	JSR ExitRight
	LDA #19
        STA ANIM_COUNTER
        JSR WalkLeftUntilAnimCounter
        EMIT_FRAMES 5
	LDA #6
        STA ANIM_COUNTER
        JSR WalkLeftUntilAnimCounterBackward
        EMIT_FRAMES 5
	LDA #-3
        STA ANIM_COUNTER
        JSR WalkLeftUntilAnimCounter
        EMIT_FRAMES 5
	LDA #-16
        STA ANIM_COUNTER
        JSR WalkLeftUntilAnimCounterBackward
        JSR ExitLeft
        EMIT_FRAMES 20
        
        JMP SetScenarioDone
 	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;DecollePlayfield
;	LDA SCENARIO_PTR + 1 ; enable decollage du split raster
;        ORA #BIT_DECOLLE_ENABLE
;        STA SCENARIO_PTR + 1
;	LDA #0
;	STA ANIM_COUNTER
;.decolleLoop
;	LDA #0
;        STA STEP_ANIM
;	LDA #12 ; 20
;        STA TRUE_YPOS
        
;        INC ANIM_COUNTER
        
;        LDA ANIM_COUNTER
;	CMP #13 ; 5
;        BEQ .endDecolle
        
;	EMIT_FRAMES 7 ; 18
;        JMP .decolleLoop
;.endDecolle
;	LDA SCENARIO_PTR + 1
;        AND #~BIT_DECOLLE_ENABLE
;        STA SCENARIO_PTR + 1
;	LDA MODE
;        AND #~BIT_PLAYFIELD_ENABLE
;        STA MODE
;	RTS 

DivideBy3
 sta TEMP1
 lsr
 lsr
 ldx #4
.loopDivide 
 adc TEMP1
 ror
 lsr
 dex
 bne .loopDivide
 rts
 
OscillateSpriteAndMissile
	LDA MODE
        AND #~BIT_HIDE_SIDES_ENABLE
        STA MODE
        LDA FRAME
        STA GLOBAL_TEMP
.loopOscillationSprites
        LDA FRAME
        SEC
        SBC GLOBAL_TEMP
;        LSR
;        LSR
	JSR DivideBy3
;        AND #31
        TAY
        LDA sin3,Y
        STA OSCILLATION
        LDA MODE
        AND #BIT_OSCILLATION_RASTER_ENABLE
        BNE .oscillationOk

        LDA MODE
        AND #BIT_DIRECTION
        BEQ .oscillationOk
        
        LDA OSCILLATION
        EOR #$FF
        CLC
        ADC #1        
        STA OSCILLATION
.oscillationOk        
        EMIT_FRAMES 3
        DEC ANIM_COUNTER
        LDA ANIM_COUNTER
        CMP #32
        BNE .not32
        JSR TurnLeft
.not32
	CMP #0
        BNE .loopOscillationSprites
	LDA MODE
        ORA #BIT_HIDE_SIDES_ENABLE
        STA MODE        
	RTS


PlayScenario2
	JMP afterEmitFrame ;(SCENARIO_PTR)

	JSR StartBombermanScenario
                
        LDA #>GetColorDesert2
        STA BACKGROUND_PTR + 1
        LDA #<GetColorDesert2
        STA BACKGROUND_PTR

	LDA #0
        STA TRUE_XPOS
        LDA #-20
        STA TRUE_YPOS
        
;        JSR SetColorRainbow
;
.bringScreen
	LDA MODE
;        AND #~BIT_HIDE_SIDES_ENABLE
        STA MODE
	EMIT_FRAMES 1
        INC SCREEN_YPOS
        bne .bringScreen

	JSR StretchFromSky
        
        JSR BombermanJump
;        EMIT_FRAMES 10

	LDA #10
        STA ANIM_COUNTER
        JSR RunRightUntilAnimCounter
	LDA #2
        STA STEP_ANIM

        LDA #32
        STA ANIM_COUNTER
	JSR OscillateSpriteAndMissile
;        EMIT_FRAMES 10

	JSR TurnLeft
;	LDA #2
;        STA STEP_ANIM
        LDA #32
        STA ANIM_COUNTER
	JSR OscillateSpriteAndMissile
        LDA #0
        STA STEP_ANIM
        EMIT_FRAMES 25

	JSR RunExitRight
        LDA #>GetColorMeadow2
        STA BACKGROUND_PTR + 1
        LDA #<GetColorMeadow2
        STA BACKGROUND_PTR
	LDA #13
        STA ANIM_COUNTER
        JSR RunLeftUntilAnimCounter



        EMIT_FRAMES 15
        JSR TurnRight
        
        EMIT_FRAMES 15
        

        LDA MODE
        ORA #BIT_OSCILLATION_RASTER_ENABLE
        STA MODE
        LDA #64
        STA ANIM_COUNTER
	JSR OscillateSpriteAndMissile
        EMIT_FRAMES 10
	JSR TurnRight
        EMIT_FRAMES 11
        LDA #0
        STA STEP_ANIM
	JSR StretchToSky
.takeBackScreen
	EMIT_FRAMES 1
        DEC SCREEN_YPOS
        LDA SCREEN_YPOS
        CMP #-25
        bne .takeBackScreen


	JMP SetScenarioDone


        
FrameToOffset
	LDA FRAME
        LSR
        LSR
        LSR
        LSR
        LSR
	TAY
	RTS

Doublette25Hz
	JSR Align4Frames
	LDA #188 + 41 - 7 - 10 + 20 + 20 + 3
        STA ANIM_COUNTER
.loopScenario2

	JSR TurnRight
        JSR FrameToOffset
        LDA Doublette25Hz,Y
        AND #8
        BNE .no
        JSR TurnLeft
.no        
        
;	LDA #0
;        STA TRUE_XPOS
;        JSR FrameToOffset
        LDA BombermanBounce,Y
        LSR
        LSR
        
        AND #3
;        CLC
;        ADC TRUE_XPOS
        STA TRUE_XPOS
        LDA FRAME
        AND #3 ; let them dance slowly
        BNE .skipAnimFwd
 	JSR AnimateForward
        
.skipAnimFwd
	EMIT_FRAMES 1

	LDA #25
        STA TRUE_XPOS
        JSR TurnLeft
        JSR FrameToOffset
        LDA PlayScenario,Y
        AND #4
        BNE .no3
        JSR TurnRight
.no3        
;        JSR FrameToOffset
        LDA RunExitLeft,Y
        LSR
        LSR
        
        AND #3
        EOR #$FF
        CLC
        ADC TRUE_XPOS
        STA TRUE_XPOS
 	EMIT_FRAMES 1

        
        DEC ANIM_COUNTER
        BEQ .endloopScenario2
        JMP .loopScenario2
.endloopScenario2        
        RTS

Doublette25HzDebut
	JSR Align4Frames
	LDA #10
        
        STA ANIM_COUNTER
	JSR TurnRight
.loopScenarioB
	LDA #2
        CLC
        ADC ANIM_COUNTER
        STA TRUE_XPOS
 	JSR AnimateForward
 	EMIT_FRAMES 1

	LDA #22
        SEC
        SBC ANIM_COUNTER
        STA TRUE_XPOS
        JSR TurnRight
 	EMIT_FRAMES 1
        
        LDA FRAME
        AND #2
        BNE .skipAnimCounter
        DEC ANIM_COUNTER
.skipAnimCounter        
;        LDA ANIM_COUNTER
;        CMP #11
        BEQ .endloopScenarioB
        JMP .loopScenarioB
.endloopScenarioB 
        RTS

Doublette25HzFin SUBROUTINE
	JSR Align4Frames
	LDA #0
        STA ANIM_COUNTER
	JSR TurnRight
.loopScenarioB
	LDA #2
        CLC
        ADC ANIM_COUNTER
        STA TRUE_XPOS
 	JSR AnimateForward
 	EMIT_FRAMES 1

	LDA #22
        SEC
        SBC ANIM_COUNTER
        STA TRUE_XPOS
        JSR TurnRight
 	EMIT_FRAMES 1
        
        LDA FRAME
        AND #2 ; 6 pour 8
        BNE .skipAnimCounter
        INC ANIM_COUNTER
.skipAnimCounter        
        LDA ANIM_COUNTER
        CMP #11
        BEQ .endloopScenarioB
        JMP .loopScenarioB
.endloopScenarioB 
        RTS

StretchFromSky SUBROUTINE
	LDA MODE
        ORA #BIT_YSTRETCH_ENABLE
        STA MODE

        LDA #0
	STA SCREEN_YPOS
	LDA #0
	STA STEP_ANIM
        LDA #-20
        STA TRUE_YPOS

	LDA #0
        STA GLOBAL_TEMP
	LDA #1
        STA ANIM_COUNTER ; indique le nombre de copies a creer
        
.effect0
	EMIT_FRAMES 2
	INC TRUE_YPOS ;amene Y a -15 pour avoir une ligne 0 et 4 lignes en dessous
        LDA TRUE_YPOS
        CMP #-15
        BNE .effect0 ; reste a descendre Y 18 fois pour arriver a +3
        ; 9 fois on incremente le nombre de lignes a ecraser, 9 fois on le decremente

        LDA #0
        STA GLOBAL_TEMP ; indique la source
.effect0Bis        
	EMIT_FRAMES 2
        INC TRUE_YPOS
        INC ANIM_COUNTER
        LDA ANIM_COUNTER ; indique le nombre de copies a creer
        CMP #9
        BNE .effect0Bis
        ; destination = source
.effect1
	EMIT_FRAMES 2
	INC TRUE_YPOS
        DEC ANIM_COUNTER
        LDA TRUE_YPOS
        CMP #2
        BNE .effect1

	LDA MODE
        AND #~BIT_YSTRETCH_ENABLE
        STA MODE
	RTS

; 65 bytes
StretchToSky SUBROUTINE
	LDA MODE
        ORA #BIT_YSTRETCH_ENABLE
        STA MODE

	LDA #0
        STA GLOBAL_TEMP
	LDA #1
        STA ANIM_COUNTER ; indique le nombre de copies a creer

.effect1
	EMIT_FRAMES 2
	DEC TRUE_YPOS
        INC ANIM_COUNTER
        LDA TRUE_YPOS
        CMP #-6
        BNE .effect1

.effect0Bis        
	EMIT_FRAMES 2
        DEC TRUE_YPOS
        DEC ANIM_COUNTER
        BNE .effect0Bis

.effect0
	EMIT_FRAMES 2
	DEC TRUE_YPOS ;amene Y a -15 pour avoir une ligne 0 et 4 lignes en dessous
        LDA TRUE_YPOS
        CMP #-21
        BNE .effect0 ; reste a descendre Y 18 fois pour arriver a +3
        ; 9 fois on

	LDA MODE
        AND #~BIT_YSTRETCH_ENABLE
        STA MODE
	RTS

MakeHalfPlayfield
.loopEnd        
        LDA FRAME
        AND #4
        beq .withPlayfield
	LDA MODE
        AND #~BIT_PLAYFIELD_ENABLE
        STA MODE
        JMP .doneHalfPlayfield
        
.withPlayfield
	LDA MODE
        ORA #BIT_PLAYFIELD_ENABLE
        STA MODE
.doneHalfPlayfield        
        EMIT_FRAMES 1
        DEC ANIM_COUNTER
        BNE .loopEnd
	LDA MODE
        ORA #BIT_PLAYFIELD_ENABLE
        STA MODE
	RTS

MakeHalfDaftPunk
.loopMakeHalfDaftPunk        
        LDA FRAME
        AND #4
        beq .withDaftPunk
	LDA MODE
        AND #~BIT_DAFT_PUNK_ENABLE
        STA MODE
        JMP .doneHalfDaftPunk
        
.withDaftPunk
	LDA MODE
        ORA #BIT_DAFT_PUNK_ENABLE
        STA MODE
.doneHalfDaftPunk   
        EMIT_FRAMES 1
        DEC ANIM_COUNTER
        BNE .loopMakeHalfDaftPunk
	LDA MODE
        ORA #BIT_DAFT_PUNK_ENABLE
        STA MODE
	RTS


PlayScenario3 SUBROUTINE
	JMP afterEmitFrame ;(SCENARIO_PTR)

	JSR StartBombermanScenario
        
	LDA #12
        STA TRUE_XPOS
        LDA #-20
        STA TRUE_YPOS
        
        LDA #>GetColorGold
        STA BACKGROUND_PTR + 1
        LDA #<GetColorGold
        STA BACKGROUND_PTR


.bringScreen
	EMIT_FRAMES 1
        INC SCREEN_YPOS
        bne .bringScreen

	JSR StretchFromSky
        EMIT_FRAMES 20

	LDA #20
        STA ANIM_COUNTER
	JSR MakeHalfPlayfield

        EMIT_FRAMES 20
;        LDA #2
;        STA ANIM_COUNTER
;        JSR WalkLeftUntilAnimCounter
        JSR ExitLeft

        LDA #>GetColorBlues
        STA BACKGROUND_PTR + 1
        LDA #<GetColorBlues
        STA BACKGROUND_PTR

;        JSR TurnRight
	LDA MODE
	AND #~BIT_PLAYFIELD_ENABLE
        STA MODE

        LDA #-5
        STA ANIM_COUNTER
        JSR WalkRightUntilAnimCounter
        LDA #9

        STA ANIM_COUNTER
        JSR WalkRightUntilAnimCounterBackward
        
        LDA #38
        STA ANIM_COUNTER
        JSR WalkRightUntilAnimCounter




;        JSR ExitRight
        
        LDA #12
        STA ANIM_COUNTER
;	EMIT_FRAMES 50
        JSR WalkLeftUntilAnimCounter
        LDA #0
        STA STEP_ANIM
	EMIT_FRAMES 25
	JSR TurnRight
	EMIT_FRAMES 25
;	JSR ExitLeft
;	LDA MODE
;        AND #~BIT_HIDE_SIDES_ENABLE
;        STA MODE
;	JSR RunExitRight
;	LDA #34
;        STA ANIM_COUNTER
;	JSR RunLeftUntilAnimCounter
;	JSR RunExitLeftFly

	LDA #20
        STA ANIM_COUNTER
        JSR MakeHalfPlayfield
        
	EMIT_FRAMES 17

;        JSR TurnLeft
;	EMIT_FRAMES 10
;        JSR TurnRight;
;	EMIT_FRAMES 10
	LDA #40
        STA ANIM_COUNTER
        JSR MakeHalfDaftPunk

;        JSR BombermanJump
;	LDA MODE
;        ORA #(BIT_DAFT_PUNK_ENABLE | BIT_FACE_ENABLE)
;        STA MODE
	EMIT_FRAMES 34

        JMP SetScenarioDone ; end scenario 2

Idle
	STA ANIM_COUNTER
.loopIdle
	JSR AnimateForward
        EMIT_FRAMES 2
        DEC ANIM_COUNTER
        BNE .loopIdle
        RTS
        
PlayScenario4
	JMP afterEmitFrame ;(SCENARIO_PTR)

	LDA MODE
        ORA #(BIT_DAFT_PUNK_ENABLE | BIT_PLAYFIELD_ENABLE | BIT_FACE_ENABLE)
        STA MODE
	JSR SetColorRainbow
	
        LDA #15
        JSR Idle
;	EMIT_FRAMES 30
	JSR Doublette25HzDebut
	JSR Doublette25Hz
	JSR Doublette25HzFin
        LDA #0
        STA STEP_ANIM
        EMIT_FRAMES 10
        JSR BombermanJump
        EMIT_FRAMES 10
;        LDA #20
;        JSR Idle

.loopScenario4
 	JSR AnimateForward
 	EMIT_FRAMES 2
        INC WAIT_LINES
        INC WAIT_LINES
        INC WAIT_LINES
        INC WAIT_LINES
        LDA WAIT_LINES
        CMP #80
        BNE .loopScenario4
        
        JSR RunExitRight

        JMP SetScenarioDone
        

AnimateForward
	DEC STEP_COUNTER
        BNE .noStepAnim
        LDA STEP_ANIM
        CLC
        ADC #1
        AND #3
        STA STEP_ANIM
     
        LDA #STEP_COUNTER_VALUE
        STA STEP_COUNTER
.noStepAnim        
	RTS

AnimateBackward
	DEC STEP_COUNTER
        BNE .noStepAnimBackward
        LDA STEP_ANIM
        CLC
        ADC #-1
        AND #3
        STA STEP_ANIM
     
        LDA #STEP_COUNTER_VALUE
        STA STEP_COUNTER
.noStepAnimBackward        
	RTS




	IF BANK_SELECT = 1
line0_generated equ line0_generatedX0
line1_generated equ line1_generatedX0
line2_generated equ line2_generatedX0
line3_generated equ line3_generatedX0
line4_generated equ line4_generatedX0
line5_generated equ line5_generatedX0
line6_generated equ line6_generatedX0
line7_generated equ line7_generatedX0
line8_generated equ line8_generatedX0
line9_generated equ line9_generatedX0
line10_generated equ line10_generatedX0
line11_generated equ line11_generatedX0
line12_generated equ line12_generatedX0
line13_generated equ line13_generatedX0
line14_generated equ line14_generatedX0
line15_generated equ line15_generatedX0
line16_generated equ line16_generatedX0
line17_generated equ line17_generatedX0
line18_generated equ line18_generatedX0
line19_generated equ line19_generatedX0
step1line13_generated equ step1line13_generatedX0
step1line14_generated equ step1line14_generatedX0
step1line15_generated equ step1line15_generatedX0
step1line16_generated equ step1line16_generatedX0
step1line17_generated equ step1line17_generatedX0
step1line18_generated equ step1line18_generatedX0
step1line19_generated equ step1line19_generatedX0
step1line20_generated equ step1line20_generatedX0
step2line11_generated equ step2line11_generatedX0
step2line12_generated equ step2line12_generatedX0
step2line13_generated equ step2line13_generatedX0
step2line14_generated equ step2line14_generatedX0
step2line15_generated equ step2line15_generatedX0
step2line16_generated equ step2line16_generatedX0
step2line17_generated equ step2line17_generatedX0
step2line18_generated equ step2line18_generatedX0
step2line19_generated equ step2line19_generatedX0
step3line12_generated equ step3line12_generatedX0
step3line13_generated equ step3line13_generatedX0
step3line14_generated equ step3line14_generatedX0
step3line15_generated equ step3line15_generatedX0
step3line16_generated equ step3line16_generatedX0
step3line17_generated equ step3line17_generatedX0
step3line18_generated equ step3line18_generatedX0
step3line19_generated equ step3line19_generatedX0
step3line20_generated equ step3line20_generatedX0
	ENDIF
	IF BANK_SELECT =  2
line0_generated equ line0_generatedX1
line1_generated equ line1_generatedX1
line2_generated equ line2_generatedX1
line3_generated equ line3_generatedX1
line4_generated equ line4_generatedX1
line5_generated equ line5_generatedX1
line6_generated equ line6_generatedX1
line7_generated equ line7_generatedX1
line8_generated equ line8_generatedX1
line9_generated equ line9_generatedX1
line10_generated equ line10_generatedX1
line11_generated equ line11_generatedX1
line12_generated equ line12_generatedX1
line13_generated equ line13_generatedX1
line14_generated equ line14_generatedX1
line15_generated equ line15_generatedX1
line16_generated equ line16_generatedX1
line17_generated equ line17_generatedX1
line18_generated equ line18_generatedX1
line19_generated equ line19_generatedX1
step1line13_generated equ step1line13_generatedX1
step1line14_generated equ step1line14_generatedX1
step1line15_generated equ step1line15_generatedX1
step1line16_generated equ step1line16_generatedX1
step1line17_generated equ step1line17_generatedX1
step1line18_generated equ step1line18_generatedX1
step1line19_generated equ step1line19_generatedX1
step1line20_generated equ step1line20_generatedX1
step2line11_generated equ step2line11_generatedX1
step2line12_generated equ step2line12_generatedX1
step2line13_generated equ step2line13_generatedX1
step2line14_generated equ step2line14_generatedX1
step2line15_generated equ step2line15_generatedX1
step2line16_generated equ step2line16_generatedX1
step2line17_generated equ step2line17_generatedX1
step2line18_generated equ step2line18_generatedX1
step2line19_generated equ step2line19_generatedX1
step3line12_generated equ step3line12_generatedX1
step3line13_generated equ step3line13_generatedX1
step3line14_generated equ step3line14_generatedX1
step3line15_generated equ step3line15_generatedX1
step3line16_generated equ step3line16_generatedX1
step3line17_generated equ step3line17_generatedX1
step3line18_generated equ step3line18_generatedX1
step3line19_generated equ step3line19_generatedX1
step3line20_generated equ step3line20_generatedX1
	ENDIF
	IF BANK_SELECT =  3
        
line0_generated equ line0_generatedX2
line1_generated equ line1_generatedX2
line2_generated equ line2_generatedX2
line3_generated equ line3_generatedX2
line4_generated equ line4_generatedX2
line5_generated equ line5_generatedX2
line6_generated equ line6_generatedX2
line7_generated equ line7_generatedX2
line8_generated equ line8_generatedX2
line9_generated equ line9_generatedX2
line10_generated equ line10_generatedX2
line11_generated equ line11_generatedX2
line12_generated equ line12_generatedX2
line13_generated equ line13_generatedX2
line14_generated equ line14_generatedX2
line15_generated equ line15_generatedX2
line16_generated equ line16_generatedX2
line17_generated equ line17_generatedX2
line18_generated equ line18_generatedX2
line19_generated equ line19_generatedX2
step1line13_generated equ step1line13_generatedX2
step1line14_generated equ step1line14_generatedX2
step1line15_generated equ step1line15_generatedX2
step1line16_generated equ step1line16_generatedX2
step1line17_generated equ step1line17_generatedX2
step1line18_generated equ step1line18_generatedX2
step1line19_generated equ step1line19_generatedX2
step1line20_generated equ step1line20_generatedX2
step2line11_generated equ step2line11_generatedX2
step2line12_generated equ step2line12_generatedX2
step2line13_generated equ step2line13_generatedX2
step2line14_generated equ step2line14_generatedX2
step2line15_generated equ step2line15_generatedX2
step2line16_generated equ step2line16_generatedX2
step2line17_generated equ step2line17_generatedX2
step2line18_generated equ step2line18_generatedX2
step2line19_generated equ step2line19_generatedX2
step3line12_generated equ step3line12_generatedX2
step3line13_generated equ step3line13_generatedX2
step3line14_generated equ step3line14_generatedX2
step3line15_generated equ step3line15_generatedX2
step3line16_generated equ step3line16_generatedX2
step3line17_generated equ step3line17_generatedX2
step3line18_generated equ step3line18_generatedX2
step3line19_generated equ step3line19_generatedX2
step3line20_generated equ step3line20_generatedX2

	endif

	IF BANK_SELECT =  4
        
line0_generated equ line0_generatedX3
line1_generated equ line1_generatedX3
line2_generated equ line2_generatedX3
line3_generated equ line3_generatedX3
line4_generated equ line4_generatedX3
line5_generated equ line5_generatedX3
line6_generated equ line6_generatedX3
line7_generated equ line7_generatedX3
line8_generated equ line8_generatedX3
line9_generated equ line9_generatedX3
line10_generated equ line10_generatedX3
line11_generated equ line11_generatedX3
line12_generated equ line12_generatedX3
line13_generated equ line13_generatedX3
line14_generated equ line14_generatedX3
line15_generated equ line15_generatedX3
line16_generated equ line16_generatedX3
line17_generated equ line17_generatedX3
line18_generated equ line18_generatedX3
line19_generated equ line19_generatedX3
step1line13_generated equ step1line13_generatedX3
step1line14_generated equ step1line14_generatedX3
step1line15_generated equ step1line15_generatedX3
step1line16_generated equ step1line16_generatedX3
step1line17_generated equ step1line17_generatedX3
step1line18_generated equ step1line18_generatedX3
step1line19_generated equ step1line19_generatedX3
step1line20_generated equ step1line20_generatedX3
step2line11_generated equ step2line11_generatedX3
step2line12_generated equ step2line12_generatedX3
step2line13_generated equ step2line13_generatedX3
step2line14_generated equ step2line14_generatedX3
step2line15_generated equ step2line15_generatedX3
step2line16_generated equ step2line16_generatedX3
step2line17_generated equ step2line17_generatedX3
step2line18_generated equ step2line18_generatedX3
step2line19_generated equ step2line19_generatedX3
step3line12_generated equ step3line12_generatedX3
step3line13_generated equ step3line13_generatedX3
step3line14_generated equ step3line14_generatedX3
step3line15_generated equ step3line15_generatedX3
step3line16_generated equ step3line16_generatedX3
step3line17_generated equ step3line17_generatedX3
step3line18_generated equ step3line18_generatedX3
step3line19_generated equ step3line19_generatedX3
step3line20_generated equ step3line20_generatedX3

	endif

	IF BANK_SELECT =  5
        
line0_generated equ line0_generatedX4
line1_generated equ line1_generatedX4
line2_generated equ line2_generatedX4
line3_generated equ line3_generatedX4
line4_generated equ line4_generatedX4
line5_generated equ line5_generatedX4
line6_generated equ line6_generatedX4
line7_generated equ line7_generatedX4
line8_generated equ line8_generatedX4
line9_generated equ line9_generatedX4
line10_generated equ line10_generatedX4
line11_generated equ line11_generatedX4
line12_generated equ line12_generatedX4
line13_generated equ line13_generatedX4
line14_generated equ line14_generatedX4
line15_generated equ line15_generatedX4
line16_generated equ line16_generatedX4
line17_generated equ line17_generatedX4
line18_generated equ line18_generatedX4
line19_generated equ line19_generatedX4
step1line13_generated equ step1line13_generatedX4
step1line14_generated equ step1line14_generatedX4
step1line15_generated equ step1line15_generatedX4
step1line16_generated equ step1line16_generatedX4
step1line17_generated equ step1line17_generatedX4
step1line18_generated equ step1line18_generatedX4
step1line19_generated equ step1line19_generatedX4
step1line20_generated equ step1line20_generatedX4
step2line11_generated equ step2line11_generatedX4
step2line12_generated equ step2line12_generatedX4
step2line13_generated equ step2line13_generatedX4
step2line14_generated equ step2line14_generatedX4
step2line15_generated equ step2line15_generatedX4
step2line16_generated equ step2line16_generatedX4
step2line17_generated equ step2line17_generatedX4
step2line18_generated equ step2line18_generatedX4
step2line19_generated equ step2line19_generatedX4
step3line12_generated equ step3line12_generatedX4
step3line13_generated equ step3line13_generatedX4
step3line14_generated equ step3line14_generatedX4
step3line15_generated equ step3line15_generatedX4
step3line16_generated equ step3line16_generatedX4
step3line17_generated equ step3line17_generatedX4
step3line18_generated equ step3line18_generatedX4
step3line19_generated equ step3line19_generatedX4
step3line20_generated equ step3line20_generatedX4

	endif

	IF BANK_SELECT =  6
        
line0_generated equ line0_generatedX5
line1_generated equ line1_generatedX5
line2_generated equ line2_generatedX5
line3_generated equ line3_generatedX5
line4_generated equ line4_generatedX5
line5_generated equ line5_generatedX5
line6_generated equ line6_generatedX5
line7_generated equ line7_generatedX5
line8_generated equ line8_generatedX5
line9_generated equ line9_generatedX5
line10_generated equ line10_generatedX5
line11_generated equ line11_generatedX5
line12_generated equ line12_generatedX5
line13_generated equ line13_generatedX5
line14_generated equ line14_generatedX5
line15_generated equ line15_generatedX5
line16_generated equ line16_generatedX5
line17_generated equ line17_generatedX5
line18_generated equ line18_generatedX5
line19_generated equ line19_generatedX5
step1line13_generated equ step1line13_generatedX5
step1line14_generated equ step1line14_generatedX5
step1line15_generated equ step1line15_generatedX5
step1line16_generated equ step1line16_generatedX5
step1line17_generated equ step1line17_generatedX5
step1line18_generated equ step1line18_generatedX5
step1line19_generated equ step1line19_generatedX5
step1line20_generated equ step1line20_generatedX5
step2line11_generated equ step2line11_generatedX5
step2line12_generated equ step2line12_generatedX5
step2line13_generated equ step2line13_generatedX5
step2line14_generated equ step2line14_generatedX5
step2line15_generated equ step2line15_generatedX5
step2line16_generated equ step2line16_generatedX5
step2line17_generated equ step2line17_generatedX5
step2line18_generated equ step2line18_generatedX5
step2line19_generated equ step2line19_generatedX5
step3line12_generated equ step3line12_generatedX5
step3line13_generated equ step3line13_generatedX5
step3line14_generated equ step3line14_generatedX5
step3line15_generated equ step3line15_generatedX5
step3line16_generated equ step3line16_generatedX5
step3line17_generated equ step3line17_generatedX5
step3line18_generated equ step3line18_generatedX5
step3line19_generated equ step3line19_generatedX5
step3line20_generated equ step3line20_generatedX5

	endif


histep0lines
	.byte #>(line0_generated - 1)
	.byte #>(line1_generated - 1)
	.byte #>(line2_generated - 1)
	.byte #>(line3_generated - 1)
	.byte #>(line4_generated - 1)
	.byte #>(line5_generated - 1)
	.byte #>(line6_generated - 1)
	.byte #>(line7_generated - 1)
	.byte #>(line8_generated - 1)
	.byte #>(line9_generated - 1)
	.byte #>(line10_generated - 1)
	.byte #>(line11_generated - 1)
	.byte #>(line12_generated - 1)
	.byte #>(line13_generated - 1)
	.byte #>(line14_generated - 1)
	.byte #>(line15_generated - 1)
	.byte #>(line16_generated - 1)
	.byte #>(line17_generated - 1)
	.byte #>(line18_generated - 1)
	.byte #>(line19_generated - 1)
        .byte 0

lostep0lines
	.byte #<(line0_generated - 1)
	.byte #<(line1_generated - 1)
	.byte #<(line2_generated - 1)
	.byte #<(line3_generated - 1)
	.byte #<(line4_generated - 1)
	.byte #<(line5_generated - 1)
	.byte #<(line6_generated - 1)
	.byte #<(line7_generated - 1)
	.byte #<(line8_generated - 1)
	.byte #<(line9_generated - 1)
	.byte #<(line10_generated - 1)
	.byte #<(line11_generated - 1)
	.byte #<(line12_generated - 1)
	.byte #<(line13_generated - 1)
	.byte #<(line14_generated - 1)
	.byte #<(line15_generated - 1)
	.byte #<(line16_generated - 1)
	.byte #<(line17_generated - 1)
	.byte #<(line18_generated - 1)
	.byte #<(line19_generated - 1)
        .byte 0


histep2lines
	.byte #>(line0_generated - 1)
	.byte #>(line1_generated - 1)
	.byte #>(line2_generated - 1)
	.byte #>(line3_generated - 1)
	.byte #>(line4_generated - 1)
	.byte #>(line5_generated - 1)
	.byte #>(line6_generated - 1)
	.byte #>(line7_generated - 1)
	.byte #>(line8_generated - 1)
	.byte #>(line9_generated - 1)
	.byte #>(line10_generated - 1)
	.byte #>(step2line11_generated - 1)
	.byte #>(step2line12_generated - 1)
	.byte #>(step2line13_generated - 1)
	.byte #>(step2line14_generated - 1)
	.byte #>(step2line15_generated - 1)
	.byte #>(step2line16_generated - 1)
	.byte #>(step2line17_generated - 1)
	.byte #>(step2line18_generated - 1)
	.byte #>(step2line19_generated - 1)
        .byte 0

lostep2lines
	.byte #<(line0_generated - 1)
	.byte #<(line1_generated - 1)
	.byte #<(line2_generated - 1)
	.byte #<(line3_generated - 1)
	.byte #<(line4_generated - 1)
	.byte #<(line5_generated - 1)
	.byte #<(line6_generated - 1)
	.byte #<(line7_generated - 1)
	.byte #<(line8_generated - 1)
	.byte #<(line9_generated - 1)
	.byte #<(line10_generated - 1)
	.byte #<(step2line11_generated - 1)
	.byte #<(step2line12_generated - 1)
	.byte #<(step2line13_generated - 1)
	.byte #<(step2line14_generated - 1)
	.byte #<(step2line15_generated - 1)
	.byte #<(step2line16_generated - 1)
	.byte #<(step2line17_generated - 1)
	.byte #<(step2line18_generated - 1)
	.byte #<(step2line19_generated - 1)
        .byte 0

histep1lines
	.byte #>(line0_generated - 1)
	.byte #>(line1_generated - 1)
	.byte #>(line2_generated - 1)
	.byte #>(line3_generated - 1)
	.byte #>(line4_generated - 1)
	.byte #>(line5_generated - 1)
	.byte #>(line6_generated - 1)
	.byte #>(line7_generated - 1)
	.byte #>(line8_generated - 1)
	.byte #>(line9_generated - 1)
	.byte #>(line10_generated - 1)
	.byte #>(line11_generated - 1)
	.byte #>(step3line12_generated - 1)
	.byte #>(step1line13_generated - 1)
	.byte #>(step1line14_generated - 1)
	.byte #>(step1line15_generated - 1)
	.byte #>(step1line16_generated - 1)
	.byte #>(step1line17_generated - 1)
	.byte #>(step1line18_generated - 1)
	.byte #>(step1line19_generated - 1)
	.byte #>(step1line20_generated - 1)

lostep1lines
	.byte #<(line0_generated - 1)
	.byte #<(line1_generated - 1)
	.byte #<(line2_generated - 1)
	.byte #<(line3_generated - 1)
	.byte #<(line4_generated - 1)
	.byte #<(line5_generated - 1)
	.byte #<(line6_generated - 1)
	.byte #<(line7_generated - 1)
	.byte #<(line8_generated - 1)
	.byte #<(line9_generated - 1)
	.byte #<(line10_generated - 1)
	.byte #<(line11_generated - 1)
        .byte #<(step3line12_generated - 1)
	.byte #<(step1line13_generated - 1)
	.byte #<(step1line14_generated - 1)
	.byte #<(step1line15_generated - 1)
	.byte #<(step1line16_generated - 1)
	.byte #<(step1line17_generated - 1)
	.byte #<(step1line18_generated - 1)
	.byte #<(step1line19_generated - 1)
	.byte #<(step1line20_generated - 1)


histep3lines
	
	.byte #>(line0_generated - 1)
	.byte #>(line1_generated - 1)
	.byte #>(line2_generated - 1)
	.byte #>(line3_generated - 1)
	.byte #>(line4_generated - 1)
	.byte #>(line5_generated - 1)
	.byte #>(line6_generated - 1)
	.byte #>(line7_generated - 1)
	.byte #>(line8_generated - 1)
	.byte #>(line9_generated - 1)
	.byte #>(line10_generated - 1)
	.byte #>(line11_generated - 1)
	.byte #>(step3line12_generated - 1)
	.byte #>(step3line13_generated - 1)
	.byte #>(step3line14_generated - 1)
	.byte #>(step3line15_generated - 1)
	.byte #>(step3line16_generated - 1)
	.byte #>(step3line17_generated - 1)
	.byte #>(step3line18_generated - 1)
	.byte #>(step3line19_generated - 1)
	.byte #>(step3line20_generated - 1)

lostep3lines
	.byte #<(line0_generated - 1)
	.byte #<(line1_generated - 1)
	.byte #<(line2_generated - 1)
	.byte #<(line3_generated - 1)
	.byte #<(line4_generated - 1)
	.byte #<(line5_generated - 1)
	.byte #<(line6_generated - 1)
	.byte #<(line7_generated - 1)
	.byte #<(line8_generated - 1)
	.byte #<(line9_generated - 1)
	.byte #<(line10_generated - 1)
	.byte #<(line11_generated - 1)
	.byte #<(step3line12_generated - 1)
	.byte #<(step3line13_generated - 1)
	.byte #<(step3line14_generated - 1)
	.byte #<(step3line15_generated - 1)
	.byte #<(step3line16_generated - 1)
	.byte #<(step3line17_generated - 1)
	.byte #<(step3line18_generated - 1)
	.byte #<(step3line19_generated - 1)
	.byte #<(step3line20_generated - 1)



	ALIGN 16


TailleSprite
	.byte 20,21,20,21
        ; include "sprites.asm"


; table de DividerZp. 97 bytes . f(height / 2 - 14). maxHeight = 220px
totalHeight
 .byte 228,213,200,188,177,168,160,152,145,139,133,128,123,118,114,110,106,103,100,96,94,91,88,86,84,82,80,78,76,74,72,71,69,68,66,65,64,62,61,60,59,58,57,56,55,54,53,52,51,50,50,49,48,47,47,46,45,45,44,43,43,42,42,41,41,40,40,39,39,38,38,37,37,36,36,35,35,35,34,34,34,33,33,32,32,32,32
 .byte 31,31,31,30,30,30,29,29,29,29

; 64 bytes
Sinus
; .byte 124,128,133,138,142,147,151,156,160,165,169,173,177,181,184,188,191,195,198,201,203,206,208,210,212,214,215,217,218,218,219,219,220,219,219,218,218,217,215,214,212,210,208,206,203,201,198,195,191,188,184,181,177,173,169,165,160,156,151,147,142,138,133,128,124,119,114,109,105,100,96,91,87,82,78,74,70,66,63,59,56,52,49,46,44,41,39,37,35,33,32,30,29,29,28,28,28,28,28,29,29,30,32,33,35,37,39,41,44,46,49,52,56,59,63,66,70,74,78,82,87,91,96,100,105,109,114,119
; Bank 0 epilogue
;totalLines .byte 53,53,53,53,53,53,53,54,54,54,55,55,55,56,56,57,57,58,59,59,60,61,62,62,63,64,65,66,67,69,70,71,72,74,75,76,78,79,81,82,84,86,87,89,91,92,94,96,97,99,101,102,104,105,107,108,109,110,111,112,113,113,113,114,114,114,113,113,113,112,111,110,109,108,107,105,104,102,101,99,97,96,94,92,91,89,87,86,84,82,81,79,78,76,75,74,72,71,70,69,67,66,65,64,63,62,62,61,60,59,59,58,57,57,56,56,55,55,55,54,54,54,53,53,53,53,53,53
;waitLines .byte 97,94,92,89,87,84,81,78,76,73,70,67,65,62,59,57,54,51,48,46,43,40,38,36,33,30,28,26,23,21,19,17,15,13,11,10,8,7,5,4,3,3,3,2,2,3,3,4,6,7,9,11,14,17,20,23,27,31,36,40,45,50,56,61,66,72,78,84,89,95,100,106,111,116,120,125,129,134,137,141,144,147,150,152,154,156,157,158,160,161,161,161,161,161,161,160,160,159,158,157,157,155,154,153,151,149,147,146,144,142,140,138,136,133,132,129,127,125,122,120,117,115,113,110,107,105,102,100
;totalLines .byte 49,49,49,49,49,49,50,50,50,51,51,52,52,53,53,54,55,56,57,58,59,60,61,62,64,65,66,68,70,72,74,76,78,80,83,85,88,91,94,97,101,104,108,112,116,120,125,129,134,139,143,148,153,158,162,167,171,175,179,182,185,187,189,190,190,190,189,187,185,182,179,175,171,167,162,158,153,148,143,139,134,129,125,120,116,112,108,104,101,97,94,91,88,85,83,80,78,76,74,72,70,68,66,65,64,62,61,60,59,58,57,56,55,54,53,53,52,52,51,51,50,50,50,49,49,49,49,49
;waitLines .byte 99,98,97,95,94,93,91,90,89,87,86,84,83,81,80,78,76,75,73,71,69,68,66,64,62,60,58,56,54,52,50,47,45,43,41,39,36,34,31,29,26,24,22,19,17,15,13,11,9,7,6,5,4,4,4,4,5,6,8,10,13,16,20,24,28,33,38,44,49,55,60,66,71,76,81,85,90,94,98,101,104,107,109,112,114,116,117,119,120,121,122,122,123,123,123,124,124,124,123,123,123,123,123,122,121,121,120,119,119,118,117,116,116,115,114,113,112,111,110,109,108,107,106,105,104,103,101,100
;totalLines .byte 51,51,51,51,51,51,51,52,52,53,53,54,54,55,55,56,57,58,59,60,61,62,64,65,66,68,70,71,73,75,78,80,82,85,88,91,94,97,101,104,108,112,117,121,126,131,136,142,147,153,159,165,171,177,183,188,194,199,204,208,211,214,216,218,218,218,216,214,211,208,204,199,194,188,183,177,171,165,159,153,147,142,136,131,126,121,117,112,108,104,101,97,94,91,88,85,82,80,78,75,73,71,70,68,66,65,64,62,61,60,59,58,57,56,55,55,54,54,53,53,52,52,51,51,51,51,51,51
;waitLines .byte 98,97,96,95,94,93,93,91,90,89,88,87,86,84,83,82,80,79,77,76,75,73,71,70,68,66,64,63,61,59,57,55,53,50,48,46,43,41,38,36,33,31,28,25,23,20,17,15,12,10,8,6,4,2,1,0,0,0,0,1,3,5,8,11,14,18,23,28,33,38,43,48,53,59,63,68,72,76,80,84,88,90,94,96,98,101,102,104,106,107,108,109,110,110,111,112,112,112,112,113,113,113,113,113,113,112,112,112,111,111,111,110,110,109,109,108,107,106,106,105,105,104,103,103,102,101,100,99
;128 bytes each
; to make 3d raster animation. 256 bytes
;totalLines .byte 50,50,50,50,50,50,50,51,51,51,52,52,53,53,54,55,56,57,57,58,59,61,62,63,65,66,68,69,71,73,75,77,80,82,84,87,90,93,96,100,103,107,111,115,120,124,129,133,138,144,149,154,159,164,169,174,179,183,187,191,194,196,198,199,200,199,198,196,194,191,187,183,179,174,169,164,159,154,149,144,138,133,129,124,120,115,111,107,103,100,96,93,90,87,84,82,80,77,75,73,71,69,68,66,65,63,62,61,59,58,57,57,56,55,54,53,53,52,52,51,51,51,50,50,50,50,50,50
;waitLines .byte 99,98,97,96,95,94,93,92,91,90,89,88,86,85,84,83,81,80,79,77,76,74,73,71,69,68,66,65,63,61,59,57,55,53,51,49,47,44,42,40,37,35,33,30,28,26,23,21,19,17,15,13,12,11,10,10,9,10,10,11,13,15,17,20,23,28,32,36,40,45,50,54,59,63,68,72,76,80,83,86,90,93,95,97,99,102,103,105,107,107,109,110,110,111,112,112,112,113,113,113,113,113,113,113,113,113,112,112,112,112,111,110,110,109,109,109,108,107,106,106,105,104,104,103,102,101,100,99

Minus18Div3Table 
	.byte -6,-5,-5,-5,-4,-4,-4,-3,-3,-3,-2,-2,-2,-1,-1,-1,0,0
Div3Table 
	.byte 0,0,0,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6
	.byte 7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12
        .byte 13,13,13,14,14

Minus18Mod3Table 
	.byte 0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2
; de 0 a 43
Mod3Table 
	.byte 0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2
	.byte 0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2
        .byte 0,1,2,0,1,2,0,1
        
;identM2 .byte -2,-2,-2,-1,-1,0,1,1,2,2,2,1,1,0,-1,-1        
; sorte de sinus pour les oscillations du beam
; 64 bytes
sin3 .byte 0,0,0,0,1,1,2,3,4,6,7,8,9,11,11,12,12,12,11,11,9,8,7,6,4,3,2,1,1,0,0,0
     .byte 0,0,0,0,-1,-1,-2,-3,-4,-6,-7,-8,-9,-11,-11,-12,-12,-12,-11,-11,-9,-8,-7,-6,-4,-3,-2,-1,-1,0,0,0,0
ident .byte 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15

;0,1,2,3,5,6,7,8,8,9,10,11,11,11,12,12,12,12,12,11,11,11,10,9,8,8,7,6,5,3,2,1,0,-1,-2,-3,-5,-6,-7,-8,-8,-9,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9,-8,-8,-7,-6,-5,-3,-2,-1,0
;0,1,2,3,4,4,5,5,6,5,5,4,4,3,2,1,0,-2,-3,-4,-5,-5,-6,-6,-6,-6,-6,-5,-5,-4,-3,-2,-1
;-4,-4,-4,-3,-2,0,2,3,4,4,4,3,2,0,-2,-3        

        echo "ROM left bank 0: ", ($1ff4 - *)

        org $0FFA
        rorg $1FFA
        .word Start      ; NMI
        .word Start      ; RESET
        .word Start      ; BRK

Bank1 SUBROUTINE
        ORG     $1000
        RORG    $3000

; Ensure that bank 0 is selected
.Start
        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch
        BANK_SWITCH_TRAMPOLINE
;----End of bank-identical code----

Lose25CyclesX0
	.byte $82
Lose24CyclesX0
	.byte $82
Lose23CyclesX0
	.byte $82
Lose22CyclesX0
	.byte $82
Lose21CyclesX0
	.byte $82
Lose20CyclesX0
	.byte $82
Lose19CyclesX0
	.byte $82
Lose18CyclesX0
	.byte $82
Lose17CyclesX0
	.byte $82
Lose16CyclesX0
        .byte $82 ; Nop imm 2
Lose15CyclesX0
        .byte $44 ; Nop zp 3
Lose14CyclesX0
        .byte $EA ; Nop
Lose12CyclesX0
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLine
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLine


LoopEmptyLine
    pha
    pla
    nop
    nop
EmptyLine
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX0
    STX COLUBK

    BCC LoopEmptyLine
    RTS

; on peut recuperer 64 bytes ici

        ;ALIGN_LINE_ROUTINE 1,line0_generated,"loop_line0"
;	ALIGN 256
loop_line0X0
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X0,Y
        STX PF0
        LDX Step0Line0PF1X0,Y
        STX PF1
        LDX Step0Line0PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
       
        LDY BACKGROUND_COLOR_LINE_0
        STY COLUBK
        JSR Lose20CyclesX0
        
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line0X0
        rts

        ;ALIGN_LINE_ROUTINE 1,line1_generated,"loop_line1"
loop_line1X0
    NOP ;3
    nop

line1_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X0,Y
        STX PF0
        LDX Step0Line1PF1X0,Y
        STX PF1
        LDX Step0Line1PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK
        JSR Lose12CyclesX0
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK
        bcc loop_line1X0
        RTS

	nop
        ;ALIGN_LINE_ROUTINE 1,line2_generated,"loop_line2"
loop_line2X0
    NOP3
    nop

line2_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X0,Y
        STX PF0
        LDX Step0Line2PF1X0,Y
        STX PF1
        LDX Step0Line2PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_2
        
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK
        LDX #COLOR_WHITE
        STX COLUBK    
	ADC Y_DIVIDER_ZP
    	STY COLUBK - COLOR_WHITE,X
        nop
	LDX COLOR_BLACK_BYTE
        STX COLUBK
        
        bcc loop_line2X0
        RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,line3_generated,"loop_line3"
loop_line3X0
    nop3
    nop

line3_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X0,Y
        STX PF0
        LDX Step0Line3PF1X0,Y
        STX PF1
        LDX Step0Line3PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3
        
        STY COLUBK
        LDX #COLOR_WHITE
        NOP
        NOP
        STX COLUBK
        PHA
        PLA
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK
        
        bcc loop_line3X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,line4_generated,"loop_line4"


	NOP
        NOP
; haut masque
loop_line4X0
    nop3
    nop

line4_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X0,Y
        STX PF0
        LDX Step0Line4PF1X0,Y
        STX PF1
        LDX Step0Line4PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDX #$FE
        STX COLUBK 
        STX GRP1
    	STY COLUBK - $FE,X
	NOP
	ADC Y_DIVIDER_ZP
	NOP3
        LDX #0
        STX COLUBK

	bcc loop_line4X0
	RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,line5_generated,"loop_line5"
; haut oeil
loop_line5X0
    nop3
    nop

line5_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X0,Y
        STX PF0
        LDX Step0Line5PF1X0,Y
        STX PF1
        LDX Step0Line5PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDX #$FF
        STX COLUBK
        STX GRP1
    	STY COLUBK
	ADC Y_DIVIDER_ZP
	NOP
	NOP
        NOP
        LDX #0
        STX COLUBK
        
	bcc loop_line5X0
	RTS


        nop
        nop
        ;ALIGN_LINE_ROUTINE 1,line6_generated,"loop_line6"
; milieu oeil
loop_line6X0
    nop
    nop

line6_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X0,Y
        STX PF0
        LDX Step0Line6PF1X0,Y
        STX PF1
        LDX Step0Line6PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDX #$FF
        STX COLUBK
        STX GRP1
    	STY COLUBK        
	ADC Y_DIVIDER_ZP
	NOP
	NOP
        NOP
        LDX #0
        STX COLUBK

        bcc loop_line6X0
        RTS

        nop
        nop
        ;ALIGN_LINE_ROUTINE 1,line7_generated,"loop_line7"
; bas oeil
loop_line7X0
    nop3
    nop

line7_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X0,Y
        STX PF0
        LDX Step0Line7PF1X0,Y
        STX PF1
        LDX Step0Line7PF2X0,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDX #$FF
        STX COLUBK
        STX GRP1
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        NOP
        LDX #0
        STX COLUBK
         
    	bcc loop_line7X0
    	RTS

        nop
        nop
        ;ALIGN_LINE_ROUTINE 1,line8_generated,"loop_line8"
; bas masque
loop_line8X0
    nop3
    nop

line8_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X0,Y
        STX PF0
        LDX Step0Line8PF1X0,Y
        STX PF1
        LDX Step0Line8PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDX #$FE
        STX COLUBK 
        STX GRP1
    	STY COLUBK - $FE,X
	NOP
	ADC Y_DIVIDER_ZP
	NOP3
        LDX #0
        STX COLUBK

	bcc loop_line8X0
    	RTS

        nop
        nop
        

        ;ALIGN_LINE_ROUTINE 1,line9_generated,"loop_line9"
; sous le masque
loop_line9X0
	nop3
        nop

line9_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X0,Y
        STX PF0
        LDX Step0Line9PF1X0,Y
        STX PF1
        LDX Step0Line9PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9

    	STY COLUBK
        LDY #0
    	LDX #COLOR_WHITE ;_BYTE
        nop
	STX COLUBK
        STY GRP1
        LDY BACKGROUND_COLOR_LINE_9
    	ADC Y_DIVIDER_ZP
        LDX #0
    	STY COLUBK
    	nop
    	STX COLUBK

        bcc loop_line9X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,line10_generated,"loop_line10"
; separation tete corps
loop_line10X0
    nop3
    nop

line10_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X0,Y
        STX PF0
        LDX Step0Line10PF1X0,Y
        STX PF1
        LDX Step0Line10PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        nop
        nop
        NOP
        LDX #0
        STY COLUBK
        ADC Y_DIVIDER_ZP
        STX COLUBK
        
        bcc loop_line10X0
        RTS

        NOP
        NOP
        nop
        ;ALIGN_LINE_ROUTINE 1,line11_generated,"loop_line11"
; haut du deuxieme bras
loop_line11X0
    nop
    nop

line11_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line11PF0X0,Y
        STX PF0
        LDX Step0Line11PF1X0,Y
        STX PF1
        LDX Step0Line11PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        STX ENAM1
        LDY BACKGROUND_COLOR_LINE_11
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_line11X0
        RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,line12_generated,"loop_line12"
; juste au dessus de la ceinture
loop_line12X0
    nop3
    nop

line12_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X0,Y
        STX PF0
        LDX Step0Line12PF1X0,Y
        STX PF1
        LDX Step0Line12PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        nop
        STY COLUBK
        ADC Y_DIVIDER_ZP
        nop
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_line12X0
        RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,line13_generated,"loop_line13"
loop_line13X0
        STX ENAM1
        NOP

line13_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X0,Y
        STX PF0
        LDX Step0Line13PF1X0,Y
        STX PF1
        LDX Step0Line13PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        NOP
        STX COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        NOP
        NOP
        ADC Y_DIVIDER_ZP
        STY COLUBK
        LDX #0
        STX COLUBK
        
	bcc loop_line13X0
    	RTS

        nop
        NOP
        NOP

        ;ALIGN_LINE_ROUTINE 1,line14_generated,"loop_line14"
loop_line14X0
    nop3
    nop

line14_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line14PF0X0,Y
        STX PF0
        LDX Step0Line14PF1X0,Y
        STX PF1
        LDX Step0Line14PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY #COLOR_VEST
        STX COLUBK
        nop3
        STY COLUBK    
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_line14X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,line15_generated,"loop_line15"
loop_line15X0
    nop3
    nop

line15_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X0,Y
        STX PF0
        LDX Step0Line15PF1X0,Y
        STX PF1
        LDX Step0Line15PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY COLOR_VEST_BYTE
        STX COLUBK
        nop
        STY COLUBK    
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK
	bcc loop_line15X0
    	RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,line16_generated,"loop_line16"
loop_line16X0
    nop
    nop

line16_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X0,Y
        STX PF0
        LDX Step0Line16PF1X0,Y
        STX PF1
        LDX Step0Line16PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_BLACK_BYTE
        STX GRP1
        NOP
        STY COLUBK
        STX COLUBK
        
        bcc loop_line16X0
        RTS

	;ALIGN_LINE_ROUTINE 1,line17_generated,"loop_line17"
loop_line17X0
    nop3
    nop

line17_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X0,Y
        STX PF0
        LDX Step0Line17PF1X0,Y
        STX PF1
        LDX Step0Line17PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        JSR Lose17CyclesX0
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_line17X0
        RTS

	NOP
        NOP
        NOP
        NOP
        ;ALIGN_LINE_ROUTINE 1,line18_generated,"loop_line18"
loop_line18X0
    nop3
    nop

line18_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X0,Y
        STX PF0
        LDX Step0Line18PF1X0,Y
        STX PF1
        LDX Step0Line18PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_RED_BYTE
        STX COLUBK
        nop
        nop
        STY COLUBK
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK
        
        bcc loop_line18X0
        RTS

        NOP
        NOP
        ;ALIGN_LINE_ROUTINE 1,line19_generated,"loop_line19"
loop_line19X0
    nop3
    nop

line19_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X0,Y
        STX PF0
        LDX Step0Line19PF1X0,Y
        STX PF1
        LDX Step0Line19PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX0
        LDX #0
        STX COLUBK
        bcc loop_line19X0
        RTS

	nop
        nop
	nop
        nop
	nop
        nop
        ;ALIGN_LINE_ROUTINE 1,step3line12_generated,"loop_step3line12"

; haut du deuxieme bras
loop_step3line12X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line12_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X0,Y
        STX PF0
        LDX Step3Line12PF1X0,Y
        STX PF1
        LDX Step3Line12PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line12X0
        RTS

            ;ALIGN_LINE_ROUTINE 1,step3line13_generated,"loop_step3line13"

	ALIGN 64
loop_step3line13X0
    LDX #COLOR_RED
    STX COLUP1
;    nop3 ;.byte $44,0 ; nop zp
;    nop

step3line13_generatedX0

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X0,Y
        STX PF0
        LDX Step3Line13PF1X0,Y
        STX PF1
        LDX Step3Line13PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        NOP3
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_step3line13X0
        RTS


        ;ALIGN_LINE_ROUTINE 1,step3line14_generated,"loop_step3line14"

	NOP
        NOP
        
loop_step3line14X0
	NOP3
        NOP

step3line14_generatedX0

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X0,Y
        STX PF0
        LDX Step3Line14PF1X0,Y
        STX PF1
        LDX Step3Line14PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step3line14X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line15_generated,"loop_step3line15"

loop_step3line15X0
        LDX #0
        STX ENAM1

step3line15_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X0,Y
        STX PF0
        LDX Step3Line15PF1X0,Y
        STX PF1
        LDX Step3Line15PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK - COLOR_VEST,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_15
        nop
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_step3line15X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line16_generated,"loop_step3line16"

loop_step3line16X0
    nop3 ;nop3 ;.byte $44,0 ; nop zp
    nop

step3line16_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X0,Y
        STX PF0
        LDX Step3Line16PF1X0,Y
        STX PF1
        LDX Step3Line16PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_WHITE
        STX COLUBK - COLOR_WHITE,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_16
        LDX #0
        STY COLUBK
        nop
        STX COLUBK
        bcc loop_step3line16X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line17_generated,"loop_step3line17"
        nop
	nop
loop_step3line17X0
    nop ;.byte $44,0 ; nop zp
    nop

step3line17_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X0,Y
        STX PF0
        LDX Step3Line17PF1X0,Y
        STX PF1
        LDX Step3Line17PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        LDY COLOR_BLACK_BYTE ;nop3
        STX COLUBK
        STY ENAM1 - COLOR_WHITE,X
	LDY BACKGROUND_COLOR_LINE_17
        LDX #0
        STY COLUBK
        nop
        STX COLUBK
        bcc loop_step3line17X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line18_generated,"loop_step3line18"

loop_step3line18X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line18_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X0,Y
        STX PF0
        LDX Step3Line18PF1X0,Y
        STX PF1
        LDX Step3Line18PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        nop
        nop
        nop3
        STX COLUBK
        LDX #0
        STY COLUBK
        nop
        STX COLUBK

        bcc loop_step3line18X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line19_generated,"loop_step3line19"

loop_step3line19X0
    nop3
    nop

step3line19_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X0,Y
        STX PF0
        LDX Step3Line19PF1X0,Y
        STX PF1
        LDX Step3Line19PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        STX COLUBK
        NOP3
        STY COLUBK
        nop        
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step3line19X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step3line20_generated,"loop_step3line20"

loop_step3line20X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line20_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X0,Y
        STX PF0
        LDX Step3Line20PF1X0,Y
        STX PF1
        LDX Step3Line20PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX0
        LDX #0
        STX COLUBK
        bcc loop_step3line20X0
        RTS
    
        ;ALIGN_LINE_ROUTINE 1,step1line13_generated,"loop_step1line13"

loop_step1line13X0
    nop3
    nop

step1line13_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X0,Y
        STX PF0
        LDX Step1Line13PF1X0,Y
        STX PF1
        LDX Step1Line13PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_WHITE
        nop
        STX COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        STY COLUBK
        NOP
        STX COLUBK

        bcc loop_step1line13X0
        RTS


        ;ALIGN_LINE_ROUTINE 1,step1line14_generated,"loop_step1line14"
	
; haut du deuxieme bras
loop_step1line14X0
    nop3
    nop

step1line14_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X0,Y
        STX PF0
        LDX Step1Line14PF1X0,Y
        STX PF1
        LDX Step1Line14PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_step1line14X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line15_generated,"loop_step1line15"

	ALIGN 16
loop_step1line15X0
    nop3
    nop

step1line15_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X0,Y
        STX PF0
        LDX Step1Line15PF1X0,Y
        STX PF1
        LDX Step1Line15PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_step1line15X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line16_generated,"loop_step1line16"

	NOP
loop_step1line16X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step1line16_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X0,Y
        STX PF0
        LDX Step1Line16PF1X0,Y
        STX PF1
        LDX Step1Line16PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        NOP3
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        NOP
        NOP
        LDX #0
        STY COLUBK,X
        nop
        STX COLUBK

        bcc loop_step1line16X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line17_generated,"loop_step1line17"

loop_step1line17X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step1line17_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X0,Y
        STX PF0
        LDX Step1Line17PF1X0,Y
        STX PF1
        LDX Step1Line17PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        nop3
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STX ENAM1
        STY COLUBK,X
        nop
        STX COLUBK
        
        bcc loop_step1line17X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line18_generated,"loop_step1line18"

loop_step1line18X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step1line18_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X0,Y
        STX PF0
        LDX Step1Line18PF1X0,Y
        STX PF1
        LDX Step1Line18PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        LDX #0
        STY COLUBK,X
        STX ENAM1
        nop
        nop
        nop
        STX COLUBK

        bcc loop_step1line18X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line19_generated,"loop_step1line19"

	NOP
        
loop_step1line19X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step1line19_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X0,Y
        STX PF0
        LDX Step1Line19PF1X0,Y
        STX PF1
        LDX Step1Line19PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19

        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #0
        STX ENAM1
        nop
        LDX #COLOR_RED
        STX COLUBK
        nop
        LDX #0
        STY COLUBK,X
        STX COLUBK

        bcc loop_step1line19X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step1line20_generated,"loop_step1line20"
loop_step1line20X0
    nop ;.byte $44,0 ; nop zp
    nop

step1line20_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X0,Y
        STX PF0
        LDX Step1Line20PF1X0,Y
        STX PF1
        LDX Step1Line20PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX0
        LDX #0
        STX COLUBK
        bcc loop_step1line20X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line11_generated,"loop_step2line11"

	NOP

; haut du deuxieme bras
loop_step2line11X0
    nop3
    nop

step2line11_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X0,Y
        STX PF0
        LDX Step2Line11PF1X0,Y
        STX PF1
        LDX Step2Line11PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_WHITE
        STX ENAM1
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step2line11X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line12_generated,"loop_step2line12"

; haut du deuxieme bras
loop_step2line12X0
        LDX #COLOR_RED
        STX COLUP1

;    nop3 ;.byte $44,0 ; nop zp
;    nop

step2line12_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X0,Y
        STX PF0
        LDX Step2Line12PF1X0,Y
        STX PF1
        LDX Step2Line12PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_12
        nop3
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step2line12X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line13_generated,"loop_step2line13"

	NOP
; 2eme main
loop_step2line13X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line13_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X0,Y
        STX PF0
        LDX Step2Line13PF1X0,Y
        STX PF1
        LDX Step2Line13PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #0
        STX COLUBK
 	LDX #COLOR_BELT ;COLOR_YELLOW
        STX COLUBK
        NOP
        ADC Y_DIVIDER_ZP
        LDX BACKGROUND_COLOR_LINE_13
        STX COLUBK
        NOP
        STY COLUBK
        
        bcc loop_step2line13X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line14_generated,"loop_step2line14"

	NOP

loop_step2line14X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line14_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X0,Y
        STX PF0
        LDX Step2Line14PF1X0,Y
        STX PF1
        LDX Step2Line14PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step2line14X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line15_generated,"loop_step2line15"

	NOP
        
loop_step2line15X0
    nop
    nop

step2line15_generatedX0

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X0,Y
        STX PF0
        LDX Step2Line15PF1X0,Y
        STX PF1
        LDX Step2Line15PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
	PHA
        PLA
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_step2line15X0
        RTS

	NOP
        NOP
        NOP

loop_step2line16X0
    nop3
    nop

step2line16_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X0,Y
        STX PF0
        LDX Step2Line16PF1X0,Y
        STX PF1
        LDX Step2Line16PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP3
        STX COLUBK
        LDX #0
        NOP
        NOP
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line16X0
        RTS

        ;ALIGN_LINE_ROUTINE 1,step2line17_generated,"loop_step2line17"

loop_step2line17X0
    nop3
    nop

step2line17_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X0,Y
        STX PF0
        LDX Step2Line17PF1X0,Y
        STX PF1
        LDX Step2Line17PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        LDX #0
        NOP3
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line17X0
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,step2line18_generated,"loop_step2line18"

loop_step2line18X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line18_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X0,Y
        STX PF0
        LDX Step2Line18PF1X0,Y
        STX PF1
        LDX Step2Line18PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        LDX #0
        NOP3
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line18X0
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,step2line19_generated,"loop_step2line19"

loop_step2line19X0
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line19_generatedX0
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X0,Y
        STX PF0
        LDX Step2Line19PF1X0,Y
        STX PF1
        LDX Step2Line19PF2X0,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX0
        LDX #0
        STX COLUBK
        bcc loop_step2line19X0
        RTS


; et apres il faut tout recalculer car le cycle
; de depart est le cycle 5 et le reste du code est aligne au cycle 0

; compensation temporaire
;    LDA #COLOR_GREEN_1
;    STA COLUBK
;    LDA #0
;    STA PF0
;    STA PF1
;    STA PF2
;    STA GRP0
;    STA GRP1
;    JSR Lose53Cycles
; back at cycle 0






; ne pas oublier de ne pas traverser de page boundary
; et qu'on a la meme tete pour les 4 sprites

; pour l'oscillation verticale, on padde avec des 0 au dessus de la tete
; mais sinon on padde avec des copies pour ne pas sortir d'une page boundary
; tout en generant le bon playfield
; on a 32 lignes par page ? on ne sort jamais de la page boundary !!

; pour que le beam puisse osciller verticalement, il faut allonger le bomberman.
; on ne le fait pas sortir de l'ecran donc s'il fait 25 lignes de haut, c'est bon.
; par contre il faut des routines pour afficher ces lignes aussi.
; si on rajoute une ligne il peut osciller de -1 a +1 deja
; l'oscillation verticale maximale est de 2 de toute facon.
; la tete est reutilisee dans les autres etapes d'animation
; c'est assez complique de faire demarrer le playfield au-dessus
; deja ajouter deux lignes -> il faut changer la facon de calculer le LO_SPRITE_PTR

; si on veut le playfield au-dessus il faut que les 3 autres etapes aient un decalage aussi
; et le calcul de X_POS change suivant la banque
; mais si on met dans l'ordre, alors le split raster descend quand X_POS augmente
; car le playfield remonte
; on laisse tomber l'oscillation dans l'autre sens
        ALIGN 8
;Step1Line11PF0X0 .byte $40,$00,$50,$80,$00,$10,$90,#$00
;Step1Line12PF0X0 .byte $40,$00,$50,$80,$00,$10,$90,#$00
Step1Line13PF0X0 .byte $C0,$00,$70,$C0,$30,$F0,$B0,#$00

;	ALIGN 256
Step0Line19PF0X0 .byte $00,$00,$30,$F0,$B0,$F0,$C0,#$00
Step0Line18PF0X0 .byte $00,$00,$40,$10,$A0,$00,$40,#$00
Step0Line17PF0X0 .byte $00,$00,$70,$F0,$B0,$F0,$80,#$00
Step0Line16PF0X0 .byte $00,$00,$20,$30,$E0,$10,$80,#$00
Step0Line15PF0X0 .byte $00,$00,$10,$C0,$10,$E0,$40,#$00
Step0Line14PF0X0 .byte $80,$00,$30,$80,$00,$40,$60,#$00
Step0Line13PF0X0 .byte $80,$00,$30,$C0,$30,$F0,$A0,#$00
Step0Line12PF0X0 .byte $40,$00,$50,$80,$00,$20,$10,#$00
Step0Line11PF0X0 .byte $40,$00,$50,$80,$00,$10,$90,#$00
Step0Line10PF0X0 .byte $80,$00,$30,$F0,$F0,$F0,$A0,#$00
Step0Line9PF0X0 .byte $80,$00,$30,$80,$00,$00,$60,#$00
Step0Line8PF0X0 .byte $80,$00,$20,$00,$00,$00,$20,#$00
Step0Line7PF0X0 .byte $80,$00,$20,$40,$20,$00,$20,#$00
Step0Line6PF0X0 .byte $80,$00,$20,$40,$20,$00,$20,#$00
Step0Line5PF0X0 .byte $80,$00,$20,$40,$20,$00,$20,#$00
Step0Line4PF0X0 .byte $80,$00,$20,$00,$00,$00,$20,#$00
Step0Line3PF0X0 .byte $E0,$00,$10,$80,$00,$00,$70,#$00
Step0Line2PF0X0 .byte $90,$80,$00,$60,$00,$30,$A0,#$00
Step0Line1PF0X0 .byte $90,$80,$00,$10,$F0,$C0,$20,#$00
Step0Line0PF0X0 .byte $60,$00,$00,$00,$00,$00,$10,#$00
; padding
;Step0Line20PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line21PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line22PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line23PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line24PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line25PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line26PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line27PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line28PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line29PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line30PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line31PF0X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00

Step0Line19PF1X0 .byte $FD,$1F,$03,$80,$F0,$BE,$F7,#$00
Step0Line18PF1X0 .byte $85,$10,$02,$40,$08,$A1,$14,#$00
Step0Line17PF1X0 .byte $7D,$0F,$01,$C0,$F8,$BF,$F7,#$00
Step0Line16PF1X0 .byte $47,$08,$01,$80,$90,$F2,$1E,#$00
Step0Line15PF1X0 .byte $B8,$17,$02,$00,$60,$0C,$E1,#$00
Step0Line14PF1X0 .byte $90,$32,$06,$80,$30,$06,$40,#$00
Step0Line13PF1X0 .byte $7C,$2F,$05,$80,$70,$8E,$F1,#$00
Step0Line12PF1X0 .byte $20,$44,$08,$41,$28,$05,$80,#$00
Step0Line11PF1X0 .byte $40,$48,$09,$41,$28,$05,$00,#$00
Step0Line10PF1X0 .byte $7F,$2F,$05,$80,$F0,$FE,$FF,#$00
Step0Line9PF1X0 .byte $80,$30,$06,$80,$30,$06,$00,#$00
Step0Line8PF1X0 .byte $00,$20,$04,$80,$10,$02,$00,#$00
Step0Line7PF1X0 .byte $04,$20,$04,$80,$50,$8A,$11,#$00
Step0Line6PF1X0 .byte $04,$20,$04,$80,$50,$8A,$11,#$00
Step0Line5PF1X0 .byte $04,$20,$04,$80,$50,$8A,$11,#$00
Step0Line4PF1X0 .byte $00,$20,$04,$80,$10,$02,$00,#$00
Step0Line3PF1X0 .byte $80,$F0,$1E,$03,$20,$04,$00,#$00
Step0Line2PF1X0 .byte $60,$2C,$25,$04,$C0,$18,$83,#$00
Step0Line1PF1X0 .byte $1F,$23,$24,$04,$00,$E0,$7C,#$00
Step0Line0PF1X0 .byte $00,$C0,$18,$03,$00,$00,$00,#$00
; padding
;Step0Line20PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line21PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line22PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line23PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line24PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line25PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line26PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line27PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line28PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line29PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line30PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line31PF1X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00

Step0Line19PF2X0 .byte $0F,$7D,$EF,$7E,$F0,$80,$03,#$00
Step0Line18PF2X0 .byte $10,$85,$28,$42,$10,$80,$04,#$00
Step0Line17PF2X0 .byte $1F,$FD,$EF,$7C,$E0,$00,$07,#$00
Step0Line16PF2X0 .byte $09,$4F,$78,$C4,$20,$00,$02,#$00
Step0Line15PF2X0 .byte $06,$30,$87,$3A,$D0,$80,$01,#$00
Step0Line14PF2X0 .byte $0C,$60,$02,$13,$98,$C0,$03,#$00
Step0Line13PF2X0 .byte $0E,$71,$8F,$7D,$E8,$40,$03,#$00
Step0Line12PF2X0 .byte $14,$A0,$01,$08,$44,$20,$05,#$00
Step0Line11PF2X0 .byte $14,$A0,$00,$04,$24,$20,$05,#$00
Step0Line10PF2X0 .byte $0F,$7F,$FF,$FD,$E8,$40,$03,#$00
Step0Line9PF2X0 .byte $0C,$60,$00,$03,$18,$C0,$03,#$00
Step0Line8PF2X0 .byte $08,$40,$00,$01,$08,$40,$02,#$00
Step0Line7PF2X0 .byte $0A,$51,$88,$41,$08,$40,$02,#$00
Step0Line6PF2X0 .byte $0A,$51,$88,$41,$08,$40,$02,#$00
Step0Line5PF2X0 .byte $0A,$51,$88,$41,$08,$40,$02,#$00
Step0Line4PF2X0 .byte $08,$40,$00,$01,$08,$40,$02,#$00
Step0Line3PF2X0 .byte $04,$20,$00,$03,$1E,$F0,$81,#$00
Step0Line2PF2X0 .byte $03,$18,$C1,$0D,$69,$48,$40,#$00
Step0Line1PF2X0 .byte $00,$07,$3E,$F1,$89,$48,$40,#$00
Step0Line0PF2X0 .byte $00,$00,$00,$00,$06,$30,$80,#$00
; padding
;Step0Line20PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line21PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line22PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line23PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line24PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line25PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line26PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line27PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line28PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line29PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line30PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00
;Step0Line31PF2X0 .byte $00,$00,$00,$00,$00,$00,$00,#$00

; la il y aura pb quand on applique le decalage et qu'on est dans le step 0
Step1Line14PF0X0 .byte $40,$00,$70,$80,$00,$10,$D0,#$00
Step1Line15PF0X0 .byte $40,$00,$30,$E0,$10,$F0,$90,#$00
Step1Line16PF0X0 .byte $80,$00,$10,$90,$E0,$10,$E0,#$00
Step1Line17PF0X0 .byte $00,$00,$10,$80,$70,$F0,$80,#$00
Step1Line18PF0X0 .byte $00,$00,$10,$F0,$E0,$00,$40,#$00
Step1Line19PF0X0 .byte $00,$00,$20,$00,$70,$F0,$C0,#$00
Step1Line20PF0X0 .byte $00,$00,$30,$F0,$C0,$00,$00,$00


Step3Line20PF0X0 .byte $00,$00,$00,$00,$70,$F0,$80,$00
Step3Line19PF0X0 .byte $00,$00,$00,$70,$C0,$10,$80,$00
Step3Line18PF0X0 .byte $00,$00,$10,$80,$70,$F0,$80,$00
Step3Line17PF0X0 .byte $00,$00,$10,$F0,$C0,$10,$C0,$00
Step3Line16PF0X0 .byte $80,$00,$10,$90,$E0,$30,$A0,$00
Step3Line15PF0X0 .byte $80,$00,$70,$E0,$10,$E0,$20,$00
Step3Line14PF0X0 .byte $40,$00,$50,$80,$00,$30,$D0,$00
Step3Line13PF0X0 .byte $40,$00,$70,$C0,$30,$F0,$90,$00
Step3Line12PF0X0 .byte $40,$00,$50,$80,$00,$10,$90,$00

Step3Line11PF0X0 .byte $40,$00,$50,$80,$00,$10,$90,$00

Step2Line19PF0X0 .byte $00,$00,$00,$30,$F0,$E0,$00,$00
Step2Line18PF0X0 .byte $00,$00,$00,$50,$80,$20,$00,$00
Step2Line17PF0X0 .byte $00,$00,$00,$70,$F0,$E0,$00,$00
Step2Line16PF0X0 .byte $C0,$00,$00,$50,$C0,$30,$B0,$00
Step2Line15PF0X0 .byte $20,$00,$10,$E0,$30,$F0,$C0,$00



Step2Line14PF0X0 .byte $A0,$10,$F0,$80,$00,$10,$E0,$00
Step2Line13PF0X0 .byte $60,$10,$90,$C0,$30,$F0,$90,$00
Step2Line12PF0X0 .byte $40,$10,$F0,$80,$00,$10,$90,$00
Step2Line11PF0X0 .byte $80,$00,$50,$80,$00,$20,$20,$00

 ; ds $88, 0 

;	ALIGN 256



Step1Line20PF1X0 .byte $03,$00,$00,$80,$F0,$7E,$0F,$00
Step1Line19PF1X0 .byte $FE,$1F,$03,$80,$10,$C2,$F8,#$00
Step1Line18PF1X0 .byte $87,$10,$02,$00,$E0,$FC,$1F,#$00
Step1Line17PF1X0 .byte $7E,$0F,$01,$00,$20,$C4,$F8,#$00
Step1Line16PF1X0 .byte $C7,$38,$07,$00,$20,$E4,$1C,#$00
Step1Line15PF1X0 .byte $78,$4F,$09,$81,$F0,$1E,$E3,#$00
Step1Line14PF1X0 .byte $C0,$58,$0B,$C1,$38,$07,$00,#$00
Step1Line13PF1X0 .byte $7C,$6F,$0D,$C1,$78,$8F,$F1,#$00
;Step1Line12PF1X0 .byte $40,$48,$09,$41,$28,$05,$00,#$00
;Step1Line11PF1X0 .byte $40,$48,$09,$41,$28,$05,$00,#$00

Step1Line20PF2X0 .byte $0F,$7E,$F0,$80,$00,$00,$03,$00
Step1Line19PF2X0 .byte $08,$43,$1F,$FE,$F0,$80,$02,#$00
Step1Line18PF2X0 .byte $07,$3F,$F8,$C2,$10,$80,$01,#$00
Step1Line17PF2X0 .byte $04,$23,$1F,$FC,$E0,$00,$01,#$00
Step1Line16PF2X0 .byte $04,$27,$38,$C7,$38,$C0,$01,#$00
Step1Line15PF2X0 .byte $0F,$78,$C7,$3C,$E4,$20,$03,#$00
Step1Line14PF2X0 .byte $1C,$E0,$00,$06,$34,$A0,$07,#$00
Step1Line13PF2X0 .byte $1E,$F1,$8F,$7D,$EC,$60,$07,#$00
;Step1Line12PF2X0 .byte $14,$A0,$00,$04,$24,$20,$05,#$00
;Step1Line11PF2X0 .byte $14,$A0,$00,$04,$24,$20,$05,#$00

Step2Line19PF1X0 .byte $3F,$07,$00,$00,$80,$F0,$FE,$00
Step2Line18PF1X0 .byte $21,$04,$00,$00,$40,$28,$85,$00
Step2Line17PF1X0 .byte $3F,$07,$00,$00,$C0,$F8,$FF,$00
Step2Line16PF1X0 .byte $63,$6C,$0D,$01,$40,$68,$8D,$00
Step2Line15PF1X0 .byte $FC,$9F,$13,$02,$E0,$9C,$F3,$00
Step2Line14PF1X0 .byte $C0,$B8,$17,$E2,$3C,$07,$00,$00
Step2Line13PF1X0 .byte $7C,$CF,$19,$23,$64,$8C,$F1,$00
Step2Line12PF1X0 .byte $40,$48,$09,$E1,$3C,$07,$00,$00
Step2Line11PF1X0 .byte $20,$24,$04,$40,$28,$05,$80,$00

Step2Line19PF2X0 .byte $01,$0F,$7F,$F8,$C0,$00,$00,$00
Step2Line18PF2X0 .byte $02,$14,$A1,$08,$40,$00,$00,$00
Step2Line17PF2X0 .byte $03,$1F,$FF,$F8,$C0,$00,$00,$00
Step2Line16PF2X0 .byte $02,$16,$B1,$8D,$6C,$60,$00,$00
Step2Line15PF2X0 .byte $07,$39,$CF,$7E,$F2,$90,$81,$00
Step2Line14PF2X0 .byte $3C,$E0,$00,$07,$3A,$D1,$8F,$00
Step2Line13PF2X0 .byte $26,$31,$8F,$7C,$E6,$31,$89,$00
Step2Line12PF2X0 .byte $3C,$E0,$00,$04,$24,$21,$0F,$00
Step2Line11PF2X0 .byte $14,$A0,$01,$09,$48,$40,$05,$00

Step3Line20PF1X0 .byte $7E,$0F,$01,$00,$00,$C0,$F8,$00
Step3Line19PF1X0 .byte $43,$08,$01,$00,$C0,$78,$0F,$00
Step3Line18PF1X0 .byte $7E,$0F,$01,$00,$20,$C4,$F8,$00
Step3Line17PF1X0 .byte $C3,$18,$03,$00,$E0,$7C,$0F,$00
Step3Line16PF1X0 .byte $67,$2C,$05,$00,$20,$E4,$9C,$00
Step3Line15PF1X0 .byte $38,$27,$04,$C0,$F8,$1F,$E3,$00
Step3Line14PF1X0 .byte $E0,$5C,$0B,$41,$28,$05,$80,$00
Step3Line13PF1X0 .byte $7C,$4F,$09,$C1,$78,$8F,$F1,$00
Step3Line12PF1X0 .byte $40,$48,$09,$41,$28,$05,$00,$00
Step3Line11PF1X0 .byte $40,$48,$09,$41,$28,$05,$00,$00

Step3Line20PF2X0 .byte $00,$03,$1F,$FC,$E0,$00,$00,$00
Step3Line19PF2X0 .byte $03,$1E,$F0,$84,$20,$00,$00,$00
Step3Line18PF2X0 .byte $04,$23,$1F,$FC,$E0,$00,$01,$00
Step3Line17PF2X0 .byte $07,$3E,$F0,$86,$30,$80,$01,$00
Step3Line16PF2X0 .byte $04,$27,$39,$CD,$68,$40,$01,$00
Step3Line15PF2X0 .byte $1F,$F8,$C7,$39,$C8,$40,$07,$00
Step3Line14PF2X0 .byte $14,$A0,$01,$0E,$74,$A0,$05,$00
Step3Line13PF2X0 .byte $1E,$F1,$8F,$7C,$E4,$20,$07,$00
Step3Line12PF2X0 .byte $14,$A0,$00,$04,$24,$20,$05,$00
Step3Line11PF2X0 .byte $14,$A0,$00,$04,$24,$20,$05,$00

PositionBombermanSprites
;fonction modulo 20, ajoute 20 si negatif, soustrait 20 si positif
; table de division et modulo 3 pour 21 elements de 0 a 20

; positionner tout directement
; positionnement sprite 1 : visage
;	IF TRUE_XPOS >= -20 && TRUE_XPOS < -14
;X_POS_SELECT_CYCLES_SPRITE equ 0
;SPRITE_START_X equ 159 - 32
;	ENDIF
TRUE_XPOS_POSITIVE_BYTE equ TEMP1

	LDA TRUE_XPOS
        CLC
        ADC #20
        STA TRUE_XPOS_POSITIVE_BYTE
	PHA
	LDA MODE
        AND #BIT_DIRECTION
        BEQ .neTournePasAGaucheLeSprite
        
        LDA TRUE_XPOS_POSITIVE_BYTE
        SEC
        SBC #4
        STA TRUE_XPOS_POSITIVE_BYTE


.neTournePasAGaucheLeSprite

	LDA MODE
        AND #BIT_FACE_ENABLE
        BEQ .afterSettingFace
        LDA TRUE_XPOS_POSITIVE_BYTE
        BMI .negativeLeftCase
        CMP #6
        BCS .sprite1notLockedOnRight
.negativeLeftCase
	LDA #159 - 32
	BCC .setSprite1Position

.sprite1notLockedOnRight

;	IF TRUE_XPOS >= -14 && TRUE_XPOS < -6
;X_POS_SELECT_CYCLES_SPRITE equ (TRUE_XPOS + 7) * 4
;SPRITE_START_X equ 159;
;	ENDIF
	CMP #14
        BCS .sprite1notClippedOnLeft
	CLC
        ADC #-13
        ASL
        ASL
        ADC #158
        BCS .setSprite1Position
        
.sprite1notClippedOnLeft

;	IF TRUE_XPOS >= -6 && TRUE_XPOS < 34
;X_POS_SELECT_CYCLES_SPRITE equ (TRUE_XPOS + 6) * 4
;SPRITE_START_X equ 3
;	ENDIF

	CMP #54
        BCS .sprite1notInMiddleOfScreen

	SEC
        SBC #14
        
        ASL
        ASL
        CLC
        ADC OSCILLATION
        CLC
        ADC OSCILLATION
        CLC ; necessaire quand negatif
        ADC OSCILLATION
	CLC
	ADC #3
        
        BNE .setSprite1Position


.sprite1notInMiddleOfScreen
.sprite1lockedOnLeft
;	IF (TRUE_XPOS >= 34 && TRUE_XPOS < 44)
;X_POS_SELECT_CYCLES_SPRITE equ 0
;SPRITE_START_X equ 159 ; 0
;	ENDIF
	LDA #159
	BNE .setSprite1Position


; positionne les sprites pour le visage
;        LDA #X_POS_SELECT_CYCLES_SPRITE
;        CLC;
;	ADC #SPRITE_START_X
.setSprite1Position
;        LDA #0
	ldx #1
        jsr SetHorizPos
        
        LDX #COLOR_YELLOW
        LDA MODE
        AND #BIT_DAFT_PUNK_ENABLE
        BEQ .setFaceColor
        LDX #2 ; gris fonce
.setFaceColor
        STX COLUP1

.afterSettingFace

	PLA
	STA TRUE_XPOS_POSITIVE_BYTE
	PHA        
; positionnement missile 1 (bras, pied...)
;	IF TRUE_XPOS >= -20 && TRUE_XPOS < -15
;X_POS_SELECT_CYCLES_MISSILE equ 0
;MISSILE1_START_X equ 157
;        ENDIF

	LDA MODE
        AND #BIT_DIRECTION
;        CMP #0
;        BNE .tourneAGaucheLeMissile
	BEQ .processRightSide
        
        LDA TRUE_XPOS_POSITIVE_BYTE
        SEC
        SBC #13
        CLC
        ADC MISSILE1_ADJUSTX        
        STA TRUE_XPOS_POSITIVE_BYTE
 
.processRightSide
	LDA TRUE_XPOS_POSITIVE_BYTE
        BMI .offScreenMissile
        CMP #5
        BCS .missile1NotLockedOnLeft
.offScreenMissile        
        LDA #157
        BCC .setMissile1Position
.missile1NotLockedOnLeft
;	IF TRUE_XPOS >= -15 && TRUE_XPOS < 25
;X_POS_SELECT_CYCLES_MISSILE equ (TRUE_XPOS + 15) * 4
;MISSILE1_START_X equ 1
;	ENDIF

	CMP #45
        BCS .missile1NotInMiddleOfScreen

	CLC
        ADC #-5

	ASL
        ASL
        CLC
        ADC OSCILLATION
        CLC
        ADC OSCILLATION
        CLC ; necessaire quand negatif
        ADC OSCILLATION
        
        CLC
        ADC #1
        BNE .setMissile1Position
        
.missile1NotInMiddleOfScreen
;	IF (TRUE_XPOS >= 25)
;X_POS_SELECT_CYCLES_MISSILE equ 0
;MISSILE1_START_X equ 1 ; 0
;	ENDIF
	LDA #1

.setMissile1Position
        LDX #3
        jsr SetHorizPos

        LDA #0 ;2
        STA ENAM1

	PLA
        STA TRUE_XPOS_POSITIVE_BYTE
        
; prepare le missile et sa couleur en cas de clipping en haut (seulement tourne a droite)
; si step = 0 et ypos = -11 ou -12 alors enable and white
; si step = 1 pareil
; si step = 2 et ypos = -13 enable red
; si step = 2 et ypos = -11 ou -12 alors enable white
; si step = 2 et ypos = -13 ou -14 enable red
; si step = 2 et ypos = -11 ou -12 alors enable white


	LDA MODE
        AND #BIT_DIRECTION
;        CMP #0
        BNE .afterAdjustEnableMissile1
        LDA TRUE_YPOS
        BPL .afterAdjustEnableMissile1
        CLC
        ADC #14
        BMI .afterAdjustEnableMissile1
        CMP #4
        BCS .afterAdjustEnableMissile1
        LDA STEP_ANIM
        ASL
        ASL
        CLC
        ADC #14
        ADC TRUE_YPOS
        TAX
        LDA ClipTopMissilePatch,X
        BEQ .afterAdjustEnableMissile1
        STA COLUP1
        LDA #2
        STA ENAM1
.afterAdjustEnableMissile1
        
        

; positionnement sprite0 (pour cacher le debordement du sprite1)
;	IF (TRUE_XPOS >= 10)
;SPRITE0_X equ 159
;	ELSE
;SPRITE0_X equ 159 - 32
;	ENDIF
	LDA TRUE_XPOS_POSITIVE_BYTE
        CMP #32
        BCC .sprite0NotOnRight
        LDA #159
        BMI .setSprite0Position
.sprite0NotOnRight
	LDA #159 - 32

;        LDA #SPRITE0_X
.setSprite0Position

; pour cacher le visage
;    pha
;	LDA #0
	TAY
        LDX #0
        jsr SetHorizPos
        
        LDA MODE
        AND #BIT_FACE_ENABLE
        BNE .doneSprite0
        TYA
        LDX #1
        jsr SetHorizPos ; put sprite 1 under sprite 0
        LDX #0 ;COLOR_YELLOW
        STX COLUP1
        
        
.doneSprite0

;    pla
;    inx
;    jsr SetHorizPos
	LDA MODE
        AND #(BIT_GHOST_ENABLE)
        BNE .applyGhostMode
        LDX #$FF ; 00 ;FF
        LDA MODE
        AND #BIT_OSCILLATION_RASTER_ENABLE
        BEQ .setSprite0Pattern
        INX
.setSprite0Pattern
        STX GRP0
        LDX #0 ;COLOR_YELLOW
        STX COLUP0
        BEQ .missile0Positioning
.applyGhostMode
        LDX #$00 ; 00 ;FF
        STX GRP0
        LDX #COLOR_YELLOW
        STX COLUP0


.missile0Positioning
; positionnement missile0 (pour cacher a gauche et simuler une colonne caractere)
	LDA #0
        STA ENABL
        STA ENAM0
        LDA MODE 
        AND #BIT_HIDE_SIDES_ENABLE
        BEQ .afterHideSides
	
        LDA MODE
        AND #BIT_GHOST_ENABLE
        BNE .doGhost
        


	JMP .normalMissile0Positioning
; applique le ghost mode (flash missile mobile)
.doGhost
	 LDA FRAME 
         AND #7
         ASL
         ASL
         ASL
         CLC
         ADC #9
         JMP .setMissile0Position

;        IF (TRUE_XPOS < 3)
;MISSILE0_X equ 159 - 8
;	ENDIF
.normalMissile0Positioning
	LDA TRUE_XPOS_POSITIVE_BYTE
        CMP #16
        BCS .notInferior3
        LDA #159-8
        BMI .setMissile0Position
.notInferior3
	LDA TRUE_XPOS
        CMP #2
        BNE .notEqual3
        LDA #154
        BMI .setMissile0Position
.notEqual3        
;        IF (TRUE_XPOS == 3)
;MISSILE0_X equ 154
;	ENDIF
	CMP #3
;	IF (TRUE_XPOS == 4)
;MISSILE0_X equ 157
;	ENDIF
	BNE .notEqual4
        LDA #157
        BMI .setMissile0Position
;	IF (TRUE_XPOS >= 5)
;MISSILE0_X equ ((TRUE_XPOS - 4) * 4) % 160) - 2
;	ENDIF
.notEqual4
	LDA TRUE_XPOS
        CLC
        ADC #-3 ;4
        ASL
        ASL
        CMP #160
        BCC .willbePos
        SEC
        SBC #160
.willbePos
	SEC
        SBC #2
        
.setMissile0Position

	LDX #2
        jsr SetHorizPos
        LDA #2
        STA ENAM0

; positionnement balle (pour cacher a droite et simuler une colonne caractere)
;	IF (TRUE_XPOS <= 22)
;BALLCACHE_X equ 160 - 4 * (22 - TRUE_XPOS)
;	ELSE
;BALLCACHE_X equ 0
;	ENDIF

	LDA TRUE_XPOS_POSITIVE_BYTE
        CMP #43
        BCC .putBallOnRight
        LDA #1
        JMP .setBallPosition
.putBallOnRight
	LDA TRUE_XPOS
        SEC
        SBC #22
        ASL
        ASL
        CLC
        ADC #160
.setBallPosition

;       LDA #BALLCACHE_X
        LDX #4
        jsr SetHorizPos
        LDA #2
        STA ENABL
.afterHideSides


        sta WSYNC
        sta HMOVE ; gotta apply HMOVE
        
        RET_MAGI_CALL

SetHorizPos
        sta WSYNC ; start a new line
        bit 0 ; waste 3 cycles
        sec ; set carry flag
DivideLoop
    sbc #15 ; subtract 15
    bcs DivideLoop ; branch until negative
    eor #7 ; calculate fine offset
    asl
    asl
    asl
    asl
    sta RESP0,x ; fix coarse position
    sta HMP0,x ; set fine offset
    rts ; return to caller


        
        echo "ROM left bank 1: ", ($3ff4 - *)

        org $1FF4
        RORG    $3FF4
        .byte 0,0,0,0,0,0
        org $1FFA
        RORG    $3FFA

        .word 0 ;.Start      ; NMI
        .word .Start      ; RESET
        .word .Start      ; BRK

        ORG     $2000
        RORG    $5000
Bank2   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE


Lose25CyclesX1
	.byte $82
Lose24CyclesX1
	.byte $82
Lose23CyclesX1
	.byte $82
Lose22CyclesX1
	.byte $82
Lose21CyclesX1
	.byte $82
Lose20CyclesX1
	.byte $82
Lose19CyclesX1
	.byte $82
Lose18CyclesX1
	.byte $82
Lose17CyclesX1
	.byte $82
Lose16CyclesX1
        .byte $82 ; Nop imm 2
Lose15CyclesX1
        .byte $44 ; Nop zp 3
Lose14CyclesX1
        .byte $EA ; Nop
Lose12CyclesX1
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen1

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0X1
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLineX1
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLineX1


LoopEmptyLineX1
    pha
    pla
    nop
    nop
EmptyLineX1
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX1
    STX COLUBK

    BCC LoopEmptyLineX1
    RTS

loop_line0X1
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X1,Y
        STX PF0
        LDX Step0Line0PF1X1,Y
        STX PF1
        LDX Step0Line0PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
       
        LDY BACKGROUND_COLOR_LINE_0
        STY COLUBK
        JSR Lose20CyclesX1
        
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line0X1
        rts

loop_line1X1
    NOP
    nop

line1_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X1,Y
        STX PF0
        LDX Step0Line1PF1X1,Y
        STX PF1
        LDX Step0Line1PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK
        JSR Lose12CyclesX1
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK
        bcc loop_line1X1
        RTS

	NOP
loop_line2X1
    NOP3
    nop

line2_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X1,Y
        STX PF0
        LDX Step0Line2PF1X1,Y
        STX PF1
        LDX Step0Line2PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_2

        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK
        LDX #COLOR_WHITE
        STX COLUBK    
        nop
        nop
    	STY COLUBK
	ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line2X1
        RTS

loop_line3X1
    nop3
    nop

line3_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X1,Y
        STX PF0
        LDX Step0Line3PF1X1,Y
        STX PF1
        LDX Step0Line3PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3

        STY COLUBK
        LDX #COLOR_WHITE
        NOP
        NOP3
        STX COLUBK
        NOP
        NOP
        NOP
;        PHA
;        PLA
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_line3X1
        RTS

; haut masque
loop_line4X1
    nop3
    nop

line4_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X1,Y
        STX PF0
        LDX Step0Line4PF1X1,Y
        STX PF1
        LDX Step0Line4PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK - $FE,X
        NOP3
	ADC Y_DIVIDER_ZP
        NOP
        LDX #0
        STX COLUBK

	bcc loop_line4X1
	RTS

	NOP
        NOP
; haut oeil
loop_line5X1
    nop3
    nop

line5_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X1,Y
        STX PF0
        LDX Step0Line5PF1X1,Y
        STX PF1
        LDX Step0Line5PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5

        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP3
        NOP3
        LDX #0
        STX COLUBK

	bcc loop_line5X1
	RTS

	NOP
        NOP
; milieu oeil
loop_line6X1
    nop
    nop

line6_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X1,Y
        STX PF0
        LDX Step0Line6PF1X1,Y
        STX PF1
        LDX Step0Line6PF2X1,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6
        
        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP3
        NOP3
        LDX #0
        STX COLUBK

        bcc loop_line6X1
        RTS

        nop
        nop

; bas oeil
loop_line7X1
    nop3
    nop

line7_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X1,Y
        STX PF0
        LDX Step0Line7PF1X1,Y
        STX PF1
        LDX Step0Line7PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7
        
        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP3
        NOP3
        LDX #0
        STX COLUBK
         
    	bcc loop_line7X1
    	RTS

	NOP
        NOP
; bas masque
loop_line8X1
    nop3
    nop

line8_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X1,Y
        STX PF0
        LDX Step0Line8PF1X1,Y
        STX PF1
        LDX Step0Line8PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK - $FE,X
        NOP3
	ADC Y_DIVIDER_ZP
        NOP
        LDX #0
        STX COLUBK
        
	bcc loop_line8X1
    	RTS

	NOP
        NOP
        NOP
; sous le masque
loop_line9X1
	nop3
        nop

line9_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X1,Y
        STX PF0
        LDX Step0Line9PF1X1,Y
        STX PF1
        LDX Step0Line9PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9
        
        STY COLUBK
        LDX #$00
        STX GRP1
        LDX #COLOR_WHITE
        STX COLUBK
        NOP3
        NOP
        NOP
	ADC Y_DIVIDER_ZP
	STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_line9X1
        RTS

; separation tete corps
loop_line10X1
    nop3
    nop

line10_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X1,Y
        STX PF0
        LDX Step0Line10PF1X1,Y
        STX PF1
        LDX Step0Line10PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        nop
        nop
        NOP
        ADC Y_DIVIDER_ZP
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line10X1
        RTS

	NOP
        NOP
        NOP
; haut du deuxieme bras
loop_line11X1
    nop
    nop

line11_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line11PF0X1,Y
        STX PF0
        LDX Step0Line11PF1X1,Y
        STX PF1
        LDX Step0Line11PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        STX ENAM1
        LDY BACKGROUND_COLOR_LINE_11
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_line11X1
        RTS

	NOP

; juste au dessus de la ceinture
loop_line12X1
    nop3
    nop

line12_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X1,Y
        STX PF0
        LDX Step0Line12PF1X1,Y
        STX PF1
        LDX Step0Line12PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        nop
        STY COLUBK
        ADC Y_DIVIDER_ZP
        nop
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_line12X1
        RTS

	NOP
        
loop_line13X1
        STX ENAM1
        NOP

line13_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X1,Y
        STX PF0
        LDX Step0Line13PF1X1,Y
        STX PF1
        LDX Step0Line13PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        NOP
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line13X1
    	RTS

        nop
        NOP
        NOP

loop_line14X1
    nop3
    nop

line14_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line14PF0X1,Y
        STX PF0
        LDX Step0Line14PF1X1,Y
        STX PF1
        LDX Step0Line14PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        NOP
        LDX #COLOR_RED ;_BYTE
        LDY #COLOR_VEST
        STX COLUBK
        nop
        STY COLUBK    
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_line14X1
        RTS

loop_line15X1
    nop3
    nop

line15_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X1,Y
        STX PF0
        LDX Step0Line15PF1X1,Y
        STX PF1
        LDX Step0Line15PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        ADC Y_DIVIDER_ZP
        STX COLUBK
        STY COLUBK    
        NOP
        NOP
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line15X1
    	RTS


loop_line16X1
    nop
    nop

line16_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X1,Y
        STX PF0
        LDX Step0Line16PF1X1,Y
        STX PF1
        LDX Step0Line16PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_BLACK_BYTE
        STX GRP1
        NOP
        STY COLUBK
        STX COLUBK
        
        bcc loop_line16X1
        RTS


loop_line17X1
    nop3
    nop

line17_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X1,Y
        STX PF0
        LDX Step0Line17PF1X1,Y
        STX PF1
        LDX Step0Line17PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_RED
        STX COLUP1
        JSR Lose12CyclesX1
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line17X1
        RTS

loop_line18X1
    nop3
    nop

line18_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X1,Y
        STX PF0
        LDX Step0Line18PF1X1,Y
        STX PF1
        LDX Step0Line18PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        nop
        STX COLUBK
        STX ENAM1
        STY COLUBK - COLOR_RED,X
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line18X1
        RTS

        NOP
loop_line19X1
    nop3
    nop

line19_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X1,Y
        STX PF0
        LDX Step0Line19PF1X1,Y
        STX PF1
        LDX Step0Line19PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        JSR Lose15CyclesX1
        LDX #0
        STX COLUBK
        bcc loop_line19X1
        RTS

	NOP
        NOP
        
; haut du deuxieme bras
loop_step3line12X1
    nop3
    nop

step3line12_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X1,Y
        STX PF0
        LDX Step3Line12PF1X1,Y
        STX PF1
        LDX Step3Line12PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step3line12X1
        RTS

	ALIGN 64
        nop
loop_step3line13X1
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line13_generatedX1

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X1,Y
        STX PF0
        LDX Step3Line13PF1X1,Y
        STX PF1
        LDX Step3Line13PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDX #0
        STX COLUP1
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        STX COLUBK
        
        bcc loop_step3line13X1
        RTS


;	ALIGN 16
	NOP
        
loop_step3line14X1
	LDX #COLOR_RED
        STX COLUP1

step3line14_generatedX1

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X1,Y
        STX PF0
        LDX Step3Line14PF1X1,Y
        STX PF1
        LDX Step3Line14PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line14X1
        RTS

loop_step3line15X1
        LDX #0
        STX ENAM1

step3line15_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X1,Y
        STX PF0
        LDX Step3Line15PF1X1,Y
        STX PF1
        LDX Step3Line15PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK - COLOR_VEST,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_15
        nop
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_step3line15X1
        RTS

loop_step3line16X1
    nop3
    nop

step3line16_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X1,Y
        STX PF0
        LDX Step3Line16PF1X1,Y
        STX PF1
        LDX Step3Line16PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_WHITE
        STX COLUBK - COLOR_WHITE,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_16
        LDX #0
        STY COLUBK
        nop
        STX COLUBK
        bcc loop_step3line16X1
        RTS

	nop
        nop
loop_step3line17X1
    nop
    nop

step3line17_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X1,Y
        STX PF0
        LDX Step3Line17PF1X1,Y
        STX PF1
        LDX Step3Line17PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        LDY COLOR_BLACK_BYTE
        STX COLUBK
        STY ENAM1 - COLOR_WHITE,X
	LDY BACKGROUND_COLOR_LINE_17
        LDX #0
        STY COLUBK
        nop
        STX COLUBK
        bcc loop_step3line17X1
        RTS


loop_step3line18X1
    nop3 
    nop

step3line18_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X1,Y
        STX PF0
        LDX Step3Line18PF1X1,Y
        STX PF1
        LDX Step3Line18PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        STX COLUBK
        nop
        nop
	LDY BACKGROUND_COLOR_LINE_18
        LDX #0
        STY COLUBK
        nop
        STX COLUBK
        bcc loop_step3line18X1
        RTS

loop_step3line19X1
    nop3
    nop

step3line19_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X1,Y
        STX PF0
        LDX Step3Line19PF1X1,Y
        STX PF1
        LDX Step3Line19PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        STX COLUBK
        nop
	LDY BACKGROUND_COLOR_LINE_19
        LDX #0
        STY COLUBK
        nop
        nop
        STX COLUBK
        bcc loop_step3line19X1
        RTS

loop_step3line20X1
    nop3
    nop

step3line20_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X1,Y
        STX PF0
        LDX Step3Line20PF1X1,Y
        STX PF1
        LDX Step3Line20PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX1
        LDX #0
        STX COLUBK
        bcc loop_step3line20X1
        RTS
    
loop_step1line13X1
    nop3
    nop

step1line13_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X1,Y
        STX PF0
        LDX Step1Line13PF1X1,Y
        STX PF1
        LDX Step1Line13PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y   
        
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        STX COLUBK
        
        bcc loop_step1line13X1
        RTS

; haut du deuxieme bras
loop_step1line14X1
    nop3
    nop

step1line14_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X1,Y
        STX PF0
        LDX Step1Line14PF1X1,Y
        STX PF1
        LDX Step1Line14PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK ;,X
        LDX #0
        STX COLUBK
        
        bcc loop_step1line14X1
        RTS

	ALIGN 16
loop_step1line15X1
    nop3
    nop

step1line15_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X1,Y
        STX PF0
        LDX Step1Line15PF1X1,Y
        STX PF1
        LDX Step1Line15PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_step1line15X1
        RTS

	NOP
        
loop_step1line16X1
    nop3
    nop

step1line16_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X1,Y
        STX PF0
        LDX Step1Line16PF1X1,Y
        STX PF1
        LDX Step1Line16PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        NOP
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STX ENAM1
        nop
        STY COLUBK,X
        nop
        STX COLUBK
        bcc loop_step1line16X1

        RTS

loop_step1line17X1
    nop3
    nop

step1line17_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X1,Y
        STX PF0
        LDX Step1Line17PF1X1,Y
        STX PF1
        LDX Step1Line17PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        PHA 
        PLA
        NOP3
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_step1line17X1
        RTS

	NOP
        NOP
        
loop_step1line18X1
    nop3
    nop

step1line18_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X1,Y
        STX PF0
        LDX Step1Line18PF1X1,Y
        STX PF1
        LDX Step1Line18PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        nop
        nop
        LDX #0
        STX COLUBK

        bcc loop_step1line18X1
        RTS

	NOP
        
loop_step1line19X1
    nop3
    nop

step1line19_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X1,Y
        STX PF0
        LDX Step1Line19PF1X1,Y
        STX PF1
        LDX Step1Line19PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19

        STY COLUBK
        ADC Y_DIVIDER_ZP
        PHA 
        PLA
        NOP3
        LDX #COLOR_RED
        STX COLUBK
        nop
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step1line19X1
        RTS

	NOP
        NOP

loop_step1line20X1
    nop
    nop

step1line20_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X1,Y
        STX PF0
        LDX Step1Line20PF1X1,Y
        STX PF1
        LDX Step1Line20PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX1
        LDX #0
        STX COLUBK
        
        bcc loop_step1line20X1
        RTS

	NOP

; haut du deuxieme bras
loop_step2line11X1
    nop3
    nop

step2line11_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X1,Y
        STX PF0
        LDX Step2Line11PF1X1,Y
        STX PF1
        LDX Step2Line11PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_WHITE
        STX ENAM1
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step2line11X1
        RTS

	NOP

; haut du deuxieme bras
loop_step2line12X1
    nop3
    nop

step2line12_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X1,Y
        STX PF0
        LDX Step2Line12PF1X1,Y
        STX PF1
        LDX Step2Line12PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_12
        nop3
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step2line12X1
        RTS

	NOP
; 2eme main
loop_step2line13X1
    nop3
    nop

step2line13_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X1,Y
        STX PF0
        LDX Step2Line13PF1X1,Y
        STX PF1
        LDX Step2Line13PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        LDY COLOR_BLACK_BYTE
        STX COLUBK
        STY COLUBK

        bcc loop_step2line13X1
        RTS

	NOP
        
loop_step2line14X1
    nop3
    nop

step2line14_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X1,Y
        STX PF0
        LDX Step2Line14PF1X1,Y
        STX PF1
        LDX Step2Line14PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX COLOR_RED_BYTE
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        ADC Y_DIVIDER_ZP
        STY COLUBK
        NOP
        STX COLUBK
        
        bcc loop_step2line14X1
        RTS

	NOP
        NOP
        NOP
        
loop_step2line15X1
    nop
    nop

step2line15_generatedX1

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X1,Y
        STX PF0
        LDX Step2Line15PF1X1,Y
        STX PF1
        LDX Step2Line15PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX COLOR_RED_BYTE
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
        bcc loop_step2line15X1
        RTS

	NOP
        NOP

loop_step2line16X1
    nop3
    nop

step2line16_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X1,Y
        STX PF0
        LDX Step2Line16PF1X1,Y
        STX PF1
        LDX Step2Line16PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        LDX #0
        NOP3
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        
        bcc loop_step2line16X1
        RTS

loop_step2line17X1
    nop3
    nop

step2line17_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X1,Y
        STX PF0
        LDX Step2Line17PF1X1,Y
        STX PF1
        LDX Step2Line17PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX1
        LDX #0
        STX COLUBK
        
        bcc loop_step2line17X1
        RTS

	DS 10,0
loop_step2line18X1
    nop3
    nop

step2line18_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X1,Y
        STX PF0
        LDX Step2Line18PF1X1,Y
        STX PF1
        LDX Step2Line18PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        LDX #0
        NOP3
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line18X1
        RTS
        
loop_step2line19X1
    nop3
    nop

step2line19_generatedX1
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X1,Y
        STX PF0
        LDX Step2Line19PF1X1,Y
        STX PF1
        LDX Step2Line19PF2X1,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX1
        LDX #0
        STX COLUBK
        
        bcc loop_step2line19X1
        RTS


	ALIGN 8
Step0Line0PF0X1 .byte $C0,$00,$00,$00,$00,$00,$30,#$00
Step0Line0PF1X1 .byte $00,$60,$0C,$01,$00,$00,$00,#$00
Step0Line0PF2X1 .byte $00,$00,$00,$01,$0C,$60,$00,#$00
Step0Line1PF0X1 .byte $20,$00,$00,$30,$F0,$80,$40,#$00
Step0Line1PF1X1 .byte $8F,$91,$12,$02,$80,$F0,$3E,#$00
Step0Line1PF2X1 .byte $01,$0F,$7C,$E2,$12,$90,$80,#$00
Step0Line2PF0X1 .byte $20,$00,$10,$C0,$00,$60,$40,#$00
Step0Line2PF1X1 .byte $B0,$96,$12,$02,$60,$0C,$C1,#$00
Step0Line2PF2X1 .byte $06,$30,$83,$1A,$D2,$90,$81,#$00
Step0Line3PF0X1 .byte $C0,$00,$20,$00,$00,$10,$F0,#$00
Step0Line3PF1X1 .byte $C0,$78,$0F,$81,$10,$02,$00,#$00
Step0Line3PF2X1 .byte $08,$40,$00,$07,$3C,$E0,$02,#$00
Step0Line4PF0X1 .byte $00,$00,$40,$00,$00,$00,$40,#$00
Step0Line4PF1X1 .byte $80,$10,$02,$40,$08,$01,$00,#$00
Step0Line4PF2X1 .byte $10,$80,$00,$02,$10,$80,$04,#$00
Step0Line5PF0X1 .byte $00,$00,$50,$80,$40,$00,$40,#$00
Step0Line5PF1X1 .byte $82,$10,$02,$40,$28,$45,$08,#$00
Step0Line5PF2X1 .byte $14,$A2,$10,$82,$10,$80,$05,#$00
Step0Line6PF0X1 .byte $00,$00,$50,$80,$40,$00,$40,#$00
Step0Line6PF1X1 .byte $82,$10,$02,$40,$28,$45,$08,#$00
Step0Line6PF2X1 .byte $14,$A2,$10,$82,$10,$80,$05,#$00
Step0Line7PF0X1 .byte $00,$00,$50,$80,$40,$00,$40,#$00
Step0Line7PF1X1 .byte $82,$10,$02,$40,$28,$45,$08,#$00
Step0Line7PF2X1 .byte $14,$A2,$10,$82,$10,$80,$05,#$00
Step0Line8PF0X1 .byte $00,$00,$40,$00,$00,$00,$40,#$00
Step0Line8PF1X1 .byte $80,$10,$02,$40,$08,$01,$00,#$00
Step0Line8PF2X1 .byte $10,$80,$00,$02,$10,$80,$04,#$00
Step0Line9PF0X1 .byte $00,$00,$60,$00,$00,$10,$C0,#$00
Step0Line9PF1X1 .byte $C0,$18,$03,$C0,$18,$03,$00,#$00
Step0Line9PF2X1 .byte $18,$C0,$00,$06,$30,$80,$06,#$00
Step0Line10PF0X1 .byte $00,$00,$70,$F0,$F0,$E0,$40,#$00
Step0Line10PF1X1 .byte $BF,$17,$02,$C0,$F8,$FF,$FF,#$00
Step0Line10PF2X1 .byte $1F,$FF,$FF,$FA,$D0,$80,$07,#$00
Step0Line11PF0X1 .byte $80,$10,$A0,$00,$00,$20,$20,#$00
Step0Line11PF1X1 .byte $20,$24,$04,$A0,$14,$02,$80,#$00
Step0Line11PF2X1 .byte $28,$40,$01,$09,$48,$41,$0A,#$00
Step0Line12PF0X1 .byte $80,$10,$A0,$00,$00,$40,$20,#$00
Step0Line12PF1X1 .byte $10,$22,$04,$A0,$14,$02,$40,#$00
Step0Line12PF2X1 .byte $28,$40,$02,$11,$88,$41,$0A,#$00
Step0Line13PF0X1 .byte $00,$00,$70,$80,$70,$E0,$40,#$00
Step0Line13PF1X1 .byte $BE,$17,$02,$C0,$38,$C7,$F8,#$00
Step0Line13PF2X1 .byte $1C,$E3,$1F,$FA,$D0,$80,$07,#$00
Step0Line14PF0X1 .byte $00,$00,$60,$00,$10,$90,$C0,#$00
Step0Line14PF1X1 .byte $C8,$19,$03,$C0,$18,$03,$20,#$00
Step0Line14PF2X1 .byte $18,$C0,$04,$26,$30,$80,$06,#$00
Step0Line15PF0X1 .byte $00,$00,$30,$80,$30,$D0,$80,#$00
Step0Line15PF1X1 .byte $5C,$0B,$01,$80,$30,$86,$70,#$00
Step0Line15PF2X1 .byte $0C,$61,$0E,$74,$A0,$00,$03,#$00
Step0Line16PF0X1 .byte $00,$00,$40,$70,$C0,$20,$00,#$00
Step0Line16PF1X1 .byte $23,$04,$00,$40,$C8,$79,$8F,#$00
Step0Line16PF2X1 .byte $13,$9E,$F1,$88,$40,$00,$04,#$00
Step0Line17PF0X1 .byte $00,$10,$F0,$E0,$70,$E0,$00,#$00
Step0Line17PF1X1 .byte $3E,$07,$00,$E0,$FC,$DF,$FB,#$00
Step0Line17PF2X1 .byte $3F,$FB,$DF,$F8,$C0,$01,$0F,#$00
Step0Line18PF0X1 .byte $00,$10,$80,$20,$40,$10,$80,#$00
Step0Line18PF1X1 .byte $42,$08,$01,$20,$84,$50,$0A,#$00
Step0Line18PF2X1 .byte $21,$0A,$50,$84,$20,$01,$08,#$00
Step0Line19PF0X1 .byte $00,$00,$70,$E0,$70,$F0,$80,#$00
Step0Line19PF1X1 .byte $7E,$0F,$01,$C0,$F8,$DF,$FB,#$00
Step0Line19PF2X1 .byte $1F,$FB,$DF,$FC,$E0,$00,$07,#$00

Step1Line11PF0X1 .byte $80,$10,$A0,$00,$00,$20,$20,#$00
Step1Line11PF1X1 .byte $20,$24,$04,$A0,$14,$02,$80,#$00
Step1Line11PF2X1 .byte $28,$40,$01,$09,$48,$41,$0A,#$00
Step1Line12PF0X1 .byte $80,$10,$A0,$00,$00,$20,$20,#$00
Step1Line12PF1X1 .byte $20,$24,$04,$A0,$14,$02,$80,#$00
Step1Line12PF2X1 .byte $28,$40,$01,$09,$48,$41,$0A,#$00
Step1Line13PF0X1 .byte $80,$10,$F0,$80,$70,$E0,$60,#$00
Step1Line13PF1X1 .byte $BE,$37,$06,$E0,$3C,$C7,$F8,#$00
Step1Line13PF2X1 .byte $3C,$E3,$1F,$FB,$D8,$C1,$0F,#$00
Step1Line14PF0X1 .byte $80,$10,$E0,$00,$00,$30,$A0,#$00
Step1Line14PF1X1 .byte $60,$2C,$05,$E0,$1C,$03,$80,#$00
Step1Line14PF2X1 .byte $38,$C0,$01,$0D,$68,$41,$0E,#$00
Step1Line15PF0X1 .byte $80,$00,$70,$C0,$30,$E0,$20,#$00
Step1Line15PF1X1 .byte $3C,$27,$04,$C0,$78,$8F,$F1,#$00
Step1Line15PF2X1 .byte $1E,$F1,$8F,$79,$C8,$40,$07,#$00
Step1Line16PF0X1 .byte $00,$00,$20,$30,$C0,$30,$C0,#$00
Step1Line16PF1X1 .byte $E3,$1C,$03,$80,$90,$72,$8E,#$00
Step1Line16PF2X1 .byte $09,$4E,$71,$8E,$70,$80,$02,#$00
Step1Line17PF0X1 .byte $00,$00,$20,$10,$F0,$E0,$00,#$00
Step1Line17PF1X1 .byte $3F,$07,$00,$80,$10,$E2,$FC,#$00
Step1Line17PF2X1 .byte $08,$47,$3F,$F8,$C0,$00,$02,#$00
Step1Line18PF0X1 .byte $00,$00,$30,$F0,$C0,$10,$80,#$00
Step1Line18PF1X1 .byte $43,$08,$01,$80,$F0,$7E,$0F,#$00
Step1Line18PF2X1 .byte $0F,$7E,$F0,$84,$20,$00,$03,#$00
Step1Line19PF0X1 .byte $00,$00,$40,$10,$F0,$F0,$80,#$00
Step1Line19PF1X1 .byte $7F,$0F,$01,$40,$08,$E1,$FC,#$00
Step1Line19PF2X1 .byte $10,$87,$3F,$FC,$E0,$00,$04,#$00
Step1Line20PF0X1 .byte $00,$00,$70,$F0,$80,$00,$00,#$00
Step1Line20PF1X1 .byte $01,$00,$00,$C0,$F8,$3F,$07,#$00
Step1Line20PF2X1 .byte $1F,$FC,$E0,$00,$00,$00,$07,#$00

Step2Line11PF0X1 .byte $00,$10,$A0,$00,$00,$40,$40,#$00
Step2Line11PF1X1 .byte $90,$12,$02,$A0,$14,$02,$40,#$00
Step2Line11PF2X1 .byte $28,$40,$02,$12,$90,$81,$0A,#$00
Step2Line12PF0X1 .byte $80,$30,$E0,$00,$00,$20,$20,#$00
Step2Line12PF1X1 .byte $20,$24,$84,$F0,$1E,$03,$80,#$00
Step2Line12PF2X1 .byte $78,$C0,$01,$09,$48,$43,$1E,#$00
Step2Line13PF0X1 .byte $C0,$20,$30,$80,$70,$E0,$30,#$00
Step2Line13PF1X1 .byte $3E,$67,$8C,$91,$32,$C6,$F8,#$00
Step2Line13PF2X1 .byte $4C,$63,$1F,$F9,$CC,$62,$13,#$00
Step2Line14PF0X1 .byte $40,$30,$E0,$00,$00,$30,$D0,#$00
Step2Line14PF1X1 .byte $E0,$5C,$8B,$F1,$1E,$03,$80,#$00
Step2Line14PF2X1 .byte $78,$C0,$01,$0E,$74,$A3,$1E,#$00
Step2Line15PF0X1 .byte $40,$00,$30,$C0,$70,$F0,$90,#$00
Step2Line15PF1X1 .byte $7E,$4F,$09,$81,$70,$CE,$F9,#$00
Step2Line15PF2X1 .byte $0E,$73,$9F,$FC,$E4,$20,$03,#$00
Step2Line16PF0X1 .byte $80,$00,$10,$B0,$80,$60,$60,#$00
Step2Line16PF1X1 .byte $B1,$36,$06,$00,$A0,$34,$C6,#$00
Step2Line16PF2X1 .byte $05,$2C,$63,$1B,$D8,$C0,$01,#$00
Step2Line17PF0X1 .byte $00,$00,$10,$F0,$F0,$C0,$00,#$00
Step2Line17PF1X1 .byte $1F,$03,$00,$00,$E0,$FC,$7F,#$00
Step2Line17PF2X1 .byte $07,$3F,$FE,$F0,$80,$00,$01,#$00
Step2Line18PF0X1 .byte $00,$00,$10,$A0,$00,$40,$00,#$00
Step2Line18PF1X1 .byte $10,$02,$00,$00,$A0,$14,$42,#$00
Step2Line18PF2X1 .byte $05,$28,$42,$10,$80,$00,$01,#$00
Step2Line19PF0X1 .byte $00,$00,$00,$70,$F0,$C0,$00,#$00
Step2Line19PF1X1 .byte $1F,$03,$00,$00,$C0,$F8,$7F,#$00
Step2Line19PF2X1 .byte $03,$1F,$FE,$F0,$80,$00,$00,#$00

Step3Line11PF0X1 .byte $80,$10,$A0,$00,$00,$20,$20,#$00
Step3Line11PF1X1 .byte $20,$24,$04,$A0,$14,$02,$80,#$00
Step3Line11PF2X1 .byte $28,$40,$01,$09,$48,$41,$0A,#$00
Step3Line12PF0X1 .byte $80,$10,$A0,$00,$00,$20,$20,#$00
Step3Line12PF1X1 .byte $20,$24,$04,$A0,$14,$02,$80,#$00
Step3Line12PF2X1 .byte $28,$40,$01,$09,$48,$41,$0A,#$00
Step3Line13PF0X1 .byte $80,$10,$F0,$80,$70,$E0,$20,#$00
Step3Line13PF1X1 .byte $3E,$27,$04,$E0,$3C,$C7,$F8,#$00
Step3Line13PF2X1 .byte $3C,$E3,$1F,$F9,$C8,$41,$0F,#$00
Step3Line14PF0X1 .byte $80,$10,$A0,$00,$00,$70,$A0,#$00
Step3Line14PF1X1 .byte $70,$2E,$05,$A0,$14,$02,$C0,#$00
Step3Line14PF2X1 .byte $28,$40,$03,$1D,$E8,$41,$0A,#$00
Step3Line15PF0X1 .byte $00,$10,$F0,$C0,$30,$C0,$40,#$00
Step3Line15PF1X1 .byte $9C,$13,$02,$E0,$7C,$8F,$71,#$00
Step3Line15PF2X1 .byte $3E,$F1,$8E,$72,$90,$81,$0F,#$00
Step3Line16PF0X1 .byte $00,$00,$20,$30,$C0,$60,$40,#$00
Step3Line16PF1X1 .byte $B3,$16,$02,$80,$90,$72,$CE,#$00
Step3Line16PF2X1 .byte $09,$4E,$73,$9A,$D0,$80,$02,#$00
Step3Line17PF0X1 .byte $00,$00,$30,$F0,$80,$30,$80,#$00
Step3Line17PF1X1 .byte $61,$0C,$01,$80,$F0,$3E,$87,#$00
Step3Line17PF2X1 .byte $0F,$7C,$E1,$0C,$60,$00,$03,#$00
Step3Line18PF0X1 .byte $00,$00,$20,$10,$F0,$E0,$00,#$00
Step3Line18PF1X1 .byte $3F,$07,$00,$80,$10,$E2,$FC,#$00
Step3Line18PF2X1 .byte $08,$47,$3F,$F8,$C0,$00,$02,#$00
Step3Line19PF0X1 .byte $00,$00,$10,$F0,$80,$20,$00,#$00
Step3Line19PF1X1 .byte $21,$04,$00,$00,$E0,$3C,$87,#$00
Step3Line19PF2X1 .byte $07,$3C,$E1,$08,$40,$00,$01,#$00
Step3Line20PF0X1 .byte $00,$00,$00,$10,$F0,$E0,$00,#$00
Step3Line20PF1X1 .byte $3F,$07,$00,$00,$00,$E0,$FC,#$00
Step3Line20PF2X1 .byte $00,$07,$3F,$F8,$C0,$00,$00,#$00

	IF ANIMATE_TEXT_BANK1
leftMaskVals .byte #$00,#$80,#$C0,#$E0,#$F0,#$F8,#$FC,#$FE
	.byte #$FF

rightMaskVals .byte #$00,#$01,#$03,#$07,#$0F,#$1F,#$3F,#$7F,#$FF

AnimateText2Bank1

        LDA ToDisplay
        cmp #1
        beq .DoDisappear
; temp = t - t0
        sec             ; set carry for borrow purpose
        lda EightFramesCounter + 1
        sbc #<T0          ; perform subtraction on the LSBs
        sta temp

        ldy #0
.loopAnimate

	lda temp
        bmi .isInf0

        cmp #8
        bpl .isSupEqual8
        
        tax ; between 0 and 7
        lda leftMaskVals,x
        sta Masks,y
        jmp .nextAnimate
        
.isInf0        
        lda leftMaskVals
        sta Masks,y
        jmp .nextAnimate
        
.isSupEqual8
        lda leftMaskVals+8
        sta Masks,y
.nextAnimate

; t - t0 - dt
        sec             ; set carry for borrow purpose
        lda temp
        sbc #DT          ; perform subtraction on the LSBs
        sta temp
        
        iny
        cpy #8
        bne .loopAnimate
        
        LDA Masks+7
        cmp #$FF
        bne .finAnimText
        LDA #1
        STA ToDisplay
.finAnimText
        RET_MAGI_CALL

.DoDisappear
; t - t1
        sec             ; set carry for borrow purpose
        lda EightFramesCounter + 1
        sbc TextFrameT1Goal ;#<T1          ; perform subtraction on the LSBs
        sta temp
        
        ldy #0
; * 8 / 64 -> /8        
.loopAnimate2
        lda temp
        sec
        sbc #8
        eor #$FF
        clc
        adc #1
        bmi .isInf02
        cmp #8
        bpl .isSupEqual82
        tax
        lda rightMaskVals,x
        sta Masks,y
        jmp .nextAnimate2
.isInf02        
        lda rightMaskVals
        sta Masks,y
        jmp .nextAnimate2
.isSupEqual82
        lda rightMaskVals+8
        sta Masks,y
.nextAnimate2
; t - t0 - dt
        sec             ; set carry for borrow purpose
        lda temp
        sbc #DT          ; perform subtraction on the LSBs
        sta temp
        
        iny
        cpy #8
        bne .loopAnimate2
.finAnimText2
        RET_MAGI_CALL
	ENDIF




        echo "ROM left bank 2: ", ($5FEB - *)
        org  $2FEB
        RORG $5FEB
;endKernelRaster
	BANK_SWITCH 7,realEndKernelRaster
;	JMP realEndKernelRaster

        org $2FF4
        RORG    $5FF4
        .byte 0,0,0,0,0,0
        org $2FFA
        RORG    $5FFA

        .word 0 ;.Start      ; NMI

        .word $5000      ; RESET
        .word $5000      ; BRK

        ORG     $3000
        RORG    $7000
Bank3   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE

Lose25CyclesX2
	.byte $82
Lose24CyclesX2
	.byte $82
Lose23CyclesX2
	.byte $82
Lose22CyclesX2
	.byte $82
Lose21CyclesX2
	.byte $82
Lose20CyclesX2
	.byte $82
Lose19CyclesX2
	.byte $82
Lose18CyclesX2
	.byte $82
Lose17CyclesX2
	.byte $82
Lose16CyclesX2
        .byte $82 ; Nop imm 2
Lose15CyclesX2
        .byte $44 ; Nop zp 3
Lose14CyclesX2
        .byte $EA ; Nop
Lose12CyclesX2
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen2

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0X2
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLineX2
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLineX2


LoopEmptyLineX2
    pha
    pla
    nop
    nop
EmptyLineX2
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX2
    STX COLUBK

    BCC LoopEmptyLineX2
    RTS


loop_line0X2
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X2,Y
        STX PF0
        LDX Step0Line0PF1X2,Y
        STX PF1
        LDX Step0Line0PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_0
        
        STY COLUBK
        JSR Lose20CyclesX2
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK
        
        bcc loop_line0X2
        rts

loop_line1X2
    NOP
    nop

line1_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X2,Y
        STX PF0
        LDX Step0Line1PF1X2,Y
        STX PF1
        LDX Step0Line1PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        pha
        pla
        nop
        nop
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK
        
        bcc loop_line1X2
        RTS

loop_line2X2
    NOP3
    nop

line2_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X2,Y
;        LDX #0
;        NOP
        STX PF0
        LDX Step0Line2PF1X2,Y
;        LDX #0
;        NOP
        STX PF1
        LDX Step0Line2PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_2
        
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        LDX #COLOR_WHITE
        STX COLUBK
	ADC Y_DIVIDER_ZP
    	STY COLUBK - COLOR_WHITE,X
        nop
	LDX #0
        STX COLUBK
        
        bcc loop_line2X2
        RTS

	NOP
        
loop_line3X2
    nop3
    nop

line3_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X2,Y
        STX PF0
        LDX Step0Line3PF1X2,Y
        STX PF1
        LDX Step0Line3PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        NOP
        PHA
        PLA
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line3X2
        RTS

	NOP
        NOP
; haut masque
loop_line4X2
    nop3
    nop

line4_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X2,Y
        STX PF0
        LDX Step0Line4PF1X2,Y
        STX PF1
        LDX Step0Line4PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK - $FE,X
        NOP3
	ADC Y_DIVIDER_ZP
        NOP
        LDX #0
        STX COLUBK
        
	bcc loop_line4X2
	RTS

        nop
        nop
; haut oeil
loop_line5X2
    nop3
    nop

line5_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X2,Y
        STX PF0
        LDX Step0Line5PF1X2,Y
        STX PF1
        LDX Step0Line5PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5
        
        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        LDX #0
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP
        NOP
        NOP
        NOP
        STX COLUBK
        
	bcc loop_line5X2
	RTS

        nop
	NOP
        NOP
; milieu oeil
loop_line6X2
    nop
    nop

line6_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X2,Y
        STX PF0
        LDX Step0Line6PF1X2,Y
        STX PF1
        LDX Step0Line6PF2X2,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6
        
        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        LDX #0
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP
        NOP
        NOP
        NOP
        STX COLUBK
        
        bcc loop_line6X2
        RTS

        nop
	nop
        nop
        
; bas oeil
loop_line7X2
    nop3
    nop

line7_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X2,Y
        STX PF0
        LDX Step0Line7PF1X2,Y
        STX PF1
        LDX Step0Line7PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7
        
        STY COLUBK
        LDX COLOR_FF_BYTE
        STX GRP1
        STX COLUBK
        LDX #0
	STY COLUBK
	ADC Y_DIVIDER_ZP
        NOP
        NOP
        NOP
        NOP
        STX COLUBK
         
    	bcc loop_line7X2
    	RTS

        nop
	nop
        nop
; bas masque
loop_line8X2
    nop3
    nop

line8_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X2,Y
        STX PF0
        LDX Step0Line8PF1X2,Y
        STX PF1
        LDX Step0Line8PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        STX GRP1
        STX COLUBK
        NOP
	STY COLUBK - $FE,X
        NOP3
	ADC Y_DIVIDER_ZP
        NOP
        LDX #0
        STX COLUBK
        
	bcc loop_line8X2
    	RTS

	NOP
        NOP
        NOP
; sous le masque
loop_line9X2
	nop3
        nop

line9_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X2,Y
        STX PF0
        LDX Step0Line9PF1X2,Y
        STX PF1
        LDX Step0Line9PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9
        
    	STY COLUBK
    	ADC Y_DIVIDER_ZP
    	LDX #COLOR_WHITE
        LDY #0
	STX COLUBK
        STY GRP1
        LDY BACKGROUND_COLOR_LINE_9
    	nop
        NOP
    	STY COLUBK
        LDX #0
    	STX COLUBK

        bcc loop_line9X2
        RTS

; separation tete corps
loop_line10X2
    nop3
    nop

line10_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X2,Y
        STX PF0
        LDX Step0Line10PF1X2,Y
        STX PF1
        LDX Step0Line10PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10

        STY COLUBK
        LDX #COLOR_WHITE
        nop
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        NOP
        NOP
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_line10X2
        RTS

	NOP
        NOP
        NOP
        
; haut du deuxieme bras
loop_line11X2
    nop
    nop

line11_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line11PF0X2,Y
        STX PF0
        LDX Step0Line11PF1X2,Y
        STX PF1
        LDX Step0Line11PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        STX ENAM1
        LDY BACKGROUND_COLOR_LINE_11
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_line11X2
        RTS

	NOP
; juste au dessus de la ceinture
loop_line12X2
    nop3
    nop

line12_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X2,Y
        STX PF0
        LDX Step0Line12PF1X2,Y
        STX PF1
        LDX Step0Line12PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        STY COLUBK
        nop
        nop
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_line12X2
        RTS

	NOP
loop_line13X2
    nop3
    nop

line13_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X2,Y
        STX PF0
        LDX Step0Line13PF1X2,Y
        STX PF1
        LDX Step0Line13PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX #0
        STY COLUBK
        STX COLUBK
        
	bcc loop_line13X2
    	RTS

	NOP
        NOP

loop_line14X2
    nop3
    nop

line14_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line14PF0X2,Y
        STX PF0
        LDX Step0Line14PF1X2,Y
        STX PF1
        LDX Step0Line14PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY #COLOR_VEST
        NOP
        STX COLUBK ;- COLOR_VEST,Y
;        nop
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line14X2
        RTS

	NOP
        
loop_line15X2
    nop3
    nop

line15_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X2,Y
        STX PF0
        LDX Step0Line15PF1X2,Y
        STX PF1
        LDX Step0Line15PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY COLOR_VEST_BYTE
        STX COLUBK - COLOR_VEST,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK
	bcc loop_line15X2
    	RTS

	NOP
        NOP
loop_line16X2
    nop
    nop

line16_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X2,Y
        STX PF0
        LDX Step0Line16PF1X2,Y
        STX PF1
        LDX Step0Line16PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_BLACK_BYTE
        STX GRP1
        NOP
        STY COLUBK
        STX COLUBK
        bcc loop_line16X2
        
        RTS


loop_line17X2
    nop3
    nop

line17_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X2,Y
        STX PF0
        LDX Step0Line17PF1X2,Y
        STX PF1
        LDX Step0Line17PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_RED
        STX COLUP1
        JSR Lose12CyclesX2
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line17X2
        RTS

loop_line18X2
    nop3
    nop

line18_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X2,Y
        STX PF0
        LDX Step0Line18PF1X2,Y
        STX PF1
        LDX Step0Line18PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
	ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX ENAM1
        STX COLUBK
        NOP3
        STY COLUBK
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line18X2
        RTS

loop_line19X2
    nop3
    nop

line19_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X2,Y
        STX PF0
        LDX Step0Line19PF1X2,Y
        STX PF1
        LDX Step0Line19PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        JSR Lose15CyclesX2
        LDX #0
        STX COLUBK
        bcc loop_line19X2
        RTS

	NOP
        NOP
        
; haut du deuxieme bras
loop_step3line12X2
    nop3
    nop

step3line12_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X2,Y
        STX PF0
        LDX Step3Line12PF1X2,Y
        STX PF1
        LDX Step3Line12PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_12
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_step3line12X2
        RTS


	ALIGN 64
        nop
loop_step3line13X2
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line13_generatedX2

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X2,Y
        STX PF0
        LDX Step3Line13PF1X2,Y
        STX PF1
        LDX Step3Line13PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDX #0
        STX COLUP1
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        STX COLUBK
        
        bcc loop_step3line13X2
        RTS

	NOP
;	ALIGN 32
loop_step3line14X2
	LDX #COLOR_RED
        STX COLUP1

step3line14_generatedX2

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X2,Y
        STX PF0
        LDX Step3Line14PF1X2,Y
        STX PF1
        LDX Step3Line14PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_step3line14X2
        RTS

loop_step3line15X2
        LDX #0
        STX ENAM1

step3line15_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X2,Y
        STX PF0
        LDX Step3Line15PF1X2,Y
        STX PF1
        LDX Step3Line15PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY #COLOR_VEST
        STX COLUBK - COLOR_VEST,Y
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_15
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK
        bcc loop_step3line15X2
        RTS

	NOP
        
loop_step3line16X2
    nop3
    nop

step3line16_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X2,Y
        STX PF0
        LDX Step3Line16PF1X2,Y
        STX PF1
        LDX Step3Line16PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        STY COLUBK
        LDX COLOR_RED_BYTE
        LDY #COLOR_WHITE
        STX COLUBK - COLOR_WHITE,Y
        STY COLUBK
        ADC Y_DIVIDER_ZP
	LDY BACKGROUND_COLOR_LINE_16
        LDX #0
        STY COLUBK
        NOP
        STX COLUBK
        bcc loop_step3line16X2
        RTS

	NOP
        NOP
loop_step3line17X2
    nop
    nop

step3line17_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X2,Y
        STX PF0
        LDX Step3Line17PF1X2,Y
        STX PF1
        LDX Step3Line17PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        STX COLUBK
        nop3
        STY COLUBK
        LDX #0
        STX ENAM1
        NOP
        STX COLUBK
        
        bcc loop_step3line17X2
        RTS


loop_step3line18X2
    nop3
    nop

step3line18_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X2,Y
        STX PF0
        LDX Step3Line18PF1X2,Y
        STX PF1
        LDX Step3Line18PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        nop
        nop
	NOP3
        STX COLUBK
        nop
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step3line18X2
        RTS

loop_step3line19X2
    nop3
    nop

step3line19_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X2,Y
        STX PF0
        LDX Step3Line19PF1X2,Y
        STX PF1
        LDX Step3Line19PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        STX COLUBK
        nop
        nop
        STY COLUBK
	nop3
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step3line19X2
        RTS

loop_step3line20X2
    nop3
    nop

step3line20_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X2,Y
        STX PF0
        LDX Step3Line20PF1X2,Y
        STX PF1
        LDX Step3Line20PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX2
        LDX #0
        STX COLUBK
        bcc loop_step3line20X2
        RTS
    
loop_step1line13X2
    nop3
    nop

step1line13_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X2,Y
        STX PF0
        LDX Step1Line13PF1X2,Y
        STX PF1
        LDX Step1Line13PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        LDY BACKGROUND_COLOR_LINE_13
        STY COLUBK
        STX COLUBK
        
        bcc loop_step1line13X2
        RTS

; haut du deuxieme bras
loop_step1line14X2
    nop3
    nop

step1line14_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X2,Y
        STX PF0
        LDX Step1Line14PF1X2,Y
        STX PF1
        LDX Step1Line14PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step1line14X2
        RTS

	ALIGN 16
loop_step1line15X2
    nop3
    nop

step1line15_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X2,Y
        STX PF0
        LDX Step1Line15PF1X2,Y
        STX PF1
        LDX Step1Line15PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_RED
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        ADC Y_DIVIDER_ZP
        nop3
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step1line15X2
        RTS

	NOP
loop_step1line16X2
    nop3
    nop

step1line16_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X2,Y
        STX PF0
        LDX Step1Line16PF1X2,Y
        STX PF1
        LDX Step1Line16PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        NOP
        NOP
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STX ENAM1
        nop
        STY COLUBK,X
        nop
        STX COLUBK

        bcc loop_step1line16X2
        RTS

loop_step1line17X2
    nop3
    nop

step1line17_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X2,Y
        STX PF0
        LDX Step1Line17PF1X2,Y
        STX PF1
        LDX Step1Line17PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        NOP3
        NOP
        nop
        LDX #COLOR_WHITE
        STX COLUBK
        nop
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_step1line17X2
        RTS

loop_step1line18X2
    nop3
    nop

step1line18_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X2,Y
        STX PF0
        LDX Step1Line18PF1X2,Y
        STX PF1
        LDX Step1Line18PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line18X2
        RTS

	NOP
loop_step1line19X2
    nop3
    nop

step1line19_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X2,Y
        STX PF0
        LDX Step1Line19PF1X2,Y
        STX PF1
        LDX Step1Line19PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        nop
        nop
        nop
        nop
        STX COLUBK
        nop
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step1line19X2
        RTS

	NOP
loop_step1line20X2
    nop
    nop

step1line20_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X2,Y
        STX PF0
        LDX Step1Line20PF1X2,Y
        STX PF1
        LDX Step1Line20PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX2
        LDX #0
        STX COLUBK
        
        bcc loop_step1line20X2
        RTS

; haut du deuxieme bras
loop_step2line11X2
	LDX #2
        STX ENAM1
        
step2line11_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X2,Y
        STX PF0
        LDX Step2Line11PF1X2,Y
        STX PF1
        LDX Step2Line11PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        LDY #COLOR_VEST
        STX COLUBK - COLOR_VEST,Y
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_11
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK
        
        bcc loop_step2line11X2
        RTS

	NOP
        NOP
        NOP

; haut du deuxieme bras
loop_step2line12X2
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line12_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X2,Y
        STX PF0
        LDX Step2Line12PF1X2,Y
        STX PF1
        LDX Step2Line12PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_VEST
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        ADC Y_DIVIDER_ZP
        LDY BACKGROUND_COLOR_LINE_12
        nop3
        STY COLUBK ;- COLOR_WHITE,X
        LDX #0
        STX COLUBK
        
        bcc loop_step2line12X2
        RTS

	NOP
; 2eme main
loop_step2line13X2
    nop3
    nop

step2line13_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X2,Y
        STX PF0
        LDX Step2Line13PF1X2,Y
        STX PF1
        LDX Step2Line13PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_WHITE
        LDY #COLOR_BELT
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #COLOR_RED
        STX COLUP1
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_RED,X
        LDX #0
        STX COLUBK
        
        bcc loop_step2line13X2
        RTS

	NOP
loop_step2line14X2
    nop3
    nop

step2line14_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X2,Y
        STX PF0
        LDX Step2Line14PF1X2,Y
        STX PF1
        LDX Step2Line14PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX COLOR_RED_BYTE
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        STY COLUBK
        NOP
        STX COLUBK
        
        bcc loop_step2line14X2
        RTS

	NOP
        NOP
        NOP

loop_step2line15X2
    nop
    nop

step2line15_generatedX2

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X2,Y
        STX PF0
        LDX Step2Line15PF1X2,Y
        STX PF1
        LDX Step2Line15PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_RED_BYTE
        STX COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK
        bcc loop_step2line15X2
        RTS

	NOP
        NOP

loop_step2line16X2
    nop3
    nop

step2line16_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X2,Y
        STX PF0
        LDX Step2Line16PF1X2,Y
        STX PF1
        LDX Step2Line16PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        LDX #0
        NOP3
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        
        bcc loop_step2line16X2
        RTS

loop_step2line17X2
    nop3
    nop

step2line17_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X2,Y
        STX PF0
        LDX Step2Line17PF1X2,Y
        STX PF1
        LDX Step2Line17PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP
        NOP3
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line17X2
        RTS
        
loop_step2line18X2
    nop3 
    nop

step2line18_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X2,Y
        STX PF0
        LDX Step2Line18PF1X2,Y
        STX PF1
        LDX Step2Line18PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        NOP3
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP3
        STX COLUBK
        bcc loop_step2line18X2
        RTS
        
loop_step2line19X2
    nop3 
    nop

step2line19_generatedX2
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X2,Y
        STX PF0
        LDX Step2Line19PF1X2,Y
        STX PF1
        LDX Step2Line19PF2X2,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX2
        LDX #0
        STX COLUBK
        bcc loop_step2line19X2
        RTS

	ALIGN 8
Step0Line0PF0X2 .byte $80,$00,$00,$00,$00,$00,#$00,#$00
Step0Line0PF1X2 .byte $80,$30,$06,$00,$00,$00,#$00,#$00
Step0Line0PF2X2 .byte $00,$00,$00,$03,$18,$C0,#$00,#$00
Step0Line1PF0X2 .byte $40,$00,$00,$70,$E0,$10,#$00,#$00
Step0Line1PF1X2 .byte $47,$48,$09,$01,$C0,$F8,#$00,#$00
Step0Line1PF2X2 .byte $03,$1F,$F8,$C4,$24,$20,#$00,#$00
Step0Line2PF0X2 .byte $40,$00,$30,$80,$10,$D0,#$00,#$00
Step0Line2PF1X2 .byte $58,$4B,$09,$81,$30,$06,#$00,#$00
Step0Line2PF2X2 .byte $0C,$60,$06,$34,$A4,$20,#$00,#$00
Step0Line3PF0X2 .byte $80,$00,$40,$00,$00,$30,#$00,#$00
Step0Line3PF1X2 .byte $E0,$3C,$07,$40,$08,$01,#$00,#$00
Step0Line3PF2X2 .byte $10,$80,$01,$0F,$78,$C0,#$00,#$00
Step0Line4PF0X2 .byte $00,$10,$80,$00,$00,$10,#$00,#$00
Step0Line4PF1X2 .byte $40,$08,$01,$20,$04,$00,#$00,#$00
Step0Line4PF2X2 .byte $20,$00,$00,$04,$20,$01,#$00,#$00
Step0Line5PF0X2 .byte $00,$10,$A0,$10,$80,$10,#$00,#$00
Step0Line5PF1X2 .byte $41,$08,$01,$A0,$14,$22,#$00,#$00
Step0Line5PF2X2 .byte $28,$44,$20,$04,$20,$01,#$00,#$00
Step0Line6PF0X2 .byte $00,$10,$A0,$10,$80,$10,#$00,#$00
Step0Line6PF1X2 .byte $41,$08,$01,$A0,$14,$22,#$00,#$00
Step0Line6PF2X2 .byte $28,$44,$20,$04,$20,$01,#$00,#$00
Step0Line7PF0X2 .byte $00,$10,$A0,$10,$80,$10,#$00,#$00
Step0Line7PF1X2 .byte $41,$08,$01,$A0,$14,$22,#$00,#$00
Step0Line7PF2X2 .byte $28,$44,$20,$04,$20,$01,#$00,#$00
Step0Line8PF0X2 .byte $00,$10,$80,$00,$00,$10,#$00,#$00
Step0Line8PF1X2 .byte $40,$08,$01,$20,$04,$00,#$00,#$00
Step0Line8PF2X2 .byte $20,$00,$00,$04,$20,$01,#$00,#$00
Step0Line9PF0X2 .byte $00,$10,$C0,$00,$00,$30,#$00,#$00
Step0Line9PF1X2 .byte $60,$0C,$01,$60,$0C,$01,#$00,#$00
Step0Line9PF2X2 .byte $30,$80,$01,$0C,$60,$01,#$00,#$00
Step0Line10PF0X2 .byte $00,$10,$F0,$F0,$F0,$D0,#$00,#$00
Step0Line10PF1X2 .byte $5F,$0B,$01,$E0,$FC,$FF,#$00,#$00
Step0Line10PF2X2 .byte $3F,$FF,$FE,$F4,$A0,$01,#$00,#$00
Step0Line11PF0X2 .byte $00,$20,$40,$00,$00,$40,#$00,#$00
Step0Line11PF1X2 .byte $90,$12,$82,$50,$0A,$01,#$00,#$00
Step0Line11PF2X2 .byte $50,$80,$02,$12,$90,$82,#$00,#$00
Step0Line12PF0X2 .byte $00,$20,$40,$00,$10,$80,#$00,#$00
Step0Line12PF1X2 .byte $88,$11,$82,$50,$0A,$01,#$00,#$00
Step0Line12PF2X2 .byte $50,$80,$04,$22,$10,$82,#$00,#$00
Step0Line13PF0X2 .byte $00,$10,$E0,$10,$F0,$D0,#$00,#$00
Step0Line13PF1X2 .byte $5F,$0B,$01,$E0,$1C,$E3,#$00,#$00
Step0Line13PF2X2 .byte $38,$C7,$3E,$F4,$A0,$01,#$00,#$00
Step0Line14PF0X2 .byte $00,$10,$C0,$00,$20,$30,#$00,#$00
Step0Line14PF1X2 .byte $64,$0C,$01,$60,$0C,$81,#$00,#$00
Step0Line14PF2X2 .byte $30,$81,$09,$4C,$60,$01,#$00,#$00
Step0Line15PF0X2 .byte $00,$00,$60,$00,$70,$A0,#$00,#$00
Step0Line15PF1X2 .byte $2E,$05,$00,$C0,$18,$C3,#$00,#$00
Step0Line15PF2X2 .byte $18,$C3,$1D,$E8,$40,$00,#$00,#$00
Step0Line16PF0X2 .byte $00,$10,$90,$F0,$80,$40,#$00,#$00
Step0Line16PF1X2 .byte $11,$02,$00,$20,$E4,$3C,#$00,#$00
Step0Line16PF2X2 .byte $27,$3C,$E2,$10,$80,$01,#$00,#$00
Step0Line17PF0X2 .byte $00,$30,$F0,$D0,$F0,$C0,#$00,#$00
Step0Line17PF1X2 .byte $1F,$03,$80,$F0,$7E,$EF,#$00,#$00
Step0Line17PF2X2 .byte $7E,$F7,$BE,$F0,$80,$03,#$00,#$00
Step0Line18PF0X2 .byte $00,$20,$00,$50,$80,$20,#$00,#$00
Step0Line18PF1X2 .byte $21,$04,$80,$10,$42,$28,#$00,#$00
Step0Line18PF2X2 .byte $42,$14,$A1,$08,$40,$02,#$00,#$00
Step0Line19PF0X2 .byte $00,$10,$F0,$D0,$F0,$E0,#$00,#$00
Step0Line19PF1X2 .byte $3F,$07,$00,$E0,$7C,$EF,#$00,#$00
Step0Line19PF2X2 .byte $3E,$F7,$BF,$F8,$C0,$01,#$00,#$00

Step1Line11PF0X2 .byte $00,$20,$40,$00,$00,$40,#$00,#$00
Step1Line11PF1X2 .byte $90,$12,$82,$50,$0A,$01,#$00,#$00
Step1Line11PF2X2 .byte $50,$80,$02,$12,$90,$82,#$00,#$00
Step1Line12PF0X2 .byte $00,$20,$40,$00,$00,$40,#$00,#$00
Step1Line12PF1X2 .byte $90,$12,$82,$50,$0A,$01,#$00,#$00
Step1Line12PF2X2 .byte $50,$80,$02,$12,$90,$82,#$00,#$00
Step1Line13PF0X2 .byte $00,$30,$E0,$10,$F0,$D0,#$00,#$00
Step1Line13PF1X2 .byte $DF,$1B,$83,$F0,$1E,$E3,#$00,#$00
Step1Line13PF2X2 .byte $78,$C7,$3E,$F6,$B0,$83,#$00,#$00
Step1Line14PF0X2 .byte $00,$30,$C0,$00,$00,$60,#$00,#$00
Step1Line14PF1X2 .byte $B0,$16,$82,$70,$0E,$01,#$00,#$00
Step1Line14PF2X2 .byte $70,$80,$03,$1A,$D0,$83,#$00,#$00
Step1Line15PF0X2 .byte $00,$10,$F0,$80,$70,$C0,#$00,#$00
Step1Line15PF1X2 .byte $9E,$13,$02,$E0,$3C,$C7,#$00,#$00
Step1Line15PF2X2 .byte $3C,$E3,$1E,$F2,$90,$81,#$00,#$00
Step1Line16PF0X2 .byte $00,$00,$40,$70,$80,$70,#$00,#$00
Step1Line16PF1X2 .byte $71,$0E,$01,$40,$C8,$39,#$00,#$00
Step1Line16PF2X2 .byte $13,$9C,$E3,$1C,$E0,$00,#$00,#$00
Step1Line17PF0X2 .byte $00,$00,$40,$30,$F0,$C0,#$00,#$00
Step1Line17PF1X2 .byte $1F,$03,$00,$40,$88,$F1,#$00,#$00
Step1Line17PF2X2 .byte $11,$8F,$7E,$F0,$80,$00,#$00,#$00
Step1Line18PF0X2 .byte $00,$00,$70,$F0,$80,$20,#$00,#$00
Step1Line18PF1X2 .byte $21,$04,$00,$C0,$F8,$3F,#$00,#$00
Step1Line18PF2X2 .byte $1F,$FC,$E1,$08,$40,$00,#$00,#$00
Step1Line19PF0X2 .byte $00,$10,$80,$30,$F0,$E0,#$00,#$00
Step1Line19PF1X2 .byte $3F,$07,$00,$20,$84,$F0,#$00,#$00
Step1Line19PF2X2 .byte $21,$0F,$7F,$F8,$C0,$01,#$00,#$00
Step1Line20PF0X2 .byte $00,$10,$F0,$E0,$00,$00,#$00,#$00
Step1Line20PF1X2 .byte $00,$00,$00,$E0,$FC,$1F,#$00,#$00
Step1Line20PF2X2 .byte $3F,$F8,$C0,$00,$00,$01,#$00,#$00

Step2Line11PF0X2 .byte $00,$20,$40,$00,$10,$90,#$00,#$00
Step2Line11PF1X2 .byte $48,$09,$81,$50,$0A,$01,#$00,#$00
Step2Line11PF2X2 .byte $50,$80,$04,$24,$20,$02,#$00,#$00
Step2Line12PF0X2 .byte $00,$70,$C0,$00,$00,$40,#$00,#$00
Step2Line12PF1X2 .byte $90,$12,$C2,$78,$0F,$01,#$00,#$00
Step2Line12PF2X2 .byte $F0,$80,$02,$12,$90,$87,#$00,#$00
Step2Line13PF0X2 .byte $80,$40,$60,$10,$F0,$C0,#$00,#$00
Step2Line13PF1X2 .byte $9F,$33,$46,$C8,$19,$E3,#$00,#$00
Step2Line13PF2X2 .byte $98,$C7,$3E,$F3,$98,$C4,#$00,#$00
Step2Line14PF0X2 .byte $80,$70,$C0,$00,$00,$70,#$00,#$00
Step2Line14PF1X2 .byte $70,$2E,$C5,$78,$0F,$01,#$00,#$00
Step2Line14PF2X2 .byte $F0,$80,$03,$1D,$E8,$47,#$00,#$00
Step2Line15PF0X2 .byte $80,$00,$70,$90,$F0,$E0,#$00,#$00
Step2Line15PF1X2 .byte $3F,$27,$04,$C0,$38,$E7,#$00,#$00
Step2Line15PF2X2 .byte $1C,$E7,$3F,$F9,$C8,$40,#$00,#$00
Step2Line16PF0X2 .byte $00,$00,$20,$60,$10,$D0,#$00,#$00
Step2Line16PF1X2 .byte $D8,$1B,$03,$80,$D0,$1A,#$00,#$00
Step2Line16PF2X2 .byte $0B,$58,$C6,$36,$B0,$80,#$00,#$00
Step2Line17PF0X2 .byte $00,$00,$30,$F0,$F0,$80,#$00,#$00
Step2Line17PF1X2 .byte $0F,$01,$00,$80,$F0,$FE,#$00,#$00
Step2Line17PF2X2 .byte $0F,$7F,$FC,$E0,$00,$00,#$00,#$00
Step2Line18PF0X2 .byte $00,$00,$20,$40,$10,$80,#$00,#$00
Step2Line18PF1X2 .byte $08,$01,$00,$80,$50,$0A,#$00,#$00
Step2Line18PF2X2 .byte $0A,$50,$84,$20,$00,$00,#$00,#$00
Step2Line19PF0X2 .byte $00,$00,$10,$F0,$F0,$80,#$00,#$00
Step2Line19PF1X2 .byte $0F,$01,$00,$00,$E0,$FC,#$00,#$00
Step2Line19PF2X2 .byte $07,$3F,$FC,$E0,$00,$00,#$00,#$00

Step3Line11PF0X2 .byte $00,$20,$40,$00,$00,$40,#$00,#$00
Step3Line11PF1X2 .byte $90,$12,$82,$50,$0A,$01,#$00,#$00
Step3Line11PF2X2 .byte $50,$80,$02,$12,$90,$82,#$00,#$00
Step3Line12PF0X2 .byte $00,$20,$40,$00,$00,$40,#$00,#$00
Step3Line12PF1X2 .byte $90,$12,$82,$50,$0A,$01,#$00,#$00
Step3Line12PF2X2 .byte $50,$80,$02,$12,$90,$82,#$00,#$00
Step3Line13PF0X2 .byte $00,$30,$E0,$10,$F0,$C0,#$00,#$00
Step3Line13PF1X2 .byte $9F,$13,$82,$F0,$1E,$E3,#$00,#$00
Step3Line13PF2X2 .byte $78,$C7,$3E,$F2,$90,$83,#$00,#$00
Step3Line14PF0X2 .byte $00,$20,$40,$00,$10,$E0,#$00,#$00
Step3Line14PF1X2 .byte $B8,$17,$82,$50,$0A,$01,#$00,#$00
Step3Line14PF2X2 .byte $50,$80,$07,$3A,$D0,$82,#$00,#$00
Step3Line15PF0X2 .byte $00,$30,$F0,$80,$70,$90,#$00,#$00
Step3Line15PF1X2 .byte $4E,$09,$81,$F0,$3E,$C7,#$00,#$00
Step3Line15PF2X2 .byte $7C,$E3,$1C,$E4,$20,$03,#$00,#$00
Step3Line16PF0X2 .byte $00,$00,$40,$70,$90,$D0,#$00,#$00
Step3Line16PF1X2 .byte $59,$0B,$01,$40,$C8,$39,#$00,#$00
Step3Line16PF2X2 .byte $13,$9C,$E6,$34,$A0,$00,#$00,#$00
Step3Line17PF0X2 .byte $00,$00,$70,$E0,$00,$60,#$00,#$00
Step3Line17PF1X2 .byte $30,$06,$00,$C0,$F8,$1F,#$00,#$00
Step3Line17PF2X2 .byte $1F,$F8,$C3,$18,$C0,$00,#$00,#$00
Step3Line18PF0X2 .byte $00,$00,$40,$30,$F0,$C0,#$00,#$00
Step3Line18PF1X2 .byte $1F,$03,$00,$40,$88,$F1,#$00,#$00
Step3Line18PF2X2 .byte $11,$8F,$7E,$F0,$80,$00,#$00,#$00
Step3Line19PF0X2 .byte $00,$00,$30,$E0,$00,$40,#$00,#$00
Step3Line19PF1X2 .byte $10,$02,$00,$80,$F0,$1E,#$00,#$00
Step3Line19PF2X2 .byte $0F,$78,$C2,$10,$80,$00,#$00,#$00
Step3Line20PF0X2 .byte $00,$00,$00,$30,$F0,$C0,#$00,#$00
Step3Line20PF1X2 .byte $1F,$03,$00,$00,$80,$F0,#$00,#$00
Step3Line20PF2X2 .byte $01,$0F,$7E,$F0,$80,$00,#$00,#$00

	ALIGN 256
	.byte 0
BombermanPF0 .byte $60,$70,$F0,$F0,$00,$00,$F0,$00,$40,$40,$40,$60,$C0,$00,$F0,$00,$F0,$00,$10,$30,$30,$30,$10,0,0
BombermanPF1 .byte $40,$80,$00,$80,$40,$20,$91,$51,$51,$51,$51,$51,$51,$91,$20,$40,$80,$00,$00,$00,$00,$00,$00,0,0
BombermanPF2 .byte $32,$F4,$F8,$FC,$02,$01,$FC,$02,$12,$12,$12,$32,$1A,$04,$F9,$02,$FC,$80,$C0,$E0,$E0,$E0,$C0,0,0
BombermanLeftPF0 .byte $60,$70,$F0,$F0,$00,$00,$F0,$00,$20,$20,$20,$60,$C0,$00,$F0,$00,$F0,$00,$10,$30,$30,$30,$10,0,0
BombermanLeftPF1 .byte $40,$80,$00,$80,$40,$20,$91,$51,$51,$51,$51,$51,$51,$91,$20,$40,$80,$00,$00,$00,$00,$00,$00,0,0
BombermanLeftPF2 .byte $32,$F4,$F8,$FC,$02,$01,$FC,$02,$0A,$0A,$2A,$1E,$02,$04,$F9,$02,$FC,$80,$C0,$E0,$E0,$E0,$C0,0,0
BombermanRightPF0 .byte $60,$70,$F0,$F0,$00,$00,$F0,$00,$80,$80,$A0,$C0,$00,$00,$F0,$00,$F0,$00,$10,$30,$30,$30,$10,0,0
BombermanRightPF1 .byte $40,$80,$00,$80,$40,$20,$91,$51,$51,$51,$51,$D1,$51,$91,$20,$40,$80,$00,$00,$00,$00,$00,$00,0,0
BombermanRightPF2 .byte $32,$F4,$F8,$FC,$02,$01,$FC,$02,$22,$22,$22,$32,$1A,$04,$F9,$02,$FC,$80,$C0,$E0,$E0,$E0,$C0,0,0

        echo "ROM left bank 3: ", ($7fEB - *)
        org  $3FEB
        RORG $7FEB
;endKernelRaster
	BANK_SWITCH 7,realEndKernelRaster


        org $3FF4
        RORG    $7FF4
        .byte 0,0,0,0,0,0
        org $3FFA
        RORG    $7FFA

        .word 0          ; NMI
        .word $7000      ; RESET
        .word $7000      ; BRK

        ORG     $4000
        RORG    $9000
Bank4   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE

Lose25CyclesX3
	.byte $82
Lose24CyclesX3
	.byte $82
Lose23CyclesX3
	.byte $82
Lose22CyclesX3
	.byte $82
Lose21CyclesX3
	.byte $82
Lose20CyclesX3
	.byte $82
Lose19CyclesX3
	.byte $82
Lose18CyclesX3
	.byte $82
Lose17CyclesX3
	.byte $82
Lose16CyclesX3
        .byte $82 ; Nop imm 2
Lose15CyclesX3
        .byte $44 ; Nop zp 3
Lose14CyclesX3
        .byte $EA ; Nop
Lose12CyclesX3
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen3

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0X3
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLineX3
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLineX3


LoopEmptyLineX3
    pha
    pla
    nop
    nop
EmptyLineX3
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX3
    STX COLUBK

    BCC LoopEmptyLineX3
    RTS

        ;;ALIGN_LINE_ROUTINE 1,loop_line0,"loop_line0"

loop_line0X3
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X3,Y
        STX PF0
        LDX Step0Line0PF1X3,Y
        STX PF1
        LDX Step0Line0PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
       
        LDY BACKGROUND_COLOR_LINE_0
        STY COLUBK
        JSR Lose20CyclesX3
        
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line0X3
        rts

        ;;ALIGN_LINE_ROUTINE 1,loop_line1,"loop_line1"
loop_line1X3
    NOP
    nop

line1_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X3,Y
        STX PF0
        LDX Step0Line1PF1X3,Y
        STX PF1
        LDX Step0Line1PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        JSR Lose15CyclesX3
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUBK
	LDX #0
        STX COLUBK
        bcc loop_line1X3
        RTS

	NOP
        NOP
        NOP
        ;ALIGN_LINE_ROUTINE 1,loop_line2,"loop_line2"
loop_line2X3
    NOP3
    nop

line2_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X3,Y
        STX PF0
        LDX Step0Line2PF1X3,Y
        STX PF1
        LDX Step0Line2PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_2

	STY COLUBK
        ADC Y_DIVIDER_ZP
	NOP
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        NOP3
        LDX #COLOR_RED
        STY COLUBK
        STX COLUBK
	LDX #0
        STX COLUBK
        
        bcc loop_line2X3
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line3,"loop_line3"
loop_line3X3
    nop3
    nop

line3_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X3,Y
        STX PF0
        LDX Step0Line3PF1X3,Y
        STX PF1
        LDX Step0Line3PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3

	STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        JSR Lose12CyclesX3
        STY COLUBK
	LDX #0
        STX COLUBK

	bcc loop_line3X3
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line4,"loop_line4"
        NOP
        NOP
        NOP
; haut masque
loop_line4X3
    nop3
    nop

line4_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X3,Y
        STX PF0
        LDX Step0Line4PF1X3,Y
        STX PF1
        LDX Step0Line4PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        NOP
        STX COLUBK
        NOP3
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line4X3
	RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line5,"loop_line5"
; haut oeil
loop_line5X3
    nop3
    nop

line5_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X3,Y
        STX PF0
        LDX Step0Line5PF1X3,Y
        STX PF1
        LDX Step0Line5PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        NOP3
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line5X3
	RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line6,"loop_line6"

	NOP
; milieu oeil
loop_line6X3
    nop
    nop

line6_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X3,Y
        STX PF0
        LDX Step0Line6PF1X3,Y
        STX PF1
        LDX Step0Line6PF2X3,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        NOP3
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line6X3
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line7,"loop_line7"

	NOP
; bas oeil
loop_line7X3
    nop3
    nop

line7_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X3,Y
        STX PF0
        LDX Step0Line7PF1X3,Y
        STX PF1
        LDX Step0Line7PF2X3,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7

	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        NOP3
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK
         
    	bcc loop_line7X3
    	RTS

        nop
        ;ALIGN_LINE_ROUTINE 1,loop_line8,"loop_line8"
; bas masque
loop_line8X3
    nop3
    nop

line8_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X3,Y
        STX PF0
        LDX Step0Line8PF1X3,Y
        STX PF1
        LDX Step0Line8PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        STX GRP1
	STY COLUBK
        NOP
        STX COLUBK

	bcc loop_line8X3
    	RTS

	NOP
        ;ALIGN_LINE_ROUTINE 1,loop_line9,"loop_line9"
; sous le masque
loop_line9X3
	nop3
        nop

line9_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X3,Y
        STX PF0
        LDX Step0Line9PF1X3,Y
        STX PF1
        LDX Step0Line9PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9

	STY COLUBK
        nop
    	LDX COLOR_WHITE_BYTE
	STX COLUBK
    	ADC Y_DIVIDER_ZP
        NOP
        NOP
	nop
    	nop
    	STY COLUBK
        LDX COLOR_BLACK_BYTE
    	STX COLUBK
        bcc loop_line9X3
        RTS

	nop
        nop
        nop
; separation tete corps
loop_line10X3
    nop3
    nop

line10_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X3,Y
        STX PF0
        LDX Step0Line10PF1X3,Y
        STX PF1
        LDX Step0Line10PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        STX ENAM1
        nop3
        ADC Y_DIVIDER_ZP
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_line10X3
        RTS


	nop
        nop
; haut du deuxieme bras
loop_line11X3
    nop
    nop

line11_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line11PF0X3,Y
        STX PF0
        LDX Step0Line11PF1X3,Y
        STX PF1
        LDX Step0Line11PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11

	STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        LDX #COLOR_WHITE
        NOP
        NOP
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_line11X3
        RTS

	NOP

; juste au dessus de la ceinture
loop_line12X3
    nop3
    nop

line12_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X3,Y
        STX PF0
        LDX Step0Line12PF1X3,Y
        STX PF1
        LDX Step0Line12PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
	STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        LDX #COLOR_WHITE
        NOP3
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK

	bcc loop_line12X3
        RTS

	NOP
loop_line13X3
    nop3
    nop

line13_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X3,Y
        STX PF0
        LDX Step0Line13PF1X3,Y
        STX PF1
        LDX Step0Line13PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        ADC Y_DIVIDER_ZP
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line13X3
    	RTS

	NOP
        NOP
loop_line14X3
    nop3
    nop

line14_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line14PF0X3,Y
        STX PF0
        LDX Step0Line14PF1X3,Y
        STX PF1
        LDX Step0Line14PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX COLOR_VEST_BYTE
        LDY #COLOR_RED
        STX COLUBK
        nop3
        ADC Y_DIVIDER_ZP
        STY COLUBK    
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line14X3
        RTS

loop_line15X3
    nop3
    nop

line15_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X3,Y
        STX PF0
        LDX Step0Line15PF1X3,Y
        STX PF1
        LDX Step0Line15PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX COLOR_VEST_BYTE
        LDY #COLOR_RED
        STX COLUBK
        nop
        ADC Y_DIVIDER_ZP
        STY COLUBK    
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
	bcc loop_line15X3
    	RTS


	NOP
loop_line16X3
    nop
    nop

line16_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X3,Y
        STX PF0
        LDX Step0Line16PF1X3,Y
        STX PF1
        LDX Step0Line16PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX #COLOR_WHITE
        nop
        STX COLUBK
        nop
        nop
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STY COLUBK
        NOP
        LDX #0
        STX COLUBK

        bcc loop_line16X3
        RTS

	NOP
loop_line17X3
    nop3
    nop

line17_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X3,Y
        STX PF0
        LDX Step0Line17PF1X3,Y
        STX PF1
        LDX Step0Line17PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        JSR Lose17CyclesX3
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line17X3
        RTS

	NOP
        NOP
        NOP
        NOP
        
loop_line18X3
    nop3
    nop

line18_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X3,Y
        STX PF0
        LDX Step0Line18PF1X3,Y
        STX PF1
        LDX Step0Line18PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_RED,X
        STX COLUBK
        nop
        nop
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        bcc loop_line18X3
        RTS

	NOP
        NOP
        
loop_line19X3
    nop3
    nop

line19_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X3,Y
        STX PF0
        LDX Step0Line19PF1X3,Y
        STX PF1
        LDX Step0Line19PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX3
        LDX #0
        STX COLUBK
        bcc loop_line19X3
        RTS

	NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        
; haut du deuxieme bras
loop_step3line12X3
    nop3
    nop

step3line12_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X3,Y
        STX PF0
        LDX Step3Line12PF1X3,Y
        STX PF1
        LDX Step3Line12PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop3
        nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line12X3
        RTS


	ALIGN 64
        nop
loop_step3line13X3
    nop3
    nop

step3line13_generatedX3

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X3,Y
        STX PF0
        LDX Step3Line13PF1X3,Y
        STX PF1
        LDX Step3Line13PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

	STY COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line13X3
        RTS

;	ALIGN 32
loop_step3line14X3
	LDX #COLOR_RED
        STX COLUP1

step3line14_generatedX3

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X3,Y
        STX PF0
        LDX Step3Line14PF1X3,Y
        STX PF1
        LDX Step3Line14PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop3
        nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line14X3
        RTS

loop_step3line15X3
        LDX #0
        STX ENAM1

step3line15_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X3,Y
        STX PF0
        LDX Step3Line15PF1X3,Y
        STX PF1
        LDX Step3Line15PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop
        nop
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line15X3
        RTS

loop_step3line16X3
    nop3
    nop

step3line16_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X3,Y
        STX PF0
        LDX Step3Line16PF1X3,Y
        STX PF1
        LDX Step3Line16PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #COLOR_RED
        NOP
        NOP3
        NOP
        STX COLUBK
        STY COLUBK; - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line16X3
        RTS

;	nop
loop_step3line17X3
    nop3
    nop

step3line17_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X3,Y
        STX PF0
        LDX Step3Line17PF1X3,Y
        STX PF1
        LDX Step3Line17PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17

        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        LDX #0
        STX COLUBK

        bcc loop_step3line17X3
        RTS

	NOP

loop_step3line18X3
    nop3
    nop

step3line18_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X3,Y
        STX PF0
        LDX Step3Line18PF1X3,Y
        STX PF1
        LDX Step3Line18PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        STX COLUBK
        NOP
        STY COLUBK
        PHA
        PLA
        NOP3
        LDX #0
        STX COLUBK

        bcc loop_step3line18X3
        RTS

	NOP
        NOP

loop_step3line19X3
    nop3
    nop

step3line19_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X3,Y
        STX PF0
        LDX Step3Line19PF1X3,Y
        STX PF1
        LDX Step3Line19PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19

	STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
	NOP3
        STY COLUBK
        nop3
        LDX #0
        STX COLUBK
        
        bcc loop_step3line19X3
        RTS


loop_step3line20X3
    nop3
    nop

step3line20_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X3,Y
        STX PF0
        LDX Step3Line20PF1X3,Y
        STX PF1
        LDX Step3Line20PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX3
        LDX #0
        STX COLUBK
        bcc loop_step3line20X3
        RTS
    
loop_step1line13X3
    nop3
    nop

step1line13_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X3,Y
        STX PF0
        LDX Step1Line13PF1X3,Y
        STX PF1
        LDX Step1Line13PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        nop
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step1line13X3
        RTS

; haut du deuxieme bras
loop_step1line14X3
        nop3
	nop

step1line14_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X3,Y
        STX PF0
        LDX Step1Line14PF1X3,Y
        STX PF1
        LDX Step1Line14PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #0
        STX ENAM1
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        STX COLUBK
        LDX #0
        STY COLUBK 
        STX COLUBK

        bcc loop_step1line14X3
        RTS

	ALIGN 16
loop_step1line15X3
    nop3
    nop

step1line15_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X3,Y
        STX PF0
        LDX Step1Line15PF1X3,Y
        STX PF1
        LDX Step1Line15PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop3
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK 
        STX COLUBK

	bcc loop_step1line15X3
        RTS

	NOP
loop_step1line16X3
    nop3
    nop

step1line16_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X3,Y
        STX PF0
        LDX Step1Line16PF1X3,Y
        STX PF1
        LDX Step1Line16PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        NOP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #0
        STX ENAM1
        STY COLUBK,X
        nop
        nop
        STX COLUBK
        
        bcc loop_step1line16X3
        RTS


loop_step1line17X3
    nop3
    nop

step1line17_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X3,Y
        STX PF0
        LDX Step1Line17PF1X3,Y
        STX PF1
        LDX Step1Line17PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        NOP
        STY COLUBK
	NOP3
        NOP
        nop
        LDX #0
        nop
        STX COLUBK
        
        bcc loop_step1line17X3
        RTS

	NOP
loop_step1line18X3
    nop3
    nop

step1line18_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X3,Y
        STX PF0
        LDX Step1Line18PF1X3,Y
        STX PF1
        LDX Step1Line18PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        nop3
        nop
        STX COLUBK
        nop3
        STY COLUBK
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line18X3
        RTS


loop_step1line19X3
    nop3
    nop

step1line19_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X3,Y
        STX PF0
        LDX Step1Line19PF1X3,Y
        STX PF1
        LDX Step1Line19PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        NOP
        LDX #COLOR_RED
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        ADC Y_DIVIDER_ZP
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line19X3
        RTS

	NOP

loop_step1line20X3
    nop
    nop

step1line20_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X3,Y
        STX PF0
        LDX Step1Line20PF1X3,Y
        STX PF1
        LDX Step1Line20PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX3
        LDX #0
        STX COLUBK
        bcc loop_step1line20X3
        RTS

	NOP
; haut du deuxieme bras
loop_step2line11X3
    nop3
    nop

step2line11_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X3,Y
        STX PF0
        LDX Step2Line11PF1X3,Y
        STX PF1
        LDX Step2Line11PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_VEST
        ADC Y_DIVIDER_ZP
        STX COLUBK
        NOP
        NOP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK
        
        bcc loop_step2line11X3
        RTS

	NOP
        NOP
; haut du deuxieme bras
loop_step2line12X3
    nop3
    nop

step2line12_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X3,Y
        STX PF0
        LDX Step2Line12PF1X3,Y
        STX PF1
        LDX Step2Line12PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_VEST
        nop
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK ;- COLOR_WHITE,X
        STX COLUBK

        bcc loop_step2line12X3
        RTS

; 2eme main
loop_step2line13X3
    nop3
    nop

step2line13_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X3,Y
        STX PF0
        LDX Step2Line13PF1X3,Y
        STX PF1
        LDX Step2Line13PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line13X3
        RTS

loop_step2line14X3
    nop3
    nop

step2line14_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X3,Y
        STX PF0
        LDX Step2Line14PF1X3,Y
        STX PF1
        LDX Step2Line14PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #0
        STX ENAM1
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        NOP
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line14X3
        RTS

	NOP
loop_step2line15X3
    nop
    nop

step2line15_generatedX3

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X3,Y
        STX PF0
        LDX Step2Line15PF1X3,Y
        STX PF1
        LDX Step2Line15PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_VEST
        NOP3
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK        
        
        bcc loop_step2line15X3
        RTS


	NOP
loop_step2line16X3
    nop3
    nop

step2line16_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X3,Y
        STX PF0
        LDX Step2Line16PF1X3,Y
        STX PF1
        LDX Step2Line16PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP
        NOP
        NOP        
        STX COLUBK

        bcc loop_step2line16X3
        RTS

	NOP

loop_step2line17X3
    nop3
    nop

step2line17_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X3,Y
        STX PF0
        LDX Step2Line17PF1X3,Y
        STX PF1
        LDX Step2Line17PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX3
        LDX #0
        STX COLUBK

	bcc loop_step2line17X3
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,loop_step2line18,"loop_step2line18"
    ds 10,0

loop_step2line18X3
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line18_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X3,Y
        STX PF0
        LDX Step2Line18PF1X3,Y
        STX PF1
        LDX Step2Line18PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP
        NOP
        NOP        
        STX COLUBK
        
        bcc loop_step2line18X3
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,loop_step2line19,"loop_step2line19"
    NOP
loop_step2line19X3
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line19_generatedX3
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X3,Y
        STX PF0
        LDX Step2Line19PF1X3,Y
        STX PF1
        LDX Step2Line19PF2X3,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX3
        LDX #0
        STX COLUBK
        bcc loop_step2line19X3
        RTS

    ALIGN 8
Step0Line0PF0X3 .byte $00,$00,$60,$00,$00,$00,$00,#$00
Step0Line0PF1X3 .byte $00,$00,$00,$C0,$18,$03,$00,#$00
Step0Line0PF2X3 .byte $18,$C0,$00,$00,$00,$00,$06,#$00
Step0Line1PF0X3 .byte $00,$10,$90,$80,$70,$E0,$00,#$00
Step0Line1PF1X3 .byte $3E,$07,$00,$20,$24,$C4,$F8,#$00
Step0Line1PF2X3 .byte $24,$23,$1F,$F8,$C0,$01,$09,#$00
Step0Line2PF0X3 .byte $00,$10,$90,$B0,$80,$10,$C0,#$00
Step0Line2PF1X3 .byte $C1,$18,$03,$20,$A4,$34,$06,#$00
Step0Line2PF2X3 .byte $25,$2C,$60,$06,$30,$81,$09,#$00
Step0Line3PF0X3 .byte $80,$00,$70,$C0,$00,$00,$20,#$00
Step0Line3PF1X3 .byte $00,$20,$04,$C0,$78,$0F,$01,#$00
Step0Line3PF2X3 .byte $1E,$F0,$80,$01,$08,$40,$07,#$00
Step0Line4PF0X3 .byte $40,$00,$10,$80,$00,$00,$10,#$00
Step0Line4PF1X3 .byte $00,$40,$08,$01,$20,$04,$00,#$00
Step0Line4PF2X3 .byte $04,$20,$00,$00,$04,$20,$01,#$00
Step0Line5PF0X3 .byte $40,$00,$10,$80,$10,$80,$50,#$00
Step0Line5PF1X3 .byte $88,$51,$0A,$01,$20,$04,$20,#$00
Step0Line5PF2X3 .byte $04,$20,$04,$22,$14,$A0,$01,#$00
Step0Line6PF0X3 .byte $40,$00,$10,$80,$10,$80,$50,#$00
Step0Line6PF1X3 .byte $88,$51,$0A,$01,$20,$04,$20,#$00
Step0Line6PF2X3 .byte $04,$20,$04,$22,$14,$A0,$01,#$00
Step0Line7PF0X3 .byte $40,$00,$10,$80,$10,$80,$50,#$00
Step0Line7PF1X3 .byte $88,$51,$0A,$01,$20,$04,$20,#$00
Step0Line7PF2X3 .byte $04,$20,$04,$22,$14,$A0,$01,#$00
Step0Line8PF0X3 .byte $40,$00,$10,$80,$00,$00,$10,#$00
Step0Line8PF1X3 .byte $00,$40,$08,$01,$20,$04,$00,#$00
Step0Line8PF2X3 .byte $04,$20,$00,$00,$04,$20,$01,#$00
Step0Line9PF0X3 .byte $C0,$00,$10,$C0,$00,$00,$30,#$00
Step0Line9PF1X3 .byte $00,$60,$0C,$01,$60,$0C,$01,#$00
Step0Line9PF2X3 .byte $06,$30,$80,$01,$0C,$60,$01,#$00
Step0Line10PF0X3 .byte $C0,$00,$10,$B0,$F0,$F0,$F0,#$00
Step0Line10PF1X3 .byte $FF,$7F,$0F,$01,$A0,$F4,$FE,#$00
Step0Line10PF2X3 .byte $05,$2F,$7F,$FF,$FC,$E0,$01,#$00
Step0Line11PF0X3 .byte $A0,$00,$20,$20,$00,$00,$20,#$00
Step0Line11PF1X3 .byte $00,$A0,$14,$82,$90,$12,$02,#$00
Step0Line11PF2X3 .byte $09,$48,$40,$01,$0A,$50,$82,#$00
Step0Line12PF0X3 .byte $A0,$00,$20,$10,$80,$00,$20,#$00
Step0Line12PF1X3 .byte $01,$A0,$14,$82,$10,$22,$04,#$00
Step0Line12PF2X3 .byte $08,$44,$20,$01,$0A,$50,$82,#$00
Step0Line13PF0X3 .byte $C0,$00,$10,$B0,$F0,$80,$70,#$00
Step0Line13PF1X3 .byte $8F,$71,$0E,$01,$A0,$F4,$3E,#$00
Step0Line13PF2X3 .byte $05,$2F,$7C,$E3,$1C,$E0,$01,#$00
Step0Line14PF0X3 .byte $C0,$00,$10,$C0,$40,$00,$30,#$00
Step0Line14PF1X3 .byte $02,$60,$0C,$01,$60,$4C,$09,#$00
Step0Line14PF2X3 .byte $06,$32,$90,$81,$0C,$60,$01,#$00
Step0Line15PF0X3 .byte $80,$00,$00,$50,$E0,$00,$60,#$00
Step0Line15PF1X3 .byte $87,$30,$06,$00,$40,$E8,$1D,#$00
Step0Line15PF2X3 .byte $02,$17,$B8,$C3,$18,$C0,$00,#$00
Step0Line16PF0X3 .byte $40,$00,$00,$20,$10,$F0,$90,#$00
Step0Line16PF1X3 .byte $78,$4F,$09,$01,$80,$10,$E2,#$00
Step0Line16PF2X3 .byte $01,$08,$47,$3C,$E4,$20,$00,#$00
Step0Line17PF0X3 .byte $E0,$00,$00,$30,$F0,$B0,$F0,#$00
Step0Line17PF1X3 .byte $EF,$FD,$1F,$03,$80,$F0,$BE,#$00
Step0Line17PF2X3 .byte $01,$0F,$7D,$EF,$7E,$F0,$80,#$00
Step0Line18PF0X3 .byte $20,$00,$00,$40,$10,$A0,$00,#$00
Step0Line18PF1X3 .byte $28,$85,$10,$02,$40,$08,$A1,#$00
Step0Line18PF2X3 .byte $02,$10,$85,$28,$42,$10,$80,#$00
Step0Line19PF0X3 .byte $C0,$00,$00,$70,$F0,$B0,$F0,#$00
Step0Line19PF1X3 .byte $EF,$7D,$0F,$01,$C0,$F8,$BF,#$00
Step0Line19PF2X3 .byte $03,$1F,$FD,$EF,$7C,$E0,$00,#$00

Step1Line11PF0X3 .byte $A0,$00,$20,$20,$00,$00,$20,#$00
Step1Line11PF1X3 .byte $00,$A0,$14,$82,$90,$12,$02,#$00
Step1Line11PF2X3 .byte $09,$48,$40,$01,$0A,$50,$82,#$00
Step1Line12PF0X3 .byte $A0,$00,$20,$20,$00,$00,$20,#$00
Step1Line12PF1X3 .byte $00,$A0,$14,$82,$90,$12,$02,#$00
Step1Line12PF2X3 .byte $09,$48,$40,$01,$0A,$50,$82,#$00
Step1Line13PF0X3 .byte $E0,$00,$30,$B0,$F0,$80,$70,#$00
Step1Line13PF1X3 .byte $8F,$F1,$1E,$83,$B0,$F6,$3E,#$00
Step1Line13PF2X3 .byte $0D,$6F,$7C,$E3,$1E,$F0,$83,#$00
Step1Line14PF0X3 .byte $E0,$00,$20,$60,$00,$00,$30,#$00
Step1Line14PF1X3 .byte $00,$E0,$1C,$83,$D0,$1A,$03,#$00
Step1Line14PF2X3 .byte $0B,$58,$C0,$01,$0E,$70,$82,#$00
Step1Line15PF0X3 .byte $C0,$00,$20,$30,$E0,$10,$F0,#$00
Step1Line15PF1X3 .byte $C7,$78,$0F,$81,$90,$F2,$1E,#$00
Step1Line15PF2X3 .byte $09,$4F,$78,$C7,$3C,$E0,$02,#$00
Step1Line16PF0X3 .byte $80,$00,$10,$E0,$10,$E0,$20,#$00
Step1Line16PF1X3 .byte $38,$27,$04,$00,$E0,$1C,$E3,#$00
Step1Line16PF2X3 .byte $07,$38,$C7,$39,$C8,$40,$01,#$00
Step1Line17PF0X3 .byte $80,$00,$00,$30,$F0,$C0,$20,#$00
Step1Line17PF1X3 .byte $1F,$23,$04,$00,$80,$F0,$7E,#$00
Step1Line17PF2X3 .byte $01,$0F,$7E,$F1,$88,$40,$00,#$00
Step1Line18PF0X3 .byte $80,$00,$00,$40,$10,$F0,$E0,#$00
Step1Line18PF1X3 .byte $F8,$3F,$07,$00,$40,$08,$E1,#$00
Step1Line18PF2X3 .byte $02,$10,$87,$3F,$F8,$C0,$00,#$00
Step1Line19PF0X3 .byte $40,$00,$00,$70,$F0,$C0,$10,#$00
Step1Line19PF1X3 .byte $1F,$43,$08,$01,$C0,$F8,$7F,#$00
Step1Line19PF2X3 .byte $03,$1F,$FE,$F0,$84,$20,$00,#$00
Step1Line20PF0X3 .byte $C0,$00,$00,$00,$00,$70,$F0,#$00
Step1Line20PF1X3 .byte $F0,$7E,$0F,$01,$00,$00,$C0,#$00
Step1Line20PF2X3 .byte $00,$00,$03,$1F,$FC,$E0,$00,#$00

Step2Line11PF0X3 .byte $A0,$00,$10,$90,$80,$00,$20,#$00
Step2Line11PF1X3 .byte $01,$A0,$14,$02,$20,$24,$04,#$00
Step2Line11PF2X3 .byte $04,$24,$20,$01,$0A,$50,$81,#$00
Step2Line12PF0X3 .byte $F0,$80,$20,$20,$00,$00,$30,#$00
Step2Line12PF1X3 .byte $00,$E0,$3C,$87,$90,$12,$02,#$00
Step2Line12PF2X3 .byte $09,$48,$40,$01,$0F,$78,$C2,#$00
Step2Line13PF0X3 .byte $90,$80,$60,$30,$F0,$80,$60,#$00
Step2Line13PF1X3 .byte $8F,$31,$26,$C4,$98,$F3,$3E,#$00
Step2Line13PF2X3 .byte $19,$CF,$7C,$E3,$19,$C8,$46,#$00
Step2Line14PF0X3 .byte $F0,$80,$50,$E0,$00,$00,$30,#$00
Step2Line14PF1X3 .byte $00,$E0,$3C,$47,$E8,$1D,$03,#$00
Step2Line14PF2X3 .byte $17,$B8,$C0,$01,$0F,$78,$C5,#$00
Step2Line15PF0X3 .byte $80,$00,$40,$70,$F0,$90,$E0,#$00
Step2Line15PF1X3 .byte $CF,$39,$07,$40,$C8,$F9,$3F,#$00
Step2Line15PF2X3 .byte $13,$9F,$FC,$E7,$38,$C0,$04,#$00
Step2Line16PF0X3 .byte $00,$00,$30,$B0,$80,$60,$40,#$00
Step2Line16PF1X3 .byte $B1,$16,$02,$80,$B0,$36,$C6,#$00
Step2Line16PF2X3 .byte $0D,$6C,$63,$1A,$D0,$80,$03,#$00
Step2Line17PF0X3 .byte $00,$00,$00,$10,$F0,$F0,$C0,#$00
Step2Line17PF1X3 .byte $FF,$1F,$03,$00,$00,$E0,$FC,#$00
Step2Line17PF2X3 .byte $00,$07,$3F,$FE,$F0,$80,$00,#$00
Step2Line18PF0X3 .byte $00,$00,$00,$10,$80,$20,$40,#$00
Step2Line18PF1X3 .byte $A1,$14,$02,$00,$00,$20,$84,#$00
Step2Line18PF2X3 .byte $00,$04,$21,$0A,$50,$80,$00,#$00
Step2Line19PF0X3 .byte $00,$00,$00,$10,$F0,$F0,$80,#$00
Step2Line19PF1X3 .byte $7F,$0F,$01,$00,$00,$E0,$FC,#$00
Step2Line19PF2X3 .byte $00,$07,$3F,$FC,$E0,$00,$00,#$00

Step3Line11PF0X3 .byte $A0,$00,$20,$20,$00,$00,$20,#$00
Step3Line11PF1X3 .byte $00,$A0,$14,$82,$90,$12,$02,#$00
Step3Line11PF2X3 .byte $09,$48,$40,$01,$0A,$50,$82,#$00
Step3Line12PF0X3 .byte $A0,$00,$20,$20,$00,$00,$20,#$00
Step3Line12PF1X3 .byte $00,$A0,$14,$82,$90,$12,$02,#$00
Step3Line12PF2X3 .byte $09,$48,$40,$01,$0A,$50,$82,#$00
Step3Line13PF0X3 .byte $E0,$00,$20,$30,$F0,$80,$70,#$00
Step3Line13PF1X3 .byte $8F,$F1,$1E,$83,$90,$F2,$3E,#$00
Step3Line13PF2X3 .byte $09,$4F,$7C,$E3,$1E,$F0,$82,#$00
Step3Line14PF0X3 .byte $A0,$00,$20,$70,$80,$00,$20,#$00
Step3Line14PF1X3 .byte $01,$A0,$14,$82,$D0,$3A,$07,#$00
Step3Line14PF2X3 .byte $0B,$5C,$E0,$01,$0A,$50,$82,#$00
Step3Line15PF0X3 .byte $E0,$00,$10,$90,$E0,$10,$F0,#$00
Step3Line15PF1X3 .byte $C7,$F8,$1F,$03,$20,$E4,$1C,#$00
Step3Line15PF2X3 .byte $04,$27,$38,$C7,$3E,$F0,$81,#$00
Step3Line16PF0X3 .byte $80,$00,$10,$B0,$90,$E0,$20,#$00
Step3Line16PF1X3 .byte $39,$27,$04,$00,$A0,$34,$E6,#$00
Step3Line16PF2X3 .byte $05,$2C,$67,$39,$C8,$40,$01,#$00
Step3Line17PF0X3 .byte $80,$00,$00,$60,$00,$70,$E0,#$00
Step3Line17PF1X3 .byte $F0,$3E,$07,$00,$C0,$18,$C3,#$00
Step3Line17PF2X3 .byte $03,$18,$C3,$1F,$F8,$C0,$00,#$00
Step3Line18PF0X3 .byte $80,$00,$00,$30,$F0,$C0,$20,#$00
Step3Line18PF1X3 .byte $1F,$23,$04,$00,$80,$F0,$7E,#$00
Step3Line18PF2X3 .byte $01,$0F,$7E,$F1,$88,$40,$00,#$00
Step3Line19PF0X3 .byte $00,$00,$00,$20,$00,$70,$C0,#$00
Step3Line19PF1X3 .byte $F0,$1E,$03,$00,$80,$10,$C2,#$00
Step3Line19PF2X3 .byte $01,$08,$43,$1E,$F0,$80,$00,#$00
Step3Line20PF0X3 .byte $00,$00,$00,$30,$F0,$C0,$00,#$00
Step3Line20PF1X3 .byte $1F,$03,$00,$00,$80,$F0,$7E,#$00
Step3Line20PF2X3 .byte $01,$0F,$7E,$F0,$80,$00,$00,#$00

	DS 32
;    ALIGN 256
DrawLogo SUBROUTINE
; setup
        LDA #0
        sta COLUBK
        sta COLUPF
        LDA #0
        sta PF0
        sta PF1
        sta PF2
        sta GRP0
        sta GRP1
        sta GRP0 ; validate write
        sta REFP0
        sta REFP1
        STA ENABL
        STA ENAM0
        STA ENAM1
        lda #3
        sta NUSIZ0
        lda #1
        sta NUSIZ1

	LDA DEMO_PART
        PHA ; save DEMO_PART in the stack
        LSR
        LSR
        LSR
        LSR
        TAY
        DEY
        STY DEMO_PART ; A = Logo phase - 1
        TAY
        CPY #8
        Bcc .waitLogo
        jmp .finLogo
        ; 0: normal, et finit trace a Y = -1
        ; 1: attend 2 lignes, et finit trace a Y = 0
        ; 2: attend 4 lignes, et finit trace a Y = 1
        ; pour l'attente sette Y = Phase
        ; pour le logo sette DEMO_PART = Phase - 1
        
;	LDY #0
.waitLogo        
        DEY
        BMI .doneWaitLogo
        STA WSYNC
        STA WSYNC
        BPL .waitLogo        
.doneWaitLogo

    sta WSYNC ; position 2 sprites in one line
    	JSR Lose14CyclesX3
    	JSR Lose19CyclesX3
    	JSR Lose20CyclesX3
	NOP
        
        STA RESP0
        sta RESP1

DECAL_LOGO equ $9

        LDA #(DECAL_LOGO * $10)
        STA HMP0
        LDA #(((DECAL_LOGO + 1) & 15) * $10)
        STA HMP1
  
        sta WSYNC
;        SLEEP 71        
        sta HMOVE ; 74: avoid HMOVE comb
;   LDA #$1E
;        STA COLUBK

	ldy #7
        lda #1
        sta VDELP0
        sta VDELP1
        lda #$1E
        sta COLUP0
        sta COLUP1 
	; 8 cycles
        
;        sta WSYNC

	JSR Lose12CyclesX3
	JSR Lose12CyclesX3
	JSR Lose12CyclesX3
	JSR Lose12CyclesX3
        
        LDA DEMO_PART
        CMP #7
        BEQ .finLogo
        NOP3
        
.loopLogo
    lda Logo1,Y
    sta GRP0
        NOP3
        NOP
        NOP
        NOP
        NOP
        NOP
    lda Logo2,Y
    sta GRP1
        NOP
	NOP3
    LDA Logo3,Y
    sta GRP0
        NOP
	NOP
        NOP
	NOP
        NOP
    LDA Logo5,Y
        tax
    lda Logo4,Y ;4,Y 
        sta GRP1
        stx GRP0
    sta GRP1
        nop
        NOP
        NOP
        NOP
    lda Logo1,Y
    sta GRP0
        lda #$FF
        NOP
        NOP
        NOP
        NOP
	NOP3
    lda Logo2,Y
    sta GRP1
        NOP
	NOP3
    LDA Logo3,Y
    sta GRP0
        NOP
	NOP
        NOP
	NOP
        NOP
    LDA Logo5,Y
        tax
    lda Logo4,Y ;4,Y 
        sta GRP1
        stx GRP0
    sta GRP1
;        NOP3
        ; il faudrait une variable en ram pour ca
        dey
        cpy DEMO_PART
        bne .loopLogo
.finLogo
        lda #0
        sta VDELP0
        sta VDELP1
        sta GRP0
        sta GRP1

	PLA
        STA DEMO_PART
        
        RET_MAGI_CALL


;	ALIGN 256
TEST_LOGO equ 0

	IF TEST_LOGO = 1
Logo1 
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111

Logo2
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111

Logo3
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111

Logo4
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111

Logo5
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
    .byte #%11111111
        
        ELSE
Logo1 
    .byte #%11111111
    .byte #%11001110
    .byte #%10110101
    .byte #%10110101
    .byte #%11000100
    .byte #%11110101
    .byte #%11110110
    .byte #%11111111

Logo2
    .byte #%11111111
    .byte #%01101011
    .byte #%10101010
    .byte #%11101010
    .byte #%01101010
    .byte #%10101010
    .byte #%01110110
    .byte #%11111111

Logo3
    .byte #%11110000
    .byte #%01010100
    .byte #%11010100
    .byte #%11010100
    .byte #%01010110
    .byte #%11110100
    .byte #%11010011
    .byte #%11110000

Logo4
    .byte #%00000000
    .byte #%01000100
    .byte #%01000101
    .byte #%01000101
    .byte #%01000101
    .byte #%01010001
    .byte #%00100100
    .byte #%00000000

Logo5
    .byte #%00000000
    .byte #%11001100
    .byte #%00010010
    .byte #%00010000
    .byte #%00011100
    .byte #%00010010
    .byte #%11001100
    .byte #%00000000
        ENDIF


        echo "ROM left bank 4: ", ($9ff4 - *)

        org $4FF4
        RORG    $9FF4
        .byte 0,0,0,0,0,0
        org $4FFA
        RORG    $9FFA

        .word 0          ; NMI
        .word $9000      ; RESET
        .word $9000      ; BRK


        ORG     $5000
        RORG    $B000
Bank5   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE

Lose25CyclesX4
	.byte $82
Lose24CyclesX4
	.byte $82
Lose23CyclesX4
	.byte $82
Lose22CyclesX4
	.byte $82
Lose21CyclesX4
	.byte $82
Lose20CyclesX4
	.byte $82
Lose19CyclesX4
	.byte $82
Lose18CyclesX4
	.byte $82
Lose17CyclesX4
	.byte $82
Lose16CyclesX4
        .byte $82 ; Nop imm 2
Lose15CyclesX4
        .byte $44 ; Nop zp 3
Lose14CyclesX4
        .byte $EA ; Nop
Lose12CyclesX4
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen4

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0X4
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLineX4
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLineX4


LoopEmptyLineX4
    pha
    pla
    nop
    nop
EmptyLineX4
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX4
    STX COLUBK

    BCC LoopEmptyLineX4
    RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line0,"loop_line0"


loop_line0X4
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X4,Y
        STX PF0
        LDX Step0Line0PF1X4,Y
        STX PF1
        LDX Step0Line0PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
       
        LDY BACKGROUND_COLOR_LINE_0
        STY COLUBK
        JSR Lose20CyclesX4
        
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line0X4
        rts

        ;ALIGN_LINE_ROUTINE 1,loop_line1,"loop_line1"
loop_line1X4
    NOP
    nop

line1_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X4,Y
        STX PF0
        LDX Step0Line1PF1X4,Y
        STX PF1
        LDX Step0Line1PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        JSR Lose15CyclesX4
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUBK
	LDX #0
        STX COLUBK
        bcc loop_line1X4
        RTS

	NOP
        NOP
        NOP
        
loop_line2X4
    NOP3
    nop

line2_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X4,Y
        STX PF0
        LDX Step0Line2PF1X4,Y
        STX PF1
        LDX Step0Line2PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_2

	STY COLUBK
        ADC Y_DIVIDER_ZP
	NOP
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        NOP3
        LDX #COLOR_RED
        STY COLUBK
        STX COLUBK
	LDX #0
        STX COLUBK
        
        bcc loop_line2X4
        RTS


loop_line3X4
    nop3
    nop

line3_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X4,Y
        STX PF0
        LDX Step0Line3PF1X4,Y
        STX PF1
        LDX Step0Line3PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3

	STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        JSR Lose12CyclesX4
        STY COLUBK
	LDX #0
        STX COLUBK

	bcc loop_line3X4
        RTS

	NOP
        NOP
        NOP
; haut masque
loop_line4X4
    nop3
    nop

line4_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X4,Y
        STX PF0
        LDX Step0Line4PF1X4,Y
        STX PF1
        LDX Step0Line4PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
        NOP3
        NOP
        NOP
        STX COLUBK
	ADC Y_DIVIDER_ZP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line4X4
	RTS


; haut oeil
loop_line5X4
    nop3
    nop

line5_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X4,Y
        STX PF0
        LDX Step0Line5PF1X4,Y
        STX PF1
        LDX Step0Line5PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line5X4
	RTS

	NOP
; milieu oeil
loop_line6X4
    nop
    nop

line6_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X4,Y
        STX PF0
        LDX Step0Line6PF1X4,Y
        STX PF1
        LDX Step0Line6PF2X4,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line6X4
        RTS

	NOP
; bas oeil
loop_line7X4
    nop3
    nop

line7_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X4,Y
        STX PF0
        LDX Step0Line7PF1X4,Y
        STX PF1
        LDX Step0Line7PF2X4,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7

	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK
         
    	bcc loop_line7X4
    	RTS

	nop
; bas masque
loop_line8X4
    nop3
    nop

line8_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X4,Y
        STX PF0
        LDX Step0Line8PF1X4,Y
        STX PF1
        LDX Step0Line8PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        STX GRP1
	STY COLUBK
        NOP
        STX COLUBK

	bcc loop_line8X4
    	RTS

	NOP
; sous le masque
loop_line9X4
	nop3
        nop

line9_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X4,Y
        STX PF0
        LDX Step0Line9PF1X4,Y
        STX PF1
        LDX Step0Line9PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9

	STY COLUBK
        nop
    	LDX COLOR_WHITE_BYTE
	STX COLUBK
        NOP
        NOP3
	nop
    	ADC Y_DIVIDER_ZP
        LDX #0
    	STY COLUBK
    	nop
    	STX COLUBK
        bcc loop_line9X4
        RTS

	NOP
        NOP
; separation tete corps
loop_line10X4
    nop3
    nop

line10_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X4,Y
        STX PF0
        LDX Step0Line10PF1X4,Y
        STX PF1
        LDX Step0Line10PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        STX ENAM1
        nop3
        ADC Y_DIVIDER_ZP
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_line10X4
        RTS

	nop
	nop
; haut du deuxieme bras
loop_line11X4
    nop
    nop

line11_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line11PF0X4,Y
        STX PF0
        LDX Step0Line11PF1X4,Y
        STX PF1
        LDX Step0Line11PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11

	STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        NOP
        NOP
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_line11X4
        RTS

	NOP
        NOP
; juste au dessus de la ceinture
loop_line12X4
    nop3
    nop

line12_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X4,Y
        STX PF0
        LDX Step0Line12PF1X4,Y
        STX PF1
        LDX Step0Line12PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
	STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        NOP3
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK

	bcc loop_line12X4
        RTS

	NOP
        NOP
        
loop_line13X4
    nop3
    nop

line13_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X4,Y
        STX PF0
        LDX Step0Line13PF1X4,Y
        STX PF1
        LDX Step0Line13PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        ADC Y_DIVIDER_ZP
        STX COLUBK
        LDX #0
        STX ENAM1
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line13X4
    	RTS

	NOP
loop_line14X4
    nop3
    nop

line14_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line14PF0X4,Y
        STX PF0
        LDX Step0Line14PF1X4,Y
        STX PF1
        LDX Step0Line14PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX #COLOR_VEST
        NOP
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP3
        STX COLUBK
        NOP
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line14X4
        RTS

loop_line15X4
    nop3
    nop

line15_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X4,Y
        STX PF0
        LDX Step0Line15PF1X4,Y
        STX PF1
        LDX Step0Line15PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX COLOR_VEST_BYTE
        LDY #COLOR_RED
        STX COLUBK
        nop
        ADC Y_DIVIDER_ZP
        STY COLUBK    
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
	bcc loop_line15X4
    	RTS

	NOP
loop_line16X4
    nop
    nop

line16_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X4,Y
        STX PF0
        LDX Step0Line16PF1X4,Y
        STX PF1
        LDX Step0Line16PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX #COLOR_WHITE
        nop
        STX COLUBK
        nop
        nop
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        STY COLUBK
        NOP
        LDX #0
        STX COLUBK

        bcc loop_line16X4
        RTS

	NOP
loop_line17X4
    nop3
    nop

line17_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X4,Y
        STX PF0
        LDX Step0Line17PF1X4,Y
        STX PF1
        LDX Step0Line17PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        JSR Lose17CyclesX4
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line17X4
        RTS

	NOP
        NOP
        NOP
        NOP
        
loop_line18X4
    nop3
    nop

line18_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X4,Y
        STX PF0
        LDX Step0Line18PF1X4,Y
        STX PF1
        LDX Step0Line18PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

	STY COLUBK
        LDX COLOR_RED_BYTE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        STY COLUBK
        STX COLUBK
        nop3
        STY COLUBK - COLOR_RED,X
        LDX COLOR_BLACK_BYTE
        STX COLUBK

        bcc loop_line18X4
        RTS

	NOP
        NOP
        
loop_line19X4
    nop3
    nop

line19_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X4,Y
        STX PF0
        LDX Step0Line19PF1X4,Y
        STX PF1
        LDX Step0Line19PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX4
        LDX #0
        STX COLUBK
        bcc loop_line19X4
        RTS

	NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        
; haut du deuxieme bras
loop_step3line12X4
    nop3
    nop

step3line12_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X4,Y
        STX PF0
        LDX Step3Line12PF1X4,Y
        STX PF1
        LDX Step3Line12PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line12X4
        RTS


	ALIGN 64
        nop
loop_step3line13X4
    nop3
    nop

step3line13_generatedX4

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X4,Y
        STX PF0
        LDX Step3Line13PF1X4,Y
        STX PF1
        LDX Step3Line13PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

	STY COLUBK
        LDX #COLOR_BELT
        NOP
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line13X4
        RTS


;	ALIGN 32
loop_step3line14X4
	LDX #COLOR_RED
        STX COLUP1

step3line14_generatedX4

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X4,Y
        STX PF0
        LDX Step3Line14PF1X4,Y
        STX PF1
        LDX Step3Line14PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line14X4
        RTS

	NOP
loop_step3line15X4
        LDX #0
        STX ENAM1

step3line15_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X4,Y
        STX PF0
        LDX Step3Line15PF1X4,Y
        STX PF1
        LDX Step3Line15PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop
        nop
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line15X4
        RTS


loop_step3line16X4
    nop3
    nop

step3line16_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X4,Y
        STX PF0
        LDX Step3Line16PF1X4,Y
        STX PF1
        LDX Step3Line16PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #COLOR_RED
        NOP
        NOP3
        NOP
        STX COLUBK
        STY COLUBK; - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line16X4
        RTS


loop_step3line17X4
    nop3
    nop

step3line17_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X4,Y
        STX PF0
        LDX Step3Line17PF1X4,Y
        STX PF1
        LDX Step3Line17PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17

        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        LDX #0
        STX COLUBK

        bcc loop_step3line17X4
        RTS

	NOP
        
loop_step3line18X4
    nop3
    nop

step3line18_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X4,Y
        STX PF0
        LDX Step3Line18PF1X4,Y
        STX PF1
        LDX Step3Line18PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        STX COLUBK
        nop3
        STY COLUBK
        nop3
        nop
        nop
        nop
        LDX #0
        STX COLUBK

        bcc loop_step3line18X4
        RTS

loop_step3line19X4
    nop3
    nop

step3line19_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X4,Y
        STX PF0
        LDX Step3Line19PF1X4,Y
        STX PF1
        LDX Step3Line19PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
	NOP
        LDX #0
        STY COLUBK
        nop
        nop
        STX COLUBK
        
        bcc loop_step3line19X4
        RTS

	NOP
        
loop_step3line20X4
    nop3
    nop

step3line20_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X4,Y
        STX PF0
        LDX Step3Line20PF1X4,Y
        STX PF1
        LDX Step3Line20PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX4
        LDX #0
        STX COLUBK
        bcc loop_step3line20X4
        RTS
    

loop_step1line13X4
    nop3
    nop

step1line13_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X4,Y
        STX PF0
        LDX Step1Line13PF1X4,Y
        STX PF1
        LDX Step1Line13PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        nop
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP3
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step1line13X4
        RTS

; haut du deuxieme bras
loop_step1line14X4
        nop
	nop3

; 7D4
step1line14_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X4,Y
        STX PF0
        LDX Step1Line14PF1X4,Y
        STX PF1
        LDX Step1Line14PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #0
        STX ENAM1
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUBK
        LDX #0
        STY COLUBK 
        STX COLUBK

        bcc loop_step1line14X4
        RTS

	ALIGN 16
loop_step1line15X4
    nop3
    nop

step1line15_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X4,Y
        STX PF0
        LDX Step1Line15PF1X4,Y
        STX PF1
        LDX Step1Line15PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop3
	nop
        STX COLUBK
        LDX #0
        STY COLUBK 
        STX COLUBK

	bcc loop_step1line15X4
        RTS

	NOP
loop_step1line16X4
    nop3
    nop

step1line16_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X4,Y
        STX PF0
        LDX Step1Line16PF1X4,Y
        STX PF1
        LDX Step1Line16PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        NOP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STY COLUBK
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line16X4
        RTS


loop_step1line17X4
    nop3
    nop

step1line17_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X4,Y
        STX PF0
        LDX Step1Line17PF1X4,Y
        STX PF1
        LDX Step1Line17PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        NOP3
        STY COLUBK
        NOP
        NOP
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line17X4
        RTS

	NOP
loop_step1line18X4
    nop3
    nop

step1line18_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X4,Y
        STX PF0
        LDX Step1Line18PF1X4,Y
        STX PF1
        LDX Step1Line18PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_RED
        NOP
        NOP3
        STX COLUBK
        nop
        nop
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
        bcc loop_step1line18X4
        RTS
	NOP

loop_step1line19X4
    nop3
    nop

step1line19_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X4,Y
        STX PF0
        LDX Step1Line19PF1X4,Y
        STX PF1
        LDX Step1Line19PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        NOP
        LDX #COLOR_RED
        STX COLUBK
        nop
        nop
        STY COLUBK
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line19X4
        RTS

	NOP
        
loop_step1line20X4
    nop
    nop

step1line20_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X4,Y
        STX PF0
        LDX Step1Line20PF1X4,Y
        STX PF1
        LDX Step1Line20PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX4
        LDX #0
        STX COLUBK
        bcc loop_step1line20X4
        RTS


	NOP

; haut du deuxieme bras
loop_step2line11X4
    nop3
    nop

step2line11_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X4,Y
        STX PF0
        LDX Step2Line11PF1X4,Y
        STX PF1
        LDX Step2Line11PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_VEST
        ADC Y_DIVIDER_ZP
        STX COLUBK
        NOP
        NOP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK
        
        bcc loop_step2line11X4
        RTS

	NOP
        NOP

; haut du deuxieme bras
loop_step2line12X4
    nop3
    nop

step2line12_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X4,Y
        STX PF0
        LDX Step2Line12PF1X4,Y
        STX PF1
        LDX Step2Line12PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_VEST
        nop
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK ;- COLOR_WHITE,X
        STX COLUBK

        bcc loop_step2line12X4
        RTS


; 2eme main
loop_step2line13X4
    nop3 
    nop

step2line13_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X4,Y
        STX PF0
        LDX Step2Line13PF1X4,Y
        STX PF1
        LDX Step2Line13PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line13X4
        RTS

	NOP

; la premiere iteration de cette routine prend un cycle de plus - decale le beam
loop_step2line14X4
    nop ; nop3 pour pas de page boundary cross - 1 ( + 1 dans la boucle)
    nop

step2line14_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X4,Y
        STX PF0
        LDX Step2Line14PF1X4,Y
        STX PF1
        LDX Step2Line14PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #0
        STX ENAM1
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        NOP3
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line14X4
        RTS

loop_step2line15X4
    nop
    nop

step2line15_generatedX4

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X4,Y
        STX PF0
        LDX Step2Line15PF1X4,Y
        STX PF1
        LDX Step2Line15PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_VEST
        NOP3
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK        
        
        bcc loop_step2line15X4
        RTS

	NOP
        
; la premiere iteration de cette routine prend un cycle de moins - decale le beam
loop_step2line16X4
    nop ; nop pour le page boundary cross + 1
    nop
    nop

step2line16_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X4,Y
        STX PF0
        LDX Step2Line16PF1X4,Y
        STX PF1
        LDX Step2Line16PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        LDX #COLOR_WHITE
        NOP
        NOP
        STX COLUBK
        LDX #0
	ADC Y_DIVIDER_ZP
	NOP3
        STY COLUBK
        NOP
        NOP        
        STX COLUBK

        bcc loop_step2line16X4
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_step2line17,"loop_step2line17"
        nop

loop_step2line17X4
    nop3
    nop

step2line17_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X4,Y
        STX PF0
        LDX Step2Line17PF1X4,Y
        STX PF1
        LDX Step2Line17PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX4
        LDX #0
        STX COLUBK

	bcc loop_step2line17X4
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,loop_step2line18,"loop_step2line18"
    ds 10,0
loop_step2line18X4
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line18_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X4,Y
        STX PF0
        LDX Step2Line18PF1X4,Y
        STX PF1
        LDX Step2Line18PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP
        NOP
        NOP        
        STX COLUBK
        
        bcc loop_step2line18X4
        RTS
        
        ;ALIGN_LINE_ROUTINE 1,loop_step2line19,"loop_step2line19"
    NOP

loop_step2line19X4
    nop3 ;.byte $44,0 ; nop zp
    nop

step2line19_generatedX4
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X4,Y
        STX PF0
        LDX Step2Line19PF1X4,Y
        STX PF1
        LDX Step2Line19PF2X4,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX4
        LDX #0
        STX COLUBK
        bcc loop_step2line19X4
        RTS

    ALIGN 8
Step0Line0PF0X4 .byte $00,$10,$C0,$00,$00,$00,$00,#$00
Step0Line0PF1X4 .byte $00,$00,$00,$60,$0C,$01,$00,#$00
Step0Line0PF2X4 .byte $30,$80,$00,$00,$00,$01,$0C,#$00
Step0Line1PF0X4 .byte $00,$20,$20,$10,$F0,$C0,$00,#$00
Step0Line1PF1X4 .byte $1F,$03,$80,$90,$12,$E2,$7C,#$00
Step0Line1PF2X4 .byte $48,$47,$3E,$F0,$80,$02,$12,#$00
Step0Line2PF0X4 .byte $00,$20,$20,$60,$00,$30,$80,#$00
Step0Line2PF1X4 .byte $60,$0C,$81,$90,$D2,$1A,$83,#$00
Step0Line2PF2X4 .byte $4B,$58,$C1,$0C,$60,$02,$12,#$00
Step0Line3PF0X4 .byte $00,$10,$F0,$80,$00,$00,$40,#$00
Step0Line3PF1X4 .byte $80,$10,$02,$E0,$3C,$07,$00,#$00
Step0Line3PF2X4 .byte $3C,$E0,$00,$02,$10,$81,$0F,#$00
Step0Line4PF0X4 .byte $80,$00,$20,$00,$00,$00,$20,#$00
Step0Line4PF1X4 .byte $00,$20,$04,$80,$10,$02,$00,#$00
Step0Line4PF2X4 .byte $08,$40,$00,$01,$08,$40,$02,#$00
Step0Line5PF0X4 .byte $80,$00,$20,$00,$20,$10,$A0,#$00
Step0Line5PF1X4 .byte $44,$28,$05,$80,$10,$82,$10,#$00
Step0Line5PF2X4 .byte $08,$41,$08,$45,$28,$40,$02,#$00
Step0Line6PF0X4 .byte $80,$00,$20,$00,$20,$10,$A0,#$00
Step0Line6PF1X4 .byte $44,$28,$05,$80,$10,$82,$10,#$00
Step0Line6PF2X4 .byte $08,$41,$08,$45,$28,$40,$02,#$00
Step0Line7PF0X4 .byte $80,$00,$20,$00,$20,$10,$A0,#$00
Step0Line7PF1X4 .byte $44,$28,$05,$80,$10,$82,$10,#$00
Step0Line7PF2X4 .byte $08,$41,$08,$45,$28,$40,$02,#$00
Step0Line8PF0X4 .byte $80,$00,$20,$00,$00,$00,$20,#$00
Step0Line8PF1X4 .byte $00,$20,$04,$80,$10,$02,$00,#$00
Step0Line8PF2X4 .byte $08,$40,$00,$01,$08,$40,$02,#$00
Step0Line9PF0X4 .byte $80,$00,$30,$80,$00,$00,$60,#$00
Step0Line9PF1X4 .byte $80,$30,$06,$80,$30,$06,$00,#$00
Step0Line9PF2X4 .byte $0C,$60,$00,$03,$18,$C0,$03,#$00
Step0Line10PF0X4 .byte $80,$00,$20,$70,$F0,$F0,$E0,#$00
Step0Line10PF1X4 .byte $FF,$3F,$07,$80,$D0,$FA,$FF,#$00
Step0Line10PF2X4 .byte $0B,$5F,$FF,$FF,$F8,$C0,$02,#$00
Step0Line11PF0X4 .byte $40,$00,$40,$40,$00,$00,$50,#$00
Step0Line11PF1X4 .byte $80,$50,$0A,$41,$48,$09,$01,#$00
Step0Line11PF2X4 .byte $12,$90,$80,$02,$14,$A0,$04,#$00
Step0Line12PF0X4 .byte $40,$00,$40,$20,$00,$00,$50,#$00
Step0Line12PF1X4 .byte $80,$50,$0A,$41,$88,$11,$02,#$00
Step0Line12PF2X4 .byte $11,$88,$40,$02,$14,$A0,$04,#$00
Step0Line13PF0X4 .byte $80,$00,$20,$70,$E0,$10,$E0,#$00
Step0Line13PF1X4 .byte $C7,$38,$07,$80,$D0,$FA,$1F,#$00
Step0Line13PF2X4 .byte $0B,$5F,$F8,$C7,$38,$C0,$02,#$00
Step0Line14PF0X4 .byte $80,$00,$30,$90,$80,$00,$60,#$00
Step0Line14PF1X4 .byte $81,$30,$06,$80,$30,$26,$04,#$00
Step0Line14PF2X4 .byte $0C,$64,$20,$03,$18,$C0,$03,#$00
Step0Line15PF0X4 .byte $00,$00,$10,$B0,$C0,$10,$C0,#$00
Step0Line15PF1X4 .byte $C3,$18,$03,$00,$A0,$74,$0E,#$00
Step0Line15PF2X4 .byte $05,$2E,$70,$86,$30,$80,$01,#$00
Step0Line16PF0X4 .byte $80,$00,$00,$40,$30,$E0,$20,#$00
Step0Line16PF1X4 .byte $3C,$27,$04,$00,$40,$88,$F1,#$00
Step0Line16PF2X4 .byte $02,$11,$8F,$79,$C8,$40,$00,#$00
Step0Line17PF0X4 .byte $C0,$00,$00,$70,$E0,$70,$F0,#$00
Step0Line17PF1X4 .byte $F7,$7E,$0F,$01,$C0,$F8,$DF,#$00
Step0Line17PF2X4 .byte $03,$1F,$FB,$DF,$FC,$E0,$00,#$00
Step0Line18PF0X4 .byte $40,$00,$10,$80,$20,$40,$10,#$00
Step0Line18PF1X4 .byte $14,$42,$08,$01,$20,$84,$50,#$00
Step0Line18PF2X4 .byte $04,$21,$0A,$50,$84,$20,$01,#$00
Step0Line19PF0X4 .byte $80,$00,$10,$F0,$E0,$70,$E0,#$00
Step0Line19PF1X4 .byte $F7,$3E,$07,$00,$E0,$FC,$DF,#$00
Step0Line19PF2X4 .byte $07,$3F,$FB,$DF,$F8,$C0,$01,#$00

Step1Line11PF0X4 .byte $40,$00,$40,$40,$00,$00,$50,#$00
Step1Line11PF1X4 .byte $80,$50,$0A,$41,$48,$09,$01,#$00
Step1Line11PF2X4 .byte $12,$90,$80,$02,$14,$A0,$04,#$00
Step1Line12PF0X4 .byte $40,$00,$40,$40,$00,$00,$50,#$00
Step1Line12PF1X4 .byte $80,$50,$0A,$41,$48,$09,$01,#$00
Step1Line12PF2X4 .byte $12,$90,$80,$02,$14,$A0,$04,#$00
Step1Line13PF0X4 .byte $C0,$00,$60,$70,$E0,$10,$F0,#$00
Step1Line13PF1X4 .byte $C7,$78,$0F,$C1,$D8,$FB,$1F,#$00
Step1Line13PF2X4 .byte $1B,$DF,$F8,$C7,$3C,$E0,$06,#$00
Step1Line14PF0X4 .byte $C0,$00,$50,$C0,$00,$00,$70,#$00
Step1Line14PF1X4 .byte $80,$70,$0E,$41,$68,$0D,$01,#$00
Step1Line14PF2X4 .byte $16,$B0,$80,$03,$1C,$E0,$05,#$00
Step1Line15PF0X4 .byte $80,$00,$40,$70,$C0,$30,$E0,#$00
Step1Line15PF1X4 .byte $E3,$3C,$07,$40,$C8,$79,$8F,#$00
Step1Line15PF2X4 .byte $13,$9E,$F1,$8F,$78,$C0,$04,#$00
Step1Line16PF0X4 .byte $00,$00,$30,$C0,$30,$C0,$40,#$00
Step1Line16PF1X4 .byte $9C,$13,$02,$80,$70,$8E,$71,#$00
Step1Line16PF2X4 .byte $0E,$71,$8E,$72,$90,$80,$03,#$00
Step1Line17PF0X4 .byte $00,$00,$00,$70,$F0,$80,$40,#$00
Step1Line17PF1X4 .byte $8F,$11,$02,$00,$C0,$F8,$3F,#$00
Step1Line17PF2X4 .byte $03,$1F,$FC,$E2,$10,$80,$00,#$00
Step1Line18PF0X4 .byte $00,$00,$10,$80,$30,$F0,$C0,#$00
Step1Line18PF1X4 .byte $FC,$1F,$03,$00,$20,$84,$F0,#$00
Step1Line18PF2X4 .byte $04,$21,$0F,$7E,$F0,$80,$01,#$00
Step1Line19PF0X4 .byte $80,$00,$10,$F0,$F0,$80,$20,#$00
Step1Line19PF1X4 .byte $0F,$21,$04,$00,$E0,$FC,$3F,#$00
Step1Line19PF2X4 .byte $07,$3F,$FC,$E1,$08,$40,$01,#$00
Step1Line20PF0X4 .byte $80,$00,$00,$00,$10,$F0,$E0,#$00
Step1Line20PF1X4 .byte $F8,$3F,$07,$00,$00,$00,$E0,#$00
Step1Line20PF2X4 .byte $00,$00,$07,$3F,$F8,$C0,$00,#$00

Step2Line11PF0X4 .byte $40,$00,$20,$20,$00,$00,$50,#$00
Step2Line11PF1X4 .byte $80,$50,$0A,$81,$90,$12,$02,#$00
Step2Line11PF2X4 .byte $09,$48,$40,$02,$14,$A0,$02,#$00
Step2Line12PF0X4 .byte $E0,$00,$40,$40,$00,$00,$70,#$00
Step2Line12PF1X4 .byte $80,$F0,$1E,$43,$48,$09,$01,#$00
Step2Line12PF2X4 .byte $12,$90,$80,$03,$1E,$F0,$84,#$00
Step2Line13PF0X4 .byte $20,$10,$C0,$70,$E0,$10,$C0,#$00
Step2Line13PF1X4 .byte $C7,$98,$13,$62,$CC,$F9,$1F,#$00
Step2Line13PF2X4 .byte $33,$9F,$F8,$C6,$32,$91,$8C,#$00
Step2Line14PF0X4 .byte $E0,$10,$B0,$C0,$00,$00,$70,#$00
Step2Line14PF1X4 .byte $80,$F0,$1E,$A3,$74,$0E,$01,#$00
Step2Line14PF2X4 .byte $2E,$70,$80,$03,$1E,$F1,$8B,#$00
Step2Line15PF0X4 .byte $00,$10,$90,$F0,$E0,$30,$C0,#$00
Step2Line15PF1X4 .byte $E7,$1C,$03,$20,$E4,$FC,$9F,#$00
Step2Line15PF2X4 .byte $27,$3F,$F9,$CE,$70,$81,$09,#$00
Step2Line16PF0X4 .byte $00,$00,$60,$60,$10,$D0,$80,#$00
Step2Line16PF1X4 .byte $58,$0B,$01,$C0,$D8,$1B,$63,#$00
Step2Line16PF2X4 .byte $1B,$D8,$C6,$34,$A0,$00,$06,#$00
Step2Line17PF0X4 .byte $00,$00,$00,$30,$F0,$F0,$80,#$00
Step2Line17PF1X4 .byte $7F,$0F,$01,$00,$80,$F0,$FE,#$00
Step2Line17PF2X4 .byte $01,$0F,$7F,$FC,$E0,$00,$00,#$00
Step2Line18PF0X4 .byte $00,$00,$00,$20,$00,$50,$80,#$00
Step2Line18PF1X4 .byte $50,$0A,$01,$00,$80,$10,$42,#$00
Step2Line18PF2X4 .byte $01,$08,$42,$14,$A0,$00,$00,#$00
Step2Line19PF0X4 .byte $00,$00,$00,$30,$F0,$E0,$00,#$00
Step2Line19PF1X4 .byte $3F,$07,$00,$00,$80,$F0,$FE,#$00
Step2Line19PF2X4 .byte $01,$0F,$7F,$F8,$C0,$00,$00,#$00

Step3Line11PF0X4 .byte $40,$00,$40,$40,$00,$00,$50,#$00
Step3Line11PF1X4 .byte $80,$50,$0A,$41,$48,$09,$01,#$00
Step3Line11PF2X4 .byte $12,$90,$80,$02,$14,$A0,$04,#$00
Step3Line12PF0X4 .byte $40,$00,$40,$40,$00,$00,$50,#$00
Step3Line12PF1X4 .byte $80,$50,$0A,$41,$48,$09,$01,#$00
Step3Line12PF2X4 .byte $12,$90,$80,$02,$14,$A0,$04,#$00
Step3Line13PF0X4 .byte $C0,$00,$40,$70,$E0,$10,$F0,#$00
Step3Line13PF1X4 .byte $C7,$78,$0F,$41,$C8,$F9,$1F,#$00
Step3Line13PF2X4 .byte $13,$9F,$F8,$C7,$3C,$E0,$04,#$00
Step3Line14PF0X4 .byte $40,$00,$50,$E0,$00,$00,$50,#$00
Step3Line14PF1X4 .byte $80,$50,$0A,$41,$E8,$1D,$03,#$00
Step3Line14PF2X4 .byte $17,$B8,$C0,$02,$14,$A0,$05,#$00
Step3Line15PF0X4 .byte $C0,$00,$20,$30,$C0,$30,$F0,#$00
Step3Line15PF1X4 .byte $E3,$7C,$0F,$81,$90,$72,$8E,#$00
Step3Line15PF2X4 .byte $09,$4E,$71,$8F,$7C,$E0,$02,#$00
Step3Line16PF0X4 .byte $00,$00,$20,$60,$30,$C0,$40,#$00
Step3Line16PF1X4 .byte $9C,$13,$02,$80,$D0,$9A,$73,#$00
Step3Line16PF2X4 .byte $0B,$59,$CE,$72,$90,$80,$02,#$00
Step3Line17PF0X4 .byte $00,$00,$10,$C0,$10,$F0,$C0,#$00
Step3Line17PF1X4 .byte $F8,$1F,$03,$00,$60,$0C,$E1,#$00
Step3Line17PF2X4 .byte $06,$30,$87,$3E,$F0,$80,$01,#$00
Step3Line18PF0X4 .byte $00,$00,$00,$70,$F0,$80,$40,#$00
Step3Line18PF1X4 .byte $8F,$11,$02,$00,$C0,$F8,$3F,#$00
Step3Line18PF2X4 .byte $03,$1F,$FC,$E2,$10,$80,$00,#$00
Step3Line19PF0X4 .byte $00,$00,$00,$40,$10,$F0,$80,#$00
Step3Line19PF1X4 .byte $78,$0F,$01,$00,$40,$08,$E1,#$00
Step3Line19PF2X4 .byte $02,$10,$87,$3C,$E0,$00,$00,#$00
Step3Line20PF0X4 .byte $00,$00,$00,$70,$F0,$80,$00,#$00
Step3Line20PF1X4 .byte $0F,$01,$00,$00,$C0,$F8,$3F,#$00
Step3Line20PF2X4 .byte $03,$1F,$FC,$E0,$00,$00,$00,#$00


texte3
    .byte #$10,#$08,#$04,#$24,#$48,#$1C,#$18,#$10,#$1C,#$44,#$04,#$10
    .byte #$10,#$34,#$6C,#$08,#$10,#$28,#$14,#$04,#$44,#$3C,#$28,#$10
    .byte #$48,#$28,#$70,#$30,#$28,#$18,#$48,#$10,#$5C,#$44,#$04,#$00
    .byte #$10,#$14,#$04,#$44,#$04,#$18,#$28,#$48,#$4C,#$1C,#$44,#$10
    .byte #$34,#$18,#$08,#$70,#$54,#$10,#$3C,#$04,#$08,#$4C,#$18,#$04
    .byte #$2C,#$1C,#$1C,#$34,#$68,#$10,#$28,#$54,#$48,#$28,#$4C,#$18
    .byte #$10,#$10,#$0C,#$04,#$34,#$1C,#$18,#$1C,#$4C,#$3C,#$08,#$10
texte4
    .byte #$24,#$18,#$04,#$3C,#$4C,#$48,#$08,#$10,#$10,#$10,#$10,#$10
    .byte #$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C
    .byte #$24,#$1C,#$3C,#$04,#$10,#$10,#$10,#$74,#$04,#$78,#$28,#$60
    .byte #$78,#$4C,#$74,#$10,#$10,#$14,#$54,#$28,#$50,#$1C,#$30,#$74
    .byte #$14,#$50,#$60,#$10,#$10,#$10,#$04,#$60,#$1C,#$24,#$04,#$48
    .byte #$50,#$1C,#$44,#$48,#$10,#$10,#$10,#$10,#$04,#$28,#$08,#$40
    .byte #$0C,#$04,#$54,#$6C,#$10,#$10,#$10,#$18,#$04,#$34,#$3C,#$40
    

temp equ $98 ; 2 bytes
Phase equ $8E
PhaseDiv2 equ $C6
textPtr equ $92 ; 2 bytes
tempStack equ $9A


; environ 8 lignes raster - 64 bytes
; optimise a 5.8. good
GenerateTextLineWaveBank5 SUBROUTINE
; alternative        
;   lda #$F0
;        sta HMP1
;        sta HMP0
        
        lda numLine
        clc
        adc #12
        sta numLine
        clc
        adc #11
        tay ; numChar in texte

        tsx
        stx tempStack
; on cree 12 pointeurs vers les data de fonte dans Char[12]        
        ldx #Char1+23 
        txs

	lda #12
        CLC
        ADC Phase
        lsr
        sta temp
        bcs .loopGenerateBisBank5
        
.loopGenerate2Bank5
	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
;        inx
	LDA #>font
	BCC .pushCharPtr
	LDA #>font + 1

.pushCharPtr
	PHA
	TXA
        clc
        adc #1
        nop
	LDX temp
	PHA   
        dey

        ELSE
        clc

;	TAX
	LDA #>font
;	BCC .pushCharPtr
;	LDA #>font + 1
;.pushCharPtr
	PHA
        lda (textPtr),y ; 19
;        ASL
;	TXA
;        LDX temp
	adc #1 ;tsin4bBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF


	IF WHOLE_FONT == 1
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr2
	LDA #>font + 1

.pushCharPtr2
	PHA
	TXA
        LDX temp
        clc
	adc tsin4aBank5,x  ; y va de 0 a 195, 
	PHA   
        dey

	ELSE
;	TAX
	LDA #>font
;	BCC .pushCharPtr3
;	LDA #>font + 1
;.pushCharPtr3
	PHA
        lda (textPtr),y ; 19
;        ASL
;	TXA
        LDX temp
	adc tsin4aBank5,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF

	dex
        STX temp
        cpx PhaseDiv2
        bne .loopGenerate2Bank5
        bit 0
.endGenerateBank5
        ldx tempStack
        txs

	LDA Phase
        AND #1
        BNE .doNotPatchBank5
	INC Char1
	INC Char1 + 4
	INC Char1 + 8
	INC Char1 + 12
	INC Char1 + 16
	INC Char1 + 20
	RET_MAGI_CALL
.doNotPatchBank5
	JSR Lose12CyclesX4 ; change selon la bank
        JSR Lose12CyclesX4
	INC Char1 - 1 ; attention
	RET_MAGI_CALL
    
.loopGenerateBisBank5
	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr3
	LDA #>font + 1

.pushCharPtr3
	PHA
	TXA
        clc
        LDX temp
	adc tsin4aBank5,x  ; y va de 0 a 195, 
;        adc #1
	PHA   
        dey

        ELSE
        
      
        clc
; si on stocke le numchar * 4 au lieu de * 8
; un ASL met la carry a 1 et on sait qu'on pioche 256 bytes plus loin
; ca vaut si la fonte est alignee

;	TAX
	LDA #>font
;	BCC .pushCharPtr2
;	LDA #>font + 1
;.pushCharPtr2
	PHA
;	TXA
        lda (textPtr),y ; 19
        LDX temp
	adc tsin4aBank5,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF



	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
;        inx
	LDA #>font
	BCC .pushCharPtr4
	LDA #>font + 1

.pushCharPtr4
	PHA
	TXA
        clc
        adc #1
        NOP
	PHA   
        dey
	LDX temp
        ELSE
;	TAX
	LDA #>font
;	BCC .pushCharPtr4
;	LDA #>font + 1
;.pushCharPtr4
	PHA
        lda (textPtr),y ; 19
;	TXA
;        LDX temp
	adc #1 ;tsin4bBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF

	dex
        STX temp
        cpx PhaseDiv2
        bne .loopGenerateBisBank5
        
        jmp .endGenerateBank5
    

tsin4aBank5
     .byte 1,0,1,0,1,0,1,0
tsin4bBank5
	.byte 1,1,1,1,1,1,1,1
        
        echo "ROM left bank 5: ", ($Bff4 - *)

        org $5FF4
        RORG    $BFF4
        .byte 0,0,0,0,0,0
        org $5FFA
        RORG    $BFFA

        .word 0          ; NMI
        .word $B000      ; RESET
        .word $B000      ; BRK


        ORG     $6000
        RORG    $D000
Bank6   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE

Lose25CyclesX5
	.byte $82
Lose24CyclesX5
	.byte $82
Lose23CyclesX5
	.byte $82
Lose22CyclesX5
	.byte $82
Lose21CyclesX5
	.byte $82
Lose20CyclesX5
	.byte $82
Lose19CyclesX5
	.byte $82
Lose18CyclesX5
	.byte $82
Lose17CyclesX5
	.byte $82
Lose16CyclesX5
        .byte $82 ; Nop imm 2
Lose15CyclesX5
        .byte $44 ; Nop zp 3
Lose14CyclesX5
        .byte $EA ; Nop
Lose12CyclesX5
	RTS

; pour les sprites en utilisant le mirror sur GRP1 on peut utiliser la meme valeur
; que GRP0 (economiser un LDA imm)

finish_screen5

    LDA #$0
    STA COLUBK
    LDA #0
    STA PF0
    STA PF1
    STA PF2
    STA ENAM1
    STA GRP1
    STA WSYNC
    
    BANK_SWITCH 0, ReturnDisplaySplitRaster




;	align 256
;        nop
;	align 128
EmptyLine0X5
    LDY BACKGROUND_COLOR_LINE_0
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_1
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_2
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_3
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_4
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_5
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_6
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_7
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_8
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_9
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_10
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_11
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_12
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_13
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_14
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_15
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_16
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_17
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_18
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_19
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_20
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_21
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_22
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_23
    BCS EmptyLineX5
    LDY BACKGROUND_COLOR_LINE_24
    BCS EmptyLineX5


LoopEmptyLineX5
    pha
    pla
    nop
    nop
EmptyLineX5
    LDX #0
    STX PF0
    STX PF1
    STX PF2
    STX COLUBK

;    STX GRP0
    STX GRP1
    ADC Y_DIVIDER_ZP
    PHA
    PLA
    nop
    nop
    STY COLUBK
    JSR Lose25CyclesX5
    STX COLUBK

    BCC LoopEmptyLineX5
    RTS


        ;ALIGN_LINE_ROUTINE 1,loop_line0,"loop_line0"

loop_line0X5
; compensation du RTS (1 cycle de moins car un cycle de plus pour le branchement)
    NOP3 ; NOP si on traverse une page, sinon NOP3
    NOP
    
line0_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line0PF0X5,Y
        STX PF0
        LDX Step0Line0PF1X5,Y
        STX PF1
        LDX Step0Line0PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
       
        LDY BACKGROUND_COLOR_LINE_0
        STY COLUBK
        JSR Lose20CyclesX5
        
        ADC Y_DIVIDER_ZP
	LDX #0
        STX COLUBK

        bcc loop_line0X5
        rts

        ;ALIGN_LINE_ROUTINE 1,loop_line1,"loop_line1"
loop_line1X5
    NOP
    nop

line1_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line1PF0X5,Y
        STX PF0
        LDX Step0Line1PF1X5,Y
        STX PF1
        LDX Step0Line1PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        

	LDY BACKGROUND_COLOR_LINE_1
        STY COLUBK
        JSR Lose15CyclesX5
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUBK
	LDX #0
        STX COLUBK
        bcc loop_line1X5
        RTS

    
	NOP
        NOP
        NOP
        
loop_line2X5
    NOP3
    nop

line2_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line2PF0X5,Y
        STX PF0
        LDX Step0Line2PF1X5,Y
        STX PF1
        LDX Step0Line2PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_2

	STY COLUBK
        ADC Y_DIVIDER_ZP
	NOP
        LDX #COLOR_WHITE
        STX COLUBK
        NOP
        NOP3
        LDX #COLOR_RED
        STY COLUBK
        STX COLUBK
	LDX #0
        STX COLUBK
        
        bcc loop_line2X5
        RTS


loop_line3X5
    nop3
    nop

line3_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line3PF0X5,Y
        STX PF0
        LDX Step0Line3PF1X5,Y
        STX PF1
        LDX Step0Line3PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_3

	STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        PHA
        PLA
        NOP
        NOP
        STY COLUBK
	LDX #0
        STX COLUBK

	bcc loop_line3X5
        RTS

	NOP
        NOP
; haut masque
loop_line4X5
    nop3
    nop

line4_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line4PF0X5,Y
        STX PF0
        LDX Step0Line4PF1X5,Y
        STX PF1
        LDX Step0Line4PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_4

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
        NOP3
        NOP
        NOP
        STX COLUBK
	ADC Y_DIVIDER_ZP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line4X5
	RTS


; haut oeil
loop_line5X5
    nop3
    nop

line5_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line5PF0X5,Y
        STX PF0
        LDX Step0Line5PF1X5,Y
        STX PF1
        LDX Step0Line5PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_5
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line5X5
	RTS

	NOP
; milieu oeil
loop_line6X5
    nop
    nop

line6_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line6PF0X5,Y
        STX PF0
        LDX Step0Line6PF1X5,Y
        STX PF1
        LDX Step0Line6PF2X5,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_6
        
	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line6X5
        RTS

	NOP
; bas oeil
loop_line7X5
    nop3
    nop

line7_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line7PF0X5,Y
        STX PF0
        LDX Step0Line7PF1X5,Y
        STX PF1
        LDX Step0Line7PF2X5,Y
        STX PF2 ; 24
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_7

	STY COLUBK
        LDX #$FF
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP3
        NOP
        STX COLUBK
        NOP
	STY COLUBK
        LDX #0
        STX COLUBK
         
    	bcc loop_line7X5
    	RTS

	nop
; bas masque
loop_line8X5
    nop3
    nop

line8_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line8PF0X5,Y
        STX PF0
        LDX Step0Line8PF1X5,Y
        STX PF1
        LDX Step0Line8PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_8

	STY COLUBK
        LDX #$7F
        STX GRP1
        LDX #COLOR_WHITE
	ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        STX GRP1
	STY COLUBK
        NOP
        STX COLUBK

	bcc loop_line8X5
    	RTS

	NOP
; sous le masque
loop_line9X5
	nop3
        nop

line9_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line9PF0X5,Y
        STX PF0
        LDX Step0Line9PF1X5,Y
        STX PF1
        LDX Step0Line9PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
	LDY BACKGROUND_COLOR_LINE_9

	STY COLUBK
        nop
    	LDX COLOR_WHITE_BYTE
	STX COLUBK
        NOP
        NOP3
	nop
    	ADC Y_DIVIDER_ZP
        LDX #0
    	STY COLUBK
    	nop
    	STX COLUBK
        bcc loop_line9X5
        RTS

	NOP
        NOP
; separation tete corps
loop_line10X5
    nop3
    nop

line10_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line10PF0X5,Y
        STX PF0
        LDX Step0Line10PF1X5,Y
        STX PF1
        LDX Step0Line10PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_10
        
        STY COLUBK
        LDX COLOR_WHITE_BYTE
        nop
        STX COLUBK
    ; prepare le missile pour le bras
        STX COLUP1
        nop3
        nop3
        ADC Y_DIVIDER_ZP
        STY COLUBK
        LDX #0
        STX COLUBK
        
        bcc loop_line10X5
        RTS

	nop
        nop
        nop
; on decale de deux cycles vers la droite
; haut du deuxieme bras
loop_line11X5
    nop ; nop pour page boundary cross - 2

line11_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
       LDX Step0Line11PF0X5,Y
;	LDX #0
;        NOP
        STX PF0
        LDX Step0Line11PF1X5,Y
;	LDX #0
;        NOP
        STX PF1
        LDX Step0Line11PF2X5,Y
;	LDX #0
;        NOP
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y         
        LDY BACKGROUND_COLOR_LINE_11

	STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX ENAM1
        STX COLUP1
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_line11X5
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_line12,"loop_line12"

; on reprend les 2 cycles
; juste au dessus de la ceinture
loop_line12X5
    nop3
    nop
    nop

line12_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y
        LDX Step0Line12PF0X5,Y
        STX PF0
        LDX Step0Line12PF1X5,Y
        STX PF1
        LDX Step0Line12PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12
        
	STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX #COLOR_WHITE
        NOP
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK

	bcc loop_line12X5
        RTS

	NOP
        NOP
        NOP
        NOP
        
; un cycle de moins ici, decale a gauche
loop_line13X5
    nop
    nop
    
line13_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line13PF0X5,Y
        STX PF0
        LDX Step0Line13PF1X5,Y
        STX PF1
        LDX Step0Line13PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        NOP3
        STX COLUBK
        LDX #0
        STX ENAM1
        ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        STX COLUBK
        STY COLUBK
        LDX #0
        STX COLUBK

	bcc loop_line13X5
    	RTS


loop_line14X5
    nop3
    nop

line14_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line14PF0X5,Y
        STX PF0
        LDX Step0Line14PF1X5,Y
        STX PF1
        LDX Step0Line14PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX #COLOR_VEST
        LDY #COLOR_RED
        STX COLUBK
        nop
        nop
        ADC Y_DIVIDER_ZP
        STY COLUBK    
        LDY BACKGROUND_COLOR_LINE_14
        STY COLUBK
        LDX #0
        STX COLUBK

        bcc loop_line14X5
        RTS


loop_line15X5
    nop3
    nop

line15_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line15PF0X5,Y
        STX PF0
        LDX Step0Line15PF1X5,Y
        STX PF1
        LDX Step0Line15PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_VEST
        LDY #COLOR_RED
        STX COLUBK - COLOR_RED,Y
        NOP
        ADC Y_DIVIDER_ZP
        STY COLUBK ; - COLOR_VEST,X    
        LDY BACKGROUND_COLOR_LINE_15
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
	bcc loop_line15X5
    	RTS

	NOP
loop_line16X5
    nop
    nop

line16_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line16PF0X5,Y
        STX PF0
        LDX Step0Line16PF1X5,Y
        STX PF1
        LDX Step0Line16PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        LDX #COLOR_WHITE
        nop
        STX COLUBK
        nop
        nop
        ADC Y_DIVIDER_ZP
        NOP3
        STY COLUBK
        NOP3
        LDX #0
        STX COLUBK

        bcc loop_line16X5
        RTS


loop_line17X5
    nop3
    nop

line17_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line17PF0X5,Y
        STX PF0
        LDX Step0Line17PF1X5,Y
        STX PF1
        LDX Step0Line17PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        STY COLUBK
        JSR Lose17CyclesX5
        ADC Y_DIVIDER_ZP
        LDX #0
        STY COLUBK
        STX COLUBK
        bcc loop_line17X5
        RTS

        nop
        nop
        nop
        nop
        ;ALIGN_LINE_ROUTINE 1,loop_line18,"loop_line18"
loop_line18X5
    nop3
    nop

line18_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line18PF0X5,Y
        STX PF0
        LDX Step0Line18PF1X5,Y
        STX PF1
        LDX Step0Line18PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        STY COLUBK
        LDX #COLOR_RED
        STX COLUBK
        ADC Y_DIVIDER_ZP
        STY COLUBK - COLOR_RED,X
        STX COLUBK
        nop
        nop
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        bcc loop_line18X5
        RTS

        NOP
        NOP
        ;ALIGN_LINE_ROUTINE 1,loop_line19,"loop_line19"
loop_line19X5
    nop3
    nop

line19_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step0Line19PF0X5,Y
        STX PF0
        LDX Step0Line19PF1X5,Y
        STX PF1
        LDX Step0Line19PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX5
        LDX #0
        STX COLUBK
        bcc loop_line19X5
        RTS

	nop
        nop
	nop
        nop
	nop
        nop
        ;ALIGN_LINE_ROUTINE 1,loop_step3line12,"loop_step3line12"

; haut du deuxieme bras
loop_step3line12X5
    nop3
    nop

step3line12_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line12PF0X5,Y
        STX PF0
        LDX Step3Line12PF1X5,Y
        STX PF1
        LDX Step3Line12PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_step3line12X5
        RTS

	ALIGN 64
; on regagne deux cycles qu'on a perdus en ligne 11
loop_step3line13X5
    nop3
    nop
    nop

step3line13_generatedX5

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line13PF0X5,Y
        STX PF0
        LDX Step3Line13PF1X5,Y
        STX PF1
        LDX Step3Line13PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

	STY COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        STX COLUP1
        LDX #COLOR_WHITE
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line13X5
        RTS

	NOP
;	ALIGN 32
loop_step3line14X5
	LDX #COLOR_RED
        STX COLUP1

step3line14_generatedX5

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line14PF0X5,Y
        STX PF0
        LDX Step3Line14PF1X5,Y
        STX PF1
        LDX Step3Line14PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        LDX COLOR_VEST_BYTE
        STX COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK

        bcc loop_step3line14X5
        RTS

	NOP
loop_step3line15X5
        LDX #0
        STX ENAM1

step3line15_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line15PF0X5,Y
        STX PF0
        LDX Step3Line15PF1X5,Y
        STX PF1
        LDX Step3Line15PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop
        nop
        STX COLUBK
        STY COLUBK - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line15X5
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_step3line16,"loop_step3line16"

loop_step3line16X5
    nop3
    nop

step3line16_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line16PF0X5,Y
        STX PF0
        LDX Step3Line16PF1X5,Y
        STX PF1
        LDX Step3Line16PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        LDX #COLOR_RED
        NOP
        NOP
        NOP
        STX COLUBK
        STY COLUBK; - COLOR_RED,X
        LDX #0
        STX COLUBK

        bcc loop_step3line16X5
        RTS

	nop
loop_step3line17X5
    nop3
    nop

step3line17_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line17PF0X5,Y
        STX PF0
        LDX Step3Line17PF1X5,Y
        STX PF1
        LDX Step3Line17PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17

        STY COLUBK
        LDX COLOR_WHITE_BYTE
        ADC Y_DIVIDER_ZP
        nop
        nop3
        STX COLUBK
        nop
        nop
        STY COLUBK
        nop
        LDX #0
        STX COLUBK

        bcc loop_step3line17X5
        RTS

	NOP
        
loop_step3line18X5
    nop3
    nop

step3line18_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line18PF0X5,Y
        STX PF0
        LDX Step3Line18PF1X5,Y
        STX PF1
        LDX Step3Line18PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18

        STY COLUBK
        LDX COLOR_RED_BYTE
        ADC Y_DIVIDER_ZP
        STX COLUBK
        nop
        STY COLUBK
        nop3
        nop
        nop
        nop
        LDX #0
        STX COLUBK

        bcc loop_step3line18X5
        RTS

	NOP
        
loop_step3line19X5
    nop3
    nop

step3line19_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line19PF0X5,Y
        STX PF0
        LDX Step3Line19PF1X5,Y
        STX PF1
        LDX Step3Line19PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
        nop
        NOP
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        nop
        nop
        STX COLUBK
        
        bcc loop_step3line19X5
        RTS

	NOP
        
loop_step3line20X5
    nop3 ;.byte $44,0 ; nop zp
    nop

step3line20_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step3Line20PF0X5,Y
        STX PF0
        LDX Step3Line20PF1X5,Y
        STX PF1
        LDX Step3Line20PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX5
        LDX #0
        STX COLUBK
        bcc loop_step3line20X5
        RTS
    

loop_step1line13X5
    nop3
    nop

step1line13_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line13PF0X5,Y
        STX PF0
        LDX Step1Line13PF1X5,Y
        STX PF1
        LDX Step1Line13PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_13

        STY COLUBK
        LDX #COLOR_BELT
        nop
        STX COLUBK
        ADC Y_DIVIDER_ZP
        nop
        nop
        LDX #COLOR_WHITE
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_step1line13X5
        RTS

	NOP
; haut du deuxieme bras
loop_step1line14X5
        NOP3
        NOP

step1line14_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line14PF0X5,Y
        STX PF0
        LDX Step1Line14PF1X5,Y
        STX PF1
        LDX Step1Line14PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_14

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        nop3
	nop
        STX COLUBK
        STY COLUBK 
        LDX #0
        STX COLUBK

        bcc loop_step1line14X5
        RTS

	ALIGN 16
loop_step1line15X5
    STX ENAM1
    nop

step1line15_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line15PF0X5,Y
        STX PF0
        LDX Step1Line15PF1X5,Y
        STX PF1
        LDX Step1Line15PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_15

        STY COLUBK
        nop
        LDX #COLOR_VEST
        STX COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
	nop3
        STX COLUBK
        nop
        STY COLUBK 
        LDX #0
        STX COLUBK

	bcc loop_step1line15X5
        RTS

; la on regagne les deux cycles qu'on avait perdus en ligne 11
loop_step1line16X5
    nop3
    nop
        NOP

step1line16_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line16PF0X5,Y
        STX PF0
        LDX Step1Line16PF1X5,Y
        STX PF1
        LDX Step1Line16PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_16
        
        STY COLUBK
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        STY COLUBK
        nop
        nop
        STX COLUBK
        
        bcc loop_step1line16X5
        RTS

	NOP
loop_step1line17X5
    nop3
    nop

step1line17_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line17PF0X5,Y
        STX PF0
        LDX Step1Line17PF1X5,Y
        STX PF1
        LDX Step1Line17PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        LDX COLOR_WHITE_BYTE
        STX COLUBK
        NOP3
        STY COLUBK
        NOP
        NOP
        nop
        LDX #0
        nop
        STX COLUBK
        
        bcc loop_step1line17X5
        RTS

	NOP
loop_step1line18X5
    nop3
    nop

step1line18_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line18PF0X5,Y
        STX PF0
        LDX Step1Line18PF1X5,Y
        STX PF1
        LDX Step1Line18PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        LDX COLOR_BLACK_BYTE
        STX ENAM1
        LDX #COLOR_RED
        STX COLUBK
        nop3
        STY COLUBK
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
        bcc loop_step1line18X5
        RTS


loop_step1line19X5
    nop3
    nop

step1line19_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line19PF0X5,Y
        STX PF0
        LDX Step1Line19PF1X5,Y
        STX PF1
        LDX Step1Line19PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_19
        
        STY COLUBK
        NOP
        LDX #COLOR_RED
        STX COLUBK
        nop
        nop
        STY COLUBK
        ADC Y_DIVIDER_ZP
        nop
        nop
        nop
        LDX #0
        STX COLUBK
        
        bcc loop_step1line19X5
        RTS

        ;ALIGN_LINE_ROUTINE 1,loop_step1line20,"loop_step1line20"

	NOP
        
loop_step1line20X5
    nop
    nop

step1line20_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step1Line20PF0X5,Y
        STX PF0
        LDX Step1Line20PF1X5,Y
        STX PF1
        LDX Step1Line20PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y        
        LDY BACKGROUND_COLOR_LINE_20
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX5
        LDX #0
        STX COLUBK
        bcc loop_step1line20X5
        RTS

	NOP
        NOP

; haut du deuxieme bras
; on perd deux cycles comme en step0 ligne 11 (comme les autres step anims dans cette bank)
loop_step2line11X5
    nop3
;	nop

step2line11_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line11PF0X5,Y
;        LDX #0
;        NOP
        STX PF0
        LDX Step2Line11PF1X5,Y
;        LDX #0
 ;       NOP
        STX PF1
        LDX Step2Line11PF2X5,Y
;        LDX #0
;        NOP

        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_11
        
        STY COLUBK
        LDX #COLOR_VEST
        ADC Y_DIVIDER_ZP
        STX COLUBK
        LDX #COLOR_WHITE
        STX ENAM1
        NOP
        NOP
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX COLOR_BLACK_BYTE
        STX COLUBK
        
        bcc loop_step2line11X5
        RTS

; on reprend un cycle ?
; haut du deuxieme bras
loop_step2line12X5
        LDX #COLOR_RED
	STX COLUP1

step2line12_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line12PF0X5,Y
;        LDX #0
;        NOP

        STX PF0
        LDX Step2Line12PF1X5,Y
;        LDX #0
;        NOP

        STX PF1
        LDX Step2Line12PF2X5,Y
;        LDX #0
;        NOP

        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_12

        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
	ADC Y_DIVIDER_ZP
        LDX #COLOR_WHITE
        NOP
        nop
    nop
        STX COLUBK
        STY COLUBK - COLOR_WHITE,X
        LDX #0
        STX COLUBK

        bcc loop_step2line12X5
        RTS

	NOP
        NOP
; 2eme main
loop_step2line13X5
        NOP3
    nop ;.byte $44,0 ; nop zp


step2line13_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line13PF0X5,Y
        STX PF0
        LDX Step2Line13PF1X5,Y
        STX PF1
        LDX Step2Line13PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_13
        
        STY COLUBK
        LDX #COLOR_BELT
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        nop
        NOP
        LDX #COLOR_WHITE
        STX COLUBK
        LDX COLOR_BLACK_BYTE
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line13X5
        RTS

	NOP
        NOP
        
loop_step2line14X5
    nop3
    nop

step2line14_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line14PF0X5,Y
        STX PF0
        LDX Step2Line14PF1X5,Y
        STX PF1
        LDX Step2Line14PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_14
        
        STY COLUBK
        LDX #COLOR_VEST
        STX COLUBK
        LDX #0
        STX ENAM1
        ADC Y_DIVIDER_ZP
        LDX #COLOR_RED
        NOP
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK
        
        bcc loop_step2line14X5
        RTS

	NOP

loop_step2line15X5
    nop
    nop

step2line15_generatedX5

	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line15PF0X5,Y
        STX PF0
        LDX Step2Line15PF1X5,Y
        STX PF1
        LDX Step2Line15PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_15
        
        STY COLUBK
        LDX #COLOR_VEST
        NOP3
        STX COLUBK
        ADC Y_DIVIDER_ZP
        NOP
        NOP
        LDX #COLOR_RED
        STX COLUBK
        LDX #0
        STY COLUBK
        STX COLUBK        
        
        bcc loop_step2line15X5
        RTS

; on reprend les deux cycles
loop_step2line16X5
    nop3
    nop
        NOP

step2line16_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line16PF0X5,Y
        STX PF0
        LDX Step2Line16PF1X5,Y
        STX PF1
        LDX Step2Line16PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_16

        STY COLUBK
        LDX #COLOR_WHITE
        ADC Y_DIVIDER_ZP
        STX COLUBK
        NOP        
        NOP
        NOP
        NOP
        STY COLUBK
        NOP
        LDX #0
        STX COLUBK

        bcc loop_step2line16X5
        RTS

	NOP
        NOP

loop_step2line17X5
    nop3
    nop

step2line17_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line17PF0X5,Y
        STX PF0
        LDX Step2Line17PF1X5,Y
        STX PF1
        LDX Step2Line17PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_17
        
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX5
        LDX #0
        STX COLUBK

	bcc loop_step2line17X5
        RTS
        
    ds 10,0
loop_step2line18X5
    nop3
    nop

step2line18_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line18PF0X5,Y
        STX PF0
        LDX Step2Line18PF1X5,Y
        STX PF1
        LDX Step2Line18PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_18
        
        STY COLUBK
        LDX #COLOR_RED
        ADC Y_DIVIDER_ZP
        NOP
        STX COLUBK
        LDX #0
        NOP
        NOP
        STY COLUBK
        NOP
        NOP
        NOP        
        STX COLUBK
        
        bcc loop_step2line18X5
        RTS
        
	NOP
        
loop_step2line19X5
    nop3
    nop

step2line19_generatedX5
	LDY X_POS
        ORA (PF_BANK_SWITCHER),Y        
        LDX Step2Line19PF0X5,Y
        STX PF0
        LDX Step2Line19PF1X5,Y
        STX PF1
        LDX Step2Line19PF2X5,Y
        STX PF2
        ORA (COLOR_BANK_SWITCHER),Y
        LDY BACKGROUND_COLOR_LINE_19
        STY COLUBK
        ADC Y_DIVIDER_ZP
        JSR Lose20CyclesX5
        LDX #0
        STX COLUBK
        bcc loop_step2line19X5
        RTS




    ALIGN 8
Step0Line0PF0X5 .byte $00,$30,$80,$00,$00,$00,#$00,#$00
Step0Line0PF1X5 .byte $00,$00,$80,$30,$06,$00,#$00,#$00
Step0Line0PF2X5 .byte $60,$00,$00,$00,$00,$03,#$00,#$00
Step0Line1PF0X5 .byte $00,$40,$40,$30,$F0,$80,#$00,#$00
Step0Line1PF1X5 .byte $0F,$01,$40,$48,$89,$F1,#$00,#$00
Step0Line1PF2X5 .byte $91,$8F,$7C,$E0,$00,$04,#$00,#$00
Step0Line2PF0X5 .byte $00,$40,$50,$C0,$00,$60,#$00,#$00
Step0Line2PF1X5 .byte $30,$06,$40,$48,$69,$0D,#$00,#$00
Step0Line2PF2X5 .byte $96,$B0,$83,$18,$C0,$04,#$00,#$00
Step0Line3PF0X5 .byte $00,$30,$E0,$00,$00,$10,#$00,#$00
Step0Line3PF1X5 .byte $40,$08,$81,$F0,$1E,$03,#$00,#$00
Step0Line3PF2X5 .byte $78,$C0,$00,$04,$20,$03,#$00,#$00
Step0Line4PF0X5 .byte $00,$00,$40,$00,$00,$00,#$00,#$00
Step0Line4PF1X5 .byte $80,$10,$02,$40,$08,$01,#$00,#$00
Step0Line4PF2X5 .byte $10,$80,$00,$02,$10,$80,#$00,#$00
Step0Line5PF0X5 .byte $00,$00,$40,$00,$40,$20,#$00,#$00
Step0Line5PF1X5 .byte $A2,$14,$02,$40,$08,$41,#$00,#$00
Step0Line5PF2X5 .byte $10,$82,$11,$8A,$50,$80,#$00,#$00
Step0Line6PF0X5 .byte $00,$00,$40,$00,$40,$20,#$00,#$00
Step0Line6PF1X5 .byte $A2,$14,$02,$40,$08,$41,#$00,#$00
Step0Line6PF2X5 .byte $10,$82,$11,$8A,$50,$80,#$00,#$00
Step0Line7PF0X5 .byte $00,$00,$40,$00,$40,$20,#$00,#$00
Step0Line7PF1X5 .byte $A2,$14,$02,$40,$08,$41,#$00,#$00
Step0Line7PF2X5 .byte $10,$82,$11,$8A,$50,$80,#$00,#$00
Step0Line8PF0X5 .byte $00,$00,$40,$00,$00,$00,#$00,#$00
Step0Line8PF1X5 .byte $80,$10,$02,$40,$08,$01,#$00,#$00
Step0Line8PF2X5 .byte $10,$80,$00,$02,$10,$80,#$00,#$00
Step0Line9PF0X5 .byte $00,$00,$60,$00,$00,$10,#$00,#$00
Step0Line9PF1X5 .byte $C0,$18,$03,$C0,$18,$03,#$00,#$00
Step0Line9PF2X5 .byte $18,$C0,$00,$06,$30,$80,#$00,#$00
Step0Line10PF0X5 .byte $00,$00,$50,$F0,$F0,$F0,#$00,#$00
Step0Line10PF1X5 .byte $FF,$1F,$03,$40,$E8,$FD,#$00,#$00
Step0Line10PF2X5 .byte $17,$BF,$FF,$FE,$F0,$80,#$00,#$00
Step0Line11PF0X5 .byte $80,$10,$90,$80,$00,$10,#$00,#$00
Step0Line11PF1X5 .byte $40,$28,$05,$20,$24,$04,#$00,#$00
Step0Line11PF2X5 .byte $24,$20,$00,$05,$28,$41,#$00,#$00
Step0Line12PF0X5 .byte $80,$10,$80,$40,$00,$10,#$00,#$00
Step0Line12PF1X5 .byte $40,$28,$05,$20,$44,$08,#$00,#$00
Step0Line12PF2X5 .byte $22,$10,$80,$05,$28,$41,#$00,#$00
Step0Line13PF0X5 .byte $00,$00,$50,$F0,$C0,$30,#$00,#$00
Step0Line13PF1X5 .byte $E3,$1C,$03,$40,$E8,$7D,#$00,#$00
Step0Line13PF2X5 .byte $17,$BE,$F1,$8E,$70,$80,#$00,#$00
Step0Line14PF0X5 .byte $00,$00,$60,$20,$00,$10,#$00,#$00
Step0Line14PF1X5 .byte $C0,$18,$03,$C0,$98,$13,#$00,#$00
Step0Line14PF2X5 .byte $19,$C8,$40,$06,$30,$80,#$00,#$00
Step0Line15PF0X5 .byte $00,$00,$20,$70,$80,$30,#$00,#$00
Step0Line15PF1X5 .byte $61,$0C,$01,$80,$D0,$3A,#$00,#$00
Step0Line15PF2X5 .byte $0B,$5C,$E1,$0C,$60,$00,#$00,#$00
Step0Line16PF0X5 .byte $00,$00,$10,$80,$70,$C0,#$00,#$00
Step0Line16PF1X5 .byte $9E,$13,$02,$00,$20,$C4,#$00,#$00
Step0Line16PF2X5 .byte $04,$23,$1E,$F2,$90,$80,#$00,#$00
Step0Line17PF0X5 .byte $80,$00,$10,$F0,$D0,$F0,#$00,#$00
Step0Line17PF1X5 .byte $FB,$3F,$07,$00,$E0,$7C,#$00,#$00
Step0Line17PF2X5 .byte $07,$3E,$F7,$BF,$F8,$C0,#$00,#$00
Step0Line18PF0X5 .byte $80,$00,$20,$00,$50,$80,#$00,#$00
Step0Line18PF1X5 .byte $0A,$21,$04,$80,$10,$42,#$00,#$00
Step0Line18PF2X5 .byte $08,$42,$14,$A1,$08,$40,#$00,#$00
Step0Line19PF0X5 .byte $00,$00,$30,$F0,$D0,$F0,#$00,#$00
Step0Line19PF1X5 .byte $FB,$1F,$03,$80,$F0,$7E,#$00,#$00
Step0Line19PF2X5 .byte $0F,$7E,$F7,$BE,$F0,$80,#$00,#$00

Step1Line11PF0X5 .byte $80,$10,$90,$80,$00,$10,#$00,#$00
Step1Line11PF1X5 .byte $40,$28,$05,$20,$24,$04,#$00,#$00
Step1Line11PF2X5 .byte $24,$20,$00,$05,$28,$41,#$00,#$00
Step1Line12PF0X5 .byte $80,$10,$90,$80,$00,$10,#$00,#$00
Step1Line12PF1X5 .byte $40,$28,$05,$20,$24,$04,#$00,#$00
Step1Line12PF2X5 .byte $24,$20,$00,$05,$28,$41,#$00,#$00
Step1Line13PF0X5 .byte $80,$10,$D0,$F0,$C0,$30,#$00,#$00
Step1Line13PF1X5 .byte $E3,$3C,$07,$60,$EC,$7D,#$00,#$00
Step1Line13PF2X5 .byte $37,$BE,$F1,$8F,$78,$C1,#$00,#$00
Step1Line14PF0X5 .byte $80,$10,$B0,$80,$00,$10,#$00,#$00
Step1Line14PF1X5 .byte $C0,$38,$07,$A0,$34,$06,#$00,#$00
Step1Line14PF2X5 .byte $2C,$60,$00,$07,$38,$C1,#$00,#$00
Step1Line15PF0X5 .byte $00,$10,$90,$F0,$80,$70,#$00,#$00
Step1Line15PF1X5 .byte $F1,$1E,$03,$20,$E4,$3C,#$00,#$00
Step1Line15PF2X5 .byte $27,$3C,$E3,$1E,$F0,$81,#$00,#$00
Step1Line16PF0X5 .byte $00,$00,$70,$80,$70,$90,#$00,#$00
Step1Line16PF1X5 .byte $4E,$09,$01,$C0,$38,$C7,#$00,#$00
Step1Line16PF2X5 .byte $1C,$E3,$1C,$E4,$20,$00,#$00,#$00
Step1Line17PF0X5 .byte $00,$00,$10,$F0,$E0,$10,#$00,#$00
Step1Line17PF1X5 .byte $47,$08,$01,$00,$E0,$FC,#$00,#$00
Step1Line17PF2X5 .byte $07,$3F,$F8,$C4,$20,$00,#$00,#$00
Step1Line18PF0X5 .byte $00,$00,$20,$00,$70,$F0,#$00,#$00
Step1Line18PF1X5 .byte $7E,$0F,$01,$80,$10,$C2,#$00,#$00
Step1Line18PF2X5 .byte $08,$43,$1F,$FC,$E0,$00,#$00,#$00
Step1Line19PF0X5 .byte $00,$00,$30,$F0,$E0,$00,#$00,#$00
Step1Line19PF1X5 .byte $87,$10,$02,$80,$F0,$FE,#$00,#$00
Step1Line19PF2X5 .byte $0F,$7F,$F8,$C2,$10,$80,#$00,#$00
Step1Line20PF0X5 .byte $00,$00,$00,$00,$30,$F0,#$00,#$00
Step1Line20PF1X5 .byte $FC,$1F,$03,$00,$00,$80,#$00,#$00
Step1Line20PF2X5 .byte $00,$01,$0F,$7E,$F0,$80,#$00,#$00

Step2Line11PF0X5 .byte $80,$00,$40,$40,$00,$10,#$00,#$00
Step2Line11PF1X5 .byte $40,$28,$05,$40,$48,$09,#$00,#$00
Step2Line11PF2X5 .byte $12,$90,$80,$05,$28,$40,#$00,#$00
Step2Line12PF0X5 .byte $C0,$10,$90,$80,$00,$10,#$00,#$00
Step2Line12PF1X5 .byte $C0,$78,$0F,$21,$24,$04,#$00,#$00
Step2Line12PF2X5 .byte $24,$20,$00,$07,$3C,$E1,#$00,#$00
Step2Line13PF0X5 .byte $40,$30,$90,$F0,$C0,$30,#$00,#$00
Step2Line13PF1X5 .byte $63,$4C,$89,$31,$E6,$7C,#$00,#$00
Step2Line13PF2X5 .byte $67,$3E,$F1,$8C,$64,$23,#$00,#$00
Step2Line14PF0X5 .byte $C0,$20,$70,$80,$00,$10,#$00,#$00
Step2Line14PF1X5 .byte $C0,$78,$8F,$D1,$3A,$07,#$00,#$00
Step2Line14PF2X5 .byte $5C,$E0,$00,$07,$3C,$E2,#$00,#$00
Step2Line15PF0X5 .byte $00,$20,$30,$F0,$C0,$70,#$00,#$00
Step2Line15PF1X5 .byte $73,$0E,$81,$90,$F2,$7E,#$00,#$00
Step2Line15PF2X5 .byte $4F,$7E,$F3,$9C,$E0,$02,#$00,#$00
Step2Line16PF0X5 .byte $00,$10,$D0,$C0,$30,$A0,#$00,#$00
Step2Line16PF1X5 .byte $2C,$05,$00,$60,$6C,$8D,#$00,#$00
Step2Line16PF2X5 .byte $36,$B1,$8D,$68,$40,$01,#$00,#$00
Step2Line17PF0X5 .byte $00,$00,$00,$70,$F0,$E0,#$00,#$00
Step2Line17PF1X5 .byte $3F,$07,$00,$00,$C0,$F8,#$00,#$00
Step2Line17PF2X5 .byte $03,$1F,$FF,$F8,$C0,$00,#$00,#$00
Step2Line18PF0X5 .byte $00,$00,$00,$40,$10,$A0,#$00,#$00
Step2Line18PF1X5 .byte $28,$05,$00,$00,$40,$08,#$00,#$00
Step2Line18PF2X5 .byte $02,$10,$85,$28,$40,$00,#$00,#$00
Step2Line19PF0X5 .byte $00,$00,$00,$70,$F0,$C0,#$00,#$00
Step2Line19PF1X5 .byte $1F,$03,$00,$00,$C0,$F8,#$00,#$00
Step2Line19PF2X5 .byte $03,$1F,$FE,$F0,$80,$00,#$00,#$00

Step3Line11PF0X5 .byte $80,$10,$90,$80,$00,$10,#$00,#$00
Step3Line11PF1X5 .byte $40,$28,$05,$20,$24,$04,#$00,#$00
Step3Line11PF2X5 .byte $24,$20,$00,$05,$28,$41,#$00,#$00
Step3Line12PF0X5 .byte $80,$10,$90,$80,$00,$10,#$00,#$00
Step3Line12PF1X5 .byte $40,$28,$05,$20,$24,$04,#$00,#$00
Step3Line12PF2X5 .byte $24,$20,$00,$05,$28,$41,#$00,#$00
Step3Line13PF0X5 .byte $80,$10,$90,$F0,$C0,$30,#$00,#$00
Step3Line13PF1X5 .byte $E3,$3C,$07,$20,$E4,$7C,#$00,#$00
Step3Line13PF2X5 .byte $27,$3E,$F1,$8F,$78,$C1,#$00,#$00
Step3Line14PF0X5 .byte $80,$10,$B0,$C0,$00,$10,#$00,#$00
Step3Line14PF1X5 .byte $40,$28,$05,$A0,$74,$0E,#$00,#$00
Step3Line14PF2X5 .byte $2E,$70,$80,$05,$28,$41,#$00,#$00
Step3Line15PF0X5 .byte $80,$00,$40,$70,$80,$70,#$00,#$00
Step3Line15PF1X5 .byte $F1,$3E,$07,$40,$C8,$39,#$00,#$00
Step3Line15PF2X5 .byte $13,$9C,$E3,$1F,$F8,$C0,#$00,#$00
Step3Line16PF0X5 .byte $00,$00,$50,$C0,$70,$90,#$00,#$00
Step3Line16PF1X5 .byte $4E,$09,$01,$40,$68,$CD,#$00,#$00
Step3Line16PF2X5 .byte $16,$B3,$9C,$E4,$20,$00,#$00,#$00
Step3Line17PF0X5 .byte $00,$00,$30,$80,$30,$F0,#$00,#$00
Step3Line17PF1X5 .byte $7C,$0F,$01,$80,$30,$86,#$00,#$00
Step3Line17PF2X5 .byte $0C,$61,$0F,$7C,$E0,$00,#$00,#$00
Step3Line18PF0X5 .byte $00,$00,$10,$F0,$E0,$10,#$00,#$00
Step3Line18PF1X5 .byte $47,$08,$01,$00,$E0,$FC,#$00,#$00
Step3Line18PF2X5 .byte $07,$3F,$F8,$C4,$20,$00,#$00,#$00
Step3Line19PF0X5 .byte $00,$00,$10,$80,$30,$E0,#$00,#$00
Step3Line19PF1X5 .byte $3C,$07,$00,$00,$20,$84,#$00,#$00
Step3Line19PF2X5 .byte $04,$21,$0F,$78,$C0,$00,#$00,#$00
Step3Line20PF0X5 .byte $00,$00,$10,$F0,$E0,$00,#$00,#$00
Step3Line20PF1X5 .byte $07,$00,$00,$00,$E0,$FC,#$00,#$00
Step3Line20PF2X5 .byte $07,$3F,$F8,$C0,$00,$00,#$00,#$00

texte
    .byte #$00,#$04,#$08,#$0C,#$10,#$14,#$18,#$1C,#$08,#$20,#$10,#$10
    .byte #$10,#$10,#$24,#$28,#$10,#$2C,#$1C,#$30,#$34,#$04,#$10,#$38
    .byte #$10,#$10,#$10,#$10,#$10,#$10,#$10,#$10,#$10,#$10,#$10,#$10
    .byte #$10,#$28,#$10,#$3C,#$04,#$34,#$1C,#$10,#$10,#$2C,#$40,#$10
    .byte #$10,#$3C,#$04,#$44,#$48,#$4C,#$50,#$18,#$4C,#$24,#$04,#$10
    .byte #$10,#$10,#$10,#$10,#$10,#$28,#$48,#$10,#$10,#$10,#$10,#$10
    .byte #$08,#$4C,#$54,#$54,#$40,#$58,#$04,#$44,#$48,#$30,#$18,#$04
texte2
    .byte #$14,#$18,#$04,#$04,#$48,#$4C,#$44,#$14,#$08,#$10,#$48,#$1C
    .byte #$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C,#$5C
    .byte #$10,#$50,#$54,#$30,#$08,#$0C,#$10,#$3C,#$30,#$44,#$04,#$10
    .byte #$44,#$1C,#$04,#$60,#$48,#$18,#$28,#$10,#$64,#$28,#$24,#$68
    .byte #$34,#$40,#$08,#$48,#$4C,#$24,#$10,#$2C,#$40,#$48,#$04,#$08
    .byte #$54,#$28,#$34,#$04,#$18,#$08,#$10,#$5C,#$50,#$18,#$04,#$3C
    .byte #$10,#$1C,#$58,#$04,#$18,#$54,#$28,#$44,#$3C,#$04,#$18,#$08

temp equ $98 ; 2 bytes
Phase equ $8E
PhaseDiv2 equ $C6
textPtr equ $92 ; 2 bytes
tempStack equ $9A


; environ 8 lignes raster - 64 bytes
; optimise a 5.8. good
GenerateTextLineWaveBank6 SUBROUTINE
; alternative        
;   lda #$F0
;        sta HMP1
;        sta HMP0
        
        lda numLine
        clc
        adc #12
        sta numLine
        clc
        adc #11
        tay ; numChar in texte

        tsx
        stx tempStack
; on cree 12 pointeurs vers les data de fonte dans Char[12]        
        ldx #Char1+23 
        txs

	lda #12
        CLC
        ADC Phase
        lsr
        sta temp
        bcs .loopGenerateBisBank6
        
.loopGenerate2Bank6
      
; si on stocke le numchar * 4 au lieu de * 8
; un ASL met la carry a 1 et on sait qu'on pioche 256 bytes plus loin
; ca vaut si la fonte est alignee

	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr
	LDA #>font + 1

.pushCharPtr
	PHA
	TXA
        LDX temp
        clc
        adc #1
        nop
;        clc
;        adc #1
	PHA   
        dey

        ELSE
        clc

;	TAX
	LDA #>font
;	BCC .pushCharPtr
;	LDA #>font + 1
;.pushCharPtr
	PHA
        lda (textPtr),y ; 19
;        ASL
;	TXA
;        LDX temp
	adc #1 ;tsin4bBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF


	IF WHOLE_FONT == 1
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr2
	LDA #>font + 1

.pushCharPtr2
	PHA
	TXA
        LDX temp
        clc
	adc tsin4aBank6,x  ; y va de 0 a 195, 
	PHA   
        dey

	ELSE
;	TAX
	LDA #>font
;	BCC .pushCharPtr3
;	LDA #>font + 1
;.pushCharPtr3
	PHA
        lda (textPtr),y ; 19
;        ASL
;	TXA
        LDX temp
	adc tsin4aBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF

	dex
        STX temp
        cpx PhaseDiv2
        bne .loopGenerate2Bank6
        bit 0
.endGenerateBank6
        ldx tempStack
        txs

	LDA Phase
        AND #1
        BNE .doNotPatchBank6
	INC Char1
	INC Char1 + 4
	INC Char1 + 8
	INC Char1 + 12
	INC Char1 + 16
	INC Char1 + 20
	RET_MAGI_CALL
.doNotPatchBank6
	JSR Lose12CyclesX5 ; change selon la bank
        JSR Lose12CyclesX5
	INC Char1 - 1 ; attention
	RET_MAGI_CALL
    
.loopGenerateBisBank6
	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr3
	LDA #>font + 1

.pushCharPtr3
	PHA
	TXA
        clc
        LDX temp
	adc tsin4aBank6,x  ; y va de 0 a 195, 
;        adc #1
	PHA   
        dey

        ELSE
        
      
        clc
; si on stocke le numchar * 4 au lieu de * 8
; un ASL met la carry a 1 et on sait qu'on pioche 256 bytes plus loin
; ca vaut si la fonte est alignee

;	TAX
	LDA #>font
;	BCC .pushCharPtr2
;	LDA #>font + 1
;.pushCharPtr2
	PHA
;	TXA
        lda (textPtr),y ; 19
        LDX temp
	adc tsin4aBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF



	IF WHOLE_FONT == 1
	
        lda (textPtr),y ; 19
	asl
        tax
	LDA #>font
	BCC .pushCharPtr4
	LDA #>font + 1

.pushCharPtr4
	PHA
	TXA
        LDX temp
        clc
        adc #1
        nop
	PHA   
        dey
;	LDX temp
        ELSE
;	TAX
	LDA #>font
;	BCC .pushCharPtr4
;	LDA #>font + 1
;.pushCharPtr4
	PHA
        lda (textPtr),y ; 19
;	TXA
;        LDX temp
	adc #1 ;tsin4bBank6,x  ; y va de 0 a 195, 
        ; il nous faut une variable allant de Phase + 1 a Phase + 12
        ; pour taper dans le tableau de 0 a 15

	PHA
        dey ; 18
        
        ENDIF


	dex
        STX temp
        cpx PhaseDiv2
        bne .loopGenerateBisBank6
        
        jmp .endGenerateBank6
    

tsin4aBank6
     .byte 1,0,1,0,1,0,1,0
tsin4bBank6
	.byte 1,1,1,1,1,1,1,1
     
        echo "ROM left bank 6: ", ($Dff4 - *)

        org $6FF4
        RORG    $DFF4
        .byte 0,0,0,0,0,0
        org $6FFA
        RORG    $DFFA

        .word 0          ; NMI
        .word $D000      ; RESET
        .word $D000      ; BRK


        ORG     $7000
        RORG    $F000



BASE_COLOR1 equ #$60
BASE_COLOR2 equ #$B0
BASE_COLOR3 equ #$20
SPEED_TEXT_PAGES equ 2



Bank7   SUBROUTINE

        lda #>(Reset_0-1)
        ldy #<(Reset_0-1)
        ldx #0
.BankSwitch        
        BANK_SWITCH_TRAMPOLINE
;BankSwitchY
	BANK_SWITCH_TRAMPOLINE_Y

; variables text routines
Phase equ $8E
txt_temp2 equ $8F ; 1 bytes , also TIA temp variable

TextPage equ $90 ; 2 bytes
textPtr equ $92 ; 2 bytes
maskPtr equ $94 ; 2 bytes
numLine equ $96 ; 1 byte
mask equ $97 ; 1 byte

temp equ $98 ; 2 bytes

tempStack equ $9A
ToDisplay equ $9B ; 1 byte
GlobalFrame equ $9C ; 2 bytes

Masks equ $9E ; 8 bytes
ColorsText equ $A6 ; 8 bytes

Char1   equ $AE ; 24 bytes
PhaseDiv2 equ $C6
TextBank equ $C7
GenerateTextRoutine equ $C8 ; 2 bytes

EightFramesCounter equ $CA ; 2 Bytes

TextFrameGoal equ $CC ; 1 byte
TextFrameT1Goal equ $CD


;Masks equ $9E ; 8 bytes
;ColorsText equ $A6 ; 8 bytes
;Char1   equ $AE ; 24 bytes

LineCounter equ txt_temp2


InitTextPage
;	CLEAN_START
	JSR DoInitTextPage

	TIMER_WAIT_2
OverscanText        
; 30-2 lines of overscan
	STA WSYNC
        LDA #37
        STA TIM64T
        
        
    	;TIMER_SETUP 30

;	JSR MusicPlay
        IF ANIMATE_TEXT_BANK1
        MAGI_CALL 7,2, AnimateText2Bank1
        ELSE
        JSR AnimateText2
        ENDIF

; Go to next frame
        LDX #7
.copyColors        
        LDA ColorsTextSource,x
        STA ColorsText,x
        dex
        bpl .copyColors


        TIMER_WAIT_2

; todo: start with overscan

; VSYNC and VBLANK periods
NextFrame
        VERTICAL_SYNC
        STA WSYNC
        LDA #50
        STA TIM64T

	IF SHOW_FREE_CPU = 0
        LDA #2
        sta VBLANK
        ENDIF

	inc GlobalFrame
        lda GlobalFrame
        CMP #4
        bne .not5thCycle
        LDA #0
        STA GlobalFrame
        inc GlobalFrame + 1
.not5thCycle        

	inc EightFramesCounter
        lda EightFramesCounter
        CMP #4
        bne .not8thCycle
        LDA #0
        STA EightFramesCounter
        inc EightFramesCounter + 1
.not8thCycle        

        
        LDA #$00

;        LDA #0
        STA COLUBK
;	LDA GlobalFrame
;        AND #1
;        BNE .noColor
;        LDA #$0
;        STA COLUBK       
;.noColor        
        
        jsr InitTextPos
    	lda -#12
        sta numLine

        TIMER_WAIT_2

        sta WSYNC
;        LDA #0
        sta VBLANK
; end of VBLANK
	TAX

;        lda #18
;        sta T1024T
	LDA #244 + 1 ;244
        STA TIM64T

        
	LDA GlobalFrame + 1
        CLC
	STA Phase
        
.displayAllText
	stx txt_temp2 ; save X
        LDA Masks,x
        sta mask

	LDX Phase
        INX
        TXA
        AND #3
        STA Phase
        LSR
        STA PhaseDiv2

        lda #>(.RetGenerateText - 1)
        pha
        lda #<(.RetGenerateText - 1)
        pha
        lda #7
        pha
        ldx TextBank
        lda GenerateTextRoutine + 1
        ldy GenerateTextRoutine
        jmp BankSwitch
.RetGenerateText

;        STA WSYNC
	LDA Phase
        AND #1
        BEQ .doAlternate

        jsr DisplayTextLine2 
        STA WSYNC
        bcs .afterDisplayText
.doAlternate
	jsr DisplayTextLine2Alternate 
.afterDisplayText        
        lda #$0
        sta GRP0
        sta GRP1

;        IF WHOLE_FONT == 1
;	JSR Lose20CyclesX6
;	JSR Lose20CyclesX6
;	JSR Lose20CyclesX6
;	JSR Lose16CyclesX6
;        ENDIF
        
        ldx txt_temp2 ; restore X
        inx
        IF WHOLE_FONT == 1
        cpx #7
        else
        cpx #8
        endif
    	bne .displayAllText

        TIMER_WAIT_2
        STA WSYNC
        JSR Lose14CyclesX6
        LDA #34
        STA TIM64T
        
        MAGI_CALL 7,4,DrawLogo
       	MAGI_CALL 7, 7, tt_PlayerStart

	lda EightFramesCounter + 1        
        cmp TextFrameGoal ;#TEXT_DURATION / SPEED_TEXT_PAGES
;48 ; 96 ; each page is displayed 768/50 = 15 seconds
        bne .endProcessResetAnim

	BANK_SWITCH 0,PlayNextDemoPart
        
.endProcessResetAnim

        TIMER_WAIT_2
        
    	jmp OverscanText
        
DisplayTextLine2 SUBROUTINE
;   sta WSYNC
;   jmp zappe1
    ;; Moving characters 8 pixels to the right
    lda #$80
    sta HMP0
    sta HMP1
	LDA ColorsText,0
        STA COLUP0
        STA COLUP1
    
;	JSR TempoWobble
    ; odd lines - Shifted by 8 pix to the right -> 108
    ; Exploiting a bug to move the sprites of +8 pixels
    ; This happens when writing HMOVE at the end of the scanline.
    ; L54: Display 2*8 lines
    ; This uses Y reg
;   ldy fx_text_offset

; HERE; wait VSYNCs and increase Y according to some mask value
; for Vertical transition effect
        ldy #0
;        sta WSYNC       ; 3  78
        sta WSYNC
        
.txt_ln:
        sta HMOVE       ; 3   3
        ldx mask ;#$FF
        lda (Char1+2),Y ; 5   8
        sax GRP0        ; 3  11
        lda (Char1+6),Y ; 5  16
        sax GRP1
        lda (Char1+22),Y    ; 5  24
        sax temp
        nop
        LDA (Char1+10),Y    ; 5  37
        sax GRP0
        LDA (Char1+14),Y    ; 5  45
        sax GRP1        ; 3  48
        LDA (Char1+18),Y    ; 5  53
        sax GRP0        ; 3  56
        LDx temp
        stx GRP1        ; 3  59 154
        sta HMCLR           ; 3  62
        nop
        ldx mask ;#$FF
        
        sta HMOVE       ; 3  73 - End of scanline

    ;; even lines
    ;; Moving characters 8 pixels to the left
        lda (Char1),Y   ; 5   2
        sax GRP0        ; 3   5
        lda (Char1+4),Y ; 5  10
        sax GRP1        ; 3  13
        lda (Char1+20),Y    ; 5  18
        sax temp
    ;; Moving characters 8 pixels to the right
        
        lda #$80        ; 2  22
        sta HMP0        ; 3  25
        sta HMP1        ; 3  30
        lda (Char1+8),Y ; 5  35
        sax GRP0        ; 3  38
        lda (Char1+12),Y    ; 5  43
        sax GRP1        ; 3  46
        lda (Char1+16),Y    ; 5  51
        sax GRP0        ; 3  54
        LDx temp
        stx GRP1        ; 3  57

;        SLEEP 10 ; changer la couleur blat
        

	LDA ColorsText,y
        iny
        STA COLUP0
        STA COLUP1
        cpy #8
        bne .txt_ln
.end_txt


	RTS
        
DisplayTextLine2Alternate SUBROUTINE
;   sta WSYNC
;   jmp zappe1
    ;; Moving characters 8 pixels to the right
    lda #$80
    sta HMP0
    sta HMP1
	LDA #0 ;ColorsText,0
        STA COLUP0
        STA COLUP1
    
;	JSR TempoWobble
    
    ; odd lines - Shifted by 8 pix to the right -> 108
    ; Exploiting a bug to move the sprites of +8 pixels
    ; This happens when writing HMOVE at the end of the scanline.
    ; L54: Display 2*8 lines
    ; This uses Y reg
;   ldy fx_text_offset

; HERE; wait VSYNCs and increase Y according to some mask value
; for Vertical transition effect
        ldy #0
        sta WSYNC 
        STA WSYNC; 3  78
.txt_ln2:
        sta HMOVE       ; 3   3  ; va a droite 
        ldx mask ;#$FF
        lda (Char1+2),Y ; 5   8
        sax GRP0        ; 3  11
        lda (Char1+6),Y ; 5  16
        sax GRP1
        lda (Char1+22),Y    ; 5  24
        sax temp
        nop
        LDA (Char1+10),Y    ; 5  37
        sax GRP0
        LDA (Char1+14),Y    ; 5  45
        sax GRP1        ; 3  48
        LDA (Char1+18),Y    ; 5  53
        sax GRP0        ; 3  56
        LDx temp
        stx GRP1        ; 3  59 154
        sta HMCLR           ; 3  62
        nop
        ldx mask ;#$FF
        
        sta HMOVE       ; 3  73 - End of scanline , va a gauche

    ;; even lines
    ;; Moving characters 8 pixels to the left
	LDA ColorsText,y
        STA COLUP0
        STA COLUP1
        
        lda (Char1),Y   ; 5   2
        sax GRP0        ; 3   5
        lda (Char1+4),Y ; 5  10
        sax GRP1        ; 3  13
;        sax temp
    ;; Moving characters 8 pixels to the right
        
        lda #$80        ; 2  22
        sta HMP0        ; 3  25
        lda (Char1+8),Y ; 5  35
        sax GRP0        ; 3  38
        lda (Char1+12),Y    ; 5  43
        sax GRP1        ; 3  46
        lda (Char1+16),Y    ; 5  51
        sax GRP0        ; 3  54
        lda (Char1+20),Y    ; 5  18
        sax GRP1        ; 3  57

        lda #$80        ; 2  22
        sta HMP1        ; 3  30

;        SLEEP 10 ; changer la couleur blat
        
        nop
        nop

        iny
        cpy #8
        bne .txt_ln2

	RTS



InitTextPos SUBROUTINE
        LDA #6
        STA NUSIZ0
        STA NUSIZ1
    	lda #34
        LDX #0
        jsr Bank7SetHorizPos
        lda #34 + 16
        LDX #1
        jsr Bank7SetHorizPos

        sta WSYNC
        sta HMOVE
    	rts
    
;        ALIGN 256
     


; align 16
Bank7SetHorizPos
        sta WSYNC   ; start a new line
        bit 0       ; waste 3 cycles
        sec     ; set carry flag
Bank7DivideLoop
        sbc #15     ; subtract 15
        bcs Bank7DivideLoop  ; branch until negative
        eor #7      ; calculate fine offset
        asl
        asl
        asl
        asl
        sta RESP0,x ; fix coarse position
        sta HMP0,x  ; set fine offset
        rts     ; return to caller


heights0 .byte 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
heights1 .byte 8,8,8,9,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,8,8
; heights2
;heights1 .byte 8,8,9,9,10,10,10,10,10,10,9,9,8,8,7,7,6,6,6,6,6,6,7,7,8,8,8,9,9,10,10,10,10,10,10,9,9,8,8,7,7,6,6,6,6,6,6,7,7,8
;heights3
;heights1 .byte 8,9,9,10,11,11,11,11,11,10,10,9,8,8,7,6,6,5,5,5,5,5,6,7,7,8,9,9,10,11,11,11,11,11,10,10,9,8,8,7,6,6,5,5,5,5,5,6,7,7
;heights4
;heights1 .byte 8,9,10,11,11,12,12,12,12,11,10,9,9,7,7,6,5,4,4,4,4,5,5,6,7,8,9,10,11,11,12,12,12,12,11,10,9,9,7,7,6,5,4,4,4,4,5,5,6,7



; PF1 et PF2 peuvent etre calcules a partir de PF0. ce serait mieux.
;Bomb0PFHi .byte #>Bomb0PF0
;Bomb0PFLo .byte #<Bomb0PF0,#<Bomb0PF1,#<Bomb0PF2

;Bomb1PFHi .byte #>Bomb1PF0
;Bomb1PFLo .byte #<Bomb1PF0,#<Bomb1PF1,#<Bomb1PF2

;BombermanPFHi .byte #>BombermanPF0
;BombermanPFLo .byte #<BombermanPF0,#<BombermanPF1,#<BombermanPF2

;Shuriken0PFHi .byte #>Shuriken0PF1
;Shuriken0PFLo .byte #<Shuriken0PF1,#<Shuriken0PF1,#<Shuriken0PF2

;Shuriken1PFHi .byte #>Shuriken1PF1
;Shuriken1PFLo .byte #<Shuriken1PF1,#<Shuriken1PF1,#<Shuriken1PF2

ColorsTextSource
	.byte BASE_COLOR1 + 6,BASE_COLOR1 + 8,BASE_COLOR1 + 10,BASE_COLOR3 + 14
        .byte BASE_COLOR3 + 12,BASE_COLOR2 + 10,BASE_COLOR2 + 8,BASE_COLOR2 + 6

; reste 28 bytes
TextPageLo       
        .byte #<texte,#<texte2,#<texte3,#<texte4
TextPageHi
        .byte #>texte,#>texte2,#>texte3,#>texte4
TextPageBank
	.byte 6,6,5,5
        
GenerateTextRoutineLo
        .byte <(GenerateTextLineWaveBank5 - 1)
        .byte <(GenerateTextLineWaveBank6 - 1)
GenerateTextRoutineHi
        .byte >(GenerateTextLineWaveBank5 - 1)
        .byte >(GenerateTextLineWaveBank6 - 1)
        
Lose20CyclesX6
        .byte $82 ; Nop imm 2
Lose19CyclesX6
        .byte $82 ; Nop imm 2
Lose18CyclesX6
        .byte $82 ; Nop imm 2
Lose17CyclesX6
        .byte $82 ; Nop imm 2
Lose16CyclesX6
        .byte $82 ; Nop imm 2
Lose15CyclesX6
        .byte $44 ; Nop zp 3
Lose14CyclesX6
        .byte $EA ; Nop
Lose12CyclesX6
	RTS

; reste 4 bytes        
ColorsBomb .byte $84,$88,$8C,$8E,$AE,$AC,$A8,$A6
	.byte $84,$88,$8C,$8E,$AE,$AC,$A8,$A6

    ALIGN 256
; size = nb total de caracteres affiches + 15
; 12 * 7 = 84 $63
; alignement a 256 enleve
; name should be table_mod11_and1_xor1
; 11 because 12 - 1; text width - 1 which gives that wave effect going from top
; right to bottom left because it goes one line down one char to the left.


; todo: on peut garder juste 6 lignes par caractere
; mais si on supprime l'ondulation.
; todo: ne garder que les caracteres reellement utilises

font
    .byte 0,#$00,#$00,#$c6,#$c6,#$ee,#$fe,#$6c
    .byte 0,#$00,#$7e,#$e0,#$f8,#$e0,#$fe,#$fe
    .byte 0,#$00,#$00,#$7e,#$e0,#$7c,#$1e,#$fc
    .byte 0,#$00,#$00,#$60,#$e0,#$fc,#$e6,#$e6
    .byte 0,#$00,#$00,#$00,#$00,#$00,#$00,#$00
    .byte 0,#$00,#$00,#$7c,#$c0,#$ce,#$ce,#$7c
    .byte 0,#$00,#$7c,#$e6,#$e6,#$fc,#$e6,#$e6
    .byte 0,#$00,#$7c,#$e6,#$e6,#$e6,#$fe,#$7c
    .byte 0,#$00,#$00,#$00,#$00,#$78,#$78,#$F0
    .byte 0,#$00,#$00,#$7e,#$f0,#$f0,#$f0,#$7e
    .byte 0,#$00,#$7c,#$e6,#$fe,#$e6,#$e6,#$e6
    .byte 0,#$00,#$00,#$e0,#$e0,#$fc,#$e6,#$fc
    .byte 0,#$00,#$e6,#$e6,#$e6,#$e6,#$e6,#$7c
    .byte 0,#$00,#$00,#$6e,#$fe,#$d6,#$c6,#$c6
    .byte 0,#$00,#$fc,#$fe,#$0e,#$7c,#$00,#$78
    .byte 0,#$00,#$f8,#$ec,#$e6,#$e6,#$e6,#$fc
    .byte 0,#$00,#$c6,#$c6,#$ee,#$7c,#$38,#$38
    .byte 0,#$00,#$00,#$fc,#$e6,#$e6,#$e6,#$e6
    .byte 0,#$00,#$fe,#$fe,#$38,#$38,#$38,#$38
    .byte 0,#$00,#$00,#$fe,#$38,#$38,#$38,#$fe
    .byte 0,#$00,#$7e,#$e0,#$f8,#$e0,#$e0,#$e0
    .byte 0,#$00,#$00,#$60,#$e0,#$e0,#$e0,#$fe
    .byte 0,#$00,#$00,#$e6,#$e6,#$e6,#$fc,#$78
    .byte 0,#$00,#$00,#$00,#$fc,#$fc,#$fc,#$00
    .byte 0,#$00,#$00,#$c6,#$fe,#$38,#$fe,#$c6
    .byte 0,#$00,#$0e,#$0e,#$0e,#$ee,#$ee,#$7c
    .byte 0,#$00,#$7c,#$7c,#$7c,#$7c,#$00,#$7c
    .byte 0,#$00,#$fc,#$e6,#$e6,#$fc,#$e0,#$e0
    .byte 0,#$00,#$00,#$7e,#$ce,#$7e,#$0e,#$0e
    .byte 0,#$00,#$e6,#$ee,#$fc,#$f8,#$fc,#$ee
    .byte 0,#$00,#$00,#$fe,#$1e,#$78,#$e0,#$fe
    .byte 0,#$00,#$00,#$00,#$00,#$00,#$00,#$00
    .byte 0,0 ; pour bien finir la derniere lettre
;

;Bomb1PF0 .byte 0,0,0,0,0,$30,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$C0,$B0,$F0,$30,$10,$E0,0,0,0,0
;Bomb1PF1 .byte 0,0,0,0,0,$00,$00,$80,$C0,$C0,$E0,$E0,$E0,$E0,$C0,$C0,$80,$00,$00,$80,$00,0,0,0,0
;Bomb1PF2 .byte 0,0,0,0,0,$C0,$F0,$F8,$FC,$FC,$FE,$CE,$86,$86,$CC,$3C,$98,$D0,$C0,$00,$00,0,0,0,0

     
;Bomb0PF0 .byte 0,0,0,0,0,$30,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$C0,$B0,$F0,$30,$10,$20,$C0,$00,0,0,0,0
;Bomb0PF1 .byte 0,0,0,0,0,$00,$00,$80,$80,$C0,$C0,$C0,$C0,$80,$80,$00,$00,$00,$00,$00,$00,0,0,0,0
;Bomb0PF2 .byte 0,0,0,0,0,$C0,$F0,$F8,$F8,$FC,$9C,$8C,$CC,$38,$98,$D0,$C0,$00,$00,$00,$00,0,0,0,0
;Bomb0PF0 .byte 0,0,0,0,0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,0,0,0,0
;Bomb0PF1 .byte 0,0,0,0,0,$07,$1F,$3F,$3F,$7F,$73,$63,$67,$38,$33,$17,$07,$01,$00,$00,$00,0,0,0,0
;Bomb0PF2 .byte 0,0,0,0,0,$01,$07,$0F,$0F,$1F,$1F,$1F,$1F,$0E,$0D,$07,$01,$00,$01,$06,$00,0,0,0,0
;Bomb1PF0 .byte 0,0,0,0,0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,0,0,0,0
;Bomb1PF1 .byte 0,0,0,0,0,$07,$1F,$3F,$7F,$7F,$FF,$E7,$C3,$C3,$67,$78,$33,$17,$07,$01,$00,0,0,0,0
;Bomb1PF2 .byte 0,0,0,0,0,$01,$07,$0F,$1F,$1F,$3F,$3F,$3F,$3F,$1F,$1E,$0D,$07,$01,$08,$07,0,0,0,0

;	ALIGN 256

Bomb0PF0 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$FF,$FF,$FF,$FF
Bomb0PF1 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$F0,$C0,$80,$80,$00,$18,$38,$30,$8F,$98,$D0,$F0,$FD,$FE,$FF,$FF,$FF,$FF,$FF,$FF
Bomb0PF2 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FC,$F8,$F8,$F0,$F0,$F0,$F0,$F8,$F9,$FC,$FF,$FF,$FF,$FC,$FF,$FF,$FF,$FF,$FF
Bomb1PF0 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$F0,$F0,$F0,$F0,$F0,$70,$70,$70,$70,$F0,$F0,$F0,$F0,$F0,$F0,$F0,$FF,$FF,$FF,$FF
Bomb1PF1 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$F0,$C0,$80,$00,$00,$00,$30,$78,$78,$30,$0F,$98,$D0,$F0,$FD,$FE,$FF,$FF,$FF,$FF
Bomb1PF2 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FC,$F8,$F0,$F0,$E0,$E0,$E0,$E0,$F0,$F0,$F9,$FC,$FF,$FB,$FC,$FF,$FF,$FF,$FF

Shuriken0PF1 .byte 0,$01,$01,$01,$01,$03,$03,$0F,$3E,$FE,$0F,$03,$03,$01,$01,$00,$00,0,0,0,0,0,0,0,0
Shuriken0PF2 .byte 0,$00,$00,$80,$80,$C0,$C0,$F0,$7F,$7C,$F0,$C0,$C0,$80,$80,$80,$80,0,0,0,0,0,0,0,0
Shuriken1PF1 .byte 0,$00,$00,$00,$40,$38,$1F,$0F,$06,$06,$07,$07,$0E,$0C,$08,$10,$00,0,0,0,0,0,0,0,0
Shuriken1PF2 .byte 0,$00,$08,$10,$30,$70,$E0,$E0,$60,$60,$F0,$F8,$1C,$02,$00,$00,$00,0,0,0,0,0,0,0,0




;Shuriken0PF1 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FE,$FE,$FE,$FC,$FC,$F0,$C1,$81,$F0,$FC,$FC,$FE,$FE,$FF,$FF,$FF,$FF,$FF,$FF
;Shuriken0PF2 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FF,$7F,$7F,$3F,$3F,$0F,$81,$83,$0F,$3F,$3F,$7F,$7F,$7F,$FF,$FF,$FF,$FF,$FF
;Shuriken1PF1 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FF,$FF,$FF,$C7,$E0,$F0,$F9,$F9,$F8,$F8,$F1,$F3,$F7,$FF,$FF,$FF,$FF,$FF,$FF
;Shuriken1PF2 .byte #$FF,#$FF,#$FF,#$FF,#$FF,$FF,$FF,$EF,$CF,$8F,$1F,$1F,$9F,$9F,$0F,$07,$E3,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF



; 7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,7,8,8
; 6 bytes libre ici


; start of fading in, in frames
T0 equ 0 / 8 / SPEED_TEXT_PAGES
; start of fading out, in frames
T1 equ 80 ; 600 / 8 / SPEED_TEXT_PAGES

DT equ #2 / SPEED_TEXT_PAGES;16



DoInitTextPage

	LDA #0
        STA GlobalFrame
        STA GlobalFrame + 1
        STA EightFramesCounter
        STA EightFramesCounter + 1
        STA ToDisplay
        
    	LDX TextPage
        lda TextPageLo,x
        sta textPtr
        lda TextPageHi,x
        sta textPtr+1
        lda TextPageBank,x
        sta TextBank
        TAX
        LDA GenerateTextRoutineLo - 5,x
        STA GenerateTextRoutine
        LDA GenerateTextRoutineHi - 5,x
        STA GenerateTextRoutine + 1

	LDA #0
        STA PF0
        STA PF1
        STA PF2
        
        LDA TextFrameGoal
        CLC
        ADC #-16
        STA TextFrameT1Goal
        
	RTS

	IF ANIMATE_TEXT_BANK1 == 0
; $200 bytes de libre !
leftMaskVals .byte #$00,#$80,#$C0,#$E0,#$F0,#$F8,#$FC,#$FE
	.byte #$FF

rightMaskVals .byte #$00,#$01,#$03,#$07,#$0F,#$1F,#$3F,#$7F,#$FF

AnimateText2

        LDA ToDisplay
        cmp #1
        beq .DoDisappear
; temp = t - t0
        sec             ; set carry for borrow purpose
        lda EightFramesCounter + 1
        sbc #<T0          ; perform subtraction on the LSBs
        sta temp

        ldy #0
.loopAnimate

	lda temp
        bmi .isInf0

        cmp #8
        bpl .isSupEqual8
        
        tax ; between 0 and 7
        lda leftMaskVals,x
        sta Masks,y
        jmp .nextAnimate
        
.isInf0        
        lda leftMaskVals
        sta Masks,y
        jmp .nextAnimate
        
.isSupEqual8
        lda leftMaskVals+8
        sta Masks,y
.nextAnimate

; t - t0 - dt
        sec             ; set carry for borrow purpose
        lda temp
        sbc #DT          ; perform subtraction on the LSBs
        sta temp
        
        iny
        cpy #8
        bne .loopAnimate
        
        LDA Masks+7
        cmp #$FF
        bne .finAnimText
        LDA #1
        STA ToDisplay
.finAnimText
        RTS

.DoDisappear
; t - t1
        sec             ; set carry for borrow purpose
        lda EightFramesCounter + 1
        sbc TextFrameT1Goal ;#<T1          ; perform subtraction on the LSBs
        sta temp
        
        ldy #0
; * 8 / 64 -> /8        
.loopAnimate2
        lda temp
        sec
        sbc #8
        eor #$FF
        clc
        adc #1
        bmi .isInf02
        cmp #8
        bpl .isSupEqual82
        tax
        lda rightMaskVals,x
        sta Masks,y
        jmp .nextAnimate2
.isInf02        
        lda rightMaskVals
        sta Masks,y
        jmp .nextAnimate2
.isSupEqual82
        lda rightMaskVals+8
        sta Masks,y
.nextAnimate2
; t - t0 - dt
        sec             ; set carry for borrow purpose
        lda temp
        sbc #DT          ; perform subtraction on the LSBs
        sta temp
        
        iny
        cpy #8
        bne .loopAnimate2
.finAnimText2
        RTS
	ENDIF

; split raster minimaliste

; 30 bytes.

;SCENARIO_PTR equ $8A ; word
;COUNTER equ $8C ; pour emitFrames
;ANIM_COUNTER equ $8D ; pour compter les frames d'animation

SplitMinimalFrameGoal equ SPLIT_RASTER_VARIABLES + 0
RasterFrame equ SPLIT_RASTER_VARIABLES + 1 ; 2 bytes


Divider equ SPLIT_RASTER_VARIABLES + 3
CycleDelay equ SPLIT_RASTER_VARIABLES + 4
DirectionRaster equ SPLIT_RASTER_VARIABLES + 5
DividerIncrement equ SPLIT_RASTER_VARIABLES + 6

DecalHeightPtr equ SPLIT_RASTER_VARIABLES + 7 ; 1 byte

srcPtr equ SPLIT_RASTER_VARIABLES + 8 ; 2 bytes
HeightPtr equ SPLIT_RASTER_VARIABLES + 8 ; 2 bytes

;destPtr equ SPLIT_RASTER_VARIABLES + 35 ; 2 bytes
DividerMax equ SPLIT_RASTER_VARIABLES + 10 
RasterTemp equ SPLIT_RASTER_VARIABLES + 11

ColorFunctionPtr equ SPLIT_RASTER_VARIABLES + 12

Playfield0 equ SPLIT_RASTER_VARIABLES + 14 ; 2 bytes
Playfield1 equ SPLIT_RASTER_VARIABLES + 16 ; 2 bytes
; il reste un byte
RasterOutputLines equ SPLIT_RASTER_VARIABLES + 18 ; 1 byte
RasterTotalLinesNeg equ SPLIT_RASTER_VARIABLES + 19 ; 1 byte

PositionShuriken equ SPLIT_RASTER_VARIABLES + 20 ; 1 byte

SplitRasterRamRoutine equ SPLIT_RASTER_VARIABLES + 21 ; $3C bytes - 60 ; end at $EC ; remains 19 bytes RAM
; 62 bytes total

Counters equ SPLIT_RASTER_VARIABLES + 83 ; 25 bytes


CopyToLeftOffset equ SplitRasterRamRoutine + 21
CopyFromRightOffset equ SplitRasterRamRoutine + 22

SplitRasterLinesCount equ SplitRasterRamRoutine + 1
SplitRasterRamRoutineRight equ SplitRasterRamRoutine + 4
SplitRasterRamRoutineLeft equ SplitRasterRamRoutine + 3

LeftRasterColors equ SplitRasterRamRoutine + $15
RightRasterColors equ SplitRasterRamRoutine + $16


BASE_COLOR1_MINIMAL equ $60
BASE_COLOR2_MINIMAL equ $80

BASE_COLOR3_MINIMAL equ $40
BASE_COLOR4_MINIMAL equ $B0

InitRasterMinimal
.waitForImtimInit
        LDA INTIM
        BNE .waitForImtimInit
	STA WSYNC
        LDA #37
        sta TIM64T

	LDA #0
        STA RasterFrame
        STA RasterFrame + 1

	LDA #12
        STA DecalHeightPtr
        
        LDA #0
        STA Divider
	LDA #1
        STA DividerIncrement
	LDA #0
        STA DirectionRaster
        LDA #0
        STA CycleDelay

	LDA #24
        STA RasterOutputLines

	LDA #-200
	STA RasterTotalLinesNeg
        
        LDA #0
        STA PositionShuriken
	beq AfterSetTimerRasterOverscan

RasterOverscan
; Overscan
	STA WSYNC
        LDA #37
        sta TIM64T

AfterSetTimerRasterOverscan
	LDA RasterFrame + 1
        ORA RasterFrame
;        BNE .afterInitSprites
	LDA PositionShuriken
        LDX #0
	JSR Bank7SetHorizPos
	LDA PositionShuriken
        CLC
        ADC #32
        CMP #160
        BCC .okInScreen
        SEC
        SBC #160
.okInScreen        
        LDX #1
	JSR Bank7SetHorizPos
.afterInitSprites        
        LDA #7
        STA NUSIZ0
        STA NUSIZ1
        LDA RasterFrame + 1
	ASL
        AND #15
        CMP #8
        BCC .colorSpriteReady
        EOR #15
.colorSpriteReady
	CLC
        LDA #$0
        STA COLUP0
        STA COLUP1

	STA WSYNC
        STA HMOVE
	LDA RasterFrame + 1
        ORA RasterFrame
        BNE .afterInitSprites2
        STA HMCLR
.afterInitSprites2        
        ; on copie toute la routine qui va a droite
        LDX #(.loopWithoutChangingPFLeft - .startCopy - 1)
.loopCopy
        LDA .startCopy,X
        STA SplitRasterRamRoutine,X
        DEX
        BPL .loopCopy

	LDA SCENARIO_PTR + 1
        BPL .useSpriteScenario
	JMP afterEmitFrameBank7        
.useSpriteScenario        
        lda #$00
        sta COLUBK
        lda #$00
        sta COLUPF
        LDA #$00
	STA PF0
;        STA PF1
        STA GRP0
        STA GRP1
        LDA #0
        STA CTRLPF ; miroir pour le sprite, repete pour le playfield
	JMP afterEmitFrameBank7Sprite
returnPlayScenarioRaster

; SAX 87
	LDA SCENARIO_PTR + 1
        AND #BIT_SAX_BACKGROUND
        BEQ .noSaxSprite
	LDA #$87
        STA LeftRasterColors + 27
.noSaxSprite        

	LDA RasterOutputLines
        STA SplitRasterLinesCount

	INC RasterFrame
        LDA RasterFrame
        AND #7
        STA RasterFrame
        BNE .noHighRasterFrameInc
        INC RasterFrame + 1
.noHighRasterFrameInc        

	LDA DirectionRaster
        BEQ .preparePlayfield
; cree la routine pour aller gauche en decalant le code d'un nop et en faisant le branchement oppose pour la perte de cycle
        LDY #28
	LDX #0
.loopCopyForward
	LDA CopyFromRightOffset,X
        STA CopyToLeftOffset,X
        INX
        DEY
        BPL .loopCopyForward
        LDA #$01
        STA SplitRasterRamRoutine + 50
        LDA #$EA
        STA SplitRasterRamRoutine + 51

; move to scenario
.preparePlayfield
        ; apres le scenario, srcPtr contient l'adresse du playfield
        ; poke les adresses ou lire les data de sprite
        ;	LDA SCENARIO_PTR + 1
;        BPL .useSpriteScenario

;        LDY #0
        LDA SCENARIO_PTR + 1 ; le bit 7 de SCENARIO_PTR + 1 indique si on utilise les sprites ou le playfield dans la routine
        BPL .skipFirstPointer1
        LDA srcPtr + 1 ;(srcPtr),Y
        STA SplitRasterRamRoutineRight + 2 ; ecriture byte de poids fort
.skipFirstPointer1
	LDA srcPtr + 1 ;(srcPtr),Y
        STA SplitRasterRamRoutineRight + 7 ; ecriture byte de poids fort
        STA SplitRasterRamRoutineRight + 12 ; ecriture byte de poids fort
 ;       INY
        LDA srcPtr ;(srcPtr),Y
        CLC
        ADC #25
        TAX
        LDA SCENARIO_PTR + 1
        BPL .skipFirstPointer2 ; le bit 7 de SCENARIO_PTR + 1 indique si on utilise les sprites ou le playfield dans la routine
        
        LDA srcPtr ;(srcPtr),Y
        STA SplitRasterRamRoutineRight + 1
.skipFirstPointer2        
	TXA        
;        LDA (srcPtr),Y
        STA SplitRasterRamRoutineRight + 6
;        INY
        CLC
        ADC #25
;        LDA (srcPtr),Y
        STA SplitRasterRamRoutineRight + 11

.endOverscan

        TIMER_WAIT_2
	VERTICAL_SYNC
        STA WSYNC
NextFrameRaster
        LDA #50
        STA TIM64T
;	TIMER_SETUP 53
        LDA #2
        STA VBLANK

	IF SHOW_FREE_CPU = 0
;        LDA #2
;        STA VBLANK
        ENDIF
        
        
; sette la hauteur des lignes de playfield. pourrait aller dans scenario        
        LDA DecalHeightPtr
        CLC
        ADC #1
        CMP #24
        bne .okDecal
        LDA #0
.okDecal
	STA DecalHeightPtr
        
        LDA SCENARIO_PTR + 1
        AND #BIT_WOBBLING
        BEQ .noDance
        
        LDA #>heights1
        PHA
        LDA #<heights1
        IF (<heights1) == 0
        BEQ .setHeightPtr
        ELSE
        BNE .setHeightPtr
        ENDIF
.noDance        
        LDA #>heights0
        PHA
        LDA #<heights0
.setHeightPtr        
        CLC
        ADC DecalHeightPtr
        STA HeightPtr
        PLA
        ADC #0
        STA HeightPtr + 1

; on genere 25 lignes
; si on arrive par le haut on genere 2 lignes
; ligne 1: 8 pixels
; ligne 0 le reste
; YSprite = 0. normal
; YSprite = -1. la derniere ligne (#23) dure 16 lignes et on commence a 1
; X = 23. Dans les datas on on decale pas. Et c'est le compteur de la ligne 0 qui change.
; YSprite = -2. la derniere ligne dure 24 lignes et on commence a 2

        LDY SplitRasterLinesCount
        LDA RasterTotalLinesNeg
        STA RasterTemp
        CLC
;        LDA #8
.prepareCountersLoop
	LDA (HeightPtr),Y
        STA Counters,Y
        ADC RasterTemp
        STA RasterTemp
        DEY
        BPL .prepareCountersLoop
; pour les boobs
	LDA DEMO_PART ; triche
        AND #15
        CMP #BOOBS_PART
        BNE .readyCounters
        
        LDA SplitRasterLinesCount
        CMP #4
        BCC .readyCounters
	LDA DecalHeightPtr
        LSR
        CMP #6
	BCS .readyCounters        
        LDY SplitRasterLinesCount
        LDA Counters,Y
        CLC
        ADC #4
        STA Counters,Y
        LDA Counters
        CLC
        ADC #-4
        STA Counters
.readyCounters        
; force 200 lines output         
	LDA Counters
        SEC
        SBC RasterTemp
        STA Counters

; set up colors of split raster
	LDA DirectionRaster
        EOR #1
        TAX ; X permet de poker a la bonne adresse selon la routine

	JMP (ColorFunctionPtr)
returnColorFunctionPtr        
        

.endVBlank        
        TIMER_WAIT_2
        LDX DEMO_PART
        LDA TargetBankFromDemoPart,X ; 7 cycles de plus
;        TAX ; sette la bank de data et de retour
	STA RasterTemp
        
    	STA WSYNC
;    	STA WSYNC
;    	STA WSYNC
;        lda #18
;        sta T1024T
	LDA #244 + 1
        STA TIM64T
        LDA #0
        STA VBLANK
;        JSR Lose20CyclesX6
        
        LDA RasterTotalLinesNeg
        BEQ realEndKernelRaster
        JSR Lose15CyclesX6
; Main frame
	LDA DirectionRaster
        BNE .alignedCycle
.alignedCycle
        BNE .alignedCycle2
.alignedCycle2
        LDA #>(SplitRasterRamRoutine - 1)
        PHA
;	LDA DirectionRaster
;        BNE .directionRasterLeft
        LDA #<(SplitRasterRamRoutine - 1)
        PHA
;        LDX #7 ; revient en bank 7
        
; demo part = 0, 3, ou 6        
	LDX RasterTemp
	LDA #>(Lose14Cycles - 1)
        PHA
        LDA CycleDelay
        CLC 
        ADC #1 ; +
        EOR #$FF
        CLC 
        ADC #1
        CLC
        ADC #<(Lose14Cycles - 1)
        PHA
	LDY #0 ; va faire un tour en bank 0 voir si j'y suis
        
        LDA #0
;	LDX #24
        
        JMP BankSwitchY
;        RTS ; go to split raster
        
; attention a ne pas deborder        
	ALIGN 8
TargetBankFromDemoPart
	.byte 3,0,0,7,0,0,7
        
        
; les deux routines sont identiques, seul le nop avant les couleurs
; passe apres le saut qui check s'il faut decaler d'un cycle, et le branchement
; de ce saut

;	align 256
.startCopy
	LDX #24
.loopWithoutChangingPF
	nop
        nop
.DoSplitRaster        
.loopDirect
	LDY BombermanPF0,X
        STY PF0
        LDY BombermanPF1,X
        STY PF1
        LDY BombermanPF2,X
        STY PF2
        
        ; LDY ShurikenPF1,X ; 7 cycles de libre, 5 bytes. on fait un saut et on recupere 2 cycles
        ; nop bpl nop nop EA 10 02 EA EA
        ; STY GRP0
        
        ; LDY ShurikenPF1,X
        ; STY GRP0
        ; LDY ShurikenPF2,X
        ; STY GRP1
        ; 
        
	ADC Divider

; move to Scenario
TARGET_RASTER_REGISTER equ COLUBK

.onlyRightRoutineBegin
; partie qui change entre les routines
	nop
	LDY #(BASE_COLOR1_MINIMAL + 0)
        STY TARGET_RASTER_REGISTER
	LDY #(BASE_COLOR1_MINIMAL + 2)
        STY TARGET_RASTER_REGISTER
	LDY #(BASE_COLOR1_MINIMAL + 4)
        STY TARGET_RASTER_REGISTER
	LDY #(BASE_COLOR1_MINIMAL + 8)
        STY TARGET_RASTER_REGISTER
	LDY #(BASE_COLOR2_MINIMAL + 4)
        STY TARGET_RASTER_REGISTER
	LDY #(BASE_COLOR2_MINIMAL + 2)
        STY TARGET_RASTER_REGISTER
	LDY #0
        STY TARGET_RASTER_REGISTER ; 6 * 5c = 30 c
        BCS .takeOneCycle
.takeOneCycle        
; fin partie qui change entre les routines
.onlyRightRoutineEnd

	DEC Counters,X
        BNE .loopWithoutChangingPF ; 14 when looping
        DEX
        BPL .loopDirect
        JMP endKernelRaster

.loopWithoutChangingPFLeft
        
;.onlyLeftRoutineBegin        
;	LDY #(BASE_COLOR3_MINIMAL + 0)
;        STY COLUBK
;	LDY #(BASE_COLOR3_MINIMAL + 2)
;        STY COLUBK
;	LDY #(BASE_COLOR3_MINIMAL + 4)
;        STY COLUBK
;	LDY #(BASE_COLOR4_MINIMAL + 8)
;        STY COLUBK
;	LDY #(BASE_COLOR4_MINIMAL + 4)
;        STY COLUBK
;	LDY #(BASE_COLOR4_MINIMAL + 2)
;        STY COLUBK
;	LDY #0
;        STY COLUBK ; 6 * 5c = 30 c
;        BCS .loseOneCycleLeft
;        nop
.loseOneCycleLeft   
.onlyLeftRoutineEnd

;	DEC Counters,X
;        BNE .loopWithoutChangingPFLeft ; 14 when looping
;        DEX
;        BPL .loopDirectLeft ;- 2
;        JMP endKernel
        
realEndKernelRaster
        STA WSYNC
        LDA #0
        STA COLUBK
        STA COLUPF
	TIMER_WAIT_2
        STA WSYNC
        JSR GetRaster4
	PHA        
        LDA #34
        STA TIM64T

	MAGI_CALL 7, 4, DrawLogo
	MAGI_CALL 7, 7, tt_PlayerStart
        PLA
	; si fini passe a la part suivante
;        LDA RasterFrame ; 0..7
;        LSR
;        LSR ; /4
;        LSR ; /8 C = half
;        LDA RasterFrame + 1
;        ROL
        CMP SplitMinimalFrameGoal
        BNE .continueRaster
        
        BANK_SWITCH 0,PlayNextDemoPart

.continueRaster

	TIMER_WAIT_2
        JMP RasterOverscan



;	ALIGN 256
;	ALIGN 256
;8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7


EmitFramesBank7Sprite
	PLA
        CLC
        ADC #1
        STA SCENARIO_PTR + 0
;        PLA
;        ADC #0
;        STA SCENARIO_PTR + 1

        LDX SCENARIO_PTR + 1
        PLA
        ADC #0
        
        
        PHA           ; Save A
	TXA           ; Copy X to A
	AND #$E0      ; Isolate bits 7 and 6 and 5 of X
	STA RasterTemp      ; Save them temporarily
	PLA           ; Restore A
	AND #$1F      ; Clear bits 7 and 6 and 5 in A
	ORA RasterTemp      ; OR in bits 7 and 6 and 5 from X

;        CPX #$80
;        BCC .saveScenarioPtrHi
;        ORA #$80 ; persist SCENARIO_DONE flag
;.saveScenarioPtrHi        
        STA SCENARIO_PTR + 1

.loopEmitFramesBank7Sprite
	JSR PrepareSprite
	DEC COUNTER
        JMP returnPlayScenarioRaster
afterEmitFrameBank7Sprite
        LDA COUNTER
        BNE .loopEmitFramesBank7Sprite
        JMP (SCENARIO_PTR)

EmitFramesBank7
	PLA
        CLC
        ADC #1
        STA SCENARIO_PTR + 0

        LDX SCENARIO_PTR + 1
        PLA
        ADC #0
        
        
        PHA           ; Save A
	TXA           ; Copy X to A
	AND #$E0      ; Isolate bits 7 and 6 and 5 of X
	STA RasterTemp      ; Save them temporarily
	PLA           ; Restore A
	AND #$1F      ; Clear bits 7 and 6 and 5 in A
	ORA RasterTemp      ; OR in bits 7 and 6 and 5 from X

;        CPX #$80
;        BCC .saveScenarioPtrHi
;        ORA #$80 ; persist SCENARIO_DONE flag
;.saveScenarioPtrHi        
        STA SCENARIO_PTR + 1
        
        
.loopEmitFramesBank7
	JSR PreparePlayfield
	DEC COUNTER
        JMP returnPlayScenarioRaster
afterEmitFrameBank7
        LDA COUNTER
        BNE .loopEmitFramesBank7
        JMP (SCENARIO_PTR)


	MAC EMIT_FRAMES_BANK7 
.Value   SET {1}
        lda #.Value
        STA COUNTER
        JSR EmitFramesBank7
        ENDM

	MAC EMIT_FRAMES_BANK7_A 
        STA COUNTER
        JSR EmitFramesBank7
        ENDM

	MAC EMIT_FRAMES_BANK7_SPRITE 
.Value   SET {1}
        lda #.Value
        STA COUNTER
        JSR EmitFramesBank7Sprite
        ENDM

	MAC EMIT_FRAMES_BANK7_SPRITE_A 
        STA COUNTER
        JSR EmitFramesBank7Sprite
        ENDM


PreparePlayfield
	LDA Playfield0 + 1
        STA srcPtr + 1
	LDA Playfield0 + 0
	STA srcPtr

	LDA DecalHeightPtr
        LSR
        CMP #6
;	LDA RasterFrame + 1
;        AND #1
        BCS .skipBomb2 ; anim entre les deux etapes de playfield

	LDA Playfield1 + 1
        STA srcPtr + 1;
	LDA Playfield1 + 0
	STA srcPtr
        
.skipBomb2
        LDA DEMO_PART
        BNE .notBomberman
        
        LDA RasterOutputLines
        CMP #24
        BCS .bombermanSet
        LDA RasterFrame + 1
        CMP #50
        BCS .bombermanSet
        DEC srcPtr
.bombermanSet
; anime les yeux du bomberman
	LDA RasterFrame + 1
        CMP #30
        BCC .notBomberman

	LDA CycleDelay
        LDX #0
        CMP #38 - 2
        BCS .notLeft
        LDX #75
.notLeft
	CMP #38 + 3
        BCC .notRight
        LDX #150
.notRight

	TXA
        CLC
        ADC srcPtr
        STA srcPtr

.notBomberman
	RTS

PrepareSprite
	; sette target data registers
        LDX #GRP0
        STX SplitRasterRamRoutineRight + 4
        STX SplitRasterRamRoutineRight + 9
        LDX #GRP1
        STX SplitRasterRamRoutineRight + 14
	LDA DecalHeightPtr
        CMP #12
        BCC .checkShurikenStepAnim
        SEC
        SBC #12
;        LSR
.checkShurikenStepAnim
        CMP #4
        BCS .notStep0
        
	LDA Playfield0 + 0
	STA srcPtr
	LDA Playfield0 + 1
        STA srcPtr + 1
        LDA #0
        STA REFP0
;        LDA #0
        STA REFP1
	BEQ .sourceDone

.notStep0

	LDX Playfield1 + 0
	STX srcPtr
	LDX Playfield1 + 1
        STX srcPtr + 1
        CMP #8
        LDA #0
        ADC #0
        EOR #1
        ASL
        ASL
        ASL
        STA REFP0
        STA REFP1
        BEQ .sourceDone
        
        ; when reflected need to exchange sprites
        LDX #GRP1
        STX SplitRasterRamRoutineRight + 4
        STX SplitRasterRamRoutineRight + 9
        LDX #GRP0
        STX SplitRasterRamRoutineRight + 14

        
.sourceDone        


	LDX #0
	; sette target color register
;	LDA #COLUBK
;        STA LeftRasterColors + 4,x
;        STA LeftRasterColors + 12,x
;        STA LeftRasterColors + 20,x
;        STA LeftRasterColors + 8,x
;        STA LeftRasterColors + 16,x
;        STA LeftRasterColors + 24,x
        LDA #$B4 ; LDY zp,X
        STA LeftRasterColors + 25,x
        LDA #(Counters - 8) ;$97
        STA LeftRasterColors + 26,x
;        	LDY Counters -1,X ;B4 ; 97        
;        STA LeftRasterColors + 23,x
;	LDA #COLUBK
;        STA LeftRasterColors + 24,x
;	LDA #COLUBK
;        STA LeftRasterColors + 28,x

        ; nop bpl nop nop EA 10 02 EA EA ; libere du temps machine pour le LDY zp,X
	LDA #$EA
        STA SplitRasterRamRoutineRight
        STA SplitRasterRamRoutineRight + 3
        STA SplitRasterRamRoutineRight + 4
	LDA #$10
        STA SplitRasterRamRoutineRight + 1
        LDA #2
        STA SplitRasterRamRoutineRight + 2
        
	RTS

COLOR_BEAT equ $60
ColorsBeat 
	.byte 0
;	.byte 0
;	.byte 0
;	.byte 0
	.byte COLOR_BEAT + 0
        .byte COLOR_BEAT + 2
        .byte COLOR_BEAT + 4
        .byte COLOR_BEAT + 6
        .byte COLOR_BEAT + 8
;        .byte COLOR_BEAT + $A

; Bombes
PlayScenarioRaster
	JMP afterEmitFrameBank7 ;(SCENARIO_PTR)

	LDA #28 - 1
        STA CycleDelay
        
        LDA #1
        STA CTRLPF
        LDA #127
        STA DividerMax
        
;tt_cur_note_index_c0    equ TIATRACKER_ORG + 3 ; ds 1    ; note index into current pattern
;tt_cur_note_index_c1    equ TIATRACKER_ORG + 4 ; ds 1
;tt_envelope_index_c0    equ TIATRACKER_ORG + 5 ; ds 1    ; index into ADSR envelope
;tt_envelope_index_c1    equ TIATRACKER_ORG + 6 ; ds 1
;tt_cur_ins_c0           equ TIATRACKER_ORG + 7 ; ds 1    ; current instrument
;tt_cur_ins_c1               
        LDA #0
        STA RasterOutputLines

;        EMIT_FRAMES_BANK7 25

	LDA #3
        STA ANIM_COUNTER
.doNothing
; gere le fall from top
	LDA ANIM_COUNTER
        CMP #3
        BNE .rasterOutputOk
        LDA RasterOutputLines
        CMP #24
        BEQ .rasterOutputOk
	INC RasterOutputLines
.rasterOutputOk
; gere le climb to top
	LDA ANIM_COUNTER
        CMP #1
        BNE .rasterDisappearOk
        LDA DividerIncrement
        CMP #-1
        BNE .rasterDisappearOk
        LDA Divider
        CMP #42
        bcs .rasterDisappearOk
        LDA RasterOutputLines
        BEQ .rasterDisappearOk
	DEC RasterOutputLines
.rasterDisappearOk

	LDX #2
	JSR UpdateDivider
        LDX #3
        JSR MoveSourceRightX
        
;        LDA RasterFrame + 1
;        CMP #40
;        bcs .noFlash
	LDA tt_cur_note_index_c1
; now check for percussion 2
    lda tt_cur_ins_c1
    cmp #TT_FIRST_PERC+1
    bne .noFlash
;        AND #3
;        CMP #2
;        BNE .noFlash
        LDX tt_timer
        LDA ColorsBeat,x
        STA COLUPF
.noFlash
        
        EMIT_FRAMES_BANK7 1
        LDA Divider
        BNE .notZero
        DEC ANIM_COUNTER
.notZero
	LDA ANIM_COUNTER
        BNE .doNothing

	LDA #30
        STA ANIM_COUNTER
.preFinish1;
	INC Divider
        JSR MoveSourceRight
        EMIT_FRAMES_BANK7 1
        DEC ANIM_COUNTER
        BNE .preFinish1
	
;	LDA #28
;        STA ANIM_COUNTER
;.preFinish2
;	DEC Divider
;        JSR MoveSourceRight
;        EMIT_FRAMES_BANK7 1
;        DEC ANIM_COUNTER
;        BNE .preFinish2


;.endTheShow
;        LDA CycleDelay
;        CMP #35
;        BEQ .okCycleDelay
        
;        JSR MoveSourceRight
;.okCycleDelay        
;        EMIT_FRAMES_BANK7 1
;        jmp .endTheShow

; utilitaires raster
SetRasterTotalLines
	TAX
	ORA #0
        BEQ .noDec
        DEX
.noDec
	STX RasterOutputLines
SetRasterTotalLinesWithoutImage
	STA RasterTemp
	ASL
        ASL
        ASL
;        CLC 
        ADC RasterTemp ; * 9 pour tenir compte du wobbling
        CMP #201
        BCC .totalLinesReady
        LDA #200 ; max 200
.totalLinesReady        
        EOR #$FF
        CLC
        ADC #1
        STA RasterTotalLinesNeg
        RTS

GetRaster4
        LDA RasterFrame ; 0..7
        LSR
        LSR ; /4
        LSR ; /8 C = half
        LDA RasterFrame + 1
        ROL
        RTS
        
MoveRasterIntro
        LDA DividerIncrement
        CLC
        ADC #1
        LSR
        EOR DirectionRaster
        BNE .goRight
        JMP MoveSourceLeft
.goRight        
        JMP MoveSourceRight

.noMovement
PlayScenarioRasterIntro
	JMP afterEmitFrameBank7 ;(SCENARIO_PTR)

	LDA #39 - 1; change here
        STA CycleDelay
        LDA #0
        STA DirectionRaster
        JSR SetRasterTotalLines
	LDA #11
        STA DividerMax
        
        LDA #8
        STA ANIM_COUNTER
        ASL
	ASL
        ASL
        ASL
        STA DEMO_PART
	EMIT_FRAMES_BANK7 96
	DEC ANIM_COUNTER
.demoStart        
        LDA ANIM_COUNTER
        ASL
	ASL
        ASL
        ASL
        STA DEMO_PART
	EMIT_FRAMES_BANK7 11
        DEC ANIM_COUNTER
        BPL .demoStart ; 96 frames = 4 beats, donc plutot 8 beats pour 192
;	EMIT_FRAMES_BANK7 96
	EMIT_FRAMES_BANK7 8
        
        EMIT_FRAMES_BANK7 12 ; + 12
        
        LDA #1
        STA ANIM_COUNTER
.loopAmeneRaster
        LDA ANIM_COUNTER
        JSR SetRasterTotalLinesWithoutImage
        EMIT_FRAMES_BANK7 1
        INC ANIM_COUNTER
        LDA ANIM_COUNTER
        CMP #24
        BNE .loopAmeneRaster
        INC ANIM_COUNTER
        LDA ANIM_COUNTER
        JSR SetRasterTotalLinesWithoutImage

	EMIT_FRAMES_BANK7 30 - 12 + 24 + 6

        LDA #0
        STA ANIM_COUNTER
.ameneBomberman
	INC RasterOutputLines
        EMIT_FRAMES_BANK7 1
        LDA RasterOutputLines
        CMP #24
        BNE .ameneBomberman
;        EMIT_FRAMES_BANK7 24 ; amene bomberman, 24 frames



	LDA SCENARIO_PTR + 1
        ORA #BIT_WOBBLING
        STA SCENARIO_PTR + 1
        EMIT_FRAMES_BANK7 96 + 48 - 6 - 48; amene wobbling, 96 frames 

;RasterFrame = 15 . 24 frames = 3
;	EMIT_FRAMES_BANK7 17
; fin intro, debut zik
;	EMIT_FRAMES_BANK7 30

	LDA #96 - 24 - 24
        STA ANIM_COUNTER ; ondule raster. 96 frames; 1x 192 au milieu
.onduleRaster
	JSR MoveRasterIntro
        LDX #1
	JSR UpdateDivider
        EMIT_FRAMES_BANK7 1
	DEC ANIM_COUNTER
        BNE .onduleRaster    ; 2 x 192

	LDA #192 - 25 - 47 ;+ 24
        STA ANIM_COUNTER ; ondule raster. 96 frames
.onduleRaster2
	JSR MoveRasterIntro
        LDX #1        
	JSR UpdateDivider
        EMIT_FRAMES_BANK7 1
	DEC ANIM_COUNTER
        BNE .onduleRaster2

        ; enleve tout 25 frames
	LDA SCENARIO_PTR + 1
        AND #~BIT_WOBBLING
        STA SCENARIO_PTR + 1


.enleveBomberman
        LDA RasterOutputLines
;        BMI .loopIntroEnd
        JSR SetRasterTotalLines

	LDX #1
	JSR UpdateDivider
        EMIT_FRAMES_BANK7 1
        JMP .enleveBomberman  ; 2 x 192

; quand on n'a pas confiance
;.loopIntroEnd
;	EMIT_FRAMES_BANK7 1
;        jmp .loopIntroEnd
        
MoveShuriken
	LDA PositionShuriken
        CLC
        ADC #3
        CMP #160
        BCC .okInScreen2
        SEC
        SBC #160
.okInScreen2
	STA PositionShuriken
	RTS
        
PlayScenarioRasterShuriken SUBROUTINE
	JMP afterEmitFrameBank7Sprite ;(SCENARIO_PTR)

	LDA #27 - 1; change here
        STA CycleDelay
        LDX #0
        STX Divider
        INX
        STX DirectionRaster
        LDA #50
        STA PositionShuriken
        LDA #127
        STA DividerMax
	LDA #0
        JSR SetRasterTotalLines

        LDA #24
        STA ANIM_COUNTER
.startTheShow2
        LDX #3
	JSR UpdateDivider
        LDX #2
        JSR MoveSourceRightX
	JSR MoveShuriken
        
        LDA #24
        SEC
        SBC ANIM_COUNTER
        JSR SetRasterTotalLines
        
        EMIT_FRAMES_BANK7_SPRITE 1
        DEC ANIM_COUNTER
        BPL .startTheShow2

;	INC RasterMode

.animateShuriken
	LDX #3
	JSR UpdateDivider
        JSR MoveSourceRight
        JSR MoveShuriken
        EMIT_FRAMES_BANK7_SPRITE 1
        
        LDA RasterFrame + 1
        CMP #44 ; fait disparaitre l'ecran du shuriken
        BCC .shurikenPositioned2
        LDA RasterOutputLines
        BMI .shurikenPositioned2
        JSR SetRasterTotalLines
.shurikenPositioned2
	JMP .animateShuriken

DemoEndScenarioRaster
	JMP afterEmitFrameBank7 ;(SCENARIO_PTR)
	LDA #0
        JSR SetRasterTotalLines

	EMIT_FRAMES_BANK7 115 ;109 ; 108 ok, 110 ko

        LDA #7
        STA ANIM_COUNTER
.demoEndLoop        
        LDA ANIM_COUNTER
        EOR #7
        ASL
	ASL
        ASL
        ASL
        ORA #11 ; on est dans la partie 11
        STA DEMO_PART
	EMIT_FRAMES_BANK7 12
        DEC ANIM_COUNTER
        BPL .demoEndLoop
        
;        LDA #$8B
;	EMIT_FRAMES_BANK7 12
;        LDA #$8B
;        STA DEMO_PART
        LDA #$9B
        STA DEMO_PART
	EMIT_FRAMES_BANK7 200

.loopEndDemo
;	EMIT_FRAMES 1
;        JMP .loopEndDemo
        
        BANK_SWITCH 0,$0000





; X = updates count to do
; 
UpdateDivider
.loopUpdateDivider
        LDA Divider
        CLC
        ADC DividerIncrement
        STA Divider
        CMP DividerMax
        BNE .didNotReachMax2
        LDA #-1
        STA DividerIncrement
        bne .dividerOk2
.didNotReachMax2
	CMP #0
	bne .dividerOk2
        LDA #1
        STA DividerIncrement
.dividerOk2        

;UpdateDirectionRaster
	LDA Divider
	BNE .noDirectionChange2
        LDA DirectionRaster
        EOR #1
        STA DirectionRaster
.noDirectionChange2
	DEX
        BNE .loopUpdateDivider
	RTS

MoveSourceRight
	LDX #1
MoveSourceRightX
.moveSourceLoop
        LDA CycleDelay
        CLC 
        ADC #1
        CMP #76
        BNE .loopCycles2
        LDA #0
.loopCycles2
	STA CycleDelay
        DEX
        BNE .moveSourceLoop
        RTS

MoveSourceLeft
        LDA CycleDelay
        SEC 
        SBC #1
        CMP #-1
        BNE .loopCycles3
        LDA #75
.loopCycles3
	STA CycleDelay
        RTS

ColorBomberman
        LDA #$90
	ORA #4
        STA LeftRasterColors + 1,x
	EOR #$C
        STA LeftRasterColors + 5,x
        EOR #6
        STA LeftRasterColors + 9,x

	lda #$60
        EOR #$C
        STA LeftRasterColors + 13,x
        EOR #4 ; 8
        STA LeftRasterColors + 17,x
        EOR #$C ;E ; 6
        STA LeftRasterColors + 21,x
        LDA #0
;        STA LeftRasterColors + 25,x
        
;        JSR ApplyTimings
	JMP returnColorFunctionPtr

ColorsShuriken 
	.byte $66,$68,$6A,$6C,$2C,$2A,$28,$26
	.byte $66,$68,$6A,$6C,$2C,$2A,$28,$26
        
ColorShuriken
	JSR GetRaster4
        
.mod18        
        CMP #8
        BCC .colorShurikenReady
        SEC
        SBC #8
        JMP .mod18
.colorShurikenReady        
	TAY
        
	LDA ColorsShuriken + 0,Y 
        STA LeftRasterColors + 1,x
	LDA ColorsShuriken + 1,Y 
        STA LeftRasterColors + 5,x
	LDA ColorsShuriken + 2,Y 
        STA LeftRasterColors + 9,x

	LDA ColorsShuriken + 3,Y 
        STA LeftRasterColors + 13,x
	LDA ColorsShuriken + 4,Y 
        STA LeftRasterColors + 17,x
	LDA ColorsShuriken + 5,Y 
        STA LeftRasterColors + 21,x
;        LDA #$90
;        STA LeftRasterColors + 25,x
        
;        JSR ApplyTimings
	JMP returnColorFunctionPtr


;ApplyTimings
;        LDA RasterMode
;        BNE .startedShow
;        BCS .startedShow
;        LDA #0
;        STA LeftRasterColors + 1,x
;        STA LeftRasterColors + 5,x
;.startedShow        

;        LDA RasterMode
;        CMP #2
;        BNE .notEndedShow
;        LDA #0
;        STA LeftRasterColors + 17,x
;        STA LeftRasterColors + 21,x
;.notEndedShow        
;	RTS

;ColorsBomb .byte $64,$68,$6C,$6E,$CE,$CC,$C6,$C6
;	.byte $64,$68,$6C,$6E,$CE,$CC,$C6,$C6
ColorBomb
	JSR GetRaster4
;        LDA RasterFrame ; 0..7
;        LSR
;        LSR ; /4
;        LSR ; /8 C = half
;        LDA RasterFrame + 1
;        ROL
        AND #7

.mod18b        
        CMP #8
        BCC .colorBombReady
        SEC
        SBC #8
        JMP .mod18b
.colorBombReady        
	TAY

        LDA ColorsBomb,Y
        STA LeftRasterColors + 1,x
        LDA ColorsBomb+1,Y
        STA LeftRasterColors + 5,x
        LDA ColorsBomb+2,Y
        STA LeftRasterColors + 9,x

        LDA ColorsBomb+3,Y
        STA LeftRasterColors + 13,x
        LDA ColorsBomb+4,Y
        STA LeftRasterColors + 17,x
        LDA ColorsBomb+5,Y
        STA LeftRasterColors + 21,x
        LDA #$86
        STA LeftRasterColors + 25,x
        
;        JSR ApplyTimings
        
NopColorFunction
	JMP returnColorFunctionPtr

;	JMP returnColorFunctionPtr

;SingleColorRaster
;        LDA #$60 ; B0
;	ORA #4
;        STA LeftRasterColors + 1,x
;	EOR #$C
;        STA LeftRasterColors + 5,x
;        EOR #6
;        STA LeftRasterColors + 9,x

;	lda #$60 ; 20
;        EOR #$C
;        STA LeftRasterColors + 13,x
;        EOR #4 ; 8
;        STA LeftRasterColors + 17,x
;        EOR #$C ;E ; 6
;        STA LeftRasterColors + 21,x

;        LDA #$62 ;E ; 6
;        STA LeftRasterColors + 25,x

;	RTS

; TIATracker music player
; Copyright 2016 Andre "Kylearan" Wichmann
; Website: https://bitbucket.org/kylearan/tiatracker
; Email: andre.wichmann@gmx.de
;
; Licensed under the Apache License, Version 2.0 (the "License");
; you may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
;   http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

; Song author: glafouk
; Song name: Bombers Schott bleu marine

; @com.wudsn.ide.asm.hardware=ATARI2600

; =====================================================================
; TIATracker Player
; =====================================================================
tt_PlayerStart:
	LDA DEMO_PART
        AND #$90
        CMP #$90
        BNE .canPlay
        
        LDA #0
        STA AUDV0
        STA AUDV1
	RET_MAGI_CALL
.canPlay        
;	RET_MAGI_CALL

; PLANNED PLAYER VARIANTS:
; - RAM, speed, player ROM: c0/c1 patterns have same length
; - RAM: Pack 2 values (out of cur_pat_index, cur_note_index, envelope_index)
;       into one and use lsr/asl to unpack them, allowing only ranges of
;       16/16 or 32/8 for them, depending on number of patterns, max
;       pattern size and max ADSR size
; - ROM: Check if tt_SequenceTable can hold ptrs directly without indexing
;       tt_PatternPtrLo/Hi. Can be smaller if not many patterns get repeated
;       (saves table and decode routine)
; - Speed: Inline tt_CalcInsIndex
; - Speed: Store ptr to current note in RAM instead of reconstructing it?
;       Might also save the need for cur_note_index


; ---------------------------------------------------------------------
; Helper macro: Retrieves current note. May advance pattern if needed.
; Becomes a subroutine if TT_USE_OVERLAY is used.
; ---------------------------------------------------------------------
    MAC TT_FETCH_CURRENT_NOTE
        ; construct ptr to pattern
.constructPatPtr:
        ldy tt_cur_pat_index_c0,x       ; get current pattern (index into tt_SequenceTable)
        lda tt_SequenceTable,y
    IF TT_USE_GOTO = 1
        bpl .noPatternGoto
        and #%01111111                  ; mask out goto bit to get pattern number
        sta tt_cur_pat_index_c0,x       ; store goto'ed pattern index
        bpl .constructPatPtr            ; unconditional
.noPatternGoto:
    ENDIF
        tay
        lda tt_PatternPtrLo,y
        sta tt_ptr
        lda tt_PatternPtrHi,y
        sta tt_ptr+1
        ; get new note
    IF TT_USE_OVERLAY = 0
        ldy tt_cur_note_index_c0,x
    ELSE
        ; If the V flag is set and if the new note is an instrument,
        ; it means it got pre-fetched by an overlay percussion, it has
        ; to remain in sustain.
        clv
        ; check if note had been pre-fetched by overlay perc already
        lda tt_cur_note_index_c0,x
        bpl .notPrefetched
        ; If so, remove flag
        and #%01111111
        sta tt_cur_note_index_c0,x
        ; Set V flag for later
        bit tt_Bit6Set
.notPrefetched:
        tay
    ENDIF
        lda (tt_ptr),y
        ; pre-process new note
        ; 7..5: instrument (1..7), 4..0 (0..31): frequency
        ; 0/0: End of pattern
        bne .noEndOfPattern
        ; End of pattern: Advance to next pattern
        sta tt_cur_note_index_c0,x      ; a is 0
        inc tt_cur_pat_index_c0,x
        bne .constructPatPtr            ; unconditional
.noEndOfPattern:
    ENDM


; ---------------------------------------------------------------------
; Music player entry. Call once per frame.
; ---------------------------------------------------------------------
tt_Player SUBROUTINE    
        ; ==================== Sequencer ====================
        ; Decrease speed timer
        dec tt_timer
        bpl .noNewNote
        
        ; Timer ran out: Do sequencer
        ; Advance to next note
        ldx #1                          ; 2 channels
.advanceLoop:
    IF TT_USE_OVERLAY = 1
        jsr tt_FetchNote
    ELSE
        TT_FETCH_CURRENT_NOTE
    ENDIF
        ; Parse new note from pattern
        cmp #TT_INS_PAUSE
    IF TT_USE_SLIDE = 0
        bcc .finishedNewNote	
        bne .newNote
    ELSE
        beq .pause
        bcs .newNote

        ; --- slide/hold ---
        ; Adjust frequency and hold note in sustain.
        ; composer/tracker has to make sure that no unwanted
        ; under/overflow happens.
        ; Note: f = f + (8-(16-x)) = x + f - 8
        adc tt_cur_ins_c0,x             ; carry is clear after cmp
        sec
        sbc #8
        sta tt_cur_ins_c0,x
        bcs .finishedNewNote            ; unconditional, since legally no underflow can happen (ins>0 or HOLD for ins=0)
    ENDIF
  
        ; --- pause ---
.pause:
        ; Get release index for current instrument. Since a pause can
        ; only follow an instrument, we don't need to handle percussion
        ; or commands.
        lda tt_cur_ins_c0,x
        jsr tt_CalcInsIndex
        lda tt_InsReleaseIndexes-1,y    ; -1 b/c instruments start at #1
        ; Put it into release. Skip junk byte so index no longer indicates
        ; sustain phase.
        clc
        adc #1
        bcc .storeADIndex               ; unconditional

; ---------------------------------------------------------------------
; Helper subroutine to minimize ROM footprint. Will be inlined if
; TT_USE_OVERLAY is not used.
; Interleaved here so player can be inlined.
; ---------------------------------------------------------------------
    IF TT_USE_OVERLAY = 1
tt_FetchNote:
        TT_FETCH_CURRENT_NOTE
        rts
    ENDIF


        ; --- start instrument or percussion ---
.newNote:
        sta tt_cur_ins_c0,x             ; set new instrument
        ; Instrument or percussion?
        cmp #TT_FREQ_MASK+1
        bcs .startInstrument

        ; --- start percussion ---
        ; Get index of envelope
        tay
        ; -TT_FIRST_PERC because percussion start with TT_FIRST_PERC
        lda tt_PercIndexes-TT_FIRST_PERC,y
        bne .storeADIndex               ; unconditional, since index values are >0

        ; --- start instrument ---
.startInstrument:
    IF TT_USE_OVERLAY = 1
        ; If V flag is set, this note had been pre-fetched. That means
        ; it should remain in sustain.
        bvs .finishedNewNote
    ENDIF
        ; Put note into attack/decay
        jsr tt_CalcInsIndex
        lda tt_InsADIndexes-1,y         ; -1 because instruments start at #1
.storeADIndex:
        sta tt_envelope_index_c0,x      

        ; --- Finished parsing new note ---
.finishedNewNote:
        ; increase note index into pattern
        inc tt_cur_note_index_c0,x
        ; loop over channels
.sequencerNextChannel:
        dex
        bpl .advanceLoop

        ; Reset timer value
    IF TT_GLOBAL_SPEED = 0
        ; Get timer value for current pattern in channel 0
        ldx tt_cur_pat_index_c0         ; get current pattern (index into tt_SequenceTable)
        ldy tt_SequenceTable,x          ; Current pattern index now in y
      IF TT_USE_FUNKTEMPO = 0
        lda tt_PatternSpeeds,y
        sta tt_timer
      ELSE
        ; Test for odd/even frame
        lda tt_cur_note_index_c0
        lsr
        lda tt_PatternSpeeds,y          ; does not affect carry flag
        bcc .evenFrame
        and #$0f                        ; does not affect carry flag
        bcs .storeFunkTempo        
.evenFrame:
        lsr
        lsr
        lsr
        lsr
.storeFunkTempo:
        sta tt_timer
      ENDIF   ; TT_USE_FUNKTEMPO = 0

    ELSE
        ; Global tempo
        ldx #TT_SPEED-1
      IF TT_USE_FUNKTEMPO = 1
        lda tt_cur_note_index_c0
        lsr
        bcc .noOddFrame
        ldx #TT_ODD_SPEED-1
.noOddFrame:
      ENDIF   ; TT_USE_FUNKTEMPO = 1
        stx tt_timer
    ENDIF   ; TT_GLOBAL_SPEED = 0

        ; No new note to process
.noNewNote:

        ; ==================== Update registers ====================
        ldx #1                          ; 2 channels
.updateLoop:
        ; Percussion or melodic instrument?
        lda tt_cur_ins_c0,x
    IF TT_STARTS_WITH_NOTES = 0
        ; This branch can be removed if track starts with a note in each channel
        beq .afterAudioUpdate
    ENDIF
        cmp #TT_FREQ_MASK+1
        bcs .instrument                 ; Melodic instrument

        ; --- Percussion: Get envelope index ---
        ldy tt_envelope_index_c0,x
        ; Set AUDC and AUDV value from envelope
        lda tt_PercCtrlVolTable-1,y     ; -1 because values are stored +1
        beq .endOfPercussion            ; 0 means end of percussion data
        inc tt_envelope_index_c0,x      ; if end not reached: advance index
.endOfPercussion:
        sta AUDV0,x
        lsr
        lsr
        lsr
        lsr
        sta AUDC0,x     
        ; Set AUDF
        lda tt_PercFreqTable-1,y        ; -1 because values are stored +1
        ; Bit 7 (overlay) might be set, but is unused in AUDF
        sta AUDF0,x
    IF TT_USE_OVERLAY = 1
        bpl .afterAudioUpdate
        ; Overlay percussion: Fetch next note out of order
        jsr tt_FetchNote
        ; Only do something if it's a melodic instrument
        cmp #TT_FREQ_MASK+1
        bcc .afterAudioUpdate
        ; Instrument: Put into sustain
        sta tt_cur_ins_c0,x             ; set new instrument
        jsr tt_CalcInsIndex
        lda tt_InsSustainIndexes-1,y    ; -1 because instruments start at #1
        sta tt_envelope_index_c0,x      
        ; Set prefetch flag. asl-sec-ror is smaller than lda-ora #128-sta
        asl tt_cur_note_index_c0,x
        sec
        ror tt_cur_note_index_c0,x
        bmi .afterAudioUpdate           ; unconditional
    ELSE  
        jmp .afterAudioUpdate
    ENDIF

    
; ---------------------------------------------------------------------
; Helper subroutine to minimize ROM footprint.
; Interleaved here so player routine can be inlined.
; ---------------------------------------------------------------------
tt_CalcInsIndex:
        ; move upper 3 bits to lower 3
        lsr
        lsr
        lsr
        lsr
        lsr
        tay
tt_Bit6Set:     ; This opcode has bit #6 set, for use with bit instruction
        rts


.instrument:
        ; --- Melodic instrument ---
        ; Compute index into ADSR indexes and master Ctrl tables
        jsr tt_CalcInsIndex
        ; Set AUDC with master value for this instrument, while we are at it
        lda tt_InsCtrlTable-1,y ; -1 because instruments start with #1
        sta AUDC0,x
        ; advance ADSR counter and compare to end of Sustain
        lda tt_envelope_index_c0,x
        cmp tt_InsReleaseIndexes-1,y    ; -1 because instruments start with #1
        bne .noEndOfSustain
        ; End of sustain: Go back to start of sustain
        lda tt_InsSustainIndexes-1,y    ; -1 because instruments start with #1
.noEndOfSustain:
        tay
        ; Set volume from envelope
        lda tt_InsFreqVolTable,y
        beq .endOfEnvelope              ; 0 means end of release has been reached:
        iny                             ; advance index otherwise
.endOfEnvelope:
        sty tt_envelope_index_c0,x
        sta AUDV0,x
        ; Now adjust frequency with ADSR value from envelope
        lsr
        lsr
        lsr
        lsr     
        clc
        adc tt_cur_ins_c0,x
        sec
        sbc #8
        sta AUDF0,x

.afterAudioUpdate:
        ; loop over channels
        dex
        bpl .updateLoop

	RET_MAGI_CALL

        echo "Music player size: ", *-tt_PlayerStart










; TIATracker music player
; Copyright 2016 Andre "Kylearan" Wichmann
; Website: https://bitbucket.org/kylearan/tiatracker
; Email: andre.wichmann@gmx.de
;
; Licensed under the Apache License, Version 2.0 (the "License");
; you may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
;   http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

;; Song author: glafouk
; Song name: Bombers Schott bleu marine

; @com.wudsn.ide.asm.hardware=ATARI2600

; =====================================================================
; TIATracker melodic and percussion instruments, patterns and sequencer
; data.
; =====================================================================
tt_TrackDataStart:

; =====================================================================
; Melodic instrument definitions (up to 7). tt_envelope_index_c0/1 hold
; the index values into these tables for the current instruments played
; in channel 0 and 1.
; 
; Each instrument is defined by:
; - tt_InsCtrlTable: the AUDC value
; - tt_InsADIndexes: the index of the start of the ADSR envelope as
;       defined in tt_InsFreqVolTable
; - tt_InsSustainIndexes: the index of the start of the Sustain phase
;       of the envelope
; - tt_InsReleaseIndexes: the index of the start of the Release phase
; - tt_InsFreqVolTable: The AUDF frequency and AUDV volume values of
;       the envelope
; =====================================================================

; Instrument master CTRL values
tt_InsCtrlTable:
        dc.b $04, $0c, $04, $0c, $01


; Instrument Attack/Decay start indexes into ADSR tables.
tt_InsADIndexes:
        dc.b $00, $00, $09, $09, $12


; Instrument Sustain start indexes into ADSR tables
tt_InsSustainIndexes:
        dc.b $05, $05, $0e, $0e, $12


; Instrument Release start indexes into ADSR tables
; Caution: Values are stored with an implicit -1 modifier! To get the
; real index, add 1.
tt_InsReleaseIndexes:
        dc.b $06, $06, $0f, $0f, $13


; AUDVx and AUDFx ADSR envelope values.
; Each byte encodes the frequency and volume:
; - Bits 7..4: Freqency modifier for the current note ([-8..7]),
;       8 means no change. Bit 7 is the sign bit.
; - Bits 3..0: Volume
; Between sustain and release is one byte that is not used and
; can be any value.
; The end of the release phase is encoded by a 0.
tt_InsFreqVolTable:
; 0+1: ---
        dc.b $87, $87, $87, $77, $86, $81, $00, $80
        dc.b $00
; 2+3: ---
        dc.b $87, $87, $87, $86, $84, $81, $00, $80
        dc.b $00
; 4: ---
        dc.b $85, $00, $85, $00



; =====================================================================
; Percussion instrument definitions (up to 15)
;
; Each percussion instrument is defined by:
; - tt_PercIndexes: The index of the first percussion frame as defined
;       in tt_PercFreqTable and tt_PercCtrlVolTable
; - tt_PercFreqTable: The AUDF frequency value
; - tt_PercCtrlVolTable: The AUDV volume and AUDC values
; =====================================================================

; Indexes into percussion definitions signifying the first frame for
; each percussion in tt_PercFreqTable.
; Caution: Values are stored with an implicit +1 modifier! To get the
; real index, subtract 1.
tt_PercIndexes:
        dc.b $01, $26, $2d


; The AUDF frequency values for the percussion instruments.
; If the second to last value is negative (>=128), it means it's an
; "overlay" percussion, i.e. the player fetches the next instrument note
; immediately and starts it in the sustain phase next frame. (Needs
; TT_USE_OVERLAY)
tt_PercFreqTable:
; 0: NoiseBruit
        dc.b $0c, $0d, $0c, $0f, $0d, $11, $0f, $13
        dc.b $11, $15, $13, $17, $15, $19, $17, $1b
        dc.b $19, $1d, $1b, $1f, $12, $11, $10, $0f
        dc.b $0e, $0d, $0c, $0b, $0a, $08, $05, $03
        dc.b $00, $00, $00, $00, $00
; 1: SnareShort
        dc.b $05, $1c, $08, $02, $01, $02, $00
; 2: KickShort
        dc.b $05, $09, $0c, $00


; The AUDCx and AUDVx volume values for the percussion instruments.
; - Bits 7..4: AUDC value
; - Bits 3..0: AUDV value
; 0 means end of percussion data.
tt_PercCtrlVolTable:
; 0: NoiseBruit
        dc.b $4f, $4f, $4f, $4f, $4f, $4f, $4f, $4f
        dc.b $4f, $4f, $4f, $4f, $4f, $4f, $4f, $4f
        dc.b $4f, $4f, $4e, $4e, $8d, $8d, $8c, $8c
        dc.b $8b, $8b, $8a, $8a, $89, $89, $88, $87
        dc.b $86, $85, $83, $81, $00
; 1: SnareShort
        dc.b $8f, $cf, $6e, $8b, $87, $84, $00
; 2: KickShort
        dc.b $6f, $6d, $69, $00


        
; =====================================================================
; Track definition
; The track is defined by:
; - tt_PatternX (X=0, 1, ...): Pattern definitions
; - tt_PatternPtrLo/Hi: Pointers to the tt_PatternX tables, serving
;       as index values
; - tt_SequenceTable: The order in which the patterns should be played,
;       i.e. indexes into tt_PatternPtrLo/Hi. Contains the sequences
;       for all channels and sub-tracks. The variables
;       tt_cur_pat_index_c0/1 hold an index into tt_SequenceTable for
;       each channel.
;
; So tt_SequenceTable holds indexes into tt_PatternPtrLo/Hi, which
; in turn point to pattern definitions (tt_PatternX) in which the notes
; to play are specified.
; =====================================================================

; ---------------------------------------------------------------------
; Pattern definitions, one table per pattern. tt_cur_note_index_c0/1
; hold the index values into these tables for the current pattern
; played in channel 0 and 1.
;
; A pattern is a sequence of notes (one byte per note) ending with a 0.
; A note can be either:
; - Pause: Put melodic instrument into release. Must only follow a
;       melodic instrument.
; - Hold: Continue to play last note (or silence). Default "empty" note.
; - Slide (needs TT_USE_SLIDE): Adjust frequency of last melodic note
;       by -7..+7 and keep playing it
; - Play new note with melodic instrument
; - Play new note with percussion instrument
; - End of pattern
;
; A note is defined by:
; - Bits 7..5: 1-7 means play melodic instrument 1-7 with a new note
;       and frequency in bits 4..0. If bits 7..5 are 0, bits 4..0 are
;       defined as:
;       - 0: End of pattern
;       - [1..15]: Slide -7..+7 (needs TT_USE_SLIDE)
;       - 8: Hold
;       - 16: Pause
;       - [17..31]: Play percussion instrument 1..15
;
; The tracker must ensure that a pause only follows a melodic
; instrument or a hold/slide.
; ---------------------------------------------------------------------
TT_FREQ_MASK    = %00011111
TT_INS_HOLD     = 8
TT_INS_PAUSE    = 16
TT_FIRST_PERC   = 17

; IntroA
tt_pattern0:
        dc.b $51, $51, $3a, $51, $4e, $08, $4b, $3f
        dc.b $3d, $08, $3d, $08, $3f, $08, $08, $08
        dc.b $10, $08, $08, $08, $08, $08, $08, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $00

; RideauBruit
tt_pattern1:
        dc.b $11, $08, $08, $08, $08, $08, $00

; VideMeubleA
tt_pattern2:
        dc.b $93, $91, $8e, $3a, $93, $91, $8e, $3d
        dc.b $8e, $93, $91, $4b, $8e, $93, $91, $3d
        dc.b $93, $91, $8c, $33, $93, $91, $8c, $3d
        dc.b $8e, $8f, $8e, $3a, $8e, $8f, $91, $3d
        dc.b $00

; mel0a
tt_pattern3:
        dc.b $3a, $3a, $2c, $3a, $35, $91, $31, $2f
        dc.b $2e, $91, $2e, $93, $2f, $93, $91, $8e
        dc.b $3d, $3d, $2e, $3d, $37, $91, $33, $31
        dc.b $30, $8e, $31, $30, $3d, $3f, $3d, $93
        dc.b $00

; mel0b
tt_pattern4:
        dc.b $4b, $4b, $31, $4b, $33, $91, $34, $33
        dc.b $4b, $8e, $31, $93, $4b, $8e, $93, $91
        dc.b $4b, $4b, $31, $4b, $33, $91, $34, $33
        dc.b $4b, $93, $31, $91, $4b, $4c, $4b, $93
        dc.b $00

; mel1d
tt_pattern5:
        dc.b $91, $91, $3d, $3a, $91, $08, $4b, $91
        dc.b $3d, $08, $91, $3a, $08, $91, $4b, $08
        dc.b $8e, $8e, $35, $3a, $8e, $08, $4b, $08
        dc.b $3d, $08, $8e, $3a, $08, $8e, $35, $91
        dc.b $00

; mel1e
tt_pattern6:
        dc.b $93, $93, $4b, $3d, $93, $08, $35, $93
        dc.b $3a, $08, $93, $3f, $08, $93, $4b, $3d
        dc.b $8b, $8b, $3d, $3a, $8b, $35, $33, $8b
        dc.b $3a, $08, $8c, $3d, $8e, $93, $3a, $8b
        dc.b $00

; mel1f
tt_pattern7:
        dc.b $8b, $8b, $33, $31, $8b, $08, $3a, $8b
        dc.b $35, $08, $8b, $3d, $08, $8e, $8c, $8e
        dc.b $93, $93, $31, $33, $93, $35, $3a, $08
        dc.b $35, $08, $91, $33, $3a, $93, $3d, $93
        dc.b $00

; mel2a
tt_pattern8:
        dc.b $6e, $7d, $08, $08, $6b, $77, $08, $08
        dc.b $71, $8b, $08, $08, $97, $08, $93, $08
        dc.b $9a, $08, $6e, $7d, $6c, $7a, $6e, $7d
        dc.b $71, $8b, $6e, $7d, $71, $8b, $77, $8f
        dc.b $00

; mel2b
tt_pattern9:
        dc.b $7a, $91, $08, $08, $73, $8c, $08, $08
        dc.b $77, $8f, $08, $08, $9d, $08, $9a, $08
        dc.b $97, $08, $93, $08, $9a, $08, $97, $08
        dc.b $9a, $08, $75, $8e, $73, $8c, $71, $8b
        dc.b $00

; mel2c
tt_pattern10:
        dc.b $7a, $91, $08, $08, $73, $8c, $08, $08
        dc.b $77, $8f, $08, $08, $97, $08, $9a, $08
        dc.b $97, $08, $9d, $08, $91, $08, $93, $08
        dc.b $91, $08, $8e, $08, $71, $8b, $73, $8c
        dc.b $00

; DAFTa
tt_pattern11:
        dc.b $08, $08, $93, $08, $91, $08, $3d, $7d
        dc.b $3f, $7f, $3d, $08, $93, $91, $3a, $7a
        dc.b $93, $08, $3d, $7d, $94, $93, $3f, $7f
        dc.b $91, $08, $3d, $7d, $9a, $97, $37, $77
        dc.b $00

; DAFTb
tt_pattern12:
        dc.b $08, $08, $9a, $08, $97, $08, $3d, $7d
        dc.b $3f, $7f, $3d, $7d, $93, $97, $3a, $7a
        dc.b $93, $08, $3d, $7d, $94, $08, $3f, $7f
        dc.b $8f, $08, $3d, $7d, $93, $08, $37, $77
        dc.b $00

; Introb
tt_pattern13:
        dc.b $3a, $3a, $2c, $3a, $35, $08, $31, $2f
        dc.b $2e, $08, $2e, $08, $2f, $08, $08, $08
        dc.b $71, $71, $68, $71, $69, $71, $6a, $69
        dc.b $68, $71, $69, $68, $6b, $08, $10, $08
        dc.b $00

; RideauDrums
tt_pattern14:
        dc.b $11, $08, $08, $08, $12, $12, $00

; DB0a
tt_pattern15:
        dc.b $13, $13, $bc, $08, $12, $08, $bc, $13
        dc.b $08, $bc, $13, $08, $12, $08, $bc, $08
        dc.b $13, $13, $b7, $08, $12, $08, $b7, $13
        dc.b $08, $b7, $13, $08, $12, $b7, $12, $12
        dc.b $00

; DB0b
tt_pattern16:
        dc.b $13, $13, $bf, $08, $12, $08, $bf, $13
        dc.b $08, $bf, $13, $08, $12, $08, $bf, $08
        dc.b $13, $13, $b7, $08, $12, $08, $b7, $13
        dc.b $08, $b4, $13, $b2, $12, $b7, $12, $12
        dc.b $00

; DB0c
tt_pattern17:
        dc.b $13, $13, $b2, $08, $12, $08, $b2, $13
        dc.b $08, $b2, $13, $08, $12, $08, $b2, $08
        dc.b $13, $13, $b4, $08, $12, $08, $b4, $13
        dc.b $08, $b4, $13, $bc, $12, $b7, $12, $12
        dc.b $00

; DrumFinals
tt_pattern18:
        dc.b $13, $13, $08, $08, $12, $08, $08, $13
        dc.b $08, $08, $13, $08, $12, $08, $08, $08
        dc.b $00

; boutDeVide
tt_pattern19:
        dc.b $08, $08, $08, $00




; Individual pattern speeds (needs TT_GLOBAL_SPEED = 0).
; Each byte encodes the speed of one pattern in the order
; of the tt_PatternPtr tables below.
; If TT_USE_FUNKTEMPO is 1, then the low nibble encodes
; the even speed and the high nibble the odd speed.
    IF TT_GLOBAL_SPEED = 0
tt_PatternSpeeds:
%%PATTERNSPEEDS%%
    ENDIF


; ---------------------------------------------------------------------
; Pattern pointers look-up table.
; ---------------------------------------------------------------------
tt_PatternPtrLo:
        dc.b <tt_pattern0, <tt_pattern1, <tt_pattern2, <tt_pattern3
        dc.b <tt_pattern4, <tt_pattern5, <tt_pattern6, <tt_pattern7
        dc.b <tt_pattern8, <tt_pattern9, <tt_pattern10, <tt_pattern11
        dc.b <tt_pattern12, <tt_pattern13, <tt_pattern14, <tt_pattern15
        dc.b <tt_pattern16, <tt_pattern17, <tt_pattern18, <tt_pattern19

tt_PatternPtrHi:
        dc.b >tt_pattern0, >tt_pattern1, >tt_pattern2, >tt_pattern3
        dc.b >tt_pattern4, >tt_pattern5, >tt_pattern6, >tt_pattern7
        dc.b >tt_pattern8, >tt_pattern9, >tt_pattern10, >tt_pattern11
        dc.b >tt_pattern12, >tt_pattern13, >tt_pattern14, >tt_pattern15
        dc.b >tt_pattern16, >tt_pattern17, >tt_pattern18, >tt_pattern19
        


; ---------------------------------------------------------------------
; Pattern sequence table. Each byte is an index into the
; tt_PatternPtrLo/Hi tables where the pointers to the pattern
; definitions can be found. When a pattern has been played completely,
; the next byte from this table is used to get the address of the next
; pattern to play. tt_cur_pat_index_c0/1 hold the current index values
; into this table for channels 0 and 1.
; If TT_USE_GOTO is used, a value >=128 denotes a goto to the pattern
; number encoded in bits 6..0 (i.e. value AND %01111111).
; ---------------------------------------------------------------------
tt_SequenceTable:
        ; ---------- Channel 0 ----------
        dc.b $00, $01, $02, $02, $02, $02, $03, $04
        dc.b $03, $04, $05, $06, $05, $07, $03, $04
        dc.b $03, $04, $08, $09, $08, $0a, $03, $04
        dc.b $03, $04, $0b, $0c, $0b, $0c, $03, $04
        dc.b $0d

        
        ; ---------- Channel 1 ----------
        dc.b $0d, $0e, $0f, $10, $0f, $11, $0f, $10
        dc.b $0f, $11, $0f, $10, $0f, $11, $0f, $10
        dc.b $0f, $11, $0f, $10, $0f, $11, $0f, $10
        dc.b $0f, $11, $0f, $10, $0f, $11, $12, $12
        dc.b $12, $12, $12, $13, $13, $13, $13, $13


        echo "Track size: ", *-tt_TrackDataStart

;	ALIGN 256

	echo "Current address", *
        echo "ROM left bank 7: ", ($FFEB - *)
        
        RORG    $FFEB
        org $7FEB
endKernelRaster
	BANK_SWITCH 7,realEndKernelRaster
        RORG    $FFF4
        org $7FF4
        DS 6,0

        .word $F000      ; NMI
        .word $F000      ; RESET
        .word $F000      ; BRK
