; Logiker X-mas challenge 2025
; By DDT, on 20241222
; Use 64tass assembler and run on C64.

  * = $0801   ; C64
  .word end_BASIC
  .word 10
  .byte $9e ; SYS
    .text "2061", $00 ; C64
end_BASIC:
  .word 0

SCR_START = $500
OFFL      = $FC
OFFR      = $FD

    ; Setup row ptr.
    ;lda #0
    ;sta $F8                ; This is already 0 after reset.
    lda #>SCR_START
    sta $F9

main:
    ; Left and right spikes.
    ldx #'*'
    stx $400+40*15+15
    stx $400+40*15+33

nxt_pattern:    
    ldy #9
    sty OFFR

    dey
    txa
    sta ($F8),y     ; Draw mid-line.

    dey
    sty OFFL
    
p0: lda pattern
    cmp #$ff        ; If end of table, change INC to DEC to mirror flake vertically.
    bne +
    ldy #$ce
    sty i0
+    
    
nxt_bit:
    asl
    bcc hole
    pha
    txa
    ldy OFFL
    sta ($F8),y     ; Draw left side.
    ldy OFFR
    sta ($F8),y     ; Draw right side.
    pla
hole:
    inc OFFR
    dec OFFL
    bpl nxt_bit

i0: inc p0+1        ; Inc pattern ptr.
    
    ; Update row ptr.
    clc
    lda $F8
    adc #40
    sta $F8
    bcc +
    inc $F9
+
    dec rows
    bne nxt_pattern

    rts

rows: .byte 19

; Upper-Right side of flake.
; That's more than enough info we need.
; In theory, we'd need just over half of it (8-way symmetry, but this would require a lot more code).
pattern:
.byte %00000000
.byte %01000000
.byte %10001010
.byte %00001100
.byte %01001110
.byte %10010000
.byte %00100000
.byte %01001001
.byte %10010010
.byte %11111111
