org 0x0100
global main

section .text
main:       mov si, -9                      ; row
reset_col:  mov di, -9                      ; col

col_loop:   mov cx, di
            test cx, cx
            jg positive_col
            neg cx                          ; cx=abs(col)
positive_col:    
            mov bx, si
            test bx, bx
            jg positive_row
            neg bx                          ; bx=abs(row)
positive_row:    
            shl bx, 1                       ; multiply by 2 to go from bytes to words
            mov bx, WORD [flakedata + bx]   ; bx = flakedata[abs(row)]
            shr bx, cl                      ; bx = flakedata[abs(row)]>>abs(col)
            and bl, 1                       ; bl = flakedata[abs(row)]>>col  & 1
            mov dl, ' '                     ; preset character to space
            jz printbit
            mov dl, '*'                     ; overwrite character as star

printbit:   mov ah, 2                       ; int 0x21, ah=2 prints the character in dl
            int 0x21                        ; print dl (either space or star)

            inc di                          ; Next column
            cmp di, 10 
            jne col_loop

            mov dl, 10                      ; Newline (ah is still set to 2)
            int 0x21

            inc si                          ; Next row
            cmp si, di                      ; di is 10
            jne reset_col
            int 0x20                        ; back to o/s

flakedata:  dw 1023,147,293,9,19,229,97,163,5,1

