/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import org.kd.common.Globals;

public class Helper {
    static int SPEED = 3;

    public static void moveCursor(Vector2 source, Vector2 destination, long startFrame, long currentFrame) {
        if (currentFrame < startFrame) {
            System.err.println("Wrong frame numbers");
            return;
        }
        long elapsedFrames = currentFrame - startFrame;
        float distanceMoved = elapsedFrames;
        float fullDistance = source.dst(destination);
        if (distanceMoved > fullDistance) {
            distanceMoved = fullDistance;
        }
        float progress = fullDistance == 0.0f ? 0.0f : distanceMoved / fullDistance * (float)SPEED;
        int currentX = Math.round(source.x + (destination.x - source.x) * progress);
        int currentY = Math.round(source.y + (destination.y - source.y) * progress);
        Gdx.input.setCursorPosition(currentX, currentY);
    }

    public static String countElapsedTime() {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - Globals.startTime;
        long minutes = elapsedTime / 1000L / 60L;
        long seconds = elapsedTime / 1000L % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }
}

