/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AlphabetScroll {
    protected final List<Sprite> textSprites;
    protected final float startX;
    protected final float endX;
    protected int speed;
    protected final long initialFrame;
    protected float shiftY = 0.0f;

    public AlphabetScroll(String text, long initialFrame) {
        this(text, 0.91f * (float)Gdx.graphics.getWidth(), 21.0f, -15, initialFrame);
    }

    public AlphabetScroll(String text, float startX, float endX, int speed, long initialFrame) {
        this.textSprites = new ArrayList<Sprite>(text.length());
        this.initialFrame = initialFrame;
        List<Character> letters = Stream.of(text.split("")).map(s -> Character.valueOf(s.charAt(0))).collect(Collectors.toList());
        letters.forEach(letter -> {
            String filename = AlphabetScroll.convertToFilename(letter).toString();
            Texture texture = new Texture(filename);
            Sprite sprite = new Sprite(texture);
            sprite.setX(speed > 0 ? startX + 1.0f : startX - 1.0f);
            this.textSprites.add(sprite);
        });
        this.startX = startX;
        this.endX = endX;
        this.speed = speed;
    }

    public void update() {
        long frame = Gdx.graphics.getFrameId() - this.initialFrame;
        for (int i = 0; i < this.textSprites.size(); ++i) {
            Sprite s = this.textSprites.get(i);
            float delay = (float)i * this.textSprites.get(0).getWidth() * 0.1f - (float)(7 * this.speed);
            if (!((float)frame > delay) || !(s.getX() < this.startX) || !(s.getX() > this.endX)) continue;
            float x = s.getX() + (float)this.speed;
            float y = this.shiftY + (float)((double)s.getHeight() * Math.sin(Math.PI * (double)x / (double)this.startX));
            s.setPosition(x, y);
        }
    }

    public void render(SpriteBatch openBatch) {
        this.textSprites.forEach(sprite -> sprite.draw(openBatch));
    }

    public void colorize(Color color) {
        this.textSprites.forEach(s -> s.setColor(color));
    }

    public void scale(float scale) {
        this.textSprites.forEach(sprite -> sprite.setScale(scale));
    }

    private static StringBuilder convertToFilename(Character letter) {
        Object firstChar = letter.charValue() == ' ' ? "space" : "" + letter;
        StringBuilder filename = new StringBuilder();
        filename.append((String)firstChar);
        filename.insert(0, "alphabet\\");
        filename.append(".png");
        return filename;
    }

    public void setShiftY(float shiftY) {
        this.shiftY = shiftY;
        this.textSprites.forEach(s -> s.setY(shiftY));
    }
}

