/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;

public class BeepSound {
    private static final int SAMPLE_RATE = 44100;
    private static final int DURATION_MS = 50;
    private final AudioDevice audioDevice = Gdx.audio.newAudioDevice(44100, true);

    public void playBeep(int frequency) {
        int numSamples = 2205;
        short[] samples = new short[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            double t = (double)i / 44100.0;
            double sineValue = Math.sin(Math.PI * 2 * (double)frequency * t);
            samples[i] = (short)(sineValue * 32767.0);
        }
        this.audioDevice.writeSamples(samples, 0, numSamples);
    }

    public void dispose() {
        if (this.audioDevice != null) {
            this.audioDevice.dispose();
        }
    }
}

