/*
 * Decompiled with CFR 0.152.
 */
package org.kd.game.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kd.game.duel.Dice;

public class Roll {
    private int diceCount;
    private final List<Dice> diceList;
    private List<Integer> keptDiceList;

    public Roll(int diceCount) {
        this.diceCount = diceCount;
        this.diceList = new ArrayList<Dice>(diceCount);
        this.firstRoll();
    }

    private void firstRoll() {
        for (int i = 0; i < this.diceCount; ++i) {
            this.diceList.add(Dice.getRandom());
        }
    }

    public void reroll() {
        int i;
        ArrayList<Dice> randomList = new ArrayList<Dice>(this.diceCount);
        for (i = 0; i < this.diceCount; ++i) {
            Dice newDice = Dice.getRandom();
            randomList.add(newDice);
        }
        for (i = 0; i < this.diceList.size(); ++i) {
            if (this.keptDiceList.contains(i)) continue;
            this.diceList.set(i, (Dice)randomList.get(i));
        }
    }

    public void keep(List<Integer> toBeKeptIndices) {
        this.keptDiceList = toBeKeptIndices.stream().filter(i -> i < this.diceCount).collect(Collectors.toList());
    }

    public List<Dice> getDiceList() {
        return this.diceList;
    }
}

