/*
 * Decompiled with CFR 0.152.
 */
package org.kd.goodjob;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.C64Helper;
import org.kd.common.Scene;
import org.kd.common.tricks.Effects;

public final class Scene1Intro
extends Scene {
    private SpriteBatch batch;
    private BitmapFont hugeFont;
    private BitmapFont fontSmall;
    private Sprite appleLogo;
    private Texture appleTexture;
    private final int fiftyFontSize = 700;
    private float progressBarWidth = 0.0f;
    private ShapeRenderer shapeRenderer;

    public Scene1Intro() {
        super("50");
    }

    @Override
    public void create() {
        this.hugeFont = C64Helper.createFont(700, "Big Daddy LED TFB.ttf");
        this.fontSmall = C64Helper.createFont(45, "Helvetica Regular.otf");
        this.batch = new SpriteBatch();
        this.appleTexture = new Texture("good-job/apple-logo.png");
        this.appleLogo = new Sprite(this.appleTexture);
        this.shapeRenderer = new ShapeRenderer();
    }

    @Override
    public void update(float delta) {
        long frame = Gdx.graphics.getFrameId();
        if (frame == 0L) {
            Gdx.input.setCursorPosition(Gdx.graphics.getWidth(), 0);
        }
        if (850L < frame && frame < 1350L) {
            float colorParam = 1.0f - ((float)frame - 850.0f) / 500.0f;
            this.hugeFont.setColor(colorParam, colorParam, colorParam, colorParam);
        }
        this.progressBarWidth += (float)(0.5 + 3.5 * Math.random());
    }

    @Override
    public void render() {
        long frame = Gdx.graphics.getFrameId();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        if (frame < 720L) {
            this.shapeRenderer.setColor(Color.LIGHT_GRAY);
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            this.shapeRenderer.rect(140.0f, 300.0f, this.progressBarWidth, 30.0f);
            this.shapeRenderer.end();
        } else if (frame < 1350L) {
            this.hugeFont.draw((Batch)this.batch, "50", (float)Gdx.graphics.getWidth() / 2.0f - 525.0f, (float)Gdx.graphics.getHeight() / 2.0f + 350.0f);
        } else if (1400L < frame && frame < 2030L) {
            float a = Math.max(0.01f, 1.0f - ((float)frame - 850.0f - 550.0f) / 500.0f);
            this.batch.setColor(new Color(a, a, a, 1.0f));
            int x = Gdx.graphics.getWidth() / 2 - this.appleTexture.getWidth() / 2;
            int y = Gdx.graphics.getHeight() / 2 - this.appleTexture.getHeight() / 2;
            this.batch.draw(this.appleLogo, (float)x, (float)y);
        } else if (2099L < frame && frame < 2180L) {
            Effects.typewriter(this.batch, this.fontSmall, 20.0f, 900.0f, 2100L, 80L, "On April 1st, 1976", 2);
            Effects.typewriter(this.batch, this.fontSmall, 20.0f, 850.0f, 2141L, 62L, "the legend was born...........", 2);
        }
        this.batch.end();
    }

    @Override
    public void dispose() {
    }
}

