/*
 * Decompiled with CFR 0.152.
 */
package org.kd.goodjob;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.kd.common.C64Helper;
import org.kd.common.ConsoleLogger;
import org.kd.common.Demo;
import org.kd.common.Scene;
import org.kd.goodjob.appendix.BannerApple;
import org.kd.tricks.StarsArray;

public final class Scene2Stars
extends Scene {
    public static final long START_FRAME = 2229L;
    private SpriteBatch batch;
    private ShapeRenderer shapeRenderer;
    private Sprite ronaldWayne;
    private Sprite steveWozniak;
    private Sprite steveJobs;
    private Sprite asciiColor;
    private Sprite asciiBlack;
    private Sprite macAsciiDark;
    private Sprite macAsciiLight;
    private Sprite macAsciiColor;
    private Sprite macintosh;
    private List<Sprite> threeAmigosSprites;
    private List<Sprite> apple1Sprites;
    private Texture threeAmigos;
    private Texture apple1;
    private Texture apple2;
    private Texture noSnow;
    private Texture asciiWhite;
    private StarsArray starsArray;
    private BitmapFont fontSmall;
    private BitmapFont fontSmaller;

    public Scene2Stars() {
        super("2");
    }

    @Override
    public void create() {
        Texture wayneTexture = new Texture("good-job/RonaldWayne.png");
        Texture wozniakTexture = new Texture("good-job/SteveWozniak.png");
        Texture jobsTexture = new Texture("good-job/SteveJobs.png");
        this.threeAmigos = new Texture("good-job/3amigos/jobsWayneWoz.jpg");
        this.apple1 = new Texture("good-job/apple1/Apple1.jpg");
        this.apple2 = new Texture("good-job/apple2/apple2.jpg");
        this.asciiWhite = new Texture("good-job/apple2/asciiWHT.png");
        this.asciiBlack = new Sprite(new Texture("good-job/apple2/asciiBLK.png"));
        this.asciiColor = new Sprite(new Texture("good-job/apple2/asciiCOL.png"));
        this.macAsciiDark = new Sprite(new Texture("good-job/macintosh/ascii-dark.png"));
        this.macAsciiLight = new Sprite(new Texture("good-job/macintosh/ascii-light.png"));
        this.macAsciiColor = new Sprite(new Texture("good-job/macintosh/1ascii-color.png"));
        this.macintosh = new Sprite(new Texture("good-job/macintosh/2jobs-macintosh.jpg"));
        this.noSnow = new Texture("good-job/macintosh/nosnow.png");
        this.batch = new SpriteBatch();
        this.ronaldWayne = new Sprite(wayneTexture);
        this.ronaldWayne.setScale(0.5f, 0.5f);
        this.steveWozniak = new Sprite(wozniakTexture);
        this.steveWozniak.setScale(0.5f, 0.5f);
        this.steveJobs = new Sprite(jobsTexture);
        this.steveJobs.setScale(0.5f, 0.5f);
        this.shapeRenderer = new ShapeRenderer();
        this.starsArray = new StarsArray(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.starsArray.spread = 0.75;
        this.fontSmall = C64Helper.createFont(45, "Helvetica Regular.otf");
        this.fontSmaller = C64Helper.createFont(40, "Helvetica Regular.otf");
        this.threeAmigosSprites = new ArrayList<Sprite>(10);
        IntStream.range(0, 10).forEach(i -> {
            Texture t = new Texture("good-job/3amigos/pic" + i + ".png");
            Sprite s = new Sprite(t);
            s.setScale(0.02f, 1.0f);
            this.threeAmigosSprites.add(s);
        });
        this.apple1Sprites = new ArrayList<Sprite>(10);
        IntStream.range(0, 10).forEach(i -> {
            Texture t = new Texture("good-job/apple1/pic" + i + ".png");
            Sprite s = new Sprite(t);
            s.setScale(0.02f, 1.0f);
            this.apple1Sprites.add(s);
        });
    }

    @Override
    public void update(float delta) {
        if (this.getRelativeFrame() > 5029L) {
            return;
        }
        this.starsArray.move(6);
        if (this.getRelativeFrame() > 500L) {
            if (this.getRelativeFrame() < 778L) {
                float newScale = Math.min(2.0f, this.ronaldWayne.getScaleX() + 0.01f);
                this.ronaldWayne.setScale(newScale, newScale);
            } else if (this.getRelativeFrame() < 1000L) {
                float newScale = Math.min(2.0f, this.steveWozniak.getScaleX() + 0.01f);
                this.steveWozniak.setScale(newScale, newScale);
            } else if (this.getRelativeFrame() < 1280L) {
                float newScale = Math.min(2.0f, this.steveJobs.getScaleX() + 0.01f);
                this.steveJobs.setScale(newScale, newScale);
            }
            if (this.getRelativeFrame() < 1600L) {
                this.picFragmentsGoRound(this.threeAmigosSprites, Gdx.graphics.getWidth() / 3, Gdx.graphics.getHeight() / 2);
            } else if (this.getRelativeFrame() < 2100L) {
                this.gluePictureFragments(this.threeAmigosSprites, (float)Gdx.graphics.getHeight() / 3.0f, (float)Gdx.graphics.getWidth() / 4.0f);
            } else if (this.getRelativeFrame() < 2250L) {
                this.picFragmentsGoRound(this.apple1Sprites, 3 * Gdx.graphics.getWidth() / 5, Gdx.graphics.getHeight() / 2 - 30);
            } else {
                this.gluePictureFragments(this.apple1Sprites, (float)(3 * Gdx.graphics.getHeight()) / 5.0f, (float)Gdx.graphics.getWidth() / 2.0f - 30.0f);
            }
        }
        if (1360L < this.getRelativeFrame() && this.getRelativeFrame() < 1800L) {
            this.restoreSize(this.threeAmigosSprites);
        } else if (2160L < this.getRelativeFrame() && this.getRelativeFrame() < 2700L) {
            this.restoreSize(this.apple1Sprites);
        }
    }

    @Override
    public void render() {
        if (this.getRelativeFrame() > 5029L) {
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.conditionallyDrawFounders();
        this.conditionallyDraw3amigos();
        this.conditionallyDrawAppleI();
        this.conditionallyDrawAppleII();
        this.conditionallyDrawMacintosh();
        this.batch.end();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.starsArray.draw(this.shapeRenderer, 0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.shapeRenderer.end();
        if (Demo.logging) {
            ConsoleLogger.logBannerWithElapsedTime(BannerApple.lines);
        }
    }

    private void conditionallyDrawAppleI() {
        if (2100L < this.getRelativeFrame() && this.getRelativeFrame() < 2418L) {
            this.apple1Sprites.forEach(sprite -> sprite.draw(this.batch));
        } else if (2418L < this.getRelativeFrame()) {
            this.batch.draw(this.apple1, this.apple1Sprites.get(0).getX(), this.apple1Sprites.get(0).getY());
            if (this.getRelativeFrame() < 3400L) {
                this.fontSmall.draw((Batch)this.batch, "Apple 1 was assembled in Jobs's garage in Los Altos, CA in 1976.", 30.0f, 45.0f);
            }
        }
    }

    private void conditionallyDraw3amigos() {
        if (1350L < this.getRelativeFrame() && this.getRelativeFrame() < 1699L) {
            this.threeAmigosSprites.forEach(sprite -> sprite.draw(this.batch));
        } else if (1699L < this.getRelativeFrame()) {
            this.batch.draw(this.threeAmigos, this.threeAmigosSprites.get(0).getX(), this.threeAmigosSprites.get(0).getY());
            if (this.getRelativeFrame() < 2100L) {
                this.fontSmaller.draw((Batch)this.batch, "Wayne didn't believe in APPLE and left soon after co-founding the company.", 30.0f, 45.0f);
            }
        }
    }

    private void conditionallyDrawFounders() {
        if (this.getRelativeFrame() > 500L) {
            if (this.getRelativeFrame() < 778L) {
                this.drawFounder(this.ronaldWayne, "Ronald Wayne", 140.0f);
            } else if (this.getRelativeFrame() < 1000L) {
                this.drawFounder(this.steveWozniak, "Steve Wozniak", 340.0f);
            } else if (this.getRelativeFrame() < 1280L) {
                this.drawFounder(this.steveJobs, "Steve Jobs", 580.0f);
            }
        }
    }

    private void conditionallyDrawMacintosh() {
        int macX = 310;
        int macY = 122;
        if (3600L < this.getRelativeFrame() && this.getRelativeFrame() < 4200L) {
            if (this.getRelativeFrame() < 3700L) {
                this.macAsciiDark.draw(this.batch);
                Arrays.asList(this.macAsciiDark, this.macAsciiLight, this.macAsciiColor).forEach(mac -> mac.setPosition(macX, macY));
            } else if (this.getRelativeFrame() < 4104L) {
                if (this.getRelativeFrame() % 28L > 14L) {
                    this.macAsciiDark.draw(this.batch);
                } else {
                    this.macAsciiLight.draw(this.batch);
                }
                Arrays.asList(this.macAsciiDark, this.macAsciiLight, this.macAsciiColor).forEach(mac -> {
                    if (this.getRelativeFrame() % 3L == 1L) {
                        return;
                    }
                    float desiredScaleX = this.macintosh.getWidth() / mac.getWidth();
                    float desiredScaleY = this.macintosh.getHeight() / mac.getHeight();
                    float scaleX = mac.getScaleX() - 0.04f;
                    float scaleY = mac.getScaleY() - 0.04f;
                    scaleX = Math.max(scaleX, desiredScaleX);
                    scaleY = Math.max(scaleY, desiredScaleY);
                    mac.setScale(scaleX, scaleY);
                });
            } else if (this.getRelativeFrame() < 4200L) {
                float x = this.macAsciiColor.getX() - 1.75f;
                float y = this.macAsciiColor.getY() - 1.5f;
                this.macAsciiColor.setPosition(x, y);
                this.macAsciiColor.draw(this.batch);
            }
        }
        if (4200L < this.getRelativeFrame()) {
            this.macintosh.setPosition(macX, macY);
            this.macintosh.draw(this.batch);
            if (this.getRelativeFrame() < 5029L) {
                this.fontSmall.draw((Batch)this.batch, "Macintosh appeared in January 1984", 30.0f, 45.0f);
                if (this.getRelativeFrame() > 4859L) {
                    this.batch.draw(this.noSnow, (float)(macX - 190), (float)(macY + 228));
                }
            }
        }
    }

    private void conditionallyDrawAppleII() {
        float asciiY = 365.0f;
        if (2600L < this.getRelativeFrame()) {
            if (this.getRelativeFrame() < 2900L) {
                this.asciiBlack.setPosition(70.0f, asciiY);
                this.asciiBlack.draw(this.batch);
                float color = this.getRelativeFrame() - 2600L;
                this.asciiBlack.setColor(new Color(color / 300.0f, color / 300.0f, color / 300.0f, color / 300.0f));
            } else if (this.getRelativeFrame() < 3150L) {
                if (this.getRelativeFrame() % 20L > 10L) {
                    this.batch.draw(this.asciiWhite, 70.0f, asciiY);
                } else {
                    this.asciiBlack.draw(this.batch);
                }
            } else if (this.getRelativeFrame() <= 3400L) {
                this.asciiColor.setPosition(70.0f, asciiY);
                this.asciiColor.draw(this.batch);
                float scaleX = Math.max(0.7f, this.asciiColor.getScaleX() * 0.995f);
                float scaleY = Math.max(0.55f, this.asciiColor.getScaleY() * 0.995f);
                this.asciiColor.setScale(scaleX, scaleY);
            }
        }
        if (3400L < this.getRelativeFrame()) {
            this.batch.draw(this.apple2, 140.0f, 552.0f);
            if (this.getRelativeFrame() < 4200L) {
                this.fontSmall.draw((Batch)this.batch, "Apple II was released in June 1977.", 30.0f, 45.0f);
            }
        }
    }

    private void drawFounder(Sprite founder, String caption, float shiftX) {
        float founderX = (float)Gdx.graphics.getWidth() / 2.0f - founder.getScaleX() * this.ronaldWayne.getWidth() + shiftX;
        founder.setPosition(founderX, (float)Gdx.graphics.getHeight() / 2.0f - 240.0f);
        founder.draw(this.batch);
        this.fontSmall.draw((Batch)this.batch, caption, (float)Gdx.graphics.getWidth() / 2.0f - 20.0f, 50.0f);
    }

    private void picFragmentsGoRound(List<Sprite> sprites, int x0, int y0) {
        int r1 = Gdx.graphics.getWidth() / 4;
        int r2 = Gdx.graphics.getHeight() / 4;
        String frameStr = Long.toString(this.getRelativeFrame() + 1000L);
        String firstTwoDigitsStr = frameStr.length() >= 4 ? frameStr.substring(2, 4) : frameStr;
        int firstTwoDigits = Integer.parseInt(firstTwoDigitsStr);
        double angle = Math.PI * (double)firstTwoDigits / 50.0;
        for (int i = 0; i < sprites.size(); ++i) {
            float x = (float)((double)x0 + (double)r1 * Math.cos(angle + (double)(i * 2) * Math.PI / 7.0));
            float y = (float)((double)y0 + (double)r2 * Math.sin(angle + (double)(i * 2) * Math.PI / 7.0));
            sprites.get(i).setPosition(x, y);
        }
    }

    private void restoreSize(List<Sprite> sprites) {
        sprites.forEach(sprite -> {
            float sc = sprite.getScaleX();
            sc = Math.min(1.0f, sc + 0.02f);
            sprite.setScale(sc, 1.0f);
        });
    }

    private void gluePictureFragments(List<Sprite> sprites, float destY, float destX0) {
        float width = sprites.get(3).getWidth();
        for (int i = 0; i < sprites.size(); ++i) {
            int dX;
            int decY;
            Sprite s = sprites.get(i);
            int n = decY = Math.abs(s.getY() - destY) > 13.0f ? 5 : 1;
            if (s.getY() > destY) {
                s.setY(s.getY() - (float)decY);
            } else if (s.getY() < destY) {
                s.setY(s.getY() + (float)decY);
            }
            float destX = destX0 + (float)i * width;
            int n2 = dX = Math.abs(s.getX() - destX) > 13.0f ? 5 : 1;
            if (s.getX() > destX) {
                s.setX(s.getX() - (float)dX);
                continue;
            }
            if (!(s.getX() < destX)) continue;
            s.setX(s.getX() + (float)dX);
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.shapeRenderer.dispose();
        this.threeAmigosSprites.clear();
        this.apple1Sprites.clear();
        this.starsArray = null;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
    }

    private long getRelativeFrame() {
        long frame = Gdx.graphics.getFrameId();
        return frame - 2229L;
    }
}

