/*
 * Decompiled with CFR 0.152.
 */
package org.kd.hellogdx.zoom;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

public class ZoomingCamera
extends ApplicationAdapter {
    SpriteBatch batch;
    private OrthographicCamera camera;
    Sprite monster;
    private float zoomSpeed = 0.5f;
    private float minZoom = 0.5f;
    private float maxZoom = 2.0f;
    private boolean zoomingIn = true;

    @Override
    public void create() {
        super.create();
        this.batch = new SpriteBatch();
        this.monster = new Sprite(new Texture("c64.png"));
        this.monster.setPosition(320.0f - this.monster.getWidth() / 2.0f, 240.0f - this.monster.getHeight() / 2.0f);
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 640.0f, 480.0f);
        this.camera.zoom = 1.0f;
    }

    public void update() {
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (this.zoomingIn) {
            this.camera.zoom -= this.zoomSpeed * Gdx.graphics.getDeltaTime();
            if (this.camera.zoom <= this.minZoom) {
                this.camera.zoom = this.minZoom;
                this.zoomingIn = false;
            }
        } else {
            this.camera.zoom += this.zoomSpeed * Gdx.graphics.getDeltaTime();
            if (this.camera.zoom >= this.maxZoom) {
                this.camera.zoom = this.maxZoom;
                this.zoomingIn = true;
            }
        }
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.monster.draw(this.batch);
        this.batch.end();
    }

    @Override
    public void dispose() {
        this.batch.dispose();
    }
}

