org 0x8048000
bits 32
[map symbols lst/map.lst]
base equ 0x8048000

SYS_READ      equ 3
SYS_WRITE     equ 4
SYS_NANOSLEEP equ 162
STDOUT        equ 1
STDIN         equ 0

; Elf32_Ehdr
Ehdr:

    db     0x7f           ; e_ident
    db     0x45
    db     0x4c
    db     0x46
    db     0x01
    db     0x01
    db     0x01
scene_loop_counter:
    db      5
rqtp:
    dd 0
    ;  12345678
    ; dd 50000000
    dd 0x3000000

    dw      0x2           ; e_type
    dw      0x3           ; e_machine 0x3 == Intel 80386
    dd      0x0           ; e_version 0x01 is not checked by the loader
    dd      _start        ; e_entry
    dd      0x2c          ; e_phoff Ehdr_len
    dd      0             ; e_shoff
    dd      0             ; e_flags
    dw      Ehdr_len      ; e_ehsize Ehdr_len
    dw      Phdr_len      ; e_phentsize Phdr_len

; overlapping of Phdr and Ehdr starts here
; Need only one Elf32_Phdr
Phdr:
    dw      1             ; e_phnum
; scene_loop_counter:
;     dw      5             ; e_shentsize
    dw      0             ; e_shentsize
    dw      0             ; e_shnum
    dw      0             ; e_shstrndx
Ehdr_len equ $ - Ehdr
;; Phdr: 8 Byte overlapping
;;     dd      0x1           ; p_type
;;     dd      0             ; p_offset
    dd      base          ; p_vaddr
    dd      base          ; p_paddr
    dd      image_len     ; p_filesz
    dd      image_len     ; p_memsz
pattern_loop_counter:
    dd      0x7           ; p_flags  0x7 == RWE
    dd      0x1000        ; p_align
Phdr_len equ $ - Phdr

demo_loop_counter:
    db    12
say_hi:
    db    7
    db    27
    db    "[4"
say_hi_background:
    db    "0mHi!"
say_hi_len equ $ - say_hi

graphics:
    db    27
    db    "["
graphics_mode:
    db    "0"
    db    "m"
graphics_len equ $ - graphics

clear_screen:
    db    27
    db    "#8"
clear_screen_len equ $ - clear_screen

scroll:
    db    27
    db    "M"
scroll_len equ $ - scroll

_start:
    mov ecx, clear_screen
    mov edx, clear_screen_len
    call near put

loop_frwd:
    inc byte [say_hi_background]
    mov ecx, say_hi
    mov edx, say_hi_len
    call near put

    dec byte [pattern_loop_counter]
    jnz loop_frwd
    mov byte [pattern_loop_counter], 7
    mov byte [say_hi_background], 0x30

    inc byte [say_hi]
    dec byte [scene_loop_counter]
    jnz loop_frwd
    mov byte [scene_loop_counter], 5
    mov byte [say_hi], 7

    inc byte [graphics_mode]
    mov ecx, graphics
    mov edx, graphics_len
    call near put

    dec byte [demo_loop_counter]
    jnz loop_frwd

    mov ecx, 128
fini:
    push ecx
    mov ecx, scroll
    mov edx, scroll_len
    call near put
    pop ecx
    loop fini

put:
    mov eax, SYS_WRITE
    mov ebx, STDOUT
    ; xor ebx, ebx
    ; inc ebx
    int 0x80

break:
    mov eax, SYS_READ
    mov edx, 1        ; one character
    xor ebx, ebx      ; STDIN == 0
    xor ecx, ecx      ; buffer == NULL
    int 0x80
    or eax, eax
    jnz exit_demo

    mov eax, SYS_NANOSLEEP
    mov ebx, rqtp
    xor ecx, ecx      ; buffer == NULL
    int 0x80
    ret

exit_demo:
    ; db  0x0f, 0xff  ; Illegal instruction
    ; hlt     ; Segmentation fault

image_len equ $ - Ehdr
