/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.C64Colors;
import org.kd.common.Globals;

public class C64Helper {
    public static void blinkCursor(long frame, ShapeRenderer shapeRenderer) {
        long cond = frame % 100L;
        C64Colors c = cond > 0L && cond <= 50L ? Globals.CURSOR_COLOR : Globals.BKG_COLOR;
        C64Helper.paintCursor(c, shapeRenderer);
    }

    public static void paintCursor(C64Colors c, ShapeRenderer shapeRenderer) {
        long curX = Math.round(0.102 * (double)Gdx.graphics.getWidth()) - 1L;
        long curY = Globals.cursorY;
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(c.getR(), c.getG(), c.getB(), 1.0f);
        shapeRenderer.box(curX, curY, 0.0f, 14.0f, 15.0f, 0.0f);
        shapeRenderer.end();
    }

    public static String countElapsedTime() {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - Globals.startTime;
        long minutes = elapsedTime / 1000L / 60L;
        long seconds = elapsedTime / 1000L % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static BitmapFont createFont(int size, String ttfFile) {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal(ttfFile));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = size;
        BitmapFont font = generator.generateFont(parameter);
        font.setColor(C64Colors.WHITE.getR(), C64Colors.WHITE.getG(), C64Colors.WHITE.getB(), 0.75f);
        generator.dispose();
        return font;
    }
}

