/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import org.kd.common.C64Colors;

public class TravellingLogo {
    Sprite sprite;
    public float spriteSpeed = 100.0f;

    public TravellingLogo(Texture texture, float startX, float startY, float width, float height) {
        this.sprite = new Sprite(texture);
        this.sprite.setSize(width, height);
        this.sprite.setPosition(startX, startY);
    }

    public void move(float deltaTime, int screenWidth) {
        float newX = this.sprite.getX() - this.spriteSpeed * deltaTime;
        this.sprite.setX(newX);
        if (this.getX() + this.getWidth() < 0.0f) {
            this.sprite.setX(screenWidth);
        }
    }

    public void draw(SpriteBatch batch, int screenWidth, int screenHeight) {
        Rectangle scissors = new Rectangle(0.0f, 0.0f, screenWidth, screenHeight);
        if (ScissorStack.pushScissors(scissors)) {
            this.sprite.draw(batch);
        }
        ScissorStack.popScissors();
    }

    public void colorize(C64Colors color) {
        this.sprite.setColor(color.toBadlogicColor());
    }

    public void changeDirection() {
        this.spriteSpeed *= -1.0f;
        this.sprite.setX(this.getX() - this.spriteSpeed / 25.0f);
    }

    public float getX() {
        return this.sprite.getX();
    }

    public float getWidth() {
        return this.sprite.getWidth();
    }

    public Sprite getSprite() {
        return this.sprite;
    }
}

