{unit written by garf, freeware}
unit pipe;

interface
uses crt,dos;

function cinput(x,y,len,fore,back:byte;prev:string):string;
function cw(a:string):string;
function cwln(a:string):string;
function presskey(a:string):string;
function center(a:string):string;
function centerln(a:string):string;
function spinread(a:string;len:byte;fg:byte;bg:byte):string;
function yesno(a:string;yes:string;no:string):boolean;
procedure blank;
procedure showcursor;
procedure hidecursor;

implementation

function cinput(x,y,len,fore,back:byte;prev:string):string;
var
  cur         : integer;
  s           : string;
  ch          : char;
  done        : boolean;
  overwrite   : boolean;

procedure redraw;
var a : integer;
begin
  gotoxy(x,y);
  write(s);
  for a:=length(s)+1 to len do write(' ');
  gotoxy(x+cur-1,y);
end;

begin
  done:=false;
  s:=prev;
  cur:=length(s)+1;
  textcolor(fore);
  textbackground(back);
  redraw;
  overwrite:=false;
  repeat
    ch:=readkey;
    case ch of
          #0:if keypressed then
             begin
               ch:=upcase(readkey);
                 case ch of
                   #82:if (overwrite) then overwrite:=false
                       else overwrite:=true;
                   #83:if (cur<=length(s)) then delete(s,cur,1);
                   #71:cur:=1;
                   #79:cur:=length(s)+1;
                   #75:if (cur>1) then dec(cur);
                   #77:if (cur<=length(s)) then inc(cur);
                 end;
             end;
         #13:done:=true;
          ^Y:begin
               cur:=1;
               s:='';
             end;
          ^H:if cur>1 then
             begin
               write(^H);
               write(' ');
               gotoxy(cur-1,wherey);
               Delete(s,cur-1,1);
               dec(cur);
             end;
   #32..#255:if (length(s)<len) or (overwrite) and (cur<=len) then
             begin
                if (length(s)<len) then
                  case overwrite of
                    true:  if cur>length(s) then s:=s+ch
                           else s[cur]:=ch;
                    false: if cur<=length(s) then insert(ch,s,cur)
                           else s:=s+ch;
                end;
                if (overwrite) and (cur<=len) then s[cur]:=ch;
                inc(cur);
              end;
    end;
    redraw;
  until done=true;
  cinput:=s;
end;

function cw(a:string):string;
var f,u:byte;
    z:integer;
    j:string;

begin
  u:=0;
  repeat
    inc(u);
    j:=a[u+1]+a[u+2];
    val(j,f,z);
    if (a[u]='|') and (f in [1..31]) then
    begin
      case f of
        1..15:begin
                textcolor(f);
                delete(a,u,2);
              end;
       16..31:begin
                textbackground(f-16);
                delete(a,u,2);
              end;
       end;
    end else write(a[u]);
  until (u=length(a))
end;

function presskey(a:string):string;
begin
  cw(a);
  readkey;
  repeat
    if keypressed then readkey;
  until (not keypressed);
end;

function cwln(a:string):string;
begin
  cw(a);
  writeln;
end;

function center(a:string):string;
var u:byte;
begin
  u:=((80 - length(a)) div 2);
  gotoxy(u,wherey);
  cw(a);
end;

function centerln(a:string):string;
var u:byte;
begin
  u:=((80 - length(a)) div 2);
  gotoxy(u,wherey);
  cwln(a);
end;

function spinread(a:string;len:byte;fg:byte;bg:byte):string;

const
  cursorData : array [0..3] of string = ('/',')','\','(');

var
  done : boolean;
  b : integer;
  s : string;
  ch : char;
  cursorstate:byte;

procedure updateCursor;
begin
  cursorState := succ(cursorState) and 3;
  write(cursorData[cursorState], ^H);
end;

begin
  s:='';
  write(a);
  write('[');
  gotoxy(wherex+len,wherey);
  write(']');
  gotoxy(wherex-len-1,wherey);
  textcolor(fg);
  textbackground(bg);
  for b:=1 to len do write(' ');
  gotoxy(wherex-len,wherey);
  done:=false;
  repeat
    repeat
      if length(s)<>len then
      begin
        gotoxy(wherex,wherey);
        updateCursor;
        if not keypressed then delay(100);
      end;
    until keypressed;
    ch:=readkey;
    case ch of
      ^H:if length(s)>0 then
         begin
           delete(s,length(s),1);
           if length(s)<>len-1 then write(' ',^H);
           gotoxy(wherex-1,wherey);
         end;
     #13:if length(s)>0 then
         begin
           done:=true;
         end;
    else;if length(s)<len then
         begin
           write(ch);
           s:=s+ch;
         end;
    end;
  until (done);
  if length(s)<len then write(' ',^H);
  spinread:=s;
  textcolor(15);
  textbackground(0);
  writeln;
end;

function yesno(a:string;yes:string;no:string):boolean;
var x : boolean;
    ch : char;
begin
  cw(a);
  repeat
    if x=true then cw(yes)
    else cw(no);
    repeat
      ch:=readkey;
    until (pos(ch,#75+#77+#13)<>0);
    case ch of
    #75:if x=true then x:=false
        else x:=true;
    #77:if x=true then x:=false
        else x:=true;
    end;
    gotoxy(1+length(a),wherey);
  until ch=#13;
  yesno:=x;
  textbackground(0);
  textcolor(15);
  writeln;
end;

procedure blank;
var a:integer;
begin
  for a:=1 to 80 do write(' ');
end;

procedure showcursor;assembler;
asm
  mov ax,0100h
  mov cx,0100h
  mov cx,0506h
  int 10h
end;

procedure hidecursor;assembler;
asm
  mov ax,100h
  mov cx,02607h
  int 10h
end;

end.
