#include <i86.h>
#include <conio.h>

static unsigned char irqNum;
static unsigned char irqIntNum;
static unsigned char irqPort;
static void far *irqOldInt;
static unsigned char irqOldMask;
static void (*irqRoutine)();
static unsigned char irqPreEOI;

static void far *getvect(unsigned char intno)
{
  REGS r;
  SREGS sr;
  r.h.ah=0x35;
  r.h.al=intno;
  sr.ds=sr.es=0;
  int386x(0x21, &r, &r, &sr);
  return MK_FP(sr.es, r.x.ebx);
}

static void setvect(unsigned char intno, void far *vect)
{
  REGS r;
  SREGS sr;
  r.h.ah=0x25;
  r.h.al=intno;
  r.x.edx=FP_OFF(vect);
  sr.ds=FP_SEG(vect);
  sr.es=0;
  int386x(0x21, &r, &r, &sr);
}

static void __interrupt irqInt()
{
  void loades();
#pragma aux loades = "push ds" "pop es"
  loades();

  if (irqPreEOI)
  {
    outp(irqPort, inp(irqPort)|(1<<(irqNum&7)));
    if (irqNum&8)
      outp(0xA0,0x20);
    outp(0x20,0x20);
    irqRoutine();
    outp(irqPort, inp(irqPort)&~(1<<(irqNum&7)));
  }
  else
  {
    irqRoutine();
    if (irqNum&8)
      outp(0xA0,0x20);
    outp(0x20,0x20);
  }
}

void irqInit(unsigned char inum, void (*routine)(), unsigned char pre)
{
  irqPreEOI=pre;
  inum&=15;
  irqNum=inum;
  irqIntNum=(inum&8)?(inum+0x68):(inum+8);
  irqPort=(inum&8)?0xA1:0x21;

  irqOldInt=getvect(irqIntNum);
  irqOldMask=inp(irqPort)&(1<<(inum&7));

  irqRoutine=routine;
  setvect(irqIntNum, irqInt);
  outp(irqPort, inp(irqPort)&~(1<<(inum&7)));
}

void irqClose()
{
  outp(irqPort, inp(irqPort)|irqOldMask);
  setvect(irqIntNum, irqOldInt);
}

void irqReInit()
{
  outp(irqPort, inp(irqPort)&~(1<<(irqNum&7)));
}
