
// ------------------------------------------------------------------------------------------------
//    "DREAMS" - 64k Intro main code.
//    Copyright (c) 2001. Remage / Fresh!mindworkz.
// ------------------------------------------------------------------------------------------------

#define MXMSTART 21
// VEGE:25

// ------------------------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <Windows.h>
#include <D3DX8.h>

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "D3DU8.h"

#include "JSphere.h"
#include "SphereBack.h"
#include "Lyrics.h"
#include "Stencil.h"
#include "BlobPlane.h"
#include "DotLights.h"
#include "MetaBalls.h"
#include "LineBlend.h"
#include "WaveBack.h"
#include "ConeBack.h"
#include "Logo.h"
#include "BlendCone.h"

// ------------------------------------------------------------------------------------------------

#include "Module.h"
#include "Samples.h"

extern "C" unsigned long __stdcall ds_init( HWND hWnd, void *Mxm );
extern "C" void __stdcall ds_close( void );
extern "C" void __stdcall xmpPlay( unsigned long Order );
extern "C" void __stdcall xmpStop( void );

static char *Module;

// ------------------------------------------------------------------------------------------------

void memcopy( void *pOut, const void *pIn, int Siz )
  {
    __asm {
        mov edi, [pOut]
        mov esi, [pIn]
        mov ecx, dword ptr [Siz]
        rep movsb
      }
   }

// ------------------------------------------------------------------------------------------------

void memclear( void *pOut, int Siz )
  {
    __asm {
        mov edi, [pOut]
        xor eax,eax
        mov ecx, dword ptr [Siz]
        rep stosb
      }
   }

// ------------------------------------------------------------------------------------------------

int StrLen( char *Str )
  {
    int I = 0;
    while ( Str[I] != 0 ) I++;
    return I;
   }

// ------------------------------------------------------------------------------------------------
//  DEBUG.
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------

HWND hWnd;
HDC hDC;

LPDIRECT3D8 Direct3D = NULL;
LPDIRECT3DDEVICE8 Direct3DDevice = NULL;

D3DLOCKED_RECT D3DLockedRect;

D3DDISPLAYMODE D3DDisplayMode;
D3DPRESENT_PARAMETERS D3DPresentParameters;

D3DVECTOR D3DVector_CameraPosition, D3DVector_CameraTarget, D3DVector_Up;
D3DMATRIX D3DMatrix_World0, D3DMatrix_World1, D3DMatrix_View, D3DMatrix_Projection, D3DMatrix_Texture0, D3DMatrix_Texture1, D3DMatrix_Temp;

D3DVIEWPORT8 D3DViewport = 
  { 0, 60, 639, 359, 0.0f, 1.0f };
D3DMATERIAL8 D3DMaterial;
D3DLIGHT8 D3DLight;

D3DXMATRIX D3DXMatrix_Projection;

float Time0, Time;
int Frame2, Pause=0;

// ------------------------------------------------------------------------------------------------

#define D3DFVF_FRESHD3D_VERTEX (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2)
struct FRESHD3D_VERTEX
  {
    D3DVECTOR Vertex, Normal;
    FLOAT TexU, TexV;
   };

// ------------------------------------------------------------------------------------------------

int FreshD3D_Initialize( HWND hWnd, int Width, int Height, BOOL Windowed )
  {
    // --- Initialize Direct3D.
    if ( !( Direct3D = Direct3DCreate8( D3D_SDK_VERSION ))) 
      {
        MessageBox( 0, "Failed: Direct3DCreate8().", "Error", MB_ICONERROR | MB_OK );
        return 0;
       }
    if ( Direct3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &D3DDisplayMode ) != D3D_OK ) 
      {
        MessageBox( 0, "Failed: GetAdapterDisplayMode()", "Error", MB_ICONERROR | MB_OK );
        return 0;
       }
    
    memclear( &D3DPresentParameters, sizeof( D3DPRESENT_PARAMETERS ));
    D3DPresentParameters.Windowed = Windowed;
    D3DPresentParameters.BackBufferWidth = Width;
    D3DPresentParameters.BackBufferHeight = Height;
    D3DPresentParameters.SwapEffect = D3DSWAPEFFECT_DISCARD;
    D3DPresentParameters.MultiSampleType = D3DMULTISAMPLE_NONE;
    if ( Direct3D->CheckDeviceMultiSampleType( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL , D3DFMT_X8R8G8B8, 
          Windowed, D3DMULTISAMPLE_4_SAMPLES ) == D3D_OK )
       D3DPresentParameters.MultiSampleType = D3DMULTISAMPLE_4_SAMPLES;
    D3DPresentParameters.EnableAutoDepthStencil = TRUE;
    D3DPresentParameters.AutoDepthStencilFormat = D3DFMT_D24S8;
    D3DPresentParameters.BackBufferFormat = D3DDisplayMode.Format;
    
    HRESULT Err;
    if (( Err = Direct3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING,
      &D3DPresentParameters, &Direct3DDevice )) != D3D_OK )
    if (( Err = Direct3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING,
      &D3DPresentParameters, &Direct3DDevice )) != D3D_OK ) 
        {
          MessageBox( 0, "Failed: Direct3D->CreateDevice().", "Error", MB_ICONERROR | MB_OK );
          return 0;
         }

    // --- Turn On Lighting.
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
    // --- Turn Off Backface Culling.
    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

    // --- 16:9 Viewport.
    Direct3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );
    Direct3DDevice->Present( NULL, NULL, NULL, NULL );
    Direct3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );
    Direct3DDevice->SetViewport( &D3DViewport );

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void FreshD3D_Cleanup()
  {
    // --- Direct3D Cleanup.
    if ( Direct3DDevice != NULL ) Direct3DDevice->Release();
    if ( Direct3D != NULL ) Direct3D->Release();
   }

// ------------------------------------------------------------------------------------------------

void FreshD3D_Render( float Time )
  {
    float Time2 = Time * 64.0f / 896.0f;

    if ( !Direct3DDevice ) return;
    Direct3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, TRUE ); 

    // --- Effects Render.
//*
    Direct3DDevice->BeginScene();

    // --- Background.

    if ( Time2 <= 6.0f * 64.0f ) 
      SphereBack_Render1( Time2 );
    if (( Time2 > 4.0f * 64.0f ) && ( Time2 <= 11.5f * 64.0f ))
      WaveBack_Render1( Time2 );
    if (( Time2 > 11.0f * 64.0f ) && ( Time2 <= 15.5f * 64.0f ))
      SphereBack_Render2( Time2 );
    if (( Time2 > 15.0f * 64.0f - 12.0f ) && ( Time2 <= 17.0f * 64.0f + 32.0f ))
      BlobPlane_Render( 297.0f - ( Time2 - 15.0f * 64.0f ) / 12.0f );

    if (( Time2 > 17.0f * 64.0f -32.0f ) && ( Time2 < 21.0f * 64.0f ))
      ConeBack_Render( Time2 );
    if ( Time2 > 20.0f * 64.0f ) 
      WaveBack_Render2( Time2 );

    LineBlend_Render( Time2 );

    // --- Effect.

    if (( Time2 > 384.0f ) && ( Time2 < 576.0f ))
        Logo_Render( Time2 );
    if (( Time2 > 384.0f ) && ( Time2 < 512.0f ))
      DotLights_Render( Time2 );
//*
    if (( Time2 > 8.5f * 64.0f ) && ( Time2 <= 11.0f * 64.0f ))
      MetaBalls_Render1( Time2 );      
    if (( Time2 > 11.5f * 64.0f ) && ( Time2 <= 15.0f * 64.0f ))
      JSphere_Render( Time2 );
    if (( Time2 > 17.0f * 64.0f - 16.0f ) && ( Time2 <= 19.0f * 64.0f ))  
      MetaBalls_Render2( Time2 );
    if (( Time2 > 19.0f * 64.0f ) && ( Time2 <= 21.0f * 64.0 ))
      BlendCone_Render( Time2 );
    if (( Time2 > 21.0f  *64.0f ) && ( Time2 <= 25.0f * 64.0f ))
      MetaBalls_Render3( Time2 );
//*/

    Lyrics_Render( Time2 / 16.0f );

    Direct3DDevice->EndScene();
    Direct3DDevice->Present( NULL, NULL, NULL, NULL );
   }

// ------------------------------------------------------------------------------------------------
//  WindowProc()
// ------------------------------------------------------------------------------------------------

LRESULT WINAPI WindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
  {
    switch( Msg )
      {
        case WM_CHAR:
          if ( wParam == ' ' ) Pause = !Pause; else
          if ( wParam == VK_ESCAPE ) 
            PostQuitMessage( 0 );
          break;
        case WM_CLOSE:
        case WM_DESTROY:
          PostQuitMessage( 0 );
          return 0;
       }
    return DefWindowProc( hWnd, Msg, wParam, lParam );
   };

// ------------------------------------------------------------------------------------------------
//  WinMain()
// ------------------------------------------------------------------------------------------------

WNDCLASSEX WndClassEx = 
  { sizeof( WNDCLASSEX ), CS_CLASSDC, WindowProc, 0, 0, NULL, NULL, NULL, NULL, NULL, "FreshD3D", NULL };

static HFILE F;

int Windowed = 0, HunLyrics = 0, ExportMXM = 0, ExportTGA = 0;

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd )
  {
    RECT Res;
    MSG Msg;

    char *CmdLine = lpCmdLine;
    if ( CmdLine )
      {
        if ( *CmdLine == '"' )
          {
            while ( *CmdLine != '"' )
              CmdLine++;
           }

        while ( *( ++CmdLine ) != 0 ) 
          {
            if (( *CmdLine == '/' ) || ( *CmdLine == '-' ))
              {
                if ( *( ++CmdLine ) == 0 ) break;
                if ((( *CmdLine ) & ~0x20 ) == 'W' ) Windowed = 1;
                if ((( *CmdLine ) & ~0x20 ) == 'H' ) HunLyrics = 1;
                if ((( *CmdLine ) & ~0x20 ) == 'M' ) ExportMXM = 1;
                if ((( *CmdLine ) & ~0x20 ) == 'T' ) ExportTGA = 1;
               }
           }        
        
//      MessageBox( 0, CmdLine, "CmdLine", MB_OK );
       }
    
//    return 0;

    // --- Initialize Window.
    WndClassEx.hInstance = hInstance;
    if ( !RegisterClassEx( &WndClassEx ))
      {
        MessageBox( 0, "Failed: RegisterClassEx().", "Error", MB_ICONERROR | MB_OK );
        return 0;
       }
    if ( !SystemParametersInfo( SPI_GETWORKAREA, 0, &Res, 0 )) 
      {
        MessageBox( 0, "Failed: SystemParametersInfo().", "Error", MB_ICONERROR | MB_OK );
        return 0;
       }
    hWnd = CreateWindowEx( WS_EX_TOPMOST, "FreshD3D", "\"Dreams\" - Fresh!mindworkz", WS_POPUP, (Res.right-640)/2, (Res.bottom-480)/2, 640, 480, NULL, NULL, hInstance, NULL );
    if ( !hWnd ) 
      {
        MessageBox( 0, "Failed: CreateWindowEx().", "Error", MB_ICONERROR | MB_OK );
        return 0;
       }
    hDC = GetDC( hWnd );
    if ( !hDC ) 
      {
        MessageBox( 0, "Failed: GetDC().", "Error", MB_OK );
        return 0;
       }

    if ( FreshD3D_Initialize( hWnd, 640, 480, Windowed ))
      {
        // --- Show Window.
        ShowWindow( hWnd, SW_SHOW );
        UpdateWindow( hWnd );
        SetFocus( hWnd );
        ShowCursor( FALSE );

        // --- Lyrics Initialize & "Precalc...".
        if ( !Lyrics_Initialize()) return 0;

        // --- Load/Calculate & Initialize Module.
        Module = (char*) HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, 6396274 );

        if (( F = _lopen( "Dreams.mxm", OF_READ )) == HFILE_ERROR )
          {
            memcopy( Module, ModuleZap, 38050 );
            Samples_Synthesize( Module );
            if ( ExportMXM )
              if (( F = _lcreat( "Dreams.mxm", 0 )) != HFILE_ERROR )
                {
                  _lwrite( F, (char*) Module, 6396274 );
                  _lclose( F );
                 }
           } else
          {
              _lread( F, (char*) Module, 6396274 );
              _lclose( F );
           }

        ds_init( hWnd, Module );

        // --- Effects Initialize.
        if ( !TxGen_Initialize()) return 0;
        if ( !SphereBack_Initialize()) return 0;
        if ( !Stencil_Initialize()) return 0;
        if ( !DotLights_Initialize()) return 0;
        if ( !MetaBalls_Initialize()) return 0;
        if ( !BlobPlane_Initialize()) return 0;
        if ( !LineBlend_Initialize()) return 0;
        if ( !WaveBack_Initialize()) return 0;
        if ( !ConeBack_Initialize()) return 0;
        if ( !JSphere_Initialize()) return 0;
        if ( !Logo_Initialize()) return 0;
        if ( !BlendCone_Initialize()) return 0;

        SetFocus( hWnd );

        // --- Time Initialize.
        Time = 896.0f * MXMSTART;
        Time0 = 0.1f * timeGetTime() - Time;

        // --- Play Module.
        xmpPlay( MXMSTART );

        // --- Message Loop.
        while ( Time < 26880.0f )
          {
            if ( PeekMessage( &Msg, 0, 0, 0, PM_NOREMOVE ))
              {
                if ( !GetMessage( &Msg, 0, 0, 0 )) break;
                TranslateMessage( &Msg );
                DispatchMessage( &Msg );
               }
            if ( !Pause ) 
              Time = 0.1f * timeGetTime() - Time0;
            // --- Render.
            FreshD3D_Render( Time );
           }

        // --- Stop Module.
        xmpStop();
        ds_close();
        HeapFree( GetProcessHeap(), 0, (void*) Module );

        // --- Effects Cleanup.
        Lyrics_Cleanup();
        TxGen_Cleanup();
        Stencil_Cleanup();
        SphereBack_Cleanup();
        DotLights_Cleanup();
        MetaBalls_Cleanup();
        BlobPlane_Cleanup();
        LineBlend_Cleanup();
        WaveBack_Cleanup();
        ConeBack_Cleanup();
        JSphere_Cleanup();
        Logo_Cleanup();
        BlendCone_Cleanup();
       }

    SetFocus( NULL );
    FreshD3D_Cleanup();
    DestroyWindow( hWnd );
    UnregisterClass( "FreshD3D", hInstance );

    return 0;
   }

// ------------------------------------------------------------------------------------------------

void WinMainCRTStartup( void )
  { 
    ExitProcess( WinMain( GetModuleHandle( NULL ), NULL, GetCommandLine(), SW_SHOW ));
   }
