
// --- Polygonization table for the 'marching cubes' algorithm.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.
//  Thanks to Rod / Mandula.

/*
Ez a tblzat tartalmazza a cellban fut fellettl fggen generlt poligonok cscsponjainak kiszmtshoz hasznlt
kocka indexeket. A kocka cscsainak szmozsa az als lap bal hats cscsval kezddik s az ramutat jrsval
megegyez irnyba indul. A fels lap cscsainak szmozsa hasonl mdon, a megfelel cscsok indexeihez 4-et
hozzadva trtnik. A cscsok g0,g1,g2....g7. A tblzatot gy hasznlhatjuk, hogy a cscsok szmozsnak sorrendjben
megvizsgljuk, hogy az adott rcspont intenzitsa a felleti rtk alatt van-e. Ha igen, akkor 1-be lltjuk a cscs szmnak
megfelel bit-et az index-ben, ha nem akkor 0-ra. Ha minden csccsal vgeztnk, az index-et felhasznlva elkezdjk olvasni
a tblzat megcmzett sort, amg -1-et nem tallunk. Az olvasott rtkek hatosval egy-egy lapot hatroznak meg, ahol a
lap cscsa, a megadott 2-2 pont kztti interpolcival nyerhet. Az itt tallhat tblzat egy kicsit jobb, mint az alap
'marching cubes' tbla, mert ott bizonyos esetekben lyukak jhetnek ltre a felletben. Ezzel a tblzattal eddig ilyen
gondokat mg nem tapasztaltam.
*/

#define s0 000
#define s1 001
#define s2 003
#define s3 002
#define s4 004
#define s5 005
#define s6 007
#define s7 006

#define d0 000
#define d1 010
#define d2 030
#define d3 020
#define d4 040
#define d5 050
#define d6 070
#define d7 060

unsigned char Polytab[ 128*16 ] = 
  {
//         0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s3|d0,s4|d0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s1|d5,s1|d2,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s1|d2,s4|d0,s1|d2,s3|d0,s4|d0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d2,s2|d6,s3|d2,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s1|d2,s4|d0,s3|d2,s3|d0,s4|d0,s1|d2,s2|d6,s4|d0,s3|d2,s4|d0,s2|d6,       0,       0,       0,       0,
    s1|d0,s1|d5,s3|d2,s1|d5,s2|d6,s3|d2,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s2|d6,s4|d0,s1|d5,s3|d2,s3|d0,s4|d0,s3|d2,s4|d0,s2|d6,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s3|d2,s3|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s1|d0,s3|d7,s1|d0,s3|d2,s3|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s1|d0,s1|d5,s3|d0,s1|d5,s3|d7,s1|d2,s3|d2,s1|d5,s3|d2,s3|d7,s1|d5,       0,       0,       0,       0,
    s1|d5,s3|d7,s4|d0,s1|d2,s3|d7,s1|d5,s1|d2,s3|d2,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s1|d2,s2|d6,s3|d7,s3|d0,s2|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s2|d6,s4|d0,s1|d0,s1|d2,s2|d6,s4|d0,s2|d6,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s1|d0,s1|d5,s3|d0,s1|d5,s3|d7,s3|d7,s1|d5,s2|d6,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s2|d6,s4|d0,s2|d6,s3|d7,s4|d0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s4|d0,s4|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s1|d0,s3|d0,s4|d7,s4|d5,s3|d0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s1|d5,s1|d2,s1|d0,s4|d0,s1|d2,s4|d5,s1|d2,s4|d7,s4|d0,s4|d7,s1|d2,       0,       0,       0,       0,
    s4|d5,s1|d5,s1|d2,s4|d5,s1|d2,s4|d7,s4|d7,s1|d2,s3|d0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s4|d7,s4|d5,s1|d2,s2|d6,s3|d2,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s1|d0,s2|d6,s4|d7,s4|d5,s2|d6,s1|d2,s2|d6,s1|d0,s3|d0,s4|d7,s2|d6,s3|d0,s2|d6,s3|d2,       0,
    s1|d5,s4|d7,s4|d5,s4|d0,s4|d7,s1|d0,s1|d5,s2|d6,s4|d7,s3|d2,s1|d0,s4|d7,s2|d6,s3|d2,s4|d7,       0,
    s4|d7,s4|d5,s1|d5,s3|d2,s4|d7,s1|d5,s3|d2,s1|d5,s2|d6,s3|d2,s3|d0,s4|d7,       0,       0,       0,       0,
    s4|d0,s3|d0,s4|d5,s3|d7,s4|d7,s4|d5,s3|d0,s3|d2,s4|d5,s3|d7,s4|d5,s3|d2,       0,       0,       0,       0,
    s3|d2,s4|d5,s1|d0,s3|d7,s4|d7,s4|d5,s3|d7,s4|d5,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d7,s4|d5,s1|d0,s4|d0,s3|d0,s1|d5,s1|d2,s3|d7,s1|d5,s3|d7,s4|d7,s3|d2,s3|d7,s1|d2,       0,
    s1|d5,s3|d7,s4|d5,s4|d5,s3|d7,s4|d7,s1|d5,s1|d2,s3|d2,s1|d5,s3|d2,s3|d7,       0,       0,       0,       0,
    s3|d0,s4|d5,s4|d0,s3|d0,s1|d2,s4|d5,s1|d2,s2|d6,s4|d5,s4|d7,s4|d5,s3|d7,s2|d6,s3|d7,s4|d5,       0,
    s1|d2,s4|d5,s1|d0,s1|d2,s3|d7,s4|d5,s4|d7,s4|d5,s3|d7,s1|d2,s2|d6,s3|d7,       0,       0,       0,       0,
    s1|d0,s4|d0,s3|d0,s4|d5,s1|d5,s4|d7,s1|d5,s3|d7,s4|d7,s1|d5,s2|d6,s3|d7,       0,       0,       0,       0,
    s4|d5,s1|d5,s3|d7,s4|d5,s3|d7,s4|d7,s1|d5,s2|d6,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d5,s5|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s4|d5,s5|d6,s1|d5,s1|d0,s5|d6,s4|d0,s5|d6,s3|d0,s1|d0,s3|d0,s5|d6,       0,       0,       0,       0,
    s1|d0,s4|d5,s5|d6,s1|d2,s1|d0,s5|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s4|d5,s5|d6,s4|d0,s5|d6,s3|d0,s3|d0,s5|d6,s1|d2,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d5,s3|d2,s5|d6,s3|d2,s4|d5,s1|d2,s1|d5,s3|d2,s5|d6,s2|d6,s3|d2,       0,       0,       0,       0,
    s4|d5,s5|d6,s4|d0,s1|d0,s1|d2,s1|d5,s3|d0,s4|d0,s5|d6,s3|d0,s5|d6,s2|d6,s3|d0,s2|d6,s3|d2,       0,
    s4|d5,s3|d2,s1|d0,s5|d6,s3|d2,s4|d5,s5|d6,s2|d6,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s4|d0,s4|d5,s3|d0,s4|d5,s5|d6,s3|d0,s5|d6,s3|d2,s3|d2,s5|d6,s2|d6,       0,       0,       0,       0,
    s1|d5,s4|d5,s5|d6,s3|d2,s3|d7,s3|d0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s5|d6,s1|d5,s4|d5,s5|d6,s4|d0,s1|d0,s3|d2,s5|d6,s3|d7,s4|d0,s5|d6,s3|d2,s3|d7,s5|d6,       0,
    s1|d0,s4|d5,s3|d7,s1|d0,s3|d7,s3|d0,s4|d5,s5|d6,s3|d7,s5|d6,s1|d2,s3|d7,s3|d2,s3|d7,s1|d2,       0,
    s4|d5,s5|d6,s4|d0,s3|d2,s4|d0,s5|d6,s3|d2,s3|d7,s4|d0,s3|d2,s5|d6,s1|d2,       0,       0,       0,       0,
    s1|d5,s4|d5,s1|d2,s3|d0,s1|d2,s4|d5,s3|d7,s3|d0,s4|d5,s2|d6,s4|d5,s5|d6,s2|d6,s3|d7,s4|d5,       0,
    s1|d0,s1|d2,s1|d5,s4|d0,s4|d5,s2|d6,s2|d6,s4|d5,s5|d6,s4|d0,s2|d6,s3|d7,       0,       0,       0,       0,
    s5|d6,s1|d0,s4|d5,s5|d6,s3|d7,s1|d0,s3|d7,s3|d0,s1|d0,s5|d6,s2|d6,s3|d7,       0,       0,       0,       0,
    s5|d6,s4|d0,s4|d5,s5|d6,s2|d6,s4|d0,s2|d6,s3|d7,s4|d0,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d0,s4|d7,s5|d6,s1|d5,s4|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s1|d0,s3|d0,s1|d5,s3|d0,s5|d6,s5|d6,s3|d0,s4|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s4|d0,s4|d7,s1|d0,s4|d7,s1|d2,s1|d2,s4|d7,s5|d6,       0,       0,       0,       0,       0,       0,       0,
    s1|d2,s3|d0,s5|d6,s3|d0,s4|d7,s5|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d0,s3|d2,s1|d5,s3|d2,s1|d2,s4|d0,s4|d7,s3|d2,s4|d7,s5|d6,s3|d2,s2|d6,s3|d2,s5|d6,       0,
    s1|d5,s1|d0,s1|d2,s5|d6,s3|d0,s4|d7,s5|d6,s2|d6,s3|d0,s3|d0,s2|d6,s3|d2,       0,       0,       0,       0,
    s4|d0,s3|d2,s1|d0,s4|d0,s4|d7,s5|d6,s4|d0,s5|d6,s3|d2,s2|d6,s3|d2,s5|d6,       0,       0,       0,       0,
    s3|d0,s4|d7,s5|d6,s3|d2,s3|d0,s5|d6,s3|d2,s5|d6,s2|d6,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d0,s3|d2,s5|d6,s1|d5,s3|d2,s3|d0,s3|d2,s4|d0,s4|d7,s5|d6,s3|d2,s4|d7,s3|d2,s3|d7,       0,
    s1|d5,s1|d0,s3|d2,s1|d5,s4|d7,s5|d6,s1|d5,s3|d2,s4|d7,s3|d2,s3|d7,s4|d7,       0,       0,       0,       0,
    s1|d0,s4|d0,s3|d0,s1|d2,s4|d7,s5|d6,s1|d2,s3|d2,s4|d7,s4|d7,s3|d2,s3|d7,       0,       0,       0,       0,
    s4|d7,s5|d6,s1|d2,s3|d7,s4|d7,s1|d2,s3|d7,s1|d2,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d0,s1|d2,s4|d0,s3|d0,s1|d2,s2|d6,s4|d7,s5|d6,s2|d6,s3|d7,s4|d7,       0,       0,       0,       0,
    s1|d2,s1|d5,s1|d0,s5|d6,s3|d7,s4|d7,s5|d6,s2|d6,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s3|d0,s1|d0,s3|d7,s4|d7,s5|d6,s3|d7,s5|d6,s2|d6,       0,       0,       0,       0,       0,       0,       0,
    s4|d7,s5|d6,s3|d7,s3|d7,s5|d6,s2|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s2|d6,s5|d6,s6|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s3|d0,s4|d0,s5|d6,s6|d7,s2|d6,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s5|d6,s1|d0,s2|d6,s1|d2,s1|d0,s5|d6,s6|d7,s1|d0,s2|d6,s1|d0,s6|d7,       0,       0,       0,       0,
    s4|d0,s1|d5,s6|d7,s3|d0,s4|d0,s6|d7,s5|d6,s6|d7,s1|d5,s1|d2,s3|d0,s6|d7,s1|d2,s6|d7,s2|d6,       0,
    s1|d2,s5|d6,s6|d7,s3|d2,s1|d2,s6|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s1|d2,s4|d0,s1|d0,s1|d2,s5|d6,s4|d0,s5|d6,s6|d7,s4|d0,s3|d0,s4|d0,s3|d2,s6|d7,s3|d2,s4|d0,       0,
    s1|d5,s6|d7,s1|d0,s1|d5,s5|d6,s6|d7,s1|d0,s6|d7,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s5|d6,s4|d0,s1|d5,s5|d6,s3|d2,s4|d0,s3|d0,s4|d0,s3|d2,s5|d6,s6|d7,s3|d2,       0,       0,       0,       0,
    s6|d7,s3|d0,s5|d6,s2|d6,s5|d6,s3|d0,s3|d2,s2|d6,s3|d0,s6|d7,s3|d7,s3|d0,       0,       0,       0,       0,
    s4|d0,s1|d0,s5|d6,s3|d7,s4|d0,s5|d6,s1|d0,s3|d2,s5|d6,s2|d6,s5|d6,s3|d2,s3|d7,s5|d6,s6|d7,       0,
    s1|d0,s1|d5,s6|d7,s1|d0,s3|d7,s3|d0,s5|d6,s6|d7,s1|d5,s1|d0,s6|d7,s3|d7,s1|d2,s3|d2,s2|d6,       0,
    s1|d5,s3|d7,s4|d0,s1|d5,s5|d6,s3|d7,s1|d2,s3|d2,s2|d6,s3|d7,s5|d6,s6|d7,       0,       0,       0,       0,
    s5|d6,s3|d0,s1|d2,s6|d7,s3|d0,s5|d6,s6|d7,s3|d7,s3|d0,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s3|d7,s4|d0,s1|d0,s1|d2,s5|d6,s1|d0,s5|d6,s3|d7,s5|d6,s6|d7,s3|d7,       0,       0,       0,       0,
    s1|d0,s1|d5,s5|d6,s1|d0,s6|d7,s3|d0,s1|d0,s5|d6,s6|d7,s3|d0,s6|d7,s3|d7,       0,       0,       0,       0,
    s3|d7,s4|d0,s1|d5,s6|d7,s1|d5,s5|d6,s6|d7,s3|d7,s1|d5,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s4|d0,s2|d6,s4|d7,s2|d6,s4|d0,s5|d6,s4|d5,s2|d6,s4|d7,s6|d7,s2|d6,       0,       0,       0,       0,
    s4|d5,s1|d0,s2|d6,s4|d5,s2|d6,s5|d6,s1|d0,s3|d0,s2|d6,s3|d0,s4|d7,s2|d6,s6|d7,s2|d6,s4|d7,       0,
    s4|d0,s4|d7,s1|d0,s1|d5,s5|d6,s4|d5,s1|d2,s1|d0,s4|d7,s1|d2,s4|d7,s6|d7,s1|d2,s6|d7,s2|d6,       0,
    s1|d5,s5|d6,s4|d5,s1|d2,s3|d0,s4|d7,s1|d2,s4|d7,s6|d7,s2|d6,s1|d2,s6|d7,       0,       0,       0,       0,
    s4|d5,s4|d0,s5|d6,s1|d2,s5|d6,s4|d0,s3|d2,s1|d2,s4|d0,s6|d7,s4|d0,s4|d7,s6|d7,s3|d2,s4|d0,       0,
    s5|d6,s4|d5,s1|d0,s1|d2,s5|d6,s1|d0,s3|d0,s4|d7,s6|d7,s3|d0,s6|d7,s3|d2,       0,       0,       0,       0,
    s1|d5,s5|d6,s4|d5,s1|d0,s4|d0,s6|d7,s6|d7,s4|d0,s4|d7,s1|d0,s6|d7,s3|d2,       0,       0,       0,       0,
    s5|d6,s4|d5,s1|d5,s4|d7,s3|d2,s3|d0,s4|d7,s6|d7,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s4|d5,s4|d0,s3|d0,s5|d6,s4|d5,s3|d0,s3|d2,s5|d6,s2|d6,s5|d6,s3|d2,s3|d7,s4|d7,s6|d7,       0,
    s4|d5,s1|d0,s3|d2,s5|d6,s4|d5,s2|d6,s4|d5,s3|d2,s2|d6,s4|d7,s6|d7,s3|d7,       0,       0,       0,       0,
    s1|d0,s4|d0,s3|d0,s4|d5,s1|d5,s5|d6,s6|d7,s3|d7,s4|d7,s1|d2,s3|d2,s2|d6,       0,       0,       0,       0,
    s1|d5,s5|d6,s4|d5,s2|d6,s1|d2,s3|d2,s4|d7,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s3|d0,s4|d5,s3|d0,s5|d6,s4|d5,s3|d0,s1|d2,s5|d6,s3|d7,s4|d7,s6|d7,       0,       0,       0,       0,
    s5|d6,s4|d5,s1|d0,s5|d6,s1|d0,s1|d2,s4|d7,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s4|d0,s3|d0,s4|d5,s1|d5,s5|d6,s3|d7,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s1|d5,s5|d6,s4|d7,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s2|d6,s1|d5,s4|d5,s6|d7,s2|d6,s4|d5,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d5,s3|d0,s4|d0,s1|d0,s3|d0,s1|d5,s4|d5,s6|d7,s3|d0,s2|d6,s1|d5,s3|d0,s6|d7,s2|d6,s3|d0,       0,
    s6|d7,s1|d0,s4|d5,s2|d6,s1|d2,s1|d0,s2|d6,s1|d0,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s4|d5,s6|d7,s4|d0,s1|d2,s3|d0,s4|d0,s6|d7,s1|d2,s6|d7,s2|d6,s1|d2,       0,       0,       0,       0,
    s1|d2,s1|d5,s4|d5,s1|d2,s4|d5,s3|d2,s3|d2,s4|d5,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d2,s1|d5,s1|d0,s4|d5,s3|d0,s4|d0,s3|d2,s3|d0,s4|d5,s3|d2,s4|d5,s6|d7,       0,       0,       0,       0,
    s1|d0,s4|d5,s3|d2,s4|d5,s6|d7,s3|d2,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s4|d5,s3|d2,s4|d0,s3|d2,s3|d0,s4|d5,s6|d7,s3|d2,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d5,s3|d0,s2|d6,s1|d5,s3|d0,s4|d5,s6|d7,s3|d0,s3|d7,s3|d0,s6|d7,s2|d6,s3|d0,s3|d2,       0,
    s4|d5,s3|d7,s4|d0,s1|d0,s3|d2,s1|d5,s4|d5,s6|d7,s3|d7,s3|d2,s2|d6,s1|d5,       0,       0,       0,       0,
    s1|d0,s4|d5,s6|d7,s3|d0,s1|d0,s3|d7,s1|d0,s6|d7,s3|d7,s1|d2,s3|d2,s2|d6,       0,       0,       0,       0,
    s6|d7,s4|d0,s4|d5,s6|d7,s3|d7,s4|d0,s3|d2,s2|d6,s1|d2,       0,       0,       0,       0,       0,       0,       0,
    s1|d5,s4|d5,s6|d7,s1|d5,s3|d0,s1|d2,s1|d5,s6|d7,s3|d0,s3|d7,s3|d0,s6|d7,       0,       0,       0,       0,
    s1|d5,s1|d0,s1|d2,s4|d0,s4|d5,s6|d7,s4|d0,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s4|d5,s6|d7,s3|d0,s1|d0,s6|d7,s3|d0,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,
    s6|d7,s4|d0,s4|d5,s3|d7,s4|d0,s6|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s2|d6,s1|d5,s4|d7,s2|d6,s4|d0,s4|d7,s6|d7,s2|d6,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s2|d6,s1|d5,s1|d0,s3|d0,s4|d7,s1|d0,s4|d7,s2|d6,s6|d7,s2|d6,s4|d7,       0,       0,       0,       0,
    s1|d2,s1|d0,s4|d0,s1|d2,s4|d0,s4|d7,s1|d2,s4|d7,s2|d6,s2|d6,s4|d7,s6|d7,       0,       0,       0,       0,
    s1|d2,s3|d0,s4|d7,s2|d6,s1|d2,s4|d7,s2|d6,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d2,s1|d5,s4|d0,s1|d2,s4|d0,s6|d7,s4|d0,s4|d7,s6|d7,s1|d2,s6|d7,s3|d2,       0,       0,       0,       0,
    s1|d0,s1|d2,s1|d5,s3|d2,s3|d0,s4|d7,s3|d2,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s4|d7,s1|d0,s4|d0,s4|d7,s6|d7,s1|d0,s6|d7,s3|d2,s1|d0,       0,       0,       0,       0,       0,       0,       0,
    s4|d7,s3|d2,s3|d0,s6|d7,s3|d2,s4|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s2|d6,s1|d5,s4|d0,s2|d6,s4|d0,s3|d0,s3|d2,s2|d6,s3|d0,s6|d7,s3|d7,s4|d7,       0,       0,       0,       0,
    s3|d2,s1|d5,s1|d0,s3|d2,s2|d6,s1|d5,s6|d7,s3|d7,s4|d7,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s1|d0,s4|d0,s1|d2,s3|d2,s2|d6,s6|d7,s3|d7,s4|d7,       0,       0,       0,       0,       0,       0,       0,
    s2|d6,s1|d2,s3|d2,s6|d7,s3|d7,s4|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d0,s1|d2,s1|d5,s4|d0,s3|d0,s1|d2,s3|d7,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,
    s1|d0,s1|d2,s1|d5,s3|d7,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s3|d0,s1|d0,s4|d0,s3|d7,s4|d7,s6|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,
    s4|d7,s6|d7,s3|d7,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0,       0
   };