
// --- Quads.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.

float QuadPos[6], QuadRot[6], QX0[6], QY0[6], QDX1[6], QDY1[6], QDX2[6], QDY2[6];

void Quads_Init( void )
  {
    for ( int I = 0; I < 6; I++ )
      {
        QuadPos[I] = (float) ( I+3 ) / 32.0f;
        QuadRot[I] = (float) ( I+24 ) / 32.0f;
        QX0[I] = 380.0f + 60.0f * ( I - 2.5f );
        QY0[I] = 240.0f;
       }
   }

void Quads_Draw( float Timer, float alpha )
  {
    int I;

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluOrtho2D( 0, 640, 360, 0 );

    glDisable( GL_DEPTH_TEST );
    glEnable( GL_LINE_SMOOTH );
    glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glEnable( GL_BLEND );

    glColor4f( BackR, BackG, BackB, 1.0f );
    glBegin( GL_QUADS );
    for ( I = 0; I < 6; I++ )
      {
        if (( Timer - I*30 ) < 256 ) QX0[I] = 380.0f + 60.0f * ( I - 2.5f ) + 800.0f * ( 1.0f - Fsin(( Timer - I*30 )*Pi / 512 )); else
        if (( Timer - I*30 ) > 2048+256 ) QX0[I] = 380.0f + 60.0f * ( I - 2.5f ); else
          QX0[I] = 380.0f + 60.0f * ( I - 2.5f );
          
        QDX1[I] = 70.0f * Fsin( QuadRot[I] * Timer * 0.004f + QuadPos[I] );
        QDY1[I] = 70.0f * Fcos( QuadRot[I] * Timer * 0.004f + QuadPos[I] );
        QDX2[I] = 70.0f * Fsin( QuadRot[I] * Timer * 0.004f + QuadPos[I] + Pi/2 );
        QDY2[I] = 70.0f * Fcos( QuadRot[I] * Timer * 0.004f + QuadPos[I] + Pi/2 );
        glVertex3f( QX0[I]+QDX1[I], QY0[I]+QDY1[I], 0.0f );
        glVertex3f( QX0[I]+QDX2[I], QY0[I]+QDY2[I], 0.0f );
        glVertex3f( QX0[I]-QDX1[I], QY0[I]-QDY1[I], 0.0f );
        glVertex3f( QX0[I]-QDX2[I], QY0[I]-QDY2[I], 0.0f );
       }
    glEnd();

    glColor4f( 0.0f, 0.0f, 0.0f, alpha );
    
    glBegin( GL_LINES );
    for ( I = 0; I < 6; I++ )
      {
        glVertex3f( QX0[I]+QDX1[I], QY0[I]+QDY1[I], 0.0f );
        glVertex3f( QX0[I]+QDX2[I], QY0[I]+QDY2[I], 0.0f );
        glVertex3f( QX0[I]+QDX2[I], QY0[I]+QDY2[I], 0.0f );
        glVertex3f( QX0[I]-QDX1[I], QY0[I]-QDY1[I], 0.0f );
        glVertex3f( QX0[I]-QDX1[I], QY0[I]-QDY1[I], 0.0f );
        glVertex3f( QX0[I]-QDX2[I], QY0[I]-QDY2[I], 0.0f );
        glVertex3f( QX0[I]-QDX2[I], QY0[I]-QDY2[I], 0.0f );
        glVertex3f( QX0[I]+QDX1[I], QY0[I]+QDY1[I], 0.0f );
       }     
/*
      glVertex3f( 0.0f, 177.5f, 0.0f );
      glVertex3f( 640.0f, 178.5f, 0.0f );
      glVertex3f( 0.0f, 181.5f, 0.0f );
      glVertex3f( 640.0f, 182.5f, 0.0f );
*/
    glEnd();

    glBegin( GL_QUADS );
    for ( I = 0; I < 6; I++ )
      {
        glColor4f( BackR, BackG, BackB, 1.0f );
        glVertex3f( QX0[I] + 0.7f * QDX1[I], QY0[I] + 0.7f * QDY1[I], 0.0f );
        glVertex3f( QX0[I] + 0.7f * QDX2[I], QY0[I] + 0.7f * QDY2[I], 0.0f );
        glVertex3f( QX0[I] - 0.7f * QDX1[I], QY0[I] - 0.7f * QDY1[I], 0.0f );
        glVertex3f( QX0[I] - 0.7f * QDX2[I], QY0[I] - 0.7f * QDY2[I], 0.0f );

        glVertex3f( QX0[I] + 0.7f * QDX1[I], QY0[I] + 0.7f * QDY1[I], 0.0f );
        glVertex3f( QX0[I] + 0.7f * QDX2[I], QY0[I] + 0.7f * QDY2[I], 0.0f );
        glColor4f( BackR, BackG, BackB, 0.0f );
        glVertex3f( QX0[I] + QDX2[I], QY0[I] + QDY2[I], 0.0f );
        glVertex3f( QX0[I] + QDX1[I], QY0[I] + QDY1[I], 0.0f );

        glColor4f( BackR, BackG, BackB, 1.0f );
        glVertex3f( QX0[I] + 0.7f * QDX2[I], QY0[I] + 0.7f * QDY2[I], 0.0f );
        glVertex3f( QX0[I] - 0.7f * QDX1[I], QY0[I] - 0.7f * QDY1[I], 0.0f );
        glColor4f( BackR, BackG, BackB, 0.0f );
        glVertex3f( QX0[I] - QDX1[I], QY0[I] - QDY1[I], 0.0f );
        glVertex3f( QX0[I] + QDX2[I], QY0[I] + QDY2[I], 0.0f );

        glColor4f( BackR, BackG, BackB, 1.0f );
        glVertex3f( QX0[I] - 0.7f * QDX1[I], QY0[I] - 0.7f * QDY1[I], 0.0f );
        glVertex3f( QX0[I] - 0.7f * QDX2[I], QY0[I] - 0.7f * QDY2[I], 0.0f );
        glColor4f( BackR, BackG, BackB, 0.0f );
        glVertex3f( QX0[I] - QDX2[I], QY0[I] - QDY2[I], 0.0f );
        glVertex3f( QX0[I] - QDX1[I], QY0[I] - QDY1[I], 0.0f );

        glColor4f( BackR, BackG, BackB, 1.0f );
        glVertex3f( QX0[I] - 0.7f * QDX2[I], QY0[I] - 0.7f * QDY2[I], 0.0f );
        glVertex3f( QX0[I] + 0.7f * QDX1[I], QY0[I] + 0.7f * QDY1[I], 0.0f );
        glColor4f( BackR, BackG, BackB, 0.0f );
        glVertex3f( QX0[I] + QDX1[I], QY0[I] + QDY1[I], 0.0f );
        glVertex3f( QX0[I] - QDX2[I], QY0[I] - QDY2[I], 0.0f );
       }
    glEnd();

    glDisable( GL_BLEND );
   }