	INCLUDE equates.h

	IMPORT playerCallback

	EXPORT setupIRQ
	EXPORT waitFrame
	EXPORT soundInit
	EXPORT pcmptr0
	EXPORT AGBinput
	EXPORT AGBkeys
	EXPORT animcounter
	EXPORT musictrigger



 AREA rom_code, CODE, READONLY


;@----------------------------------------------------------------------------
waitFrame
;@----------------------------------------------------------------------------
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr


;@----------------------------------------------------------------------------
setupIRQ
;@----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=AGB_IRQVECT
	ldr r2,=irqHandler
	str r2,[r1]

	mov r0,#0x0008
	strh r0,[r3,#REG_DISPSTAT]	;vblank IRQ enable.

	add r2,r3,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]		;stop pending interrupts
	mov r0,#1
	strh r0,[r2]		;vblank enable
	mov r0,#1
	strh r0,[r2,#8]		;master irq enable
	bx lr

;@----------------------------------------------------------------------------
soundInit
;@----------------------------------------------------------------------------
	stmfd sp!,{r4,lr}
	mov r1,#REG_BASE

	ldrh r0,[r1,#REG_SGBIAS]
	bic r0,r0,#0xc000			;@ PWM 9-bit  32.768kHz.
;	orr r0,r0,#0x8000			;@ PWM 7-bit 131.072kHz
	strh r0,[r1,#REG_SGBIAS]

	ldr r0,=0xBB0c				;@ use directsound A&B mono, timer 0
;	ldr r0,=0x9A0c				;@ use directsound A&B stereo, timer 0
	strh r0,[r1,#REG_SGCNT_H]

	mov r0,#0x80
	strh r0,[r1,#REG_SGCNT_X]	;@ sound master enable

	mov r0,#0					;@ triangle reset
	str r0,[r1,#REG_SG3CNT_L]	;@ sound3 disable, mute, write bank 0

								;@ Mixer channels
	strh r1,[r1,#REG_DMA1CNT_H]	;@ DMA1 stop, Left channel
	strh r1,[r1,#REG_DMA2CNT_H]	;@ DMA2 stop, Right channel
	add r0,r1,#REG_FIFO_A_L		;@ DMA1 destination..
	str r0,[r1,#REG_DMA1DAD]
	add r0,r1,#REG_FIFO_B_L		;@ DMA2 destination..
	str r0,[r1,#REG_DMA2DAD]
	ldr r0,=pcmptr0
	ldr r0,[r0]
	str r0,[r1,#REG_DMA1SAD]	;@ DMA1 src=..
	add r0,r0,#PCMWAVSIZE*2
	str r0,[r1,#REG_DMA2SAD]	;@ DMA2 src=..
;	ldr r0,=0xB640				;@ noIRQ fifo 32bit repeat incsrc fixeddst
;	strh r0,[r1,#REG_DMA1CNT_H]	;@ DMA1 start
;	strh r0,[r1,#REG_DMA2CNT_H]	;@ DMA2 start


	add r1,r1,#REG_TM0CNT_L		;@ timer 0 controls sample rate:
	mov r0,#0
	str r0,[r1]					;@ stop timer 0
	ldr r3,=532					;@ 924=18157.16Hz, 627=26757.92Hz, 532=31536.12Hz.
	rsb r0,r3,#0x10000			;@ frequency = 0x1000000/r3 Hz
	orr r0,r0,#0x800000			;@ timer 0 on
	str r0,[r1]

	ldmfd sp!,{r4,lr}
	bx lr

;@----------------------------------------------------------------------------
soundSwitchBanks
;@----------------------------------------------------------------------------
	mov r1,#REG_BASE
	strh r1,[r1,#REG_DMA1CNT_H]	;@ DMA1 stop
	strh r1,[r1,#REG_DMA2CNT_H]	;@ DMA2 stop
	ldr r3,=pcmptr0
	ldr r2,[r3]
	str r2,[r1,#REG_DMA1SAD]	;@ DMA1 src=..
	add r0,r2,#PCMWAVSIZE*2
	str r0,[r1,#REG_DMA2SAD]	;@ DMA2 src=..
	ldr r0,=0xB640				;@ noIRQ fifo 32bit repeat incsrc fixeddst
	strh r0,[r1,#REG_DMA1CNT_H]	;@ DMA1 go
	strh r0,[r1,#REG_DMA2CNT_H]	;@ DMA2 go

	ldr r1,[r3,#4]
	str r1,[r3]
	str r2,[r3,#4]

	bx lr
;@----------------------------------------------------------------------------
	AREA wram_code1, CODE, READWRITE
irqHandler	;r0-r3,r12 are safe to use
;@----------------------------------------------------------------------------
	mov r2,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16			;@ r1=IE&IF

		;---these CAN'T be interrupted
;		ands r0,r1,#0x80
;		strneh r0,[r2,#2]		;@ IF clear
;		bne serialinterrupt
		;---
		adr r12,irq0

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,=vblankInterrupt
		bne jmpintr
;		ands r0,r1,#0x10
;		ldrne r12,=timer1interrupt
		;----
		moveq r0,r1				;@ if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]				;@ IF clear
	mov r2,#REG_BASE
	ldrh r1,[r2,#-8]
	orr r1,r1,r0
	strh r1,[r2,#-8]

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0xdf
	orr r3,r3,#0x1f				;@--> Enable IRQ & FIQ. Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}

	adr lr,irq0
	bx r12

irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0xdf
	orr r3,r3,#0x92        		;@--> Disable IRQ. Enable FIQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
	bx lr
;@----------------------------------------------------------------------------
vblankInterrupt
;@----------------------------------------------------------------------------
	stmfd sp!,{r4,lr}

	adr lr,vbl_ret
	ldr r0,=soundSwitchBanks
	bx r0
vbl_ret

	ldr r0,=REG_P1				;@ refresh input every frame
	ldrh r0,[r0]
		eor r0,r0,#0xff
		eor r0,r0,#0x300		;@ r0=button state (raw)
	ldr r1,AGBinput
	eor r1,r1,r0
	and r1,r1,r0				;@ r1=button state (0->1)
	str r0,AGBinput
	str r1,AGBkeys

;@ Do other stuff that you want to be done in the VBL.

	ldmfd sp!,{r4,lr}
	ldr r0,=playerCallback
	bx r0


;@----------------------------------------------------------------------------
pcmptr0			DCD PCMWAV
pcmptr1			DCD PCMWAV+PCMWAVSIZE
;@----------------------------------------------------------------------------

animcounter		DCD 0
musictrigger	DCD 0

;@----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

AGBinput	;@ this label here for main.c to use
	DCD 0	;@ AGBjoypad (why is this in vdc.s again?  um.. i forget)
AGBkeys		;@ this label here for main.c to use
	DCD 0	;@ AGBjoypad (why is this in vdc.s again?  um.. i forget)

;@----------------------------------------------------------------------------
	END
