{Strings related functions.                                                  }
{v1.1.0 (c) 08.05.2000 by Flying/Digital Reality                             }
Unit StringsUnit;

Interface

Const
{⠭ १ ࠢ 2- ப}
  cmp_Lower = -1;
  cmp_Equal = 0;
  cmp_Higher = 1;

{ ॢ  孨 ॣ}
  UpCaseData:array [char] of byte =
    ($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
     $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
     $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,
     $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,
     $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
     $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F,
     $60,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
     $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$7B,$7C,$7D,$7E,$7F,
     $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,
     $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,
     $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,
     $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF,
     $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,
     $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,
     $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,
     $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

{ ॢ   ॣ}
  DownCaseData:array [char] of byte =
    ($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
     $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
     $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,
     $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,
     $40,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,
     $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$5B,$5C,$5D,$5E,$5F,
     $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,
     $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,
     $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,
     $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,
     $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,
     $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF,
     $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,
     $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,
     $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,
     $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

{८ࠧ뢠 ப  孥 ॣ}
Function StrUpCase(Str:string):string;
{८ࠧ뢠 ப   ॣ}
Function StrDownCase(Str:string):string;
{ࠢ 2 ப}
Function StrCompare(Str1,Str2:string):shortint;
{ࠢ 2 ப   ॣ}
Function StrCompareNoCase(Str1,Str2:string):shortint;
{㭪 "१" ஡ ᫥  ࢮ 饣 ᨬ  ப}
Function StrTrimLeft(Str:string):string;
{㭪 "१" ஡  ᫥ 饣 ᨬ  ப   }
Function StrTrimRight(Str:string):string;

Implementation

Function StrUpCase(Str:string):string;
var
  i:word;
  s:string;
begin
  s:='';
  for i:=1 to Length(Str) do s:=s+char(UpCaseData[Str[i]]);
  StrUpCase:=s;
end;

Function StrDownCase(Str:string):string;
var
  i:word;
  s:string;
begin
  s:='';
  for i:=1 to Length(Str) do s:=s+char(DownCaseData[Str[i]]);
  StrDownCase:=s;
end;

Function StrCompare(Str1,Str2:string):shortint;
var
  i : word;
  L_Str1 : byte absolute Str1;
  L_Str2 : byte absolute Str2;
begin
  i:=1;
  repeat
    if (L_Str1>=i) and (L_Str2>=i) then
      begin
        if Str1[i]>Str2[i] then
          begin
            StrCompare:=cmp_Higher;
            exit;
          end
        else
          if Str1[i]<Str2[i] then
            begin
              StrCompare:=cmp_Lower;
              exit;
            end
          else
            begin
              inc(i);
              continue;
            end;
      end
    else
      if (L_Str1<i) and (L_Str2>=i) then
        begin
          StrCompare:=cmp_Lower;
          exit;
        end
      else
        if (L_Str1>=i) and (L_Str2<i) then
          begin
            StrCompare:=cmp_Higher;
            exit;
          end
        else
          if (L_Str1<i) and (L_Str2<i) then
            begin
              StrCompare:=cmp_Equal;
              exit;
            end
  until false;
end;

Function StrCompareNoCase(Str1,Str2:string):shortint;
begin
  Str1:=StrUpCase(Str1);
  Str2:=StrUpCase(Str2);
  StrCompareNoCase:=StrCompare(Str1,Str2);
end;

Function StrTrimLeft(Str:string):string;
var
  i:byte;
begin
  i:=1;
  while (Str[i]=' ') or (Str[i]=#09) do
    inc(i);
  StrTrimLeft:=Copy(Str,i,Length(Str)-i+1);
end;

Function StrTrimRight(Str:string):string;
var
  i:byte;
begin
  i:=Length(Str);
  while (Str[i]=' ') or (Str[i]=#09) do
    dec(i);
  StrTrimRight:=Copy(Str,1,i);
end;

BEGIN
END.