{Timer handling.                                                             }
{v1.0.0 (c) 22.11.1999 by Flying/Digital Reality                             }
Unit Timer;

Interface

Procedure InitTimer; {Set frequency = 70hz}
Procedure DoneTimer;
Function  GetTimerTicks:word;
Procedure SetTimerTicks(QTicks:word);
Procedure ResetTimerTicks;
Procedure SetBorder(Color:byte);

Implementation

Var
  OldInt8:longint;
  TimerAddr:longint;
  QTimerTicks:word;

Procedure InitTimer;assembler;
asm
  xor ax,ax
  mov es,ax
  mov ax,es:[8*4]
  mov dx,es:[8*4+2]
  mov word ptr OldInt8,ax
  mov word ptr OldInt8+2,dx
  mov dx,word ptr TimerAddr
  mov ax,word ptr TimerAddr+2
  mov es:[8*4],dx
  mov es:[8*4+2],ax
  mov dx,17000         {Constant to set frequency 70hz}
  cli
  mov al,036h
  out 43h,al
  mov al,dl
  out 40h,al
  mov al,dh
  out 40h,al
  sti
  mov ax,seg QTimerTicks
  mov es,ax
  mov di,offset QTimerTicks
  xor ax,ax
  mov es:[di],ax
end;

Procedure DoneTimer;assembler;
asm
  xor ax,ax
  mov es,ax
  mov ax,word ptr OldInt8
  mov dx,word ptr OldInt8+2
  mov es:[8*4],ax
  mov es:[8*4+2],dx
  xor dx,dx
  cli
  mov al,036h
  out 43h,al
  mov al,dl
  out 40h,al
  mov al,dh
  out 40h,al
  sti
end;

Procedure TimerHandler;assembler;
asm
  push es
  push di
  push ax
  mov al,20h
  out 20h,al
  mov ax,seg QTimerTicks
  mov es,ax
  mov di,offset QTimerTicks
  mov ax,es:[di]
  inc ax
  mov es:[di],ax
  pop ax
  pop di
  pop es
  iret
end;

Procedure SetBorder(Color:byte);assembler;
asm
  push ax
  push dx
  mov dx,3dah
  in al,dx
  mov dx,3c0h
  mov al,11h+32
  out dx,al
  mov al,Color
  out dx,al
  pop dx
  pop ax
end;

Function GetTimerTicks:word;
begin
  GetTimerTicks:=QTimerTicks;
end;

Procedure SetTimerTicks(QTicks:word);
begin
  QTimerTicks:=QTicks;
end;

Procedure ResetTimerTicks;
begin
  SetTimerTicks(0);
end;


BEGIN
  TimerAddr:=longint(Addr(TimerHandler));
  QTimerTicks:=0;
END.
