#include "anim.h"
#include "audio.h"
#include "physics.h"

#if _DEBUG
#include <iostream>
#endif

typedef struct AnimState {
	bool bounceUp;
	bool bounceDown;
	float bounceStartTime;
	float bounceStopTime;
	float bounceDuration;
	float floorMoveAmount;

} AnimState;

AnimState sAnimState;

static float smoothstep(float x)
{
	return x * x * (3 - 2 * x);
}

void AnimInit()
{
	sAnimState.bounceDuration = .2;
	sAnimState.floorMoveAmount = .25;
}

void AnimFloorBounce(float t, int hex)
{
	if (sAnimState.bounceUp && sAnimState.bounceDown)
	{
		sAnimState.bounceUp = sAnimState.bounceDown = false;
		PhysicsSelectFloorHex(-2);
		PhysicsMoveFloor(kMinY);
		return;
	}

	sAnimState.bounceStartTime = t;
	sAnimState.bounceStopTime = t + sAnimState.bounceDuration;
	sAnimState.bounceUp = true;
	PhysicsSelectFloorHex(hex);
}

#define BACK 65
#define CENTER 76
#define FRONT 89

void AnimRun(float t)
{
	//if (audioState.onBeat) {
		static int previousHex = -1;
		int hex = (previousHex + 1) % 9;
		previousHex = hex;
		if (hex < 4) hex = BACK + hex;
		else if (hex < 7) hex = CENTER + (hex - 3);
		else hex = FRONT + (hex - 7);
	//	AnimFloorBounce(t, hex);
	//}

	if (audioState.bar < 9) {
		if (audioState.onHit)
			AnimFloorBounce(t, hex);
	}
	else if (audioState.bar < 16) {
		if (audioState.onBar)
			AnimFloorBounce(t, CENTER + 2);
		else if (audioState.onHit)
			AnimFloorBounce(t, hex);
	}
	else if (audioState.bar < 25) {
		if (audioState.onBar)
			AnimFloorBounce(t, CENTER+2);
	}
	else if (audioState.bar < 30) {
		if (audioState.onHit)
			AnimFloorBounce(t, hex);
	}
	else {
		if (audioState.onHit)
			AnimFloorBounce(t, hex);
	}

	if (sAnimState.bounceUp || sAnimState.bounceDown)
	{
		float ease = smoothstep((t - sAnimState.bounceStartTime) / sAnimState.bounceDuration);
		float amount = min(max(sAnimState.floorMoveAmount * ease, 0), sAnimState.floorMoveAmount);
		if (sAnimState.bounceDown)
			amount = sAnimState.floorMoveAmount - amount;

		PhysicsMoveFloor(kMinY + amount);

		if (t >= sAnimState.bounceStopTime)
		{
			if (sAnimState.bounceUp) {
				sAnimState.bounceStartTime = t;
				sAnimState.bounceStopTime = sAnimState.bounceStartTime + sAnimState.bounceDuration / 2;
				sAnimState.bounceDown = true;
				sAnimState.bounceUp = false;
			}
			else {
				sAnimState.bounceDown = false;
				PhysicsMoveFloor(kMinY);
			}
		}
	}

}
